/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.PeriodicSequence;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class PeriodicImpulse
extends PTransform<PBegin, PCollection<Instant>> {
    @UnknownKeyFor @NonNull @Initialized Instant startTimestamp = Instant.now();
    @UnknownKeyFor @NonNull @Initialized Instant stopTimestamp = BoundedWindow.TIMESTAMP_MAX_VALUE;
    @UnknownKeyFor @NonNull @Initialized Duration fireInterval = Duration.standardMinutes((long)1L);
    @UnknownKeyFor @NonNull @Initialized boolean applyWindowing = false;

    private PeriodicImpulse() {
    }

    public static @UnknownKeyFor @NonNull @Initialized PeriodicImpulse create() {
        return new PeriodicImpulse();
    }

    public @UnknownKeyFor @NonNull @Initialized PeriodicImpulse startAt(@UnknownKeyFor @NonNull @Initialized Instant startTime) {
        this.startTimestamp = startTime;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized PeriodicImpulse stopAt(@UnknownKeyFor @NonNull @Initialized Instant stopTime) {
        this.stopTimestamp = stopTime;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized PeriodicImpulse withInterval(@UnknownKeyFor @NonNull @Initialized Duration interval) {
        this.fireInterval = interval;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized PeriodicImpulse applyWindowing() {
        this.applyWindowing = true;
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Instant> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        PCollection result = ((PCollection)input.apply(Create.of(new PeriodicSequence.SequenceDefinition(this.startTimestamp, this.stopTimestamp, this.fireInterval), new PeriodicSequence.SequenceDefinition[0]))).apply(PeriodicSequence.create());
        if (this.applyWindowing) {
            result = (PCollection)result.apply(Window.into(FixedWindows.of(Duration.millis((long)this.fireInterval.getMillis()))));
        }
        return result;
    }
}

