/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.AutoValue_FileIO_Match;
import org.apache.beam.sdk.io.AutoValue_FileIO_MatchAll;
import org.apache.beam.sdk.io.AutoValue_FileIO_MatchConfiguration;
import org.apache.beam.sdk.io.AutoValue_FileIO_ReadMatches;
import org.apache.beam.sdk.io.AutoValue_FileIO_Write;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MetadataCoderV2;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.StreamUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FileIO.class);

    public static @UnknownKeyFor @NonNull @Initialized Match match() {
        return new AutoValue_FileIO_Match.Builder().setConfiguration(MatchConfiguration.create(EmptyMatchTreatment.DISALLOW)).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized MatchAll matchAll() {
        return new AutoValue_FileIO_MatchAll.Builder().setConfiguration(MatchConfiguration.create(EmptyMatchTreatment.ALLOW_IF_WILDCARD)).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadMatches readMatches() {
        return new AutoValue_FileIO_ReadMatches.Builder().setCompression(Compression.AUTO).setDirectoryTreatment(ReadMatches.DirectoryTreatment.SKIP).build();
    }

    public static <InputT> @UnknownKeyFor @NonNull @Initialized Write<@UnknownKeyFor @Nullable @Initialized Void, InputT> write() {
        return new AutoValue_FileIO_Write.Builder().setDynamic(false).setCompression(Compression.UNCOMPRESSED).setIgnoreWindowing(false).setNoSpilling(false).build();
    }

    public static <DestT, InputT> @UnknownKeyFor @NonNull @Initialized Write<DestT, InputT> writeDynamic() {
        return new AutoValue_FileIO_Write.Builder().setDynamic(true).setCompression(Compression.UNCOMPRESSED).setIgnoreWindowing(false).setNoSpilling(false).build();
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor DestinationT, @UnknownKeyFor UserT>
    extends PTransform<PCollection<UserT>, WriteFilesResult<DestinationT>> {
        public static @UnknownKeyFor @NonNull @Initialized FileNaming defaultNaming(@UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized String suffix) {
            return Write.defaultNaming(ValueProvider.StaticValueProvider.of(prefix), ValueProvider.StaticValueProvider.of(suffix));
        }

        public static @UnknownKeyFor @NonNull @Initialized FileNaming defaultNaming(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> prefix, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> suffix) {
            return (window, pane, numShards, shardIndex, compression) -> {
                boolean isOnlyFiring;
                Preconditions.checkArgument((window != null ? 1 : 0) != 0, (Object)"window can not be null");
                Preconditions.checkArgument((pane != null ? 1 : 0) != 0, (Object)"pane can not be null");
                Preconditions.checkArgument((compression != null ? 1 : 0) != 0, (Object)"compression can not be null");
                StringBuilder res = new StringBuilder((String)prefix.get());
                if (window != GlobalWindow.INSTANCE) {
                    if (res.length() > 0) {
                        res.append("-");
                    }
                    Preconditions.checkArgument((boolean)(window instanceof IntervalWindow), (String)"defaultNaming() supports only windows of type %s, but got window %s of type %s", (Object)IntervalWindow.class.getSimpleName(), (Object)window, (Object)window.getClass().getSimpleName());
                    IntervalWindow iw = (IntervalWindow)window;
                    res.append(iw.start().toString()).append("-").append(iw.end().toString());
                }
                boolean bl = isOnlyFiring = pane.isFirst() && pane.isLast();
                if (!isOnlyFiring) {
                    if (res.length() > 0) {
                        res.append("-");
                    }
                    res.append(pane.getIndex());
                }
                if (res.length() > 0) {
                    res.append("-");
                }
                String numShardsStr = String.valueOf(numShards);
                DecimalFormat df = new DecimalFormat("000000000000".substring(0, Math.max(5, numShardsStr.length())));
                res.append(df.format(shardIndex)).append("-of-").append(df.format(numShards));
                res.append((String)suffix.get());
                res.append(compression.getSuggestedSuffix());
                return res.toString();
            };
        }

        public static @UnknownKeyFor @NonNull @Initialized FileNaming relativeFileNaming(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> baseDirectory, @UnknownKeyFor @NonNull @Initialized FileNaming innerNaming) {
            return (window, pane, numShards, shardIndex, compression) -> FileSystems.matchNewResource((String)baseDirectory.get(), true).resolve(innerNaming.getFilename(window, pane, numShards, shardIndex, compression), ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString();
        }

        abstract @UnknownKeyFor @NonNull @Initialized boolean getDynamic();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<DestinationT, @UnknownKeyFor @NonNull @Initialized Sink<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> getSinkFn();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<UserT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputFn();

        abstract @Nullable @UnknownKeyFor @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<UserT, DestinationT>> getDestinationFn();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getOutputDirectory();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFilenamePrefix();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFilenameSuffix();

        abstract @Nullable @UnknownKeyFor @Initialized FileNaming getConstantFileNaming();

        abstract @Nullable @UnknownKeyFor @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<DestinationT, @UnknownKeyFor @NonNull @Initialized FileNaming>> getFileNamingFn();

        abstract @Nullable DestinationT getEmptyWindowDestination();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<DestinationT> getDestinationCoder();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getTempDirectory();

        abstract @UnknownKeyFor @NonNull @Initialized Compression getCompression();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> getNumShards();

        abstract @Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<UserT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Integer>> getSharding();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getIgnoreWindowing();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getNoSpilling();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> by(@UnknownKeyFor @NonNull @Initialized SerializableFunction<UserT, DestinationT> destinationFn) {
            Preconditions.checkArgument((destinationFn != null ? 1 : 0) != 0, (Object)"destinationFn can not be null");
            return this.by(Contextful.fn(destinationFn));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> by(@UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<UserT, DestinationT>> destinationFn) {
            Preconditions.checkArgument((destinationFn != null ? 1 : 0) != 0, (Object)"destinationFn can not be null");
            return this.toBuilder().setDestinationFn(destinationFn).build();
        }

        public <OutputT> @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> via(@UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<UserT, OutputT>> outputFn, @UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<DestinationT, @UnknownKeyFor @NonNull @Initialized Sink<OutputT>>> sinkFn) {
            Preconditions.checkArgument((sinkFn != null ? 1 : 0) != 0, (Object)"sinkFn can not be null");
            Preconditions.checkArgument((outputFn != null ? 1 : 0) != 0, (Object)"outputFn can not be null");
            return this.toBuilder().setSinkFn(sinkFn).setOutputFn(outputFn).build();
        }

        public <OutputT> @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> via(@UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<UserT, OutputT>> outputFn, @UnknownKeyFor @NonNull @Initialized Sink<OutputT> sink) {
            Preconditions.checkArgument((sink != null ? 1 : 0) != 0, (Object)"sink can not be null");
            Preconditions.checkArgument((outputFn != null ? 1 : 0) != 0, (Object)"outputFn can not be null");
            return this.via(outputFn, Contextful.fn(SerializableFunctions.clonesOf(sink)));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> via(@UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<DestinationT, @UnknownKeyFor @NonNull @Initialized Sink<UserT>>> sinkFn) {
            Preconditions.checkArgument((sinkFn != null ? 1 : 0) != 0, (Object)"sinkFn can not be null");
            return this.toBuilder().setSinkFn(sinkFn).setOutputFn(Contextful.fn(SerializableFunctions.identity())).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> via(@UnknownKeyFor @NonNull @Initialized Sink<UserT> sink) {
            Preconditions.checkArgument((sink != null ? 1 : 0) != 0, (Object)"sink can not be null");
            return this.via(Contextful.fn(SerializableFunctions.clonesOf(sink)));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> to(@UnknownKeyFor @NonNull @Initialized String directory) {
            Preconditions.checkArgument((directory != null ? 1 : 0) != 0, (Object)"directory can not be null");
            return this.to(ValueProvider.StaticValueProvider.of(directory));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> to(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> directory) {
            Preconditions.checkArgument((directory != null ? 1 : 0) != 0, (Object)"directory can not be null");
            return this.toBuilder().setOutputDirectory(directory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withPrefix(@UnknownKeyFor @NonNull @Initialized String prefix) {
            Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"prefix can not be null");
            return this.withPrefix(ValueProvider.StaticValueProvider.of(prefix));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withPrefix(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> prefix) {
            Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"prefix can not be null");
            return this.toBuilder().setFilenamePrefix(prefix).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withSuffix(@UnknownKeyFor @NonNull @Initialized String suffix) {
            Preconditions.checkArgument((suffix != null ? 1 : 0) != 0, (Object)"suffix can not be null");
            return this.withSuffix(ValueProvider.StaticValueProvider.of(suffix));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withSuffix(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> suffix) {
            Preconditions.checkArgument((suffix != null ? 1 : 0) != 0, (Object)"suffix can not be null");
            return this.toBuilder().setFilenameSuffix(suffix).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withNaming(@UnknownKeyFor @NonNull @Initialized FileNaming naming) {
            Preconditions.checkArgument((naming != null ? 1 : 0) != 0, (Object)"naming can not be null");
            return this.toBuilder().setConstantFileNaming(naming).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withNaming(@UnknownKeyFor @NonNull @Initialized SerializableFunction<DestinationT, @UnknownKeyFor @NonNull @Initialized FileNaming> namingFn) {
            Preconditions.checkArgument((namingFn != null ? 1 : 0) != 0, (Object)"namingFn can not be null");
            return this.withNaming(Contextful.fn(namingFn));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withNaming(@UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<DestinationT, @UnknownKeyFor @NonNull @Initialized FileNaming>> namingFn) {
            Preconditions.checkArgument((namingFn != null ? 1 : 0) != 0, (Object)"namingFn can not be null");
            return this.toBuilder().setFileNamingFn(namingFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withTempDirectory(@UnknownKeyFor @NonNull @Initialized String tempDirectory) {
            Preconditions.checkArgument((tempDirectory != null ? 1 : 0) != 0, (Object)"tempDirectory can not be null");
            return this.withTempDirectory(ValueProvider.StaticValueProvider.of(tempDirectory));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withTempDirectory(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tempDirectory) {
            Preconditions.checkArgument((tempDirectory != null ? 1 : 0) != 0, (Object)"tempDirectory can not be null");
            return this.toBuilder().setTempDirectory(tempDirectory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withCompression(@UnknownKeyFor @NonNull @Initialized Compression compression) {
            Preconditions.checkArgument((compression != null ? 1 : 0) != 0, (Object)"compression can not be null");
            Preconditions.checkArgument((compression != Compression.AUTO ? 1 : 0) != 0, (Object)"AUTO compression is not supported for writing");
            return this.toBuilder().setCompression(compression).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withEmptyGlobalWindowDestination(DestinationT emptyWindowDestination) {
            return this.toBuilder().setEmptyWindowDestination(emptyWindowDestination).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withDestinationCoder(@UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder) {
            Preconditions.checkArgument((destinationCoder != null ? 1 : 0) != 0, (Object)"destinationCoder can not be null");
            return this.toBuilder().setDestinationCoder(destinationCoder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withNumShards(@UnknownKeyFor @NonNull @Initialized int numShards) {
            Preconditions.checkArgument((numShards >= 0 ? 1 : 0) != 0, (String)"numShards must be non-negative, but was: %s", (int)numShards);
            if (numShards == 0) {
                return this.withNumShards(null);
            }
            return this.withNumShards(ValueProvider.StaticValueProvider.of(numShards));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withNumShards(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> numShards) {
            return this.toBuilder().setNumShards(numShards).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withSharding(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<UserT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Integer>> sharding) {
            Preconditions.checkArgument((sharding != null ? 1 : 0) != 0, (Object)"sharding can not be null");
            return this.toBuilder().setSharding(sharding).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withIgnoreWindowing() {
            return this.toBuilder().setIgnoreWindowing(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> withNoSpilling() {
            return this.toBuilder().setNoSpilling(true).build();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<DestinationT, @UnknownKeyFor @NonNull @Initialized FileNaming>> resolveFileNamingFn() {
            FileNaming constantFileNaming;
            if (this.getDynamic()) {
                Preconditions.checkArgument((this.getConstantFileNaming() == null ? 1 : 0) != 0, (Object)"when using writeDynamic(), must use versions of .withNaming() that take functions from DestinationT");
                Preconditions.checkArgument((this.getFilenamePrefix() == null ? 1 : 0) != 0, (Object)".withPrefix() requires write()");
                Preconditions.checkArgument((this.getFilenameSuffix() == null ? 1 : 0) != 0, (Object)".withSuffix() requires write()");
                Preconditions.checkArgument((this.getFileNamingFn() != null ? 1 : 0) != 0, (Object)"when using writeDynamic(), must specify .withNaming() taking a function form DestinationT");
                return Contextful.fn((element, c) -> {
                    FileNaming naming = this.getFileNamingFn().getClosure().apply(element, c);
                    return this.getOutputDirectory() == null ? naming : Write.relativeFileNaming(this.getOutputDirectory(), naming);
                }, this.getFileNamingFn().getRequirements());
            }
            Preconditions.checkArgument((this.getFileNamingFn() == null ? 1 : 0) != 0, (Object)".withNaming() taking a function from DestinationT requires writeDynamic()");
            if (this.getConstantFileNaming() == null) {
                constantFileNaming = Write.defaultNaming((ValueProvider)MoreObjects.firstNonNull(this.getFilenamePrefix(), ValueProvider.StaticValueProvider.of("output")), (ValueProvider)MoreObjects.firstNonNull(this.getFilenameSuffix(), ValueProvider.StaticValueProvider.of("")));
            } else {
                Preconditions.checkArgument((this.getFilenamePrefix() == null ? 1 : 0) != 0, (Object)".to(FileNaming) is incompatible with .withSuffix()");
                Preconditions.checkArgument((this.getFilenameSuffix() == null ? 1 : 0) != 0, (Object)".to(FileNaming) is incompatible with .withPrefix()");
                constantFileNaming = this.getConstantFileNaming();
            }
            if (this.getOutputDirectory() != null) {
                constantFileNaming = Write.relativeFileNaming(this.getOutputDirectory(), constantFileNaming);
            }
            return Contextful.fn(SerializableFunctions.constant(constantFileNaming));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<UserT> input) {
            AutoValue_FileIO_Write.Builder<DestinationT, UserT> resolvedSpec = new AutoValue_FileIO_Write.Builder<DestinationT, UserT>();
            ((Builder)resolvedSpec).setDynamic(this.getDynamic());
            Preconditions.checkArgument((this.getSinkFn() != null ? 1 : 0) != 0, (Object)".via() is required");
            ((Builder)resolvedSpec).setSinkFn(this.getSinkFn());
            Preconditions.checkArgument((this.getOutputFn() != null ? 1 : 0) != 0, (Object)"outputFn should have been set by .via()");
            ((Builder)resolvedSpec).setOutputFn(this.getOutputFn());
            if (this.getDynamic()) {
                Preconditions.checkArgument((this.getDestinationFn() != null ? 1 : 0) != 0, (Object)"when using writeDynamic(), .by() is required");
                ((Builder)resolvedSpec).setDestinationFn(this.getDestinationFn());
                ((Builder)resolvedSpec).setDestinationCoder(this.resolveDestinationCoder(input));
            } else {
                Preconditions.checkArgument((this.getDestinationFn() == null ? 1 : 0) != 0, (Object)".by() requires writeDynamic()");
                Preconditions.checkArgument((this.getDestinationCoder() == null ? 1 : 0) != 0, (Object)".withDestinationCoder() requires writeDynamic()");
                ((Builder)resolvedSpec).setDestinationFn(Contextful.fn(SerializableFunctions.constant(null)));
                ((Builder)resolvedSpec).setDestinationCoder(VoidCoder.of());
            }
            ((Builder)resolvedSpec).setFileNamingFn(this.resolveFileNamingFn());
            ((Builder)resolvedSpec).setEmptyWindowDestination(this.getEmptyWindowDestination());
            if (this.getTempDirectory() == null) {
                Preconditions.checkArgument((this.getOutputDirectory() != null ? 1 : 0) != 0, (Object)"must specify either .withTempDirectory() or .to()");
                ((Builder)resolvedSpec).setTempDirectory(this.getOutputDirectory());
            } else {
                ((Builder)resolvedSpec).setTempDirectory(this.getTempDirectory());
            }
            ((Builder)resolvedSpec).setCompression(this.getCompression());
            ((Builder)resolvedSpec).setNumShards(this.getNumShards());
            ((Builder)resolvedSpec).setSharding(this.getSharding());
            ((Builder)resolvedSpec).setIgnoreWindowing(this.getIgnoreWindowing());
            ((Builder)resolvedSpec).setNoSpilling(this.getNoSpilling());
            Write resolved = ((Builder)resolvedSpec).build();
            WriteFiles writeFiles = WriteFiles.to(new ViaFileBasedSink(resolved)).withSideInputs(Lists.newArrayList(super.getAllSideInputs()));
            writeFiles = this.getNumShards() != null ? writeFiles.withNumShards(this.getNumShards()) : (this.getSharding() != null ? writeFiles.withSharding(this.getSharding()) : writeFiles.withRunnerDeterminedSharding());
            if (!this.getIgnoreWindowing()) {
                writeFiles = writeFiles.withWindowedWrites();
            }
            if (this.getNoSpilling()) {
                writeFiles = writeFiles.withNoSpilling();
            }
            return (WriteFilesResult)input.apply(writeFiles);
        }

        private @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> resolveDestinationCoder(@UnknownKeyFor @NonNull @Initialized PCollection<UserT> input) {
            Coder<DestinationT> destinationCoder = this.getDestinationCoder();
            if (destinationCoder == null) {
                TypeDescriptor<DestinationT> destinationT = TypeDescriptors.outputOf(this.getDestinationFn().getClosure());
                try {
                    destinationCoder = input.getPipeline().getCoderRegistry().getCoder(destinationT);
                }
                catch (CannotProvideCoderException e) {
                    throw new IllegalArgumentException("Unable to infer a coder for destination type (inferred from .by() as \"" + destinationT + "\") - specify it explicitly using .withDestinationCoder()");
                }
            }
            return destinationCoder;
        }

        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getAllSideInputs() {
            return Requirements.union(this.getDestinationFn(), this.getOutputFn(), this.getSinkFn(), this.getFileNamingFn()).getSideInputs();
        }

        private static class ViaFileBasedSink<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
        extends FileBasedSink<UserT, DestinationT, OutputT> {
            private final @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> spec;

            private ViaFileBasedSink(@UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> spec) {
                super(ValueProvider.NestedValueProvider.of(spec.getTempDirectory(), input -> FileSystems.matchNewResource(input, true)), new DynamicDestinationsAdapter(spec), spec.getCompression());
                this.spec = spec;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized FileBasedSink.WriteOperation<DestinationT, OutputT> createWriteOperation() {
                return new FileBasedSink.WriteOperation<DestinationT, OutputT>(this){

                    @Override
                    public @UnknownKeyFor @NonNull @Initialized FileBasedSink.Writer<DestinationT, OutputT> createWriter() throws @UnknownKeyFor @NonNull @Initialized Exception {
                        return new FileBasedSink.Writer<DestinationT, OutputT>(this, ""){
                            private @Nullable @UnknownKeyFor @Initialized Sink<OutputT> sink;

                            @Override
                            protected void prepareWrite(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized Exception {
                                Contextful.Fn sinkFn = spec.getSinkFn().getClosure();
                                this.sink = sinkFn.apply(this.getDestination(), new Contextful.Fn.Context(){

                                    @Override
                                    public <T> T sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
                                        return this.getWriteOperation().getSink().getDynamicDestinations().sideInput(view);
                                    }
                                });
                                this.sink.open(channel);
                            }

                            @Override
                            public void write(OutputT value) throws @UnknownKeyFor @NonNull @Initialized Exception {
                                this.sink.write(value);
                            }

                            @Override
                            protected void finishWrite() throws @UnknownKeyFor @NonNull @Initialized Exception {
                                this.sink.flush();
                            }
                        };
                    }
                };
            }

            private static class DynamicDestinationsAdapter<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
            extends FileBasedSink.DynamicDestinations<UserT, DestinationT, OutputT> {
                private final @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> spec;
                private transient @Nullable @UnknownKeyFor @Initialized Contextful.Fn.Context context;

                private DynamicDestinationsAdapter(@UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> spec) {
                    this.spec = spec;
                }

                private @UnknownKeyFor @NonNull @Initialized Contextful.Fn.Context getContext() {
                    if (this.context == null) {
                        this.context = new Contextful.Fn.Context(){

                            @Override
                            public <T> T sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
                                return this.sideInput(view);
                            }
                        };
                    }
                    return this.context;
                }

                @Override
                public OutputT formatRecord(UserT record) {
                    try {
                        return (OutputT)this.spec.getOutputFn().getClosure().apply(record, this.getContext());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public DestinationT getDestination(UserT element) {
                    try {
                        return this.spec.getDestinationFn().getClosure().apply(element, this.getContext());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public DestinationT getDefaultDestination() {
                    return this.spec.getEmptyWindowDestination();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized FileBasedSink.FilenamePolicy getFilenamePolicy(DestinationT destination) {
                    FileNaming namingFn;
                    try {
                        namingFn = this.spec.getFileNamingFn().getClosure().apply(destination, this.getContext());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return new FileBasedSink.FilenamePolicy(){

                        @Override
                        public @UnknownKeyFor @NonNull @Initialized ResourceId windowedFilename(@UnknownKeyFor @NonNull @Initialized int shardNumber, @UnknownKeyFor @NonNull @Initialized int numShards, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @UnknownKeyFor @NonNull @Initialized FileBasedSink.OutputFileHints outputFileHints) {
                            return FileSystems.matchNewResource(namingFn.getFilename(window, paneInfo, numShards, shardNumber, spec.getCompression()), false);
                        }

                        @Override
                        public @Nullable @UnknownKeyFor @Initialized ResourceId unwindowedFilename(@UnknownKeyFor @NonNull @Initialized int shardNumber, @UnknownKeyFor @NonNull @Initialized int numShards, @UnknownKeyFor @NonNull @Initialized FileBasedSink.OutputFileHints outputFileHints) {
                            return FileSystems.matchNewResource(namingFn.getFilename(GlobalWindow.INSTANCE, PaneInfo.NO_FIRING, numShards, shardNumber, spec.getCompression()), false);
                        }
                    };
                }

                @Override
                public /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
                    return Lists.newArrayList((Iterable)((Write)this.spec).getAllSideInputs());
                }

                @Override
                public @Nullable @UnknownKeyFor @Initialized Coder<DestinationT> getDestinationCoder() {
                    return this.spec.getDestinationCoder();
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor DestinationT, @UnknownKeyFor UserT> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setDynamic(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setSinkFn(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<DestinationT, @UnknownKeyFor @NonNull @Initialized Sink<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setOutputFn(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<UserT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setDestinationFn(@UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<UserT, DestinationT>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setOutputDirectory(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setFilenamePrefix(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setFilenameSuffix(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setConstantFileNaming(@UnknownKeyFor @NonNull @Initialized FileNaming var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setFileNamingFn(@UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<DestinationT, @UnknownKeyFor @NonNull @Initialized FileNaming>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setEmptyWindowDestination(DestinationT var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setDestinationCoder(@UnknownKeyFor @NonNull @Initialized Coder<DestinationT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setTempDirectory(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setCompression(@UnknownKeyFor @NonNull @Initialized Compression var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setNumShards(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setSharding(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<UserT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Integer>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setIgnoreWindowing(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<DestinationT, UserT> setNoSpilling(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write<DestinationT, UserT> build();
        }

        public static interface FileNaming
        extends Serializable {
            public @UnknownKeyFor @NonNull @Initialized String getFilename(@UnknownKeyFor @NonNull @Initialized BoundedWindow var1, @UnknownKeyFor @NonNull @Initialized PaneInfo var2, @UnknownKeyFor @NonNull @Initialized int var3, @UnknownKeyFor @NonNull @Initialized int var4, @UnknownKeyFor @NonNull @Initialized Compression var5);
        }
    }

    public static interface Sink<@UnknownKeyFor ElementT>
    extends Serializable {
        public void open(@UnknownKeyFor @NonNull @Initialized WritableByteChannel var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

        public void write(ElementT var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

        public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException;
    }

    @AutoValue
    public static abstract class ReadMatches
    extends PTransform<PCollection<MatchResult.Metadata>, PCollection<ReadableFile>> {
        abstract @UnknownKeyFor @NonNull @Initialized Compression getCompression();

        abstract @UnknownKeyFor @NonNull @Initialized DirectoryTreatment getDirectoryTreatment();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ReadMatches withCompression(@UnknownKeyFor @NonNull @Initialized Compression compression) {
            Preconditions.checkArgument((compression != null ? 1 : 0) != 0, (Object)"compression can not be null");
            return this.toBuilder().setCompression(compression).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadMatches withDirectoryTreatment(@UnknownKeyFor @NonNull @Initialized DirectoryTreatment directoryTreatment) {
            Preconditions.checkArgument((directoryTreatment != null ? 1 : 0) != 0, (Object)"directoryTreatment can not be null");
            return this.toBuilder().setDirectoryTreatment(directoryTreatment).build();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ReadableFile> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> input) {
            return (PCollection)((Object)input.apply(ParDo.of(new ToReadableFileFn(this))));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.add(DisplayData.item("compression", this.getCompression().toString()));
            builder.add(DisplayData.item("directoryTreatment", this.getDirectoryTreatment().toString()));
        }

        static @UnknownKeyFor @NonNull @Initialized boolean shouldSkipDirectory(@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized DirectoryTreatment directoryTreatment) {
            if (metadata.resourceId().isDirectory()) {
                switch (directoryTreatment) {
                    case SKIP: {
                        return true;
                    }
                    case PROHIBIT: {
                        throw new IllegalArgumentException("Trying to read " + metadata.resourceId() + " which is a directory");
                    }
                }
                throw new UnsupportedOperationException("Unknown DirectoryTreatment: " + (Object)((Object)directoryTreatment));
            }
            return false;
        }

        static @UnknownKeyFor @NonNull @Initialized ReadableFile matchToReadableFile(@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized Compression compression) {
            compression = compression == Compression.AUTO ? Compression.detect(metadata.resourceId().getFilename()) : compression;
            return new ReadableFile(MatchResult.Metadata.builder().setResourceId(metadata.resourceId()).setSizeBytes(metadata.sizeBytes()).setLastModifiedMillis(metadata.lastModifiedMillis()).setIsReadSeekEfficient(metadata.isReadSeekEfficient() && compression == Compression.UNCOMPRESSED).build(), compression);
        }

        private static class ToReadableFileFn
        extends DoFn<MatchResult.Metadata, ReadableFile> {
            private final @UnknownKeyFor @NonNull @Initialized ReadMatches spec;

            private ToReadableFileFn(@UnknownKeyFor @NonNull @Initialized ReadMatches spec) {
                this.spec = spec;
            }

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                if (ReadMatches.shouldSkipDirectory((MatchResult.Metadata)c.element(), this.spec.getDirectoryTreatment())) {
                    return;
                }
                ReadableFile r = ReadMatches.matchToReadableFile((MatchResult.Metadata)c.element(), this.spec.getCompression());
                c.output(r);
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setCompression(@UnknownKeyFor @NonNull @Initialized Compression var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDirectoryTreatment(@UnknownKeyFor @NonNull @Initialized DirectoryTreatment var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadMatches build();
        }

        public static enum DirectoryTreatment {
            SKIP,
            PROHIBIT;

        }
    }

    @AutoValue
    public static abstract class MatchAll
    extends PTransform<PCollection<String>, PCollection<MatchResult.Metadata>> {
        abstract @UnknownKeyFor @NonNull @Initialized MatchConfiguration getConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized MatchAll withConfiguration(@UnknownKeyFor @NonNull @Initialized MatchConfiguration configuration) {
            return this.toBuilder().setConfiguration(configuration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized MatchAll withEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment treatment) {
            return this.withConfiguration(this.getConfiguration().withEmptyMatchTreatment(treatment));
        }

        public @UnknownKeyFor @NonNull @Initialized MatchAll continuously(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition, @UnknownKeyFor @NonNull @Initialized boolean matchUpdatedFiles) {
            return this.withConfiguration(this.getConfiguration().continuously(pollInterval, terminationCondition, matchUpdatedFiles));
        }

        public @UnknownKeyFor @NonNull @Initialized MatchAll continuously(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition) {
            return this.continuously(pollInterval, terminationCondition, false);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            PCollection<MatchResult.Metadata> res = this.getConfiguration().getWatchInterval() == null ? (PCollection<MatchResult.Metadata>)((Object)input.apply("Match filepatterns", ParDo.of(new MatchFn(this.getConfiguration().getEmptyMatchTreatment())))) : (this.getConfiguration().getMatchUpdatedFiles() ? ((PCollection)((PCollection)input.apply(this.createWatchTransform(new ExtractFilenameAndLastUpdateFn()))).apply(Values.create())).setCoder(MetadataCoderV2.of()) : (PCollection)((PCollection)input.apply(this.createWatchTransform(new ExtractFilenameFn()))).apply(Values.create()));
            return (PCollection)res.apply(Reshuffle.viaRandomKey());
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.include("configuration", this.getConfiguration());
        }

        private <KeyT> @UnknownKeyFor @NonNull @Initialized Watch.Growth<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata, KeyT> createWatchTransform(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata, KeyT> outputKeyFn) {
            return Watch.growthOf(Contextful.of(new MatchPollFn(), Requirements.empty()), outputKeyFn).withPollInterval(this.getConfiguration().getWatchInterval()).withTerminationPerInput(this.getConfiguration().getWatchTerminationCondition());
        }

        private static class ExtractFilenameAndLastUpdateFn
        implements SerializableFunction<MatchResult.Metadata, KV<String, Long>> {
            private ExtractFilenameAndLastUpdateFn() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> apply(@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata input) throws @UnknownKeyFor @NonNull @Initialized RuntimeException {
                long timestamp = input.lastModifiedMillis();
                if (0L == timestamp) {
                    throw new RuntimeException("Extract file timestamp failed: got file timestamp == 0.");
                }
                return KV.of(input.resourceId().toString(), timestamp);
            }
        }

        private static class ExtractFilenameFn
        implements SerializableFunction<MatchResult.Metadata, String> {
            private ExtractFilenameFn() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String apply(@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata input) {
                return input.resourceId().toString();
            }
        }

        private static class MatchPollFn
        extends Watch.Growth.PollFn<String, MatchResult.Metadata> {
            private MatchPollFn() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized Watch.Growth.PollResult<@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> apply(@UnknownKeyFor @NonNull @Initialized String element, @UnknownKeyFor @NonNull @Initialized Contextful.Fn.Context c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                Instant now = Instant.now();
                return Watch.Growth.PollResult.incomplete(now, FileSystems.match(element, EmptyMatchTreatment.ALLOW).metadata()).withWatermark(now);
            }
        }

        private static class MatchFn
        extends DoFn<String, MatchResult.Metadata> {
            private final @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment;

            public MatchFn(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment) {
                this.emptyMatchTreatment = emptyMatchTreatment;
            }

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                String filepattern = (String)c.element();
                MatchResult match = FileSystems.match(filepattern, this.emptyMatchTreatment);
                LOG.info("Matched {} files for pattern {}", (Object)match.metadata().size(), (Object)filepattern);
                for (MatchResult.Metadata metadata : match.metadata()) {
                    c.output(metadata);
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConfiguration(@UnknownKeyFor @NonNull @Initialized MatchConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized MatchAll build();
        }
    }

    @AutoValue
    public static abstract class Match
    extends PTransform<PBegin, PCollection<MatchResult.Metadata>> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFilepattern();

        abstract @UnknownKeyFor @NonNull @Initialized MatchConfiguration getConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Match filepattern(@UnknownKeyFor @NonNull @Initialized String filepattern) {
            return this.filepattern(ValueProvider.StaticValueProvider.of(filepattern));
        }

        public @UnknownKeyFor @NonNull @Initialized Match filepattern(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Match withConfiguration(@UnknownKeyFor @NonNull @Initialized MatchConfiguration configuration) {
            return this.toBuilder().setConfiguration(configuration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Match withEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment treatment) {
            return this.withConfiguration(this.getConfiguration().withEmptyMatchTreatment(treatment));
        }

        public @UnknownKeyFor @NonNull @Initialized Match continuously(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition, @UnknownKeyFor @NonNull @Initialized boolean matchUpdatedFiles) {
            return this.withConfiguration(this.getConfiguration().continuously(pollInterval, terminationCondition, matchUpdatedFiles));
        }

        public @UnknownKeyFor @NonNull @Initialized Match continuously(@UnknownKeyFor @NonNull @Initialized Duration pollInterval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> terminationCondition) {
            return this.continuously(pollInterval, terminationCondition, false);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            return ((PCollection)input.apply("Create filepattern", Create.ofProvider(this.getFilepattern(), StringUtf8Coder.of()))).apply("Via MatchAll", FileIO.matchAll().withConfiguration(this.getConfiguration()));
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item("filePattern", this.getFilepattern()).withLabel("Input File Pattern")).include("configuration", this.getConfiguration());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFilepattern(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConfiguration(@UnknownKeyFor @NonNull @Initialized MatchConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Match build();
        }
    }

    @AutoValue
    public static abstract class MatchConfiguration
    implements HasDisplayData,
    Serializable {
        public static @UnknownKeyFor @NonNull @Initialized MatchConfiguration create(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment) {
            return new AutoValue_FileIO_MatchConfiguration.Builder().setEmptyMatchTreatment(emptyMatchTreatment).setMatchUpdatedFiles(false).build();
        }

        public abstract @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment getEmptyMatchTreatment();

        public abstract @UnknownKeyFor @NonNull @Initialized boolean getMatchUpdatedFiles();

        public abstract @Nullable @UnknownKeyFor @Initialized Duration getWatchInterval();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getWatchTerminationCondition();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized MatchConfiguration withEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment treatment) {
            return this.toBuilder().setEmptyMatchTreatment(treatment).build();
        }

        public @UnknownKeyFor @NonNull @Initialized MatchConfiguration continuously(@UnknownKeyFor @NonNull @Initialized Duration interval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> condition, @UnknownKeyFor @NonNull @Initialized boolean matchUpdatedFiles) {
            return this.toBuilder().setWatchInterval(interval).setWatchTerminationCondition(condition).setMatchUpdatedFiles(matchUpdatedFiles).build();
        }

        public @UnknownKeyFor @NonNull @Initialized MatchConfiguration continuously(@UnknownKeyFor @NonNull @Initialized Duration interval, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> condition) {
            return this.continuously(interval, condition, false);
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.add(DisplayData.item("emptyMatchTreatment", this.getEmptyMatchTreatment().toString()).withLabel("Treatment of filepatterns that match no files"));
            if (this.getWatchInterval() != null) {
                builder.add(DisplayData.item("watchForNewFilesInterval", this.getWatchInterval()).withLabel("Interval to watch for new files")).add(DisplayData.item("isMatchUpdatedFiles", this.getMatchUpdatedFiles()).withLabel("If also match for files with timestamp change"));
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMatchUpdatedFiles(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setWatchInterval(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setWatchTerminationCondition(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Watch.Growth.TerminationCondition<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized MatchConfiguration build();
        }
    }

    public static final class ReadableFile {
        private final @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata;
        private final @UnknownKeyFor @NonNull @Initialized Compression compression;

        ReadableFile(@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized Compression compression) {
            this.metadata = metadata;
            this.compression = compression;
        }

        public @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata getMetadata() {
            return this.metadata;
        }

        public @UnknownKeyFor @NonNull @Initialized Compression getCompression() {
            return this.compression;
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableByteChannel open() throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.compression.readDecompressed(FileSystems.open(this.metadata.resourceId()));
        }

        public @UnknownKeyFor @NonNull @Initialized SeekableByteChannel openSeekable() throws @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkState((boolean)this.getMetadata().isReadSeekEfficient(), (String)"The file %s is not seekable", (Object)this.metadata.resourceId());
            return (SeekableByteChannel)this.open();
        }

        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] readFullyAsBytes() throws @UnknownKeyFor @NonNull @Initialized IOException {
            try (InputStream stream = Channels.newInputStream(this.open());){
                byte[] byArray = StreamUtils.getBytesWithoutClosing(stream);
                return byArray;
            }
        }

        public @UnknownKeyFor @NonNull @Initialized String readFullyAsUTF8String() throws @UnknownKeyFor @NonNull @Initialized IOException {
            return new String(this.readFullyAsBytes(), StandardCharsets.UTF_8);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "ReadableFile{metadata=" + this.metadata + ", compression=" + (Object)((Object)this.compression) + '}';
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReadableFile that = (ReadableFile)o;
            return Objects.equal((Object)this.metadata, (Object)that.metadata) && this.compression == that.compression;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.metadata, this.compression});
        }
    }
}

