/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.rpc.Code;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.apache.beam.sdk.io.gcp.firestore.CounterFactory;
import org.apache.beam.sdk.io.gcp.firestore.DistributionFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1RpcAttemptContexts;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.MovingFunction;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Ints;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RpcQosImpl
implements RpcQos {
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer> NON_RETRYABLE_ERROR_NUMBERS = (Set)ImmutableSet.of((Object)Code.ALREADY_EXISTS, (Object)Code.DATA_LOSS, (Object)Code.FAILED_PRECONDITION, (Object)Code.INVALID_ARGUMENT, (Object)Code.OUT_OF_RANGE, (Object)Code.NOT_FOUND, (Object[])new Code[]{Code.PERMISSION_DENIED, Code.UNIMPLEMENTED}).stream().map(Code::getNumber).collect(ImmutableSet.toImmutableSet());
    private static final @UnknownKeyFor @NonNull @Initialized double MIN_REQUESTS = 1.0;
    private final @UnknownKeyFor @NonNull @Initialized RpcQosOptions options;
    private final @UnknownKeyFor @NonNull @Initialized RpcQosImpl. @UnknownKeyFor @NonNull @Initialized AdaptiveThrottler at;
    private final @UnknownKeyFor @NonNull @Initialized WriteBatcher wb;
    private final @UnknownKeyFor @NonNull @Initialized WriteRampUp writeRampUp;
    private final @UnknownKeyFor @NonNull @Initialized WeakHashMap<@UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context, @UnknownKeyFor @NonNull @Initialized O11y> counters;
    private final @UnknownKeyFor @NonNull @Initialized Random random;
    private final @UnknownKeyFor @NonNull @Initialized Sleeper sleeper;
    private final @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context, @UnknownKeyFor @NonNull @Initialized O11y> computeCounters;
    private final @UnknownKeyFor @NonNull @Initialized DistributionFactory distributionFactory;

    RpcQosImpl(@UnknownKeyFor @NonNull @Initialized RpcQosOptions options, @UnknownKeyFor @NonNull @Initialized Random random, @UnknownKeyFor @NonNull @Initialized Sleeper sleeper, @UnknownKeyFor @NonNull @Initialized CounterFactory counterFactory, @UnknownKeyFor @NonNull @Initialized DistributionFactory distributionFactory) {
        this.options = options;
        this.random = random;
        this.sleeper = sleeper;
        DiagnosticOnlyFilteringDistributionFactory filteringDistributionFactory = new DiagnosticOnlyFilteringDistributionFactory(!options.isShouldReportDiagnosticMetrics(), distributionFactory);
        this.distributionFactory = filteringDistributionFactory;
        this.at = new AdaptiveThrottler(options.getSamplePeriod(), options.getSamplePeriodBucketSize(), options.getThrottleDuration(), options.getOverloadRatio());
        this.wb = new WriteBatcher(options.getSamplePeriod(), options.getSamplePeriodBucketSize(), options.getBatchInitialCount(), options.getBatchTargetLatency(), filteringDistributionFactory);
        this.writeRampUp = new WriteRampUp(500.0 / (double)options.getHintMaxNumWorkers(), filteringDistributionFactory);
        this.counters = new WeakHashMap();
        this.computeCounters = c -> O11y.create(c, counterFactory, filteringDistributionFactory);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RpcQosImpl. @UnknownKeyFor @NonNull @Initialized RpcWriteAttemptImpl newWriteAttempt(@UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context context) {
        return new RpcWriteAttemptImpl(context, this.counters.computeIfAbsent(context, this.computeCounters), new StatusCodeAwareBackoff(this.random, this.options.getMaxAttempts(), this.options.getThrottleDuration(), Collections.emptySet()), this.sleeper);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RpcQosImpl. @UnknownKeyFor @NonNull @Initialized RpcReadAttemptImpl newReadAttempt(@UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context context) {
        ImmutableSet graceStatusCodeNumbers = Collections.emptySet();
        if (FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.RunQuery.equals(context) || FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext.BatchGetDocuments.equals(context)) {
            graceStatusCodeNumbers = ImmutableSet.of((Object)14);
        }
        return new RpcReadAttemptImpl(context, this.counters.computeIfAbsent(context, this.computeCounters), new StatusCodeAwareBackoff(this.random, this.options.getMaxAttempts(), this.options.getThrottleDuration(), (Set<Integer>)graceStatusCodeNumbers), this.sleeper);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean bytesOverLimit(@UnknownKeyFor @NonNull @Initialized long bytes) {
        return bytes > this.options.getBatchMaxBytes();
    }

    private static @UnknownKeyFor @NonNull @Initialized MovingFunction createMovingFunction(@UnknownKeyFor @NonNull @Initialized Duration samplePeriod, @UnknownKeyFor @NonNull @Initialized Duration sampleUpdate) {
        return new MovingFunction(samplePeriod.getMillis(), sampleUpdate.getMillis(), 1, 1, Sum.ofLongs());
    }

    private static class SimpleMetricName
    extends MetricName {
        private final @UnknownKeyFor @NonNull @Initialized String namespace;
        private final @UnknownKeyFor @NonNull @Initialized String name;

        public SimpleMetricName(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public @UnknownKeyFor @NonNull @Initialized String getNamespace() {
            return this.namespace;
        }

        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.name;
        }
    }

    private static final class NullDistribution
    implements Distribution {
        private final @UnknownKeyFor @NonNull @Initialized MetricName name;

        private NullDistribution(@UnknownKeyFor @NonNull @Initialized MetricName name) {
            this.name = name;
        }

        public void update(@UnknownKeyFor @NonNull @Initialized long value) {
        }

        public void update(@UnknownKeyFor @NonNull @Initialized long sum, @UnknownKeyFor @NonNull @Initialized long count, @UnknownKeyFor @NonNull @Initialized long min, @UnknownKeyFor @NonNull @Initialized long max) {
        }

        public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
            return this.name;
        }
    }

    private static final class DiagnosticOnlyFilteringDistributionFactory
    implements DistributionFactory {
        private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> DIAGNOSTIC_ONLY_METRIC_NAMES = ImmutableSet.of((Object)"qos_adaptiveThrottler_allRequestsCount", (Object)"qos_adaptiveThrottler_overloadMaxCount", (Object)"qos_adaptiveThrottler_overloadUsagePct", (Object)"qos_adaptiveThrottler_successfulRequestsCount", (Object)"qos_adaptiveThrottler_throttleProbabilityPct", (Object)"qos_adaptiveThrottler_throttlingMs", (Object[])new String[]{"qos_rampUp_availableWriteCountBudget", "qos_rampUp_throttlingMs", "qos_writeBatcher_batchMaxCount", "qos_write_latencyPerDocumentMs"});
        private final @UnknownKeyFor @NonNull @Initialized boolean excludeMetrics;
        private final @UnknownKeyFor @NonNull @Initialized DistributionFactory delegate;

        private DiagnosticOnlyFilteringDistributionFactory(@UnknownKeyFor @NonNull @Initialized boolean excludeMetrics, @UnknownKeyFor @NonNull @Initialized DistributionFactory delegate) {
            this.excludeMetrics = excludeMetrics;
            this.delegate = delegate;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Distribution get(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
            if (this.excludeMetrics && DIAGNOSTIC_ONLY_METRIC_NAMES.contains(name)) {
                return new NullDistribution(new SimpleMetricName(namespace, name));
            }
            return this.delegate.get(namespace, name);
        }
    }

    static class FlushBufferImpl<@UnknownKeyFor T, @UnknownKeyFor ElementT extends @UnknownKeyFor @NonNull @Initialized RpcQos.RpcWriteAttempt.Element<T>>
    implements RpcQos.RpcWriteAttempt.FlushBuffer<ElementT> {
        final @UnknownKeyFor @NonNull @Initialized int nextBatchMaxCount;
        final @UnknownKeyFor @NonNull @Initialized long nextBatchMaxBytes;
        final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ImmutableList.Builder<ElementT> elements;
        @UnknownKeyFor @NonNull @Initialized int offersAcceptedCount = 0;
        @UnknownKeyFor @NonNull @Initialized long offersAcceptedBytes = 0L;

        public FlushBufferImpl(@UnknownKeyFor @NonNull @Initialized int nextBatchMaxCount, @UnknownKeyFor @NonNull @Initialized long nextBatchMaxBytes) {
            this.nextBatchMaxCount = nextBatchMaxCount;
            this.nextBatchMaxBytes = nextBatchMaxBytes;
            this.elements = ImmutableList.builder();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean offer(ElementT newElement) {
            if (this.offersAcceptedCount < this.nextBatchMaxCount) {
                long newBytesTotal = this.offersAcceptedBytes + newElement.getSerializedSize();
                if (newBytesTotal <= this.nextBatchMaxBytes) {
                    this.elements.add(newElement);
                    ++this.offersAcceptedCount;
                    this.offersAcceptedBytes = newBytesTotal;
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterator<ElementT> iterator() {
            return this.elements.build().iterator();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int getBufferedElementsCount() {
            return this.offersAcceptedCount;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long getBufferedElementsBytes() {
            return this.offersAcceptedBytes;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isFull() {
            return this.isNonEmpty() && (this.offersAcceptedCount == this.nextBatchMaxCount || this.offersAcceptedBytes >= this.nextBatchMaxBytes);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isNonEmpty() {
            return this.offersAcceptedCount > 0;
        }
    }

    private static final class O11y {
        final @UnknownKeyFor @NonNull @Initialized Counter throttlingMs;
        final @UnknownKeyFor @NonNull @Initialized Counter rpcFailures;
        final @UnknownKeyFor @NonNull @Initialized Counter rpcSuccesses;
        final @UnknownKeyFor @NonNull @Initialized Counter rpcStreamValueReceived;
        final @UnknownKeyFor @NonNull @Initialized Distribution rpcDurationMs;
        final @UnknownKeyFor @NonNull @Initialized Distribution latencyPerDocumentMs;
        final @UnknownKeyFor @NonNull @Initialized Distribution batchCapacityCount;

        private O11y(@UnknownKeyFor @NonNull @Initialized Counter throttlingMs, @UnknownKeyFor @NonNull @Initialized Counter rpcFailures, @UnknownKeyFor @NonNull @Initialized Counter rpcSuccesses, @UnknownKeyFor @NonNull @Initialized Counter rpcStreamValueReceived, @UnknownKeyFor @NonNull @Initialized Distribution rpcDurationMs, @UnknownKeyFor @NonNull @Initialized Distribution latencyPerDocumentMs, @UnknownKeyFor @NonNull @Initialized Distribution batchCapacityCount) {
            this.throttlingMs = throttlingMs;
            this.rpcFailures = rpcFailures;
            this.rpcSuccesses = rpcSuccesses;
            this.rpcStreamValueReceived = rpcStreamValueReceived;
            this.rpcDurationMs = rpcDurationMs;
            this.latencyPerDocumentMs = latencyPerDocumentMs;
            this.batchCapacityCount = batchCapacityCount;
        }

        private static @UnknownKeyFor @NonNull @Initialized O11y create(@UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context context, @UnknownKeyFor @NonNull @Initialized CounterFactory counterFactory, @UnknownKeyFor @NonNull @Initialized DistributionFactory distributionFactory) {
            return new O11y(counterFactory.get(context.getNamespace(), "throttlingMs"), counterFactory.get(context.getNamespace(), "rpc_failures"), counterFactory.get(context.getNamespace(), "rpc_successes"), counterFactory.get(context.getNamespace(), "rpc_streamValueReceived"), distributionFactory.get(context.getNamespace(), "rpc_durationMs"), distributionFactory.get(RpcQos.class.getName(), "qos_write_latencyPerDocumentMs"), distributionFactory.get(RpcQos.class.getName(), "qos_write_batchCapacityCount"));
        }
    }

    private static class MovingAverage {
        private final @UnknownKeyFor @NonNull @Initialized MovingFunction sum;
        private final @UnknownKeyFor @NonNull @Initialized MovingFunction count;

        private MovingAverage(@UnknownKeyFor @NonNull @Initialized Duration samplePeriod, @UnknownKeyFor @NonNull @Initialized Duration sampleUpdate) {
            this.sum = RpcQosImpl.createMovingFunction(samplePeriod, sampleUpdate);
            this.count = RpcQosImpl.createMovingFunction(samplePeriod, sampleUpdate);
        }

        private void add(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch, @UnknownKeyFor @NonNull @Initialized long value) {
            this.sum.add(instantSinceEpoch.getMillis(), value);
            this.count.add(instantSinceEpoch.getMillis(), 1L);
        }

        private @UnknownKeyFor @NonNull @Initialized long get(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch) {
            return this.sum.get(instantSinceEpoch.getMillis()) / this.count.get(instantSinceEpoch.getMillis());
        }

        private @UnknownKeyFor @NonNull @Initialized boolean hasValue(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch) {
            return this.sum.isSignificant() && this.count.isSignificant() && this.count.get(instantSinceEpoch.getMillis()) > 0L;
        }
    }

    static final class StatusCodeAwareBackoff {
        private static final @UnknownKeyFor @NonNull @Initialized double RANDOMIZATION_FACTOR = 0.5;
        private static final @UnknownKeyFor @NonNull @Initialized Duration MAX_BACKOFF = Duration.standardMinutes((long)1L);
        private static final @UnknownKeyFor @NonNull @Initialized Duration MAX_CUMULATIVE_BACKOFF = Duration.standardMinutes((long)1L);
        private final @UnknownKeyFor @NonNull @Initialized Random rand;
        private final @UnknownKeyFor @NonNull @Initialized int maxAttempts;
        private final @UnknownKeyFor @NonNull @Initialized Duration initialBackoff;
        private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer> graceStatusCodeNumbers;
        private final @UnknownKeyFor @NonNull @Initialized MovingFunction graceStatusCodeTracker;
        private @UnknownKeyFor @NonNull @Initialized Duration cumulativeBackoff;
        private @UnknownKeyFor @NonNull @Initialized int attempt;

        StatusCodeAwareBackoff(@UnknownKeyFor @NonNull @Initialized Random rand, @UnknownKeyFor @NonNull @Initialized int maxAttempts, @UnknownKeyFor @NonNull @Initialized Duration throttleDuration, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer> graceStatusCodeNumbers) {
            this.rand = rand;
            this.graceStatusCodeNumbers = graceStatusCodeNumbers;
            this.maxAttempts = maxAttempts;
            this.initialBackoff = throttleDuration;
            this.graceStatusCodeTracker = StatusCodeAwareBackoff.createGraceStatusCodeTracker();
            this.cumulativeBackoff = Duration.ZERO;
            this.attempt = 1;
        }

        @UnknownKeyFor @NonNull @Initialized BackoffResult nextBackoff(@UnknownKeyFor @NonNull @Initialized Instant now, @UnknownKeyFor @NonNull @Initialized int statusCodeNumber) {
            if (this.graceStatusCodeNumbers.contains(statusCodeNumber)) {
                long nowMillis = now.getMillis();
                long numGraceStatusCode = this.graceStatusCodeTracker.get(nowMillis);
                this.graceStatusCodeTracker.add(nowMillis, 1L);
                if (numGraceStatusCode < 1L) {
                    return BackoffResults.NONE;
                }
                return this.doBackoff();
            }
            return this.doBackoff();
        }

        private @UnknownKeyFor @NonNull @Initialized BackoffResult doBackoff() {
            if (this.attempt >= this.maxAttempts) {
                return BackoffResults.EXHAUSTED;
            }
            if (this.cumulativeBackoff.compareTo((ReadableDuration)MAX_CUMULATIVE_BACKOFF) >= 0) {
                return BackoffResults.EXHAUSTED;
            }
            double currentIntervalMillis = Math.min((double)this.initialBackoff.getMillis() * Math.pow(1.5, this.attempt - 1), (double)MAX_BACKOFF.getMillis());
            double randomOffset = (this.rand.nextDouble() * 2.0 - 1.0) * 0.5 * currentIntervalMillis;
            long nextBackoffMillis = Math.round(currentIntervalMillis + randomOffset);
            Duration remainingCumulative = MAX_CUMULATIVE_BACKOFF.minus((ReadableDuration)this.cumulativeBackoff);
            nextBackoffMillis = Math.min(nextBackoffMillis, remainingCumulative.getMillis());
            this.cumulativeBackoff = this.cumulativeBackoff.plus((ReadableDuration)Duration.millis((long)nextBackoffMillis));
            ++this.attempt;
            return new BackoffDuration(Duration.millis((long)nextBackoffMillis));
        }

        private static @UnknownKeyFor @NonNull @Initialized MovingFunction createGraceStatusCodeTracker() {
            return RpcQosImpl.createMovingFunction(Duration.standardMinutes((long)1L), Duration.millis((long)500L));
        }

        static final class BackoffDuration
        implements BackoffResult {
            private final @UnknownKeyFor @NonNull @Initialized Duration duration;

            BackoffDuration(@UnknownKeyFor @NonNull @Initialized Duration duration) {
                this.duration = duration;
            }

            @UnknownKeyFor @NonNull @Initialized Duration getDuration() {
                return this.duration;
            }

            @EnsuresNonNullIf(expression={"#1"}, result=true)
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof BackoffDuration)) {
                    return false;
                }
                BackoffDuration that = (BackoffDuration)o;
                return Objects.equals(this.duration, that.duration);
            }

            @Pure
            public @UnknownKeyFor @NonNull @Initialized int hashCode() {
                return Objects.hash(this.duration);
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return "BackoffDuration{duration=" + this.duration + '}';
            }
        }

        static enum BackoffResults implements BackoffResult
        {
            EXHAUSTED,
            NONE;

        }

        static interface BackoffResult {
        }
    }

    private static class LinearBackoff
    implements BackOff {
        private static final @UnknownKeyFor @NonNull @Initialized long MAX_BACKOFF_MILLIS = 60000L;
        private static final @UnknownKeyFor @NonNull @Initialized long MAX_CUMULATIVE_MILLIS = 60000L;
        private final @UnknownKeyFor @NonNull @Initialized long startBackoffMillis;
        private @UnknownKeyFor @NonNull @Initialized long currentBackoffMillis;
        private @UnknownKeyFor @NonNull @Initialized long cumulativeMillis;

        public LinearBackoff(@UnknownKeyFor @NonNull @Initialized Duration throttleDuration) {
            this.currentBackoffMillis = this.startBackoffMillis = throttleDuration.getMillis();
            this.cumulativeMillis = 0L;
        }

        public void reset() {
            this.currentBackoffMillis = this.startBackoffMillis;
            this.cumulativeMillis = 0L;
        }

        public @UnknownKeyFor @NonNull @Initialized long nextBackOffMillis() {
            if (this.currentBackoffMillis > 60000L) {
                this.reset();
                return 60000L;
            }
            long remainingBudget = Math.max(60000L - this.cumulativeMillis, 0L);
            if (remainingBudget == 0L) {
                this.reset();
                return -1L;
            }
            long retVal = Math.min(this.currentBackoffMillis, remainingBudget);
            this.currentBackoffMillis = (long)((double)this.currentBackoffMillis * 1.5);
            this.cumulativeMillis += retVal;
            return retVal;
        }
    }

    @VisibleForTesting
    static final class WriteRampUp {
        private static final @UnknownKeyFor @NonNull @Initialized Duration RAMP_UP_INTERVAL = Duration.standardMinutes((long)5L);
        private final @UnknownKeyFor @NonNull @Initialized double baseBatchBudget;
        private final @UnknownKeyFor @NonNull @Initialized long rampUpIntervalMinutes;
        private final @UnknownKeyFor @NonNull @Initialized MovingFunction writeCounts;
        private final @UnknownKeyFor @NonNull @Initialized LinearBackoff backoff;
        private final @UnknownKeyFor @NonNull @Initialized Distribution throttlingMs;
        private final @UnknownKeyFor @NonNull @Initialized Distribution availableWriteCountBudget;
        private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Instant> firstInstant = Optional.empty();

        WriteRampUp(@UnknownKeyFor @NonNull @Initialized double baseBatchBudget, @UnknownKeyFor @NonNull @Initialized DistributionFactory distributionFactory) {
            this.baseBatchBudget = baseBatchBudget;
            this.rampUpIntervalMinutes = RAMP_UP_INTERVAL.getStandardMinutes();
            this.writeCounts = RpcQosImpl.createMovingFunction(Duration.standardSeconds((long)1L), Duration.standardSeconds((long)1L));
            this.backoff = new LinearBackoff(Duration.standardSeconds((long)1L));
            this.throttlingMs = distributionFactory.get(RpcQos.class.getName(), "qos_rampUp_throttlingMs");
            this.availableWriteCountBudget = distributionFactory.get(RpcQos.class.getName(), "qos_rampUp_availableWriteCountBudget");
        }

        @UnknownKeyFor @NonNull @Initialized int getAvailableWriteCountBudget(@UnknownKeyFor @NonNull @Initialized Instant instant) {
            if (!this.firstInstant.isPresent()) {
                this.firstInstant = Optional.of(instant);
                return (int)Math.max(1.0, this.baseBatchBudget);
            }
            Instant first = this.firstInstant.get();
            double maxRequestBudget = this.calcMaxRequestBudget(instant, first);
            long writeCount = this.writeCounts.get(instant.getMillis());
            double availableBudget = maxRequestBudget - (double)writeCount;
            int budget = Ints.saturatedCast((long)((long)availableBudget));
            this.availableWriteCountBudget.update((long)budget);
            return budget;
        }

        private @UnknownKeyFor @NonNull @Initialized double calcMaxRequestBudget(@UnknownKeyFor @NonNull @Initialized Instant instant, @UnknownKeyFor @NonNull @Initialized Instant first) {
            Duration durationSinceFirst = new Duration((ReadableInstant)first, (ReadableInstant)instant);
            long calculatedGrowth = (durationSinceFirst.getStandardMinutes() - this.rampUpIntervalMinutes) / this.rampUpIntervalMinutes;
            long growth = Math.max(0L, calculatedGrowth);
            return this.baseBatchBudget * Math.pow(1.5, growth);
        }

        void recordWriteCount(@UnknownKeyFor @NonNull @Initialized Instant instant, @UnknownKeyFor @NonNull @Initialized int numWrites) {
            this.writeCounts.add(instant.getMillis(), (long)numWrites);
        }

        @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Duration> shouldThrottle(@UnknownKeyFor @NonNull @Initialized Instant instant) {
            int availableWriteCountBudget = this.getAvailableWriteCountBudget(instant);
            if (availableWriteCountBudget <= 0) {
                long nextBackOffMillis = this.backoff.nextBackOffMillis();
                if (nextBackOffMillis > -1L) {
                    Duration throttleDuration = Duration.millis((long)nextBackOffMillis);
                    this.throttlingMs.update(throttleDuration.getMillis());
                    return Optional.of(throttleDuration);
                }
                this.backoff.reset();
                return Optional.empty();
            }
            this.backoff.reset();
            return Optional.empty();
        }
    }

    private final class AdaptiveThrottler {
        private final @UnknownKeyFor @NonNull @Initialized MovingFunction successfulRequestsMovingFunction;
        private final @UnknownKeyFor @NonNull @Initialized MovingFunction failedRequestsMovingFunction;
        private final @UnknownKeyFor @NonNull @Initialized MovingFunction allRequestsMovingFunction;
        private final @UnknownKeyFor @NonNull @Initialized Distribution allRequestsCountDist;
        private final @UnknownKeyFor @NonNull @Initialized Distribution successfulRequestsCountDist;
        private final @UnknownKeyFor @NonNull @Initialized Distribution overloadMaxCountDist;
        private final @UnknownKeyFor @NonNull @Initialized Distribution overloadUsageDist;
        private final @UnknownKeyFor @NonNull @Initialized Distribution throttleProbabilityDist;
        private final @UnknownKeyFor @NonNull @Initialized Distribution throttlingMs;
        private final @UnknownKeyFor @NonNull @Initialized LinearBackoff backoff;
        private final @UnknownKeyFor @NonNull @Initialized double overloadRatio;

        private AdaptiveThrottler(@UnknownKeyFor @NonNull @Initialized Duration samplePeriod, @UnknownKeyFor @NonNull @Initialized Duration samplePeriodBucketSize, @UnknownKeyFor @NonNull @Initialized Duration throttleDuration, double overloadRatio) {
            this.allRequestsMovingFunction = RpcQosImpl.createMovingFunction(samplePeriod, samplePeriodBucketSize);
            this.successfulRequestsMovingFunction = RpcQosImpl.createMovingFunction(samplePeriod, samplePeriodBucketSize);
            this.failedRequestsMovingFunction = RpcQosImpl.createMovingFunction(samplePeriod, samplePeriodBucketSize);
            this.allRequestsCountDist = RpcQosImpl.this.distributionFactory.get(RpcQos.class.getName(), "qos_adaptiveThrottler_allRequestsCount");
            this.successfulRequestsCountDist = RpcQosImpl.this.distributionFactory.get(RpcQos.class.getName(), "qos_adaptiveThrottler_successfulRequestsCount");
            this.overloadMaxCountDist = RpcQosImpl.this.distributionFactory.get(RpcQos.class.getName(), "qos_adaptiveThrottler_overloadMaxCount");
            this.overloadUsageDist = RpcQosImpl.this.distributionFactory.get(RpcQos.class.getName(), "qos_adaptiveThrottler_overloadUsagePct");
            this.throttleProbabilityDist = RpcQosImpl.this.distributionFactory.get(RpcQos.class.getName(), "qos_adaptiveThrottler_throttleProbabilityPct");
            this.throttlingMs = RpcQosImpl.this.distributionFactory.get(RpcQos.class.getName(), "qos_adaptiveThrottler_throttlingMs");
            this.backoff = new LinearBackoff(throttleDuration);
            this.overloadRatio = overloadRatio;
        }

        private @UnknownKeyFor @NonNull @Initialized Duration shouldThrottleRequest(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch) {
            double delayProbability = this.throttlingProbability(instantSinceEpoch);
            if (RpcQosImpl.this.random.nextDouble() < delayProbability) {
                long millis = this.backoff.nextBackOffMillis();
                this.throttlingMs.update(millis);
                return Duration.millis((long)millis);
            }
            this.backoff.reset();
            return Duration.ZERO;
        }

        private void recordRequestStart(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch) {
            this.recordRequestStart(instantSinceEpoch, 1);
        }

        private void recordRequestStart(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch, @UnknownKeyFor @NonNull @Initialized int value) {
            this.allRequestsMovingFunction.add(instantSinceEpoch.getMillis(), (long)value);
        }

        private void recordRequestSuccessful(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch) {
            this.recordRequestSuccessful(instantSinceEpoch, 1);
        }

        private void recordRequestSuccessful(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch, @UnknownKeyFor @NonNull @Initialized int value) {
            this.successfulRequestsMovingFunction.add(instantSinceEpoch.getMillis(), (long)value);
        }

        private void recordRequestFailed(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch) {
            this.recordRequestFailed(instantSinceEpoch, 1);
        }

        private void recordRequestFailed(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch, @UnknownKeyFor @NonNull @Initialized int value) {
            this.failedRequestsMovingFunction.add(instantSinceEpoch.getMillis(), (long)value);
        }

        private @UnknownKeyFor @NonNull @Initialized double throttlingProbability(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch) {
            if (!this.allRequestsMovingFunction.isSignificant()) {
                return 0.0;
            }
            long nowMsSinceEpoch = instantSinceEpoch.getMillis();
            long allRequestsCount = this.allRequestsMovingFunction.get(nowMsSinceEpoch);
            long successfulRequestsCount = this.successfulRequestsMovingFunction.get(nowMsSinceEpoch);
            double overloadMaxCount = this.overloadRatio * (double)successfulRequestsCount;
            double overloadUsage = (double)allRequestsCount - overloadMaxCount;
            double calcProbability = overloadUsage / ((double)allRequestsCount + 1.0);
            this.allRequestsCountDist.update(allRequestsCount);
            this.successfulRequestsCountDist.update(successfulRequestsCount);
            this.overloadMaxCountDist.update((long)overloadMaxCount);
            this.overloadUsageDist.update((long)(overloadUsage * 100.0));
            this.throttleProbabilityDist.update((long)(calcProbability * 100.0));
            return Math.max(0.0, calcProbability);
        }
    }

    private static final class WriteBatcher {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WriteBatcher.class);
        private final @UnknownKeyFor @NonNull @Initialized int batchInitialCount;
        private final @UnknownKeyFor @NonNull @Initialized Duration batchTargetLatency;
        private final @UnknownKeyFor @NonNull @Initialized MovingAverage meanLatencyPerDocumentMs;
        private final @UnknownKeyFor @NonNull @Initialized Distribution batchMaxCount;

        private WriteBatcher(@UnknownKeyFor @NonNull @Initialized Duration samplePeriod, @UnknownKeyFor @NonNull @Initialized Duration samplePeriodBucketSize, @UnknownKeyFor @NonNull @Initialized int batchInitialCount, @UnknownKeyFor @NonNull @Initialized Duration batchTargetLatency, @UnknownKeyFor @NonNull @Initialized DistributionFactory distributionFactory) {
            this.batchInitialCount = batchInitialCount;
            this.batchTargetLatency = batchTargetLatency;
            this.meanLatencyPerDocumentMs = new MovingAverage(samplePeriod, samplePeriodBucketSize);
            this.batchMaxCount = distributionFactory.get(RpcQos.class.getName(), "qos_writeBatcher_batchMaxCount");
        }

        private void recordRequestLatency(@UnknownKeyFor @NonNull @Initialized Instant start, @UnknownKeyFor @NonNull @Initialized Instant end, @UnknownKeyFor @NonNull @Initialized int numWrites, @UnknownKeyFor @NonNull @Initialized Distribution distribution) {
            try {
                Interval interval = new Interval((ReadableInstant)start, (ReadableInstant)end);
                long msPerWrite = numWrites == 0 ? 0L : interval.toDurationMillis() / (long)numWrites;
                distribution.update(msPerWrite);
                this.meanLatencyPerDocumentMs.add(end, msPerWrite);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Invalid time interval start = {} end = {}", new Object[]{start, end, e});
            }
        }

        private @UnknownKeyFor @NonNull @Initialized int nextBatchMaxCount(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch) {
            if (!this.meanLatencyPerDocumentMs.hasValue(instantSinceEpoch)) {
                return this.batchInitialCount;
            }
            long recentMeanLatency = Math.max(this.meanLatencyPerDocumentMs.get(instantSinceEpoch), 1L);
            long nextBatchMaxCount = this.batchTargetLatency.getMillis() / recentMeanLatency;
            int count = Math.toIntExact(nextBatchMaxCount);
            this.batchMaxCount.update((long)count);
            return count;
        }
    }

    final class RpcWriteAttemptImpl
    extends BaseRpcAttempt
    implements RpcQos.RpcWriteAttempt {
        private RpcWriteAttemptImpl(@UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context context, @UnknownKeyFor @NonNull @Initialized O11y o11y, @UnknownKeyFor @NonNull @Initialized StatusCodeAwareBackoff backoff, Sleeper sleeper) {
            super(context, o11y, backoff, sleeper);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean awaitSafeToProceed(@UnknownKeyFor @NonNull @Initialized Instant instant) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            this.state.checkActive();
            Optional<Duration> shouldThrottle = RpcQosImpl.this.writeRampUp.shouldThrottle(instant);
            if (shouldThrottle.isPresent()) {
                Duration throttleDuration = shouldThrottle.get();
                long throttleDurationMillis = throttleDuration.getMillis();
                this.getLogger().debug("Still ramping up, Delaying request by {}ms", (Object)throttleDurationMillis);
                this.throttleRequest(throttleDuration);
                return false;
            }
            return super.awaitSafeToProceed(instant);
        }

        public <T, ElementT extends RpcQos.RpcWriteAttempt.Element<T>> @UnknownKeyFor @NonNull @Initialized FlushBufferImpl<T, ElementT> newFlushBuffer(@UnknownKeyFor @NonNull @Initialized Instant instantSinceEpoch) {
            this.state.checkActive();
            int availableWriteCountBudget = RpcQosImpl.this.writeRampUp.getAvailableWriteCountBudget(instantSinceEpoch);
            int nextBatchMaxCount = RpcQosImpl.this.wb.nextBatchMaxCount(instantSinceEpoch);
            int batchMaxCount = Ints.min((int[])new int[]{Math.max(0, availableWriteCountBudget), Math.max(0, nextBatchMaxCount), RpcQosImpl.this.options.getBatchMaxCount()});
            this.o11y.batchCapacityCount.update((long)batchMaxCount);
            return new FlushBufferImpl(batchMaxCount, RpcQosImpl.this.options.getBatchMaxBytes());
        }

        @Override
        public void recordRequestStart(@UnknownKeyFor @NonNull @Initialized Instant start, @UnknownKeyFor @NonNull @Initialized int numWrites) {
            RpcQosImpl.this.at.recordRequestStart(start, numWrites);
            RpcQosImpl.this.writeRampUp.recordWriteCount(start, numWrites);
            this.start = start;
            this.state = AttemptState.STARTED;
        }

        @Override
        public void recordWriteCounts(@UnknownKeyFor @NonNull @Initialized Instant end, @UnknownKeyFor @NonNull @Initialized int successfulWrites, @UnknownKeyFor @NonNull @Initialized int failedWrites) {
            int totalWrites = successfulWrites + failedWrites;
            this.state.checkStarted();
            RpcQosImpl.this.wb.recordRequestLatency(this.start, end, totalWrites, this.o11y.latencyPerDocumentMs);
            if (successfulWrites > 0) {
                RpcQosImpl.this.at.recordRequestSuccessful(this.start, successfulWrites);
            }
            if (failedWrites > 0) {
                RpcQosImpl.this.at.recordRequestFailed(this.start, failedWrites);
            }
        }
    }

    private final class RpcReadAttemptImpl
    extends BaseRpcAttempt
    implements RpcQos.RpcReadAttempt {
        private RpcReadAttemptImpl(@UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context context, @UnknownKeyFor @NonNull @Initialized O11y o11y, @UnknownKeyFor @NonNull @Initialized StatusCodeAwareBackoff backoff, Sleeper sleeper) {
            super(context, o11y, backoff, sleeper);
        }

        @Override
        public void recordRequestStart(@UnknownKeyFor @NonNull @Initialized Instant start) {
            RpcQosImpl.this.at.recordRequestStart(start);
            this.start = start;
            this.state = AttemptState.STARTED;
        }

        @Override
        public void recordStreamValue(@UnknownKeyFor @NonNull @Initialized Instant now) {
            this.state.checkActive();
            this.o11y.rpcStreamValueReceived.inc();
        }
    }

    private abstract class BaseRpcAttempt
    implements RpcQos.RpcAttempt {
        private final @UnknownKeyFor @NonNull @Initialized Logger logger;
        final @UnknownKeyFor @NonNull @Initialized O11y o11y;
        final @UnknownKeyFor @NonNull @Initialized StatusCodeAwareBackoff backoff;
        final @UnknownKeyFor @NonNull @Initialized Sleeper sleeper;
        @UnknownKeyFor @NonNull @Initialized AttemptState state;
        @UnknownKeyFor @NonNull @Initialized Instant start;

        BaseRpcAttempt(@UnknownKeyFor @NonNull @Initialized RpcQos.RpcAttempt.Context context, @UnknownKeyFor @NonNull @Initialized O11y o11y, @UnknownKeyFor @NonNull @Initialized StatusCodeAwareBackoff backoff, Sleeper sleeper) {
            this.logger = LoggerFactory.getLogger((String)String.format("%s.RpcQos", context.getNamespace()));
            this.o11y = o11y;
            this.backoff = backoff;
            this.sleeper = sleeper;
            this.state = AttemptState.PENDING;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean awaitSafeToProceed(@UnknownKeyFor @NonNull @Initialized Instant instant) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            this.state.checkActive();
            Duration shouldThrottleRequest = RpcQosImpl.this.at.shouldThrottleRequest(instant);
            if (shouldThrottleRequest.compareTo((ReadableDuration)Duration.ZERO) > 0) {
                long throttleRequestMillis = shouldThrottleRequest.getMillis();
                this.logger.debug("Delaying request by {}ms", (Object)throttleRequestMillis);
                this.throttleRequest(shouldThrottleRequest);
                return false;
            }
            return true;
        }

        @Override
        public void checkCanRetry(@UnknownKeyFor @NonNull @Initialized Instant instant, @UnknownKeyFor @NonNull @Initialized RuntimeException exception) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            block4: {
                block2: {
                    ApiException apiException;
                    block3: {
                        this.state.checkActive();
                        Optional<ApiException> findApiException = this.findApiException(exception);
                        if (!findApiException.isPresent()) break block2;
                        apiException = findApiException.get();
                        Optional<Integer> statusCodeNumber = this.getStatusCodeNumber(apiException);
                        if (this.maxAttemptsExhausted(instant, statusCodeNumber.orElse(2))) break block3;
                        if (!statusCodeNumber.map(NON_RETRYABLE_ERROR_NUMBERS::contains).orElse(false).booleanValue() && apiException.isRetryable()) break block4;
                    }
                    this.state = AttemptState.COMPLETE_ERROR;
                    throw apiException;
                }
                this.state = AttemptState.COMPLETE_ERROR;
                throw exception;
            }
        }

        @Override
        public void completeSuccess() {
            this.state.checkActive();
            this.state = AttemptState.COMPLETE_SUCCESS;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isCodeRetryable(@UnknownKeyFor @NonNull @Initialized Code code) {
            return !NON_RETRYABLE_ERROR_NUMBERS.contains(code.getNumber());
        }

        @Override
        public void recordRequestSuccessful(@UnknownKeyFor @NonNull @Initialized Instant end) {
            this.state.checkStarted();
            this.o11y.rpcSuccesses.inc();
            this.o11y.rpcDurationMs.update(this.durationMs(end));
            RpcQosImpl.this.at.recordRequestSuccessful(this.start);
        }

        @Override
        public void recordRequestFailed(@UnknownKeyFor @NonNull @Initialized Instant end) {
            this.state.checkStarted();
            this.o11y.rpcFailures.inc();
            this.o11y.rpcDurationMs.update(this.durationMs(end));
            RpcQosImpl.this.at.recordRequestFailed(this.start);
        }

        private @UnknownKeyFor @NonNull @Initialized boolean maxAttemptsExhausted(@UnknownKeyFor @NonNull @Initialized Instant now, @UnknownKeyFor @NonNull @Initialized int statusCodeNumber) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            StatusCodeAwareBackoff.BackoffResult backoffResult = this.backoff.nextBackoff(now, statusCodeNumber);
            if (StatusCodeAwareBackoff.BackoffResults.EXHAUSTED.equals(backoffResult)) {
                this.logger.error("Max attempts exhausted after {} attempts.", (Object)RpcQosImpl.this.options.getMaxAttempts());
                return true;
            }
            if (backoffResult instanceof StatusCodeAwareBackoff.BackoffDuration) {
                StatusCodeAwareBackoff.BackoffDuration result = (StatusCodeAwareBackoff.BackoffDuration)backoffResult;
                this.sleeper.sleep(result.getDuration().getMillis());
                return false;
            }
            return false;
        }

        @UnknownKeyFor @NonNull @Initialized Logger getLogger() {
            return this.logger;
        }

        final void throttleRequest(@UnknownKeyFor @NonNull @Initialized Duration shouldThrottleRequest) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            this.o11y.throttlingMs.inc(shouldThrottleRequest.getMillis());
            this.sleeper.sleep(shouldThrottleRequest.getMillis());
        }

        final @UnknownKeyFor @NonNull @Initialized long durationMs(@UnknownKeyFor @NonNull @Initialized Instant end) {
            return end.minus((ReadableDuration)Duration.millis((long)this.start.getMillis())).getMillis();
        }

        private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Integer> getStatusCodeNumber(@UnknownKeyFor @NonNull @Initialized ApiException apiException) {
            StatusCode statusCode = apiException.getStatusCode();
            if (statusCode instanceof GrpcStatusCode) {
                GrpcStatusCode grpcStatusCode = (GrpcStatusCode)statusCode;
                return Optional.of(grpcStatusCode.getTransportCode().value());
            }
            return Optional.empty();
        }

        private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ApiException> findApiException(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
            if (throwable instanceof ApiException) {
                ApiException apiException = (ApiException)throwable;
                return Optional.of(apiException);
            }
            Throwable cause = throwable.getCause();
            if (cause != null) {
                return this.findApiException(cause);
            }
            return Optional.empty();
        }
    }

    private static enum AttemptState {
        PENDING,
        STARTED,
        COMPLETE_SUCCESS,
        COMPLETE_ERROR;


        public void checkActive() {
            switch (this) {
                case PENDING: 
                case STARTED: {
                    return;
                }
                case COMPLETE_SUCCESS: {
                    throw new IllegalStateException("Expected state to be PENDING or STARTED, but was COMPLETE_SUCCESS");
                }
                case COMPLETE_ERROR: {
                    throw new IllegalStateException("Expected state to be PENDING or STARTED, but was COMPLETE_ERROR");
                }
            }
        }

        public void checkStarted() {
            switch (this) {
                case STARTED: {
                    return;
                }
                case PENDING: {
                    throw new IllegalStateException("Expected state to be STARTED, but was PENDING");
                }
                case COMPLETE_SUCCESS: {
                    throw new IllegalStateException("Expected state to be STARTED, but was COMPLETE_SUCCESS");
                }
                case COMPLETE_ERROR: {
                    throw new IllegalStateException("Expected state to be STARTED, but was COMPLETE_ERROR");
                }
            }
        }
    }
}

