/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.veneer.repackaged.io.opencensus.implcore.stats;

import com.google.bigtable.veneer.repackaged.io.opencensus.common.Clock;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.internal.CurrentState;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.internal.EventQueue;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.stats.MeasureMapInternal;
import com.google.bigtable.veneer.repackaged.io.opencensus.implcore.stats.MeasureToViewMap;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Metric;
import com.google.bigtable.veneer.repackaged.io.opencensus.stats.View;
import com.google.bigtable.veneer.repackaged.io.opencensus.stats.ViewData;
import com.google.bigtable.veneer.repackaged.io.opencensus.tags.TagContext;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;

final class StatsManager {
    private final EventQueue queue;
    private final Clock clock;
    private final CurrentState state;
    private final MeasureToViewMap measureToViewMap = new MeasureToViewMap();

    StatsManager(EventQueue queue, Clock clock, CurrentState state) {
        Preconditions.checkNotNull((Object)queue, (Object)"EventQueue");
        Preconditions.checkNotNull((Object)clock, (Object)"Clock");
        Preconditions.checkNotNull((Object)state, (Object)"state");
        this.queue = queue;
        this.clock = clock;
        this.state = state;
    }

    void registerView(View view) {
        this.measureToViewMap.registerView(view, this.clock);
    }

    @Nullable
    ViewData getView(View.Name viewName) {
        return this.measureToViewMap.getView(viewName, this.clock, this.state.getInternal());
    }

    Set<View> getExportedViews() {
        return this.measureToViewMap.getExportedViews();
    }

    void record(TagContext tags, MeasureMapInternal measurementValues) {
        if (this.state.getInternal() == CurrentState.State.ENABLED) {
            this.queue.enqueue(new StatsEvent(this, tags, measurementValues));
        }
    }

    Collection<Metric> getMetrics() {
        return this.measureToViewMap.getMetrics(this.clock, this.state.getInternal());
    }

    void clearStats() {
        this.measureToViewMap.clearStats();
    }

    void resumeStatsCollection() {
        this.measureToViewMap.resumeStatsCollection(this.clock.now());
    }

    private static final class StatsEvent
    implements EventQueue.Entry {
        private final TagContext tags;
        private final MeasureMapInternal stats;
        private final StatsManager statsManager;

        StatsEvent(StatsManager statsManager, TagContext tags, MeasureMapInternal stats) {
            this.statsManager = statsManager;
            this.tags = tags;
            this.stats = stats;
        }

        @Override
        public void process() {
            this.statsManager.measureToViewMap.record(this.tags, this.stats, this.statsManager.clock.now());
        }
    }
}

