/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.opencensus.implcore.tags;

import com.clickhouse.client.internal.opencensus.implcore.tags.TagValueWithMetadata;
import com.clickhouse.client.internal.opencensus.tags.Tag;
import com.clickhouse.client.internal.opencensus.tags.TagContext;
import com.clickhouse.client.internal.opencensus.tags.TagKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TagMapImpl
extends TagContext {
    public static final TagMapImpl EMPTY = new TagMapImpl(Collections.emptyMap());
    private final Map<TagKey, TagValueWithMetadata> tags;

    public TagMapImpl(Map<? extends TagKey, ? extends TagValueWithMetadata> tags) {
        this.tags = Collections.unmodifiableMap(new HashMap<TagKey, TagValueWithMetadata>(tags));
    }

    public Map<TagKey, TagValueWithMetadata> getTags() {
        return this.tags;
    }

    @Override
    protected Iterator<Tag> getIterator() {
        return new TagIterator(this.tags);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other instanceof TagMapImpl) {
            return this.getTags().equals(((TagMapImpl)other).getTags());
        }
        return super.equals(other);
    }

    private static final class TagIterator
    implements Iterator<Tag> {
        Iterator<Map.Entry<TagKey, TagValueWithMetadata>> iterator;

        TagIterator(Map<TagKey, TagValueWithMetadata> tags) {
            this.iterator = tags.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Tag next() {
            Map.Entry<TagKey, TagValueWithMetadata> next = this.iterator.next();
            TagValueWithMetadata valueWithMetadata = next.getValue();
            return Tag.create(next.getKey(), valueWithMetadata.getTagValue(), valueWithMetadata.getTagMetadata());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("TagIterator.remove()");
        }
    }
}

