/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.sftp;

import java.net.InetAddress;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.sftp.ActionSftp;
import org.apache.hop.workflow.actions.sftp.SftpClient;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionSftpDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionSftp.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionSftp.Filetype.Pem", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftp.Filetype.All", (String[])new String[0])};
    private Text wName;
    private TextVar wServerName;
    private TextVar wServerPort;
    private TextVar wUserName;
    private TextVar wPassword;
    private TextVar wScpDirectory;
    private TextVar wTargetDirectory;
    private Label wlWildcard;
    private TextVar wWildcard;
    private Button wRemove;
    private ActionSftp action;
    private boolean changed;
    private Button wAddFilenameToResult;
    private Button wCreateTargetFolder;
    private Button wGetPrevious;
    private LabelTextVar wKeyfilePass;
    private Button wUsePublicKey;
    private Label wlKeyFilename;
    private Button wbKeyFilename;
    private TextVar wKeyFilename;
    private SftpClient sftpclient = null;
    private CCombo wCompression;
    private CCombo wProxyType;
    private LabelTextVar wProxyHost;
    private LabelTextVar wProxyPort;
    private LabelTextVar wProxyUsername;
    private LabelTextVar wProxyPassword;

    public ActionSftpDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionSftp)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionSftp.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> {
            this.sftpclient = null;
            this.action.setChanged();
        };
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionSftp.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionSftp.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ActionSftp.Tab.General.Label", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wServerSettings = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wServerSettings);
        wServerSettings.setText(BaseMessages.getString(PKG, (String)"ActionSftp.ServerSettings.Group.Label", (String[])new String[0]));
        FormLayout serverSettingsgroupLayout = new FormLayout();
        serverSettingsgroupLayout.marginWidth = 10;
        serverSettingsgroupLayout.marginHeight = 10;
        wServerSettings.setLayout((Layout)serverSettingsgroupLayout);
        Label wlServerName = new Label((Composite)wServerSettings, 131072);
        wlServerName.setText(BaseMessages.getString(PKG, (String)"ActionSftp.Server.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlServerName);
        FormData fdlServerName = new FormData();
        fdlServerName.left = new FormAttachment(0, 0);
        fdlServerName.top = new FormAttachment((Control)this.wName, margin);
        fdlServerName.right = new FormAttachment(middle, -margin);
        wlServerName.setLayoutData((Object)fdlServerName);
        this.wServerName = new TextVar(this.variables, (Composite)wServerSettings, 18436);
        PropsUi.setLook((Widget)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        FormData fdServerName = new FormData();
        fdServerName.left = new FormAttachment(middle, 0);
        fdServerName.top = new FormAttachment((Control)this.wName, margin);
        fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData((Object)fdServerName);
        Label wlServerPort = new Label((Composite)wServerSettings, 131072);
        wlServerPort.setText(BaseMessages.getString(PKG, (String)"ActionSftp.Port.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlServerPort);
        FormData fdlServerPort = new FormData();
        fdlServerPort.left = new FormAttachment(0, 0);
        fdlServerPort.top = new FormAttachment((Control)this.wServerName, margin);
        fdlServerPort.right = new FormAttachment(middle, -margin);
        wlServerPort.setLayoutData((Object)fdlServerPort);
        this.wServerPort = new TextVar(this.variables, (Composite)wServerSettings, 18436);
        PropsUi.setLook((Widget)this.wServerPort);
        this.wServerPort.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftp.Port.Tooltip", (String[])new String[0]));
        this.wServerPort.addModifyListener(lsMod);
        FormData fdServerPort = new FormData();
        fdServerPort.left = new FormAttachment(middle, 0);
        fdServerPort.top = new FormAttachment((Control)this.wServerName, margin);
        fdServerPort.right = new FormAttachment(100, 0);
        this.wServerPort.setLayoutData((Object)fdServerPort);
        Label wlUserName = new Label((Composite)wServerSettings, 131072);
        wlUserName.setText(BaseMessages.getString(PKG, (String)"ActionSftp.Username.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUserName);
        FormData fdlUserName = new FormData();
        fdlUserName.left = new FormAttachment(0, 0);
        fdlUserName.top = new FormAttachment((Control)this.wServerPort, margin);
        fdlUserName.right = new FormAttachment(middle, -margin);
        wlUserName.setLayoutData((Object)fdlUserName);
        this.wUserName = new TextVar(this.variables, (Composite)wServerSettings, 18436);
        PropsUi.setLook((Widget)this.wUserName);
        this.wUserName.addModifyListener(lsMod);
        FormData fdUserName = new FormData();
        fdUserName.left = new FormAttachment(middle, 0);
        fdUserName.top = new FormAttachment((Control)this.wServerPort, margin);
        fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData((Object)fdUserName);
        Label wlPassword = new Label((Composite)wServerSettings, 131072);
        wlPassword.setText(BaseMessages.getString(PKG, (String)"ActionSftp.Password.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPassword);
        FormData fdlPassword = new FormData();
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdlPassword.right = new FormAttachment(middle, -margin);
        wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar(this.variables, (Composite)wServerSettings, 18436);
        PropsUi.setLook((Widget)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(middle, 0);
        fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        Label wlUsePublicKey = new Label((Composite)wServerSettings, 131072);
        wlUsePublicKey.setText(BaseMessages.getString(PKG, (String)"ActionSftp.useKeyFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUsePublicKey);
        FormData fdlUsePublicKey = new FormData();
        fdlUsePublicKey.left = new FormAttachment(0, 0);
        fdlUsePublicKey.top = new FormAttachment((Control)this.wPassword, margin);
        fdlUsePublicKey.right = new FormAttachment(middle, -margin);
        wlUsePublicKey.setLayoutData((Object)fdlUsePublicKey);
        this.wUsePublicKey = new Button((Composite)wServerSettings, 32);
        this.wUsePublicKey.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftp.useKeyFile.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUsePublicKey);
        FormData fdUsePublicKey = new FormData();
        fdUsePublicKey.left = new FormAttachment(middle, 0);
        fdUsePublicKey.top = new FormAttachment((Control)wlUsePublicKey, 0, 0x1000000);
        fdUsePublicKey.right = new FormAttachment(100, 0);
        this.wUsePublicKey.setLayoutData((Object)fdUsePublicKey);
        this.wUsePublicKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionSftpDialog.this.activeUseKey();
                ActionSftpDialog.this.action.setChanged();
            }
        });
        this.wlKeyFilename = new Label((Composite)wServerSettings, 131072);
        this.wlKeyFilename.setText(BaseMessages.getString(PKG, (String)"ActionSftp.KeyFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlKeyFilename);
        FormData fdlKeyFilename = new FormData();
        fdlKeyFilename.left = new FormAttachment(0, 0);
        fdlKeyFilename.top = new FormAttachment((Control)wlUsePublicKey, 2 * margin);
        fdlKeyFilename.right = new FormAttachment(middle, -margin);
        this.wlKeyFilename.setLayoutData((Object)fdlKeyFilename);
        this.wbKeyFilename = new Button((Composite)wServerSettings, 0x1000008);
        PropsUi.setLook((Widget)this.wbKeyFilename);
        this.wbKeyFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbKeyFilename = new FormData();
        fdbKeyFilename.right = new FormAttachment(100, 0);
        fdbKeyFilename.top = new FormAttachment((Control)this.wUsePublicKey, 0);
        this.wbKeyFilename.setLayoutData((Object)fdbKeyFilename);
        this.wKeyFilename = new TextVar(this.variables, (Composite)wServerSettings, 18436);
        this.wKeyFilename.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftp.KeyFilename.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wKeyFilename);
        this.wKeyFilename.addModifyListener(lsMod);
        FormData fdKeyFilename = new FormData();
        fdKeyFilename.left = new FormAttachment(middle, 0);
        fdKeyFilename.top = new FormAttachment((Control)this.wUsePublicKey, margin);
        fdKeyFilename.right = new FormAttachment((Control)this.wbKeyFilename, -margin);
        this.wKeyFilename.setLayoutData((Object)fdKeyFilename);
        this.wbKeyFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wKeyFilename, (IVariables)this.variables, (String[])new String[]{"*.pem", "*"}, (String[])FILETYPES, (boolean)true));
        this.wKeyfilePass = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionSftp.keyfilePass.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftp.keyfilePass.Tooltip", (String[])new String[0]), true, false);
        PropsUi.setLook((Widget)this.wKeyfilePass);
        this.wKeyfilePass.addModifyListener(lsMod);
        FormData fdkeyfilePass = new FormData();
        fdkeyfilePass.left = new FormAttachment(0, -2 * margin);
        fdkeyfilePass.top = new FormAttachment((Control)this.wKeyFilename, margin);
        fdkeyfilePass.right = new FormAttachment(100, 0);
        this.wKeyfilePass.setLayoutData((Object)fdkeyfilePass);
        Label wlProxyType = new Label((Composite)wServerSettings, 131072);
        wlProxyType.setText(BaseMessages.getString(PKG, (String)"ActionSftp.ProxyType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProxyType);
        FormData fdlProxyType = new FormData();
        fdlProxyType.left = new FormAttachment(0, 0);
        fdlProxyType.right = new FormAttachment(middle, -margin);
        fdlProxyType.top = new FormAttachment((Control)this.wKeyfilePass, 2 * margin);
        wlProxyType.setLayoutData((Object)fdlProxyType);
        this.wProxyType = new CCombo((Composite)wServerSettings, 2060);
        this.wProxyType.add("HTTP");
        this.wProxyType.add("SOCKS5");
        this.wProxyType.select(0);
        PropsUi.setLook((Widget)this.wProxyType);
        FormData fdProxyType = new FormData();
        fdProxyType.left = new FormAttachment(middle, 0);
        fdProxyType.top = new FormAttachment((Control)this.wKeyfilePass, 2 * margin);
        fdProxyType.right = new FormAttachment(100, 0);
        this.wProxyType.setLayoutData((Object)fdProxyType);
        this.wProxyType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionSftpDialog.this.setDefaultProxyPort();
            }
        });
        this.wProxyHost = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionSftp.ProxyHost.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftp.ProxyHost.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wProxyHost);
        this.wProxyHost.addModifyListener(lsMod);
        FormData fdProxyHost = new FormData();
        fdProxyHost.left = new FormAttachment(0, -2 * margin);
        fdProxyHost.top = new FormAttachment((Control)this.wProxyType, margin);
        fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData((Object)fdProxyHost);
        this.wProxyPort = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionSftp.ProxyPort.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftp.ProxyPort.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wProxyPort);
        this.wProxyPort.addModifyListener(lsMod);
        FormData fdProxyPort = new FormData();
        fdProxyPort.left = new FormAttachment(0, -2 * margin);
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData((Object)fdProxyPort);
        this.wProxyUsername = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionSftp.ProxyUsername.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftp.ProxyUsername.Tooltip", (String[])new String[0]), false, false);
        PropsUi.setLook((Widget)this.wProxyUsername);
        this.wProxyUsername.addModifyListener(lsMod);
        FormData fdProxyUsername = new FormData();
        fdProxyUsername.left = new FormAttachment(0, -2 * margin);
        fdProxyUsername.top = new FormAttachment((Control)this.wProxyPort, margin);
        fdProxyUsername.right = new FormAttachment(100, 0);
        this.wProxyUsername.setLayoutData((Object)fdProxyUsername);
        this.wProxyPassword = new LabelTextVar(this.variables, (Composite)wServerSettings, 0, BaseMessages.getString(PKG, (String)"ActionSftp.ProxyPassword.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftp.ProxyPassword.Tooltip", (String[])new String[0]), true, false);
        PropsUi.setLook((Widget)this.wProxyPassword);
        this.wProxyPassword.addModifyListener(lsMod);
        FormData fdProxyPasswd = new FormData();
        fdProxyPasswd.left = new FormAttachment(0, -2 * margin);
        fdProxyPasswd.top = new FormAttachment((Control)this.wProxyUsername, margin);
        fdProxyPasswd.right = new FormAttachment(100, 0);
        this.wProxyPassword.setLayoutData((Object)fdProxyPasswd);
        Button wTest = new Button((Composite)wServerSettings, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"ActionSftp.TestConnection.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wTest);
        FormData fdTest = new FormData();
        wTest.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftp.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)this.wProxyPassword, margin);
        fdTest.right = new FormAttachment(100, 0);
        wTest.setLayoutData((Object)fdTest);
        wTest.addListener(13, e -> this.test());
        FormData fdServerSettings = new FormData();
        fdServerSettings.left = new FormAttachment(0, margin);
        fdServerSettings.top = new FormAttachment((Control)this.wName, margin);
        fdServerSettings.right = new FormAttachment(100, -margin);
        wServerSettings.setLayoutData((Object)fdServerSettings);
        Label wlCompression = new Label(wGeneralComp, 131072);
        wlCompression.setText(BaseMessages.getString(PKG, (String)"ActionSftp.Compression.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCompression);
        FormData fdlCompression = new FormData();
        fdlCompression.left = new FormAttachment(0, -margin);
        fdlCompression.right = new FormAttachment(middle, 0);
        fdlCompression.top = new FormAttachment((Control)wServerSettings, margin);
        wlCompression.setLayoutData((Object)fdlCompression);
        this.wCompression = new CCombo(wGeneralComp, 2060);
        this.wCompression.add("none");
        this.wCompression.add("zlib");
        this.wCompression.select(0);
        PropsUi.setLook((Widget)this.wCompression);
        FormData fdCompression = new FormData();
        fdCompression.left = new FormAttachment(middle, margin);
        fdCompression.top = new FormAttachment((Control)wServerSettings, margin);
        fdCompression.right = new FormAttachment(100, 0);
        this.wCompression.setLayoutData((Object)fdCompression);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        PropsUi.setLook((Widget)wGeneralComp);
        CTabItem wFilesTab = new CTabItem(wTabFolder, 0);
        wFilesTab.setFont(GuiResource.getInstance().getFontDefault());
        wFilesTab.setText(BaseMessages.getString(PKG, (String)"ActionSftp.Tab.Files.Label", (String[])new String[0]));
        Composite wFilesComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFilesComp);
        FormLayout filesLayout = new FormLayout();
        filesLayout.marginWidth = 3;
        filesLayout.marginHeight = 3;
        wFilesComp.setLayout((Layout)filesLayout);
        Group wSourceFiles = new Group(wFilesComp, 32);
        PropsUi.setLook((Widget)wSourceFiles);
        wSourceFiles.setText(BaseMessages.getString(PKG, (String)"ActionSftp.SourceFiles.Group.Label", (String[])new String[0]));
        FormLayout sourceFilesgroupLayout = new FormLayout();
        sourceFilesgroupLayout.marginWidth = 10;
        sourceFilesgroupLayout.marginHeight = 10;
        wSourceFiles.setLayout((Layout)sourceFilesgroupLayout);
        Label wlGetPrevious = new Label((Composite)wSourceFiles, 131072);
        wlGetPrevious.setText(BaseMessages.getString(PKG, (String)"ActionSftp.getPrevious.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGetPrevious);
        FormData fdlGetPrevious = new FormData();
        fdlGetPrevious.left = new FormAttachment(0, 0);
        fdlGetPrevious.top = new FormAttachment((Control)wServerSettings, 2 * margin);
        fdlGetPrevious.right = new FormAttachment(middle, -margin);
        wlGetPrevious.setLayoutData((Object)fdlGetPrevious);
        this.wGetPrevious = new Button((Composite)wSourceFiles, 32);
        PropsUi.setLook((Widget)this.wGetPrevious);
        this.wGetPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftp.getPrevious.Tooltip", (String[])new String[0]));
        FormData fdGetPrevious = new FormData();
        fdGetPrevious.left = new FormAttachment(middle, 0);
        fdGetPrevious.top = new FormAttachment((Control)wlGetPrevious, 0, 0x1000000);
        fdGetPrevious.right = new FormAttachment(100, 0);
        this.wGetPrevious.setLayoutData((Object)fdGetPrevious);
        this.wGetPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionSftpDialog.this.activeCopyFromPrevious();
                ActionSftpDialog.this.action.setChanged();
            }
        });
        Label wlScpDirectory = new Label((Composite)wSourceFiles, 131072);
        wlScpDirectory.setText(BaseMessages.getString(PKG, (String)"ActionSftp.RemoteDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlScpDirectory);
        FormData fdlScpDirectory = new FormData();
        fdlScpDirectory.left = new FormAttachment(0, 0);
        fdlScpDirectory.top = new FormAttachment((Control)wlGetPrevious, 2 * margin);
        fdlScpDirectory.right = new FormAttachment(middle, -margin);
        wlScpDirectory.setLayoutData((Object)fdlScpDirectory);
        Button wbTestChangeFolderExists = new Button((Composite)wSourceFiles, 0x1000008);
        PropsUi.setLook((Widget)wbTestChangeFolderExists);
        wbTestChangeFolderExists.setText(BaseMessages.getString(PKG, (String)"ActionSftp.TestFolderExists.Label", (String[])new String[0]));
        FormData fdbTestChangeFolderExists = new FormData();
        fdbTestChangeFolderExists.right = new FormAttachment(100, 0);
        fdbTestChangeFolderExists.top = new FormAttachment((Control)this.wGetPrevious, 2 * margin);
        wbTestChangeFolderExists.setLayoutData((Object)fdbTestChangeFolderExists);
        wbTestChangeFolderExists.addListener(13, e -> this.checkRemoteFolder());
        this.wScpDirectory = new TextVar(this.variables, (Composite)wSourceFiles, 18436, BaseMessages.getString(PKG, (String)"ActionSftp.RemoteDir.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wScpDirectory);
        this.wScpDirectory.addModifyListener(lsMod);
        FormData fdScpDirectory = new FormData();
        fdScpDirectory.left = new FormAttachment(middle, 0);
        fdScpDirectory.top = new FormAttachment((Control)this.wGetPrevious, 2 * margin);
        fdScpDirectory.right = new FormAttachment((Control)wbTestChangeFolderExists, -margin);
        this.wScpDirectory.setLayoutData((Object)fdScpDirectory);
        this.wlWildcard = new Label((Composite)wSourceFiles, 131072);
        this.wlWildcard.setText(BaseMessages.getString(PKG, (String)"ActionSftp.Wildcard.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlWildcard);
        FormData fdlWildcard = new FormData();
        fdlWildcard.left = new FormAttachment(0, 0);
        fdlWildcard.top = new FormAttachment((Control)this.wScpDirectory, margin);
        fdlWildcard.right = new FormAttachment(middle, -margin);
        this.wlWildcard.setLayoutData((Object)fdlWildcard);
        this.wWildcard = new TextVar(this.variables, (Composite)wSourceFiles, 18436, BaseMessages.getString(PKG, (String)"ActionSftp.Wildcard.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wWildcard);
        this.wWildcard.addModifyListener(lsMod);
        FormData fdWildcard = new FormData();
        fdWildcard.left = new FormAttachment(middle, 0);
        fdWildcard.top = new FormAttachment((Control)this.wScpDirectory, margin);
        fdWildcard.right = new FormAttachment(100, 0);
        this.wWildcard.setLayoutData((Object)fdWildcard);
        Label wlRemove = new Label((Composite)wSourceFiles, 131072);
        wlRemove.setText(BaseMessages.getString(PKG, (String)"ActionSftp.RemoveFiles.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRemove);
        FormData fdlRemove = new FormData();
        fdlRemove.left = new FormAttachment(0, 0);
        fdlRemove.top = new FormAttachment((Control)this.wWildcard, margin);
        fdlRemove.right = new FormAttachment(middle, -margin);
        wlRemove.setLayoutData((Object)fdlRemove);
        this.wRemove = new Button((Composite)wSourceFiles, 32);
        PropsUi.setLook((Widget)this.wRemove);
        this.wRemove.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftp.RemoveFiles.Tooltip", (String[])new String[0]));
        FormData fdRemove = new FormData();
        fdRemove.left = new FormAttachment(middle, 0);
        fdRemove.top = new FormAttachment((Control)wlRemove, 0, 0x1000000);
        fdRemove.right = new FormAttachment(100, 0);
        this.wRemove.setLayoutData((Object)fdRemove);
        FormData fdSourceFiles = new FormData();
        fdSourceFiles.left = new FormAttachment(0, margin);
        fdSourceFiles.top = new FormAttachment((Control)wServerSettings, 2 * margin);
        fdSourceFiles.right = new FormAttachment(100, -margin);
        wSourceFiles.setLayoutData((Object)fdSourceFiles);
        Group wTargetFiles = new Group(wFilesComp, 32);
        PropsUi.setLook((Widget)wTargetFiles);
        wTargetFiles.setText(BaseMessages.getString(PKG, (String)"ActionSftp.TargetFiles.Group.Label", (String[])new String[0]));
        FormLayout targetFilesgroupLayout = new FormLayout();
        targetFilesgroupLayout.marginWidth = 10;
        targetFilesgroupLayout.marginHeight = 10;
        wTargetFiles.setLayout((Layout)targetFilesgroupLayout);
        Label wlTargetDirectory = new Label((Composite)wTargetFiles, 131072);
        wlTargetDirectory.setText(BaseMessages.getString(PKG, (String)"ActionSftp.TargetDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTargetDirectory);
        FormData fdlTargetDirectory = new FormData();
        fdlTargetDirectory.left = new FormAttachment(0, 0);
        fdlTargetDirectory.top = new FormAttachment((Control)wSourceFiles, margin);
        fdlTargetDirectory.right = new FormAttachment(middle, -margin);
        wlTargetDirectory.setLayoutData((Object)fdlTargetDirectory);
        Button wbTargetDirectory = new Button((Composite)wTargetFiles, 0x1000008);
        PropsUi.setLook((Widget)wbTargetDirectory);
        wbTargetDirectory.setText(BaseMessages.getString(PKG, (String)"ActionSftp.BrowseFolders.Label", (String[])new String[0]));
        FormData fdbTargetDirectory = new FormData();
        fdbTargetDirectory.right = new FormAttachment(100, 0);
        fdbTargetDirectory.top = new FormAttachment((Control)wSourceFiles, margin);
        wbTargetDirectory.setLayoutData((Object)fdbTargetDirectory);
        wbTargetDirectory.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wTargetDirectory, (IVariables)this.variables));
        this.wTargetDirectory = new TextVar(this.variables, (Composite)wTargetFiles, 18436, BaseMessages.getString(PKG, (String)"ActionSftp.TargetDir.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wTargetDirectory);
        this.wTargetDirectory.addModifyListener(lsMod);
        FormData fdTargetDirectory = new FormData();
        fdTargetDirectory.left = new FormAttachment(middle, 0);
        fdTargetDirectory.top = new FormAttachment((Control)wSourceFiles, margin);
        fdTargetDirectory.right = new FormAttachment((Control)wbTargetDirectory, -margin);
        this.wTargetDirectory.setLayoutData((Object)fdTargetDirectory);
        Label wlCreateTargetFolder = new Label((Composite)wTargetFiles, 131072);
        wlCreateTargetFolder.setText(BaseMessages.getString(PKG, (String)"ActionSftp.CreateTargetFolder.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateTargetFolder);
        FormData fdlCreateTargetFolder = new FormData();
        fdlCreateTargetFolder.left = new FormAttachment(0, 0);
        fdlCreateTargetFolder.top = new FormAttachment((Control)this.wTargetDirectory, margin);
        fdlCreateTargetFolder.right = new FormAttachment(middle, -margin);
        wlCreateTargetFolder.setLayoutData((Object)fdlCreateTargetFolder);
        this.wCreateTargetFolder = new Button((Composite)wTargetFiles, 32);
        this.wCreateTargetFolder.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftp.CreateTargetFolder.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wCreateTargetFolder);
        FormData fdCreateTargetFolder = new FormData();
        fdCreateTargetFolder.left = new FormAttachment(middle, 0);
        fdCreateTargetFolder.top = new FormAttachment((Control)wlCreateTargetFolder, 0, 0x1000000);
        fdCreateTargetFolder.right = new FormAttachment(100, 0);
        this.wCreateTargetFolder.setLayoutData((Object)fdCreateTargetFolder);
        Label wlAddFilenameToResult = new Label((Composite)wTargetFiles, 131072);
        wlAddFilenameToResult.setText(BaseMessages.getString(PKG, (String)"ActionSftp.AddFilenameToResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddFilenameToResult);
        FormData fdlAddFilenameToResult = new FormData();
        fdlAddFilenameToResult.left = new FormAttachment(0, 0);
        fdlAddFilenameToResult.top = new FormAttachment((Control)this.wCreateTargetFolder, margin);
        fdlAddFilenameToResult.right = new FormAttachment(middle, -margin);
        wlAddFilenameToResult.setLayoutData((Object)fdlAddFilenameToResult);
        this.wAddFilenameToResult = new Button((Composite)wTargetFiles, 32);
        this.wAddFilenameToResult.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSftp.AddFilenameToResult.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAddFilenameToResult);
        FormData fdAddFilenameToResult = new FormData();
        fdAddFilenameToResult.left = new FormAttachment(middle, 0);
        fdAddFilenameToResult.top = new FormAttachment((Control)wlAddFilenameToResult, 0, 0x1000000);
        fdAddFilenameToResult.right = new FormAttachment(100, 0);
        this.wAddFilenameToResult.setLayoutData((Object)fdAddFilenameToResult);
        FormData fdTargetFiles = new FormData();
        fdTargetFiles.left = new FormAttachment(0, margin);
        fdTargetFiles.top = new FormAttachment((Control)wSourceFiles, margin);
        fdTargetFiles.right = new FormAttachment(100, -margin);
        wTargetFiles.setLayoutData((Object)fdTargetFiles);
        FormData fdFilesComp = new FormData();
        fdFilesComp.left = new FormAttachment(0, 0);
        fdFilesComp.top = new FormAttachment(0, 0);
        fdFilesComp.right = new FormAttachment(100, 0);
        fdFilesComp.bottom = new FormAttachment(100, 0);
        wFilesComp.setLayoutData((Object)fdFilesComp);
        wFilesComp.layout();
        wFilesTab.setControl((Control)wFilesComp);
        PropsUi.setLook((Widget)wFilesComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        this.activeCopyFromPrevious();
        this.activeUseKey();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void test() {
        if (this.connectToSftp(false, null)) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionSftp.Connected.OK", (String[])new String[]{this.wServerName.getText()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionSftp.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        }
    }

    private void activeCopyFromPrevious() {
        this.wlWildcard.setEnabled(!this.wGetPrevious.getSelection());
        this.wWildcard.setEnabled(!this.wGetPrevious.getSelection());
    }

    private void closeFtpConnections() {
        if (this.sftpclient != null) {
            try {
                this.sftpclient.disconnect();
                this.sftpclient = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean connectToSftp(boolean checkFolder, String remotefoldername) {
        boolean retval = false;
        try {
            if (this.sftpclient == null) {
                this.sftpclient = new SftpClient(InetAddress.getByName(this.variables.resolve(this.wServerName.getText())), Const.toInt((String)this.variables.resolve(this.wServerPort.getText()), (int)22), this.variables.resolve(this.wUserName.getText()), this.variables.resolve(this.wKeyFilename.getText()), this.variables.resolve(this.wKeyfilePass.getText()));
                String realProxyHost = this.variables.resolve(this.wProxyHost.getText());
                if (!Utils.isEmpty((CharSequence)realProxyHost)) {
                    this.sftpclient.setProxy(realProxyHost, this.variables.resolve(this.wProxyPort.getText()), this.variables.resolve(this.wProxyUsername.getText()), Utils.resolvePassword((IVariables)this.variables, (String)this.wProxyPassword.getText()), this.wProxyType.getText());
                }
                this.sftpclient.login(this.action.getRealPassword(this.variables.resolve(this.wPassword.getText())));
                retval = true;
            }
            if (checkFolder) {
                retval = this.sftpclient.folderExists(remotefoldername);
            }
        }
        catch (Exception e) {
            if (this.sftpclient != null) {
                try {
                    this.sftpclient.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sftpclient = null;
            }
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionSftp.ErrorConnect.NOK", (String[])new String[]{this.wServerName.getText(), e.getMessage()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionSftp.ErrorConnect.Title.Bad", (String[])new String[0]));
            mb.open();
        }
        return retval;
    }

    private void checkRemoteFolder() {
        String changeFtpFolder = this.variables.resolve(this.wScpDirectory.getText());
        if (!Utils.isEmpty((CharSequence)changeFtpFolder) && this.connectToSftp(true, changeFtpFolder)) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionSftp.FolderExists.OK", (String[])new String[]{changeFtpFolder}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"ActionSftp.FolderExists.Title.Ok", (String[])new String[0]));
            mb.open();
        }
    }

    public void dispose() {
        this.closeFtpConnections();
        super.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wServerName.setText(Const.NVL((String)this.action.getServerName(), (String)""));
        this.wServerPort.setText(this.action.getServerPort());
        this.wUserName.setText(Const.NVL((String)this.action.getUserName(), (String)""));
        this.wPassword.setText(Const.NVL((String)this.action.getPassword(), (String)""));
        this.wScpDirectory.setText(Const.NVL((String)this.action.getScpDirectory(), (String)""));
        this.wTargetDirectory.setText(Const.NVL((String)this.action.getTargetDirectory(), (String)""));
        this.wWildcard.setText(Const.NVL((String)this.action.getWildcard(), (String)""));
        this.wRemove.setSelection(this.action.getRemove());
        this.wAddFilenameToResult.setSelection(this.action.isAddToResult());
        this.wCreateTargetFolder.setSelection(this.action.isCreateTargetFolder());
        this.wGetPrevious.setSelection(this.action.isCopyPrevious());
        this.wUsePublicKey.setSelection(this.action.isUseKeyFile());
        this.wKeyFilename.setText(Const.NVL((String)this.action.getKeyFilename(), (String)""));
        this.wKeyfilePass.setText(Const.NVL((String)this.action.getKeyPassPhrase(), (String)""));
        this.wCompression.setText(Const.NVL((String)this.action.getCompression(), (String)"none"));
        this.wProxyType.setText(Const.NVL((String)this.action.getProxyType(), (String)""));
        this.wProxyHost.setText(Const.NVL((String)this.action.getProxyHost(), (String)""));
        this.wProxyPort.setText(Const.NVL((String)this.action.getProxyPort(), (String)""));
        this.wProxyUsername.setText(Const.NVL((String)this.action.getProxyUsername(), (String)""));
        this.wProxyPassword.setText(Const.NVL((String)this.action.getProxyPassword(), (String)""));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setServerName(this.wServerName.getText());
        this.action.setServerPort(this.wServerPort.getText());
        this.action.setUserName(this.wUserName.getText());
        this.action.setPassword(this.wPassword.getText());
        this.action.setScpDirectory(this.wScpDirectory.getText());
        this.action.setTargetDirectory(this.wTargetDirectory.getText());
        this.action.setWildcard(this.wWildcard.getText());
        this.action.setRemove(this.wRemove.getSelection());
        this.action.setAddToResult(this.wAddFilenameToResult.getSelection());
        this.action.setCreateTargetFolder(this.wCreateTargetFolder.getSelection());
        this.action.setCopyPrevious(this.wGetPrevious.getSelection());
        this.action.setUseKeyFile(this.wUsePublicKey.getSelection());
        this.action.setKeyFilename(this.wKeyFilename.getText());
        this.action.setKeyPassPhrase(this.wKeyfilePass.getText());
        this.action.setCompression(this.wCompression.getText());
        this.action.setProxyType(this.wProxyType.getText());
        this.action.setProxyHost(this.wProxyHost.getText());
        this.action.setProxyPort(this.wProxyPort.getText());
        this.action.setProxyUsername(this.wProxyUsername.getText());
        this.action.setProxyPassword(this.wProxyPassword.getText());
        this.dispose();
    }

    private void activeUseKey() {
        this.wlKeyFilename.setEnabled(this.wUsePublicKey.getSelection());
        this.wKeyFilename.setEnabled(this.wUsePublicKey.getSelection());
        this.wbKeyFilename.setEnabled(this.wUsePublicKey.getSelection());
        this.wKeyfilePass.setEnabled(this.wUsePublicKey.getSelection());
    }

    private void setDefaultProxyPort() {
        if (this.wProxyType.getText().equals("HTTP")) {
            if (Utils.isEmpty((CharSequence)this.wProxyPort.getText()) || !Utils.isEmpty((CharSequence)this.wProxyPort.getText()) && this.wProxyPort.getText().equals("1080")) {
                this.wProxyPort.setText("80");
            }
        } else if (Utils.isEmpty((CharSequence)this.wProxyPort.getText()) || !Utils.isEmpty((CharSequence)this.wProxyPort.getText()) && this.wProxyPort.getText().equals("80")) {
            this.wProxyPort.setText("1080");
        }
    }
}

