/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.bulk;

import java.io.PrintWriter;
import java.io.Writer;

public class CsvWriter {
    private PrintWriter writer;

    public CsvWriter(String[] headers, Writer w) {
        assert (headers != null);
        assert (headers.length != 0);
        this.writer = new PrintWriter(w, true);
        this.writeRecord(headers);
    }

    public void writeRecord(String[] values) {
        assert (values != null);
        this.writeFirstField(values[0]);
        int i = 1;
        while (i < values.length) {
            this.writeField(values[i]);
            ++i;
        }
        this.endRecord();
    }

    public void endDocument() {
        this.writer.close();
    }

    public void endRecord() {
        this.writer.println();
    }

    public void writeField(String value) {
        this.writer.print(",");
        this.writeFirstField(value);
    }

    public void writeFirstField(String value) {
        if (value == null) {
            return;
        }
        this.writer.print("\"");
        value = value.replaceAll("\"", "\"\"");
        this.writer.print(value);
        this.writer.print("\"");
    }
}

