/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.dostounix;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

@Action(id="DOS_UNIX_CONVERTER", name="i18n::ActionDosToUnix.Name", description="i18n::ActionDosToUnix.Description", image="DosToUnix.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionDosToUnix.keyword"}, documentationUrl="/workflow/actions/dostounix.html")
public class ActionDosToUnix
extends ActionBase
implements Cloneable,
IAction {
    private static final int LF = 10;
    private static final int CR = 13;
    private static final Class<?> PKG = ActionDosToUnix.class;
    public static final String[] ConversionTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionDosToUnix.ConversionType.Guess.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionDosToUnix.ConversionType.DosToUnix.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionDosToUnix.ConversionType.UnixToDos.Label", (String[])new String[0])};
    public static final String[] ConversionTypeCode = new String[]{"guess", "dostounix", "unixtodos"};
    public static final int CONVERTION_TYPE_GUESS = 0;
    public static final int CONVERTION_TYPE_DOS_TO_UNIX = 1;
    public static final int CONVERTION_TYPE_UNIX_TO_DOS = 2;
    private static final int TYPE_DOS_FILE = 0;
    private static final int TYPE_UNIX_FILE = 1;
    private static final int TYPE_BINAY_FILE = 2;
    public static final String ADD_NOTHING = "nothing";
    public static final String SUCCESS_IF_AT_LEAST_X_FILES_PROCESSED = "success_when_at_least";
    public static final String SUCCESS_IF_ERROR_FILES_LESS = "success_if_error_files_less";
    public static final String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    public static final String ADD_ALL_FILENAMES = "all_filenames";
    public static final String ADD_PROCESSED_FILES_ONLY = "only_processed_filenames";
    public static final String ADD_ERROR_FILES_ONLY = "only_error_filenames";
    public boolean argFromPrevious = false;
    public boolean includeSubFolders = false;
    public String[] sourceFileFolder = null;
    public String[] wildcard = null;
    public int[] conversionTypes = null;
    private String nrErrorsLessThan = "10";
    private String successCondition = "success_if_no_errors";
    private String resultFilenames = "all_filenames";
    int nrAllErrors = 0;
    int nrErrorFiles = 0;
    int nrProcessedFiles = 0;
    int limitFiles = 0;
    int nrErrors = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    private static String tempFolder;

    public ActionDosToUnix(String n) {
        super(n, "");
    }

    public ActionDosToUnix() {
        this("");
    }

    public void allocate(int nrFields) {
        this.sourceFileFolder = new String[nrFields];
        this.wildcard = new String[nrFields];
        this.conversionTypes = new int[nrFields];
    }

    public Object clone() {
        ActionDosToUnix je = (ActionDosToUnix)super.clone();
        if (this.sourceFileFolder != null) {
            int nrFields = this.sourceFileFolder.length;
            je.allocate(nrFields);
            System.arraycopy(this.sourceFileFolder, 0, je.sourceFileFolder, 0, nrFields);
            System.arraycopy(this.wildcard, 0, je.wildcard, 0, nrFields);
            System.arraycopy(this.conversionTypes, 0, je.conversionTypes, 0, nrFields);
        }
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubFolders));
        retval.append("      ").append(XmlHandler.addTagValue((String)"nr_errors_less_than", (String)this.nrErrorsLessThan));
        retval.append("      ").append(XmlHandler.addTagValue((String)"success_condition", (String)this.successCondition));
        retval.append("      ").append(XmlHandler.addTagValue((String)"resultfilenames", (String)this.resultFilenames));
        retval.append("      <fields>").append(Const.CR);
        if (this.sourceFileFolder != null) {
            for (int i = 0; i < this.sourceFileFolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XmlHandler.addTagValue((String)"source_filefolder", (String)this.sourceFileFolder[i]));
                retval.append("          ").append(XmlHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                retval.append("          ").append(XmlHandler.addTagValue((String)"ConversionType", (String)ActionDosToUnix.getConversionTypeCode(this.conversionTypes[i])));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    private static String getConversionTypeCode(int i) {
        if (i < 0 || i >= ConversionTypeCode.length) {
            return ConversionTypeCode[0];
        }
        return ConversionTypeCode[i];
    }

    public static String getConversionTypeDesc(int i) {
        if (i < 0 || i >= ConversionTypeDesc.length) {
            return ConversionTypeDesc[0];
        }
        return ConversionTypeDesc[i];
    }

    public static int getConversionTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ConversionTypeDesc.length; ++i) {
            if (!ConversionTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionDosToUnix.getConversionTypeByCode(tt);
    }

    private static int getConversionTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ConversionTypeCode.length; ++i) {
            if (!ConversionTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.argFromPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.includeSubFolders = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.nrErrorsLessThan = XmlHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.successCondition = XmlHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.resultFilenames = XmlHandler.getTagValue((Node)entrynode, (String)"resultfilenames");
            Node fields = XmlHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.sourceFileFolder[i] = XmlHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.wildcard[i] = XmlHandler.getTagValue((Node)fnode, (String)"wildcard");
                this.conversionTypes[i] = ActionDosToUnix.getConversionTypeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"ConversionType"), (String)""));
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    public Result execute(Result previousResult, int nr) throws HopException {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        List rows = previousResult.getRows();
        RowMetaAndData resultRow = null;
        this.nrErrors = 0;
        this.nrProcessedFiles = 0;
        this.nrErrorFiles = 0;
        this.limitFiles = Const.toInt((String)this.resolve(this.getNrErrorsLessThan()), (int)10);
        this.successConditionBroken = false;
        this.successConditionBrokenExit = false;
        tempFolder = this.resolve("%%java.io.tmpdir%%");
        String[] vSourceFileFolder = this.sourceFileFolder;
        String[] vwildcard = this.wildcard;
        if (this.argFromPrevious && this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.ArgFromPrevious.Found", (String[])new String[]{"" + (rows != null ? rows.size() : 0)}));
        }
        if (this.argFromPrevious && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Error.SuccessConditionbroken", (String[])new String[]{"" + this.nrAllErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setEntryNr((long)this.nrAllErrors);
                    result.setNrLinesRejected((long)this.nrErrorFiles);
                    result.setNrLinesWritten((long)this.nrProcessedFiles);
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(iteration);
                String vSourceFileFolderPrevious = resultRow.getString(0, null);
                String vWildcardPrevious = resultRow.getString(1, null);
                int conversionType = ActionDosToUnix.getConversionTypeByCode(resultRow.getString(2, null));
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.ProcessingRow", (String[])new String[]{vSourceFileFolderPrevious, vWildcardPrevious}));
                }
                this.processFileFolder(vSourceFileFolderPrevious, vWildcardPrevious, conversionType, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result);
            }
        } else if (vSourceFileFolder != null) {
            for (int i = 0; i < vSourceFileFolder.length && !this.parentWorkflow.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Error.SuccessConditionbroken", (String[])new String[]{"" + this.nrAllErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setEntryNr((long)this.nrAllErrors);
                    result.setNrLinesRejected((long)this.nrErrorFiles);
                    result.setNrLinesWritten((long)this.nrProcessedFiles);
                    return result;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Log.ProcessingRow", (String[])new String[]{vSourceFileFolder[i], vwildcard[i]}));
                }
                this.processFileFolder(vSourceFileFolder[i], vwildcard[i], this.conversionTypes[i], (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result);
            }
        }
        result.setNrErrors((long)this.nrAllErrors);
        result.setNrLinesRejected((long)this.nrErrorFiles);
        result.setNrLinesWritten((long)this.nrProcessedFiles);
        if (this.getSuccessStatus()) {
            result.setNrErrors(0L);
            result.setResult(true);
        }
        this.displayResults();
        return result;
    }

    private void displayResults() {
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Log.Info.Errors", (Object[])new Object[]{this.nrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Log.Info.ErrorFiles", (Object[])new Object[]{this.nrErrorFiles}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Log.Info.FilesProcessed", (Object[])new Object[]{this.nrProcessedFiles}));
            this.logDetailed("=======================================");
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.nrAllErrors > 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.nrErrorFiles >= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_ERROR_FILES_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.nrAllErrors == 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.nrProcessedFiles >= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_AT_LEAST_X_FILES_PROCESSED) || this.nrErrorFiles < this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_ERROR_FILES_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateErrors() {
        ++this.nrErrors;
        this.updateAllErrors();
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private void updateAllErrors() {
        this.nrAllErrors = this.nrErrors + this.nrErrorFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getFileType(FileObject file) throws Exception {
        int aCount = 0;
        int dCount = 0;
        try (FileInputStream in = new FileInputStream(file.getName().getPathDecoded());){
            while (in.available() > 0) {
                int b = in.read();
                if (b == 13) {
                    ++dCount;
                    if (in.available() <= 0) continue;
                    b = in.read();
                    if (b != 10) {
                        int n = 2;
                        return n;
                    }
                    ++aCount;
                    continue;
                }
                if (b != 10) continue;
                ++aCount;
            }
        }
        if (aCount != dCount) return 1;
        return 0;
    }

    @VisibleForTesting
    boolean convert(FileObject file, boolean toUnix) {
        boolean retval = false;
        try {
            String localfilename = HopVfs.getFilename((FileObject)file);
            File source = new File(localfilename);
            if (this.isDetailed()) {
                if (toUnix) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Log.ConvertingFileToUnix", (String[])new String[]{source.getAbsolutePath()}));
                } else {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Log.ConvertingFileToDos", (String[])new String[]{source.getAbsolutePath()}));
                }
            }
            File tempFile = new File(tempFolder, source.getName() + ".tmp");
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Log.CreatingTempFile", (String[])new String[]{tempFile.getAbsolutePath()}));
            }
            int FOUR_KB = 4096;
            byte[] buffer = new byte[4096];
            try (FileOutputStream out = new FileOutputStream(tempFile);
                 FileInputStream in = new FileInputStream(localfilename);){
                int read;
                ConversionAutomata automata = new ConversionAutomata(out, toUnix);
                while ((read = in.read(buffer)) > 0) {
                    automata.convert(buffer, read);
                }
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Log.DeletingSourceFile", (String[])new String[]{localfilename}));
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"JobDosToUnix.Log.RenamingTempFile", (String[])new String[]{tempFile.getAbsolutePath(), source.getAbsolutePath()}));
            }
            Files.move(tempFile.toPath(), source.toPath(), StandardCopyOption.REPLACE_EXISTING);
            retval = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Log.ErrorConvertingFile", (String[])new String[]{file.toString(), e.getMessage()}));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFileFolder(String sourcefilefoldername, String wildcard, int convertion, IWorkflowEngine<WorkflowMeta> parentWorkflow, Result result) {
        boolean entrystatus;
        block37: {
            entrystatus = false;
            FileObject sourcefilefolder = null;
            FileObject currentFile = null;
            String realSourceFilefoldername = this.resolve(sourcefilefoldername);
            if (Utils.isEmpty((CharSequence)realSourceFilefoldername)) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionDosToUnix.log.FileFolderEmpty", (String[])new String[]{sourcefilefoldername}));
                this.updateErrors();
                return entrystatus;
            }
            String realWildcard = this.resolve(wildcard);
            try {
                sourcefilefolder = HopVfs.getFileObject((String)realSourceFilefoldername);
                if (sourcefilefolder.exists()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Log.FileExists", (String[])new String[]{sourcefilefolder.toString()}));
                    }
                    if (sourcefilefolder.getType() == FileType.FILE) {
                        entrystatus = this.convertOneFile(sourcefilefolder, convertion, result, parentWorkflow);
                        break block37;
                    }
                    if (sourcefilefolder.getType() == FileType.FOLDER) {
                        FileObject[] fileObjects = sourcefilefolder.findFiles((FileSelector)new AllFileSelector(){

                            public boolean traverseDescendents(FileSelectInfo info) {
                                return info.getDepth() == 0 || ActionDosToUnix.this.includeSubFolders;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public boolean includeFile(FileSelectInfo info) {
                                block18: {
                                    boolean bl;
                                    FileObject fileObject = info.getFile();
                                    try {
                                        if (fileObject == null) {
                                            boolean bl2 = false;
                                            return bl2;
                                        }
                                        if (fileObject.getType() == FileType.FILE) break block18;
                                        bl = false;
                                    }
                                    catch (Exception ex) {
                                        boolean bl3 = false;
                                        return bl3;
                                    }
                                    finally {
                                        if (fileObject != null) {
                                            try {
                                                fileObject.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                    return bl;
                                }
                                return true;
                            }
                        });
                        if (fileObjects == null) break block37;
                        int j = 0;
                        while (true) {
                            if (j < fileObjects.length && !parentWorkflow.isStopped()) {
                                if (this.successConditionBroken) {
                                    if (!this.successConditionBrokenExit) {
                                        this.logError(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Error.SuccessConditionbroken", (String[])new String[]{"" + this.nrAllErrors}));
                                        this.successConditionBrokenExit = true;
                                    }
                                    boolean bl = false;
                                    return bl;
                                }
                                currentFile = fileObjects[j];
                                if (!currentFile.getParent().toString().equals(sourcefilefolder.toString())) {
                                    if (this.includeSubFolders && this.getFileWildcard(currentFile.toString(), realWildcard)) {
                                        this.convertOneFile(currentFile, convertion, result, parentWorkflow);
                                    }
                                } else if (this.getFileWildcard(currentFile.toString(), realWildcard)) {
                                    this.convertOneFile(currentFile, convertion, result, parentWorkflow);
                                }
                                ++j;
                                continue;
                            }
                            break block37;
                            break;
                        }
                    }
                    this.logError(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Error.UnknowFileFormat", (String[])new String[]{sourcefilefolder.toString()}));
                    this.updateErrors();
                    break block37;
                }
                this.logError(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Error.SourceFileNotExists", (String[])new String[]{realSourceFilefoldername}));
                this.updateErrors();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.Exception.Processing", (String[])new String[]{realSourceFilefoldername.toString(), e.getMessage()}));
                this.updateErrors();
            }
            finally {
                if (sourcefilefolder != null) {
                    try {
                        sourcefilefolder.close();
                    }
                    catch (IOException iOException) {}
                }
                if (currentFile != null) {
                    try {
                        currentFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return entrystatus;
    }

    private boolean convertOneFile(FileObject file, int convertion, Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow) throws HopException {
        boolean retval = false;
        try {
            int fileType;
            boolean convertToUnix = true;
            convertToUnix = convertion == 0 ? (fileType = ActionDosToUnix.getFileType(file)) == 0 : convertion == 1;
            retval = this.convert(file, convertToUnix);
            if (!retval) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Error.FileNotConverted", (String[])new String[]{file.toString()}));
                this.updateBadFormed();
                if (this.resultFilenames.equals(ADD_ALL_FILENAMES) || this.resultFilenames.equals(ADD_ERROR_FILES_ONLY)) {
                    this.addFileToResultFilenames(file, result, parentWorkflow);
                }
            } else {
                if (this.isDetailed()) {
                    this.logDetailed("---------------------------");
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Error.FileConverted", (Object[])new Object[]{file, convertToUnix ? "UNIX" : "DOS"}));
                }
                this.updateProcessedFormed();
                if (this.resultFilenames.equals(ADD_ALL_FILENAMES) || this.resultFilenames.equals(ADD_PROCESSED_FILES_ONLY)) {
                    this.addFileToResultFilenames(file, result, parentWorkflow);
                }
            }
        }
        catch (Exception e) {
            throw new HopException("Unable to convert file '" + file.toString() + "'", (Throwable)e);
        }
        return retval;
    }

    private void updateProcessedFormed() {
        ++this.nrProcessedFiles;
    }

    private void updateBadFormed() {
        ++this.nrErrorFiles;
        this.updateAllErrors();
    }

    private void addFileToResultFilenames(FileObject fileaddentry, Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow) {
        try {
            ResultFile resultFile = new ResultFile(0, fileaddentry, parentWorkflow.getWorkflowName(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDosToUnix.Log.FileAddedToResultFilesName", (Object[])new Object[]{fileaddentry}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobDosToUnix.Error.AddingToFilenameResult", (String[])new String[]{fileaddentry.toString(), e.getMessage()}));
        }
    }

    private boolean getFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setIncludeSubFolders(boolean includeSubFolders) {
        this.includeSubFolders = includeSubFolders;
    }

    public void setArgFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    public void setNrErrorsLessThan(String nrErrorsLessThan) {
        this.nrErrorsLessThan = nrErrorsLessThan;
    }

    public String getNrErrorsLessThan() {
        return this.nrErrorsLessThan;
    }

    public void setSuccessCondition(String successCondition) {
        this.successCondition = successCondition;
    }

    public String getSuccessCondition() {
        return this.successCondition;
    }

    public void setResultFilenames(String resultFilenames) {
        this.resultFilenames = resultFilenames;
    }

    public String getResultFilenames() {
        return this.resultFilenames;
    }

    public boolean isEvaluation() {
        return true;
    }

    private static class ConversionAutomata {
        private final OutputStream os;
        private final boolean toUnix;
        private byte state;

        ConversionAutomata(OutputStream os, boolean toUnix) {
            this.os = os;
            this.toUnix = toUnix;
            this.state = 0;
        }

        void convert(byte[] input, int amount) throws IOException {
            if (this.toUnix) {
                this.toUnix(input, amount);
            } else {
                this.toDos(input, amount);
            }
        }

        private void toUnix(byte[] input, int amount) throws IOException {
            int index = 0;
            block4: while (index < amount) {
                byte b = input[index++];
                switch (this.state) {
                    case 0: {
                        if (b == 13) {
                            this.state = 1;
                            continue block4;
                        }
                        this.os.write(b);
                        continue block4;
                    }
                    case 1: {
                        if (b == 10) {
                            this.os.write(10);
                            this.state = 0;
                            continue block4;
                        }
                        this.os.write(13);
                        if (b == 13) continue block4;
                        this.os.write(b);
                        this.state = 0;
                        continue block4;
                    }
                }
                throw this.unknownStateException();
            }
        }

        private void toDos(byte[] input, int amount) throws IOException {
            int index = 0;
            block4: while (index < amount) {
                byte b = input[index++];
                switch (this.state) {
                    case 0: {
                        if (b == 13) {
                            this.state = 1;
                            continue block4;
                        }
                        if (b == 10) {
                            this.os.write(13);
                            this.os.write(10);
                            continue block4;
                        }
                        this.os.write(b);
                        continue block4;
                    }
                    case 1: {
                        this.os.write(13);
                        if (b == 13) continue block4;
                        this.os.write(b);
                        this.state = 0;
                        continue block4;
                    }
                }
                throw this.unknownStateException();
            }
        }

        private IllegalStateException unknownStateException() {
            return new IllegalStateException("Unknown state: " + this.state);
        }
    }
}

