/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagElement;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class LabelFormElement
implements HTMLTagElement,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -325048684986308647L;
    private String label_;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;

    public LabelFormElement() {
    }

    public LabelFormElement(String label) {
        try {
            this.setLabel(label);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public String getLabel() {
        return this.label_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A LabelFormElement was here -->";
    }

    @Override
    public String getTag() {
        if (this.label_ == null) {
            Trace.log(2, "Attempting to get tag before setting label.");
            throw new ExtendedIllegalStateException("label", 4);
        }
        return this.label_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setLabel(String label) throws PropertyVetoException {
        if (label == null) {
            throw new NullPointerException("label");
        }
        String old = this.label_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("label", old, label);
        }
        this.label_ = label;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("label", old, label);
        }
    }

    public String toString() {
        return this.label_;
    }
}

