/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hop.core.BaseRowSet;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.row.IRowMeta;

public class BlockingBatchingRowSet
extends BaseRowSet
implements Comparable<IRowSet>,
IRowSet {
    private BlockingQueue<Object[][]> putArray = new ArrayBlockingQueue<Object[][]>(2, true);
    private BlockingQueue<Object[][]> getArray = new ArrayBlockingQueue<Object[][]>(2, true);
    private int putIndex;
    private int getIndex;
    private Object[][] inputBuffer;
    private Object[][] outputBuffer;
    private int size;
    private final int BATCHSIZE = 2;

    public BlockingBatchingRowSet(int maxSize) {
        this.size = maxSize / 2;
        for (int i = 0; i < 2; ++i) {
            Object[][] buffer = new Object[this.size][];
            this.putArray.offer(buffer);
        }
        this.outputBuffer = null;
        this.putIndex = this.getIndex = this.size;
    }

    @Override
    public boolean putRow(IRowMeta rowMeta, Object[] rowData) {
        return this.putRowWait(rowMeta, rowData, 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean putRowWait(IRowMeta rowMeta, Object[] rowData, long time, TimeUnit tu) {
        this.rowMeta = rowMeta;
        if (this.inputBuffer == null) {
            try {
                this.inputBuffer = this.putArray.poll(time, tu);
            }
            catch (InterruptedException e) {
                return false;
            }
            if (this.inputBuffer == null) {
                return false;
            }
            this.putIndex = 0;
        }
        this.inputBuffer[this.putIndex++] = rowData;
        if (this.putIndex == this.size) {
            try {
                this.getArray.offer(this.inputBuffer, time, tu);
                this.inputBuffer = null;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object[] getRow() {
        return this.getRowWait(50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object[] getRowImmediate() {
        return this.getRow();
    }

    @Override
    public Object[] getRowWait(long timeout, TimeUnit tu) {
        if (this.outputBuffer == null) {
            try {
                this.outputBuffer = this.getArray.poll(timeout, tu);
            }
            catch (InterruptedException e) {
                return null;
            }
            if (this.outputBuffer == null) {
                return null;
            }
            this.getIndex = 0;
        }
        Object[] row = this.outputBuffer[this.getIndex];
        this.outputBuffer[this.getIndex++] = null;
        if (this.getIndex == this.size) {
            this.putArray.offer(this.outputBuffer);
            this.outputBuffer = null;
        }
        return row;
    }

    @Override
    public int size() {
        return this.size - this.getIndex + this.size * this.getArray.size();
    }

    @Override
    public void setDone() {
        super.setDone();
        if (this.putIndex > 0 && this.putIndex < this.size && this.inputBuffer != null) {
            this.inputBuffer[this.putIndex] = null;
            for (int i = this.putIndex + 1; i < this.size; ++i) {
                this.inputBuffer[i] = null;
            }
            this.getArray.offer(this.inputBuffer);
        }
        this.putArray.clear();
    }

    @Override
    public void clear() {
        this.putArray.clear();
        this.getArray.clear();
        this.done.set(false);
    }
}

