/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.heap.AbstractHeapMergingState;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.util.Preconditions;

class HeapAggregatingState<K, N, IN, ACC, OUT>
extends AbstractHeapMergingState<K, N, IN, ACC, OUT>
implements InternalAggregatingState<K, N, IN, ACC, OUT> {
    private AggregateTransformation<IN, ACC, OUT> aggregateTransformation;

    private HeapAggregatingState(StateTable<K, N, ACC> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<ACC> valueSerializer, TypeSerializer<N> namespaceSerializer, ACC defaultValue, AggregateFunction<IN, ACC, OUT> aggregateFunction) {
        super(stateTable, keySerializer, valueSerializer, namespaceSerializer, defaultValue);
        this.aggregateTransformation = new AggregateTransformation<IN, ACC, OUT>(aggregateFunction);
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    @Override
    public TypeSerializer<ACC> getValueSerializer() {
        return this.valueSerializer;
    }

    public OUT get() {
        Object accumulator = this.getInternal();
        return (OUT)(accumulator != null ? ((AggregateTransformation)this.aggregateTransformation).aggFunction.getResult(accumulator) : null);
    }

    public void add(IN value) throws IOException {
        Object namespace = this.currentNamespace;
        if (value == null) {
            this.clear();
            return;
        }
        try {
            this.stateTable.transform(namespace, value, this.aggregateTransformation);
        }
        catch (Exception e) {
            throw new IOException("Exception while applying AggregateFunction in aggregating state", e);
        }
    }

    @Override
    protected ACC mergeState(ACC a, ACC b) {
        return (ACC)((AggregateTransformation)this.aggregateTransformation).aggFunction.merge(a, b);
    }

    HeapAggregatingState<K, N, IN, ACC, OUT> setAggregateFunction(AggregateFunction<IN, ACC, OUT> aggregateFunction) {
        this.aggregateTransformation = new AggregateTransformation<IN, ACC, OUT>(aggregateFunction);
        return this;
    }

    static <T, K, N, SV, S extends State, IS extends S> IS create(StateDescriptor<S, SV> stateDesc, StateTable<K, N, SV> stateTable, TypeSerializer<K> keySerializer) {
        return (IS)new HeapAggregatingState(stateTable, keySerializer, stateTable.getStateSerializer(), stateTable.getNamespaceSerializer(), stateDesc.getDefaultValue(), ((AggregatingStateDescriptor)stateDesc).getAggregateFunction());
    }

    static <T, K, N, SV, S extends State, IS extends S> IS update(StateDescriptor<S, SV> stateDesc, StateTable<K, N, SV> stateTable, IS existingState) {
        return (IS)((HeapAggregatingState)existingState).setAggregateFunction(((AggregatingStateDescriptor)stateDesc).getAggregateFunction()).setNamespaceSerializer(stateTable.getNamespaceSerializer()).setValueSerializer(stateTable.getStateSerializer()).setDefaultValue(stateDesc.getDefaultValue());
    }

    static final class AggregateTransformation<IN, ACC, OUT>
    implements StateTransformationFunction<ACC, IN> {
        private final AggregateFunction<IN, ACC, OUT> aggFunction;

        AggregateTransformation(AggregateFunction<IN, ACC, OUT> aggFunction) {
            this.aggFunction = (AggregateFunction)Preconditions.checkNotNull(aggFunction);
        }

        @Override
        public ACC apply(ACC accumulator, IN value) {
            if (accumulator == null) {
                accumulator = this.aggFunction.createAccumulator();
            }
            return (ACC)this.aggFunction.add(value, accumulator);
        }
    }
}

