/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.util.html.HTMLListItem;
import com.ibm.as400.util.html.HTMLTagElement;
import java.io.IOException;
import java.io.ObjectInputStream;

public class UnorderedListItem
extends HTMLListItem {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -4124433047652031568L;
    private String type_;

    public UnorderedListItem() {
    }

    public UnorderedListItem(HTMLTagElement data) {
        this.setItemData(data);
    }

    @Override
    String getTypeAttribute() {
        StringBuffer s = new StringBuffer("");
        if (this.type_ != null) {
            if (this.type_.equals("disc")) {
                s.append(" type=\"disc\"");
            } else if (this.type_.equals("square")) {
                s.append(" type=\"square\"");
            } else if (this.type_.equals("circle")) {
                s.append(" type=\"circle\"");
            }
            return new String(s);
        }
        return "";
    }

    @Override
    String getTypeAttributeFO(String type, int label) {
        StringBuffer s = new StringBuffer("");
        if (type != null) {
            if (type.equals("disc")) {
                s.append("&#183;");
            } else if (type.equals("square")) {
                s.append("&#197;");
            } else if (type.equals("circle")) {
                s.append("&#202;");
            }
        }
        return s.toString();
    }

    public String getType() {
        return this.type_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setType(String type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (!(type.equals("disc") || type.equals("circle") || type.equals("square"))) {
            throw new ExtendedIllegalArgumentException("type", 2);
        }
        String old = this.type_;
        this.type_ = type;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("type", old, type);
        }
    }
}

