/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.SelectOption;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class SelectFormElement
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -5409799783351050576L;
    private String name_;
    private int size_ = 0;
    private boolean multiple_ = false;
    private boolean optionSelected_;
    private String lang_;
    private String dir_;
    private Vector list_ = new Vector();
    private transient VetoableChangeSupport vetos_;
    private transient Vector elementListeners;

    public SelectFormElement() {
    }

    public SelectFormElement(String name) {
        this();
        try {
            this.setName(name);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(listener);
    }

    public void addOption(SelectOption option) {
        if (option == null) {
            throw new NullPointerException("option");
        }
        if (option.isSelected() && this.optionSelected_ && !this.multiple_) {
            Trace.log(2, "Multiple options marked as 'selected' but multiple attribute not set.");
            throw new ExtendedIllegalArgumentException("selected", 2);
        }
        if (option.isSelected() && !this.optionSelected_) {
            this.optionSelected_ = true;
        }
        this.list_.addElement(option);
        this.fireElementEvent(0);
    }

    public SelectOption addOption(String text, String value) {
        return this.addOption(text, value, false);
    }

    public SelectOption addOption(String text, String value, boolean selected) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (selected && this.optionSelected_ && !this.multiple_) {
            Trace.log(2, "Multiple options marked as 'selected' but multiple attribute not set.");
            throw new ExtendedIllegalArgumentException("selected", 2);
        }
        if (selected && !this.optionSelected_) {
            this.optionSelected_ = true;
        }
        SelectOption option = new SelectOption(text, value, selected);
        this.list_.addElement(option);
        this.fireElementEvent(0);
        return option;
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    private void fireElementEvent(int evt) {
        if (this.elementListeners == null) {
            return;
        }
        Vector targets = (Vector)this.elementListeners.clone();
        ElementEvent elementEvt = new ElementEvent(this, evt);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            if (evt == 0) {
                target.elementAdded(elementEvt);
                continue;
            }
            if (evt != 2) continue;
            target.elementRemoved(elementEvt);
        }
    }

    public String getDirection() {
        return this.dir_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    public String getName() {
        return this.name_;
    }

    public int getOptionCount() {
        return this.list_.size();
    }

    public int getSize() {
        return this.size_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A SelectFormElement was here -->";
    }

    @Override
    public String getTag() {
        if (this.name_ == null) {
            Trace.log(2, "Attempting to get tag before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        StringBuffer s = new StringBuffer("<select");
        s.append(" name=\"");
        s.append(this.name_);
        s.append("\"");
        if (this.size_ > 0) {
            s.append(" size=\"");
            s.append(this.size_);
            s.append("\"");
        }
        if (this.multiple_) {
            s.append(" multiple=\"multiple\"");
        }
        if (this.lang_ != null && this.lang_.length() > 0) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using language attribute.");
            }
            s.append(" lang=\"");
            s.append(this.lang_);
            s.append("\"");
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using direction attribute.");
            }
            s.append(" dir=\"");
            s.append(this.dir_);
            s.append("\"");
        }
        s.append(this.getAttributeString());
        s.append(">\n");
        this.optionSelected_ = false;
        for (int i = 0; i < this.getOptionCount(); ++i) {
            SelectOption option = (SelectOption)this.list_.elementAt(i);
            s.append(option.getTag());
            s.append("\n");
        }
        s.append("</select>");
        return s.toString();
    }

    public boolean isMultiple() {
        return this.multiple_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeOption(SelectOption option) {
        if (option == null) {
            throw new NullPointerException("option");
        }
        if (option.isSelected()) {
            if (this.multiple_) {
                boolean stillSomeLeft = false;
                for (int i = 0; !stillSomeLeft && i < this.list_.size(); ++i) {
                    SelectOption cur = (SelectOption)this.list_.elementAt(i);
                    if (cur == option || !cur.isSelected()) continue;
                    stillSomeLeft = true;
                }
                if (!stillSomeLeft) {
                    this.optionSelected_ = false;
                }
            } else {
                this.optionSelected_ = false;
            }
        }
        if (this.list_.removeElement(option)) {
            this.fireElementEvent(2);
        }
    }

    public void removeElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", old, dir);
        }
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", old, lang);
        }
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setMultiple(boolean multiple) throws PropertyVetoException {
        boolean old = this.multiple_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("multiple", (Object)old, (Object)multiple);
        }
        this.multiple_ = multiple;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("multiple", (Object)old, (Object)multiple);
        }
    }

    public void setName(String name) throws PropertyVetoException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String old = this.name_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("name", old, name);
        }
        this.name_ = name;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", old, name);
        }
    }

    public void setSize(int size) throws PropertyVetoException {
        if (size < 0) {
            throw new ExtendedIllegalArgumentException("size", 4);
        }
        int old = this.size_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("size", (Object)old, (Object)size);
        }
        this.size_ = size;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("size", (Object)old, (Object)size);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

