/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLList;
import java.io.IOException;
import java.io.ObjectInputStream;

public class OrderedList
extends HTMLList {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -1082870000306640180L;
    private String type_;
    private int start_ = -1;

    public OrderedList() {
    }

    public OrderedList(String type) {
        this.setType(type);
    }

    public int getStartingSequenceNumber() {
        return this.start_;
    }

    @Override
    public String getTag() {
        if (this.isUseFO()) {
            return this.getFOTag();
        }
        if (this.getItems().isEmpty()) {
            Trace.log(2, "Attempting to get tag before setting items in list.");
            throw new ExtendedIllegalStateException("items", 4);
        }
        StringBuffer s = new StringBuffer("<ol");
        s.append(this.getTypeAttributeTag());
        if (this.start_ > 0) {
            s.append(" start=\"");
            s.append(Integer.toString(this.start_));
            s.append("\"");
        }
        if (this.isCompact()) {
            s.append(" compact=\"compact\"");
        }
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(this.getAttributeString());
        s.append(">\n");
        s.append(this.getItemAttributeTag());
        s.append("</ol>\n");
        return s.toString();
    }

    @Override
    public String getFOTag() {
        boolean useFO = this.isUseFO();
        this.setUseFO(true);
        if (this.getItems().isEmpty()) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting items in list.");
            throw new ExtendedIllegalStateException("items", 4);
        }
        if (this.type_ == null) {
            this.type_ = "numbers";
        }
        StringBuffer s = new StringBuffer("<fo:block-container");
        s.append(this.getDirectionAttributeTag());
        s.append(">\n");
        s.append("<fo:list-block>\n");
        s.append(this.getItemAttributeFOTag(this.type_));
        s.append("</fo:list-block>\n");
        s.append("</fo:block-container>\n");
        this.setUseFO(useFO);
        return s.toString();
    }

    public String getType() {
        return this.type_;
    }

    private String getTypeAttributeTag() {
        StringBuffer s = new StringBuffer("");
        if (this.type_ != null) {
            if (this.type_.equals("numbers")) {
                s.append(" type=\"1\"");
            } else if (this.type_.equals("capitals")) {
                s.append(" type=\"A\"");
            } else if (this.type_.equals("lower_case")) {
                s.append(" type=\"a\"");
            } else if (this.type_.equals("large_roman")) {
                s.append(" type=\"I\"");
            } else if (this.type_.equals("small_roman")) {
                s.append(" type=\"i\"");
            }
            return s.toString();
        }
        return "";
    }

    public void setType(String type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (!(type.equals("numbers") || type.equals("capitals") || type.equals("lower_case") || type.equals("large_roman") || type.equals("small_roman"))) {
            throw new ExtendedIllegalArgumentException("type", 2);
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "   Setting order labeling type for <ol>.");
        }
        String old = this.type_;
        this.type_ = type;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("type", old, type);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setStartingSequenceNumber(int start) {
        if (start < 0) {
            throw new ExtendedIllegalArgumentException("start", 4);
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "   Setting starting number for <ol>.");
        }
        int old = this.start_;
        this.start_ = start;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("start", (Object)old, (Object)start);
        }
    }
}

