/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.ElementEvent;
import com.ibm.as400.util.html.ElementListener;
import com.ibm.as400.util.html.HTMLMeta;
import com.ibm.as400.util.html.HTMLTagAttributes;
import com.ibm.as400.util.html.HTMLTagElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class HTMLHead
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = 5006426803056962528L;
    private String title_;
    private String lang_;
    private String dir_;
    private boolean useFO_ = false;
    private Vector list_ = new Vector();
    private transient Vector elementListeners;

    public HTMLHead() {
    }

    public HTMLHead(String title) {
        this.setTitle(title);
    }

    public HTMLHead(String title, HTMLMeta meta) {
        this.addMetaInformation(meta);
        this.setTitle(title);
    }

    public void addMetaInformation(HTMLMeta meta) {
        if (meta == null) {
            throw new NullPointerException("meta");
        }
        this.list_.addElement(meta);
        this.fireElementEvent(0);
    }

    public void addMetaInformationElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners == null) {
            this.elementListeners = new Vector();
        }
        this.elementListeners.addElement(listener);
    }

    private void fireElementEvent(int evt) {
        if (this.elementListeners == null) {
            return;
        }
        Vector targets = (Vector)this.elementListeners.clone();
        ElementEvent elementEvt = new ElementEvent(this, evt);
        for (int i = 0; i < targets.size(); ++i) {
            ElementListener target = (ElementListener)targets.elementAt(i);
            if (evt == 0) {
                target.elementAdded(elementEvt);
                continue;
            }
            if (evt != 2) continue;
            target.elementRemoved(elementEvt);
        }
    }

    public String getDirection() {
        return this.dir_;
    }

    String getDirectionAttributeTag() {
        if (this.useFO_) {
            if (this.dir_ != null && this.dir_.length() > 0) {
                if (this.dir_.equals("rtl")) {
                    return " writing-mode='rl'";
                }
                return " writing-mode='lr'";
            }
            return "";
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            return " dir=\"" + this.dir_ + "\"";
        }
        return "";
    }

    public String getLanguage() {
        return this.lang_;
    }

    String getLanguageAttributeTag() {
        if (this.lang_ != null && this.lang_.length() > 0) {
            return " lang=\"" + this.lang_ + "\"";
        }
        return "";
    }

    @Override
    public String getTag() {
        if (this.useFO_) {
            return this.getFOTag();
        }
        if (this.title_ == null && this.list_.isEmpty()) {
            Trace.log(2, "Attempting to get tag before setting the title or adding meta information to the head.");
            throw new ExtendedIllegalStateException("title/meta", 4);
        }
        StringBuffer s = new StringBuffer("");
        s.append("<head");
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(this.getAttributeString());
        s.append(">\n");
        for (int i = 0; i < this.list_.size(); ++i) {
            HTMLTagElement data = (HTMLTagElement)this.list_.elementAt(i);
            s.append(data.getTag());
        }
        if (this.title_ != null) {
            s.append("<title");
            s.append(this.getLanguageAttributeTag());
            s.append(this.getDirectionAttributeTag());
            s.append(">");
            s.append(this.title_);
            s.append("</title>\n");
        }
        s.append("</head>\n");
        return s.toString();
    }

    @Override
    public String getFOTag() {
        boolean useFO = this.useFO_;
        this.setUseFO(true);
        if (this.title_ == null && this.list_.isEmpty()) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting the title for the head.");
            throw new ExtendedIllegalStateException("title", 4);
        }
        StringBuffer s = new StringBuffer("<fo:static-content flow-name='xsl-region-before'>\n");
        s.append("<fo:block-container");
        s.append(this.getDirectionAttributeTag());
        s.append(">\n");
        if (this.title_ != null) {
            s.append(this.title_);
        }
        s.append("</fo:block-container>\n");
        s.append("</fo:static-content>\n");
        this.setUseFO(useFO);
        return s.toString();
    }

    public String getTitle() {
        return this.title_;
    }

    public boolean isUseFO() {
        return this.useFO_;
    }

    public void removeMetaInformationElementListener(ElementListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.elementListeners != null) {
            this.elementListeners.removeElement(listener);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void removeMetaInformation(HTMLMeta meta) {
        if (meta == null) {
            throw new NullPointerException("meta");
        }
        if (this.list_.removeElement(meta)) {
            this.fireElementEvent(2);
        }
    }

    public void setDirection(String dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setLanguage(String lang) {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (title.length() == 0) {
            throw new ExtendedIllegalArgumentException("title", 2);
        }
        if (Trace.isTraceOn()) {
            Trace.log(3, "   Setting title for <head>.");
        }
        String old = this.title_;
        this.title_ = title;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("title", old, title);
        }
    }

    public void setUseFO(boolean useFO) {
        boolean old = this.useFO_;
        this.useFO_ = useFO;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("useFO", old, useFO);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

