/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.io.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.FlinkSourceSplit;
import org.apache.beam.runners.flink.translation.wrappers.streaming.io.source.compat.FlinkSourceCompat;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.metrics.Counter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlinkSourceReaderBase<@UnknownKeyFor T, @UnknownKeyFor OutputT>
implements SourceReader<OutputT, FlinkSourceSplit<T>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkSourceReaderBase.class);
    protected static final @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void> AVAILABLE_NOW = CompletableFuture.completedFuture(null);
    protected static final @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void> DUMMY_FUTURE = new CompletableFuture();
    protected static final @UnknownKeyFor @NonNull @Initialized Exception NO_EXCEPTION = new Exception();
    protected final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
    @javax.annotation.Nullable
    protected final @UnknownKeyFor @Nullable @Initialized Function<OutputT, @UnknownKeyFor @NonNull @Initialized Long> timestampExtractor;
    private final @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> sourceSplits = new ArrayDeque<FlinkSourceSplit<T>>();
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized FlinkSourceReaderBase. @UnknownKeyFor @NonNull @Initialized ReaderAndOutput> beamSourceReaders;
    protected final @UnknownKeyFor @NonNull @Initialized SourceReaderContext context;
    private final @UnknownKeyFor @NonNull @Initialized ScheduledExecutorService executor;
    protected final @UnknownKeyFor @NonNull @Initialized Counter numRecordsInCounter;
    protected final @UnknownKeyFor @NonNull @Initialized long idleTimeoutMs;
    private final @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void> idleTimeoutFuture;
    private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Throwable> exception;
    private @UnknownKeyFor @NonNull @Initialized boolean idleTimeoutCountingDown;
    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void> waitingForSplitChangeFuture;
    private @UnknownKeyFor @NonNull @Initialized boolean noMoreSplits;

    protected FlinkSourceReaderBase(@UnknownKeyFor @NonNull @Initialized SourceReaderContext context, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized Function<OutputT, @UnknownKeyFor @NonNull @Initialized Long> timestampExtractor) {
        this(Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "FlinkSource-Executor-Thread-" + context.getIndexOfSubtask())), context, pipelineOptions, timestampExtractor);
    }

    protected FlinkSourceReaderBase(@UnknownKeyFor @NonNull @Initialized ScheduledExecutorService executor, @UnknownKeyFor @NonNull @Initialized SourceReaderContext context, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized Function<OutputT, @UnknownKeyFor @NonNull @Initialized Long> timestampExtractor) {
        this.context = context;
        this.pipelineOptions = pipelineOptions;
        this.timestampExtractor = timestampExtractor;
        this.beamSourceReaders = new ConcurrentHashMap<Integer, ReaderAndOutput>();
        this.exception = new AtomicReference<Exception>(NO_EXCEPTION);
        this.executor = executor;
        this.idleTimeoutMs = ((FlinkPipelineOptions)pipelineOptions.as(FlinkPipelineOptions.class)).getShutdownSourcesAfterIdleMs();
        this.idleTimeoutFuture = new CompletableFuture();
        this.waitingForSplitChangeFuture = new CompletableFuture();
        this.idleTimeoutCountingDown = false;
        this.numRecordsInCounter = FlinkSourceCompat.getNumRecordsInCounter(context);
    }

    public void start() {
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> snapshotState(@UnknownKeyFor @NonNull @Initialized long checkpointId) {
        this.checkExceptionAndMaybeThrow();
        ArrayList<FlinkSourceSplit<T>> splitsState = new ArrayList<FlinkSourceSplit<T>>(this.sourceSplits);
        this.beamSourceReaders.forEach((splitId, readerAndOutput) -> {
            Source.Reader reader = readerAndOutput.reader;
            if (reader instanceof BoundedSource.BoundedReader) {
                splitsState.add(new FlinkSourceSplit((int)splitId, reader.getCurrentSource()));
            } else if (reader instanceof UnboundedSource.UnboundedReader) {
                byte[] checkpointState = this.getAndEncodeCheckpointMark((UnboundedSource.UnboundedReader)reader);
                splitsState.add(new FlinkSourceSplit((int)splitId, reader.getCurrentSource(), checkpointState));
            }
        });
        return splitsState;
    }

    public @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void> isAvailable() {
        this.checkExceptionAndMaybeThrow();
        if (!this.sourceSplits.isEmpty() || !this.beamSourceReaders.isEmpty()) {
            CompletableFuture<Void> aliveReaderAvailableFuture = this.isAvailableForAliveReaders();
            if (this.waitingForSplitChangeFuture.isDone()) {
                this.waitingForSplitChangeFuture = new CompletableFuture();
            }
            return CompletableFuture.anyOf(aliveReaderAvailableFuture, this.waitingForSplitChangeFuture).thenAccept(ignored -> {});
        }
        if (this.noMoreSplits) {
            this.checkIdleTimeoutAndMaybeStartCountdown();
            return this.idleTimeoutFuture;
        }
        if (this.waitingForSplitChangeFuture.isDone()) {
            this.waitingForSplitChangeFuture = new CompletableFuture();
        }
        return this.waitingForSplitChangeFuture;
    }

    public void notifyNoMoreSplits() {
        this.checkExceptionAndMaybeThrow();
        LOG.info("Received NoMoreSplits signal from enumerator.");
        this.noMoreSplits = true;
        this.waitingForSplitChangeFuture.complete(null);
    }

    public void addSplits(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> splits) {
        this.checkExceptionAndMaybeThrow();
        LOG.info("Adding splits {}", splits);
        this.sourceSplits.addAll(splits);
        this.waitingForSplitChangeFuture.complete(null);
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (ReaderAndOutput readerAndOutput : this.beamSourceReaders.values()) {
            readerAndOutput.reader.close();
        }
        this.executor.shutdown();
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @Nullable @Initialized Void> isAvailableForAliveReaders();

    protected @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized FlinkSourceReaderBase. @UnknownKeyFor @NonNull @Initialized ReaderAndOutput> createAndTrackNextReader() throws @UnknownKeyFor @NonNull @Initialized IOException {
        FlinkSourceSplit<T> sourceSplit = this.sourceSplits.poll();
        if (sourceSplit != null) {
            Source.Reader<T> reader = this.createReader(sourceSplit);
            ReaderAndOutput readerAndOutput = new ReaderAndOutput(sourceSplit.splitId(), reader, false);
            this.beamSourceReaders.put(sourceSplit.splitIndex(), readerAndOutput);
            return Optional.of(readerAndOutput);
        }
        return Optional.empty();
    }

    protected void finishSplit(@UnknownKeyFor @NonNull @Initialized int splitIndex) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ReaderAndOutput readerAndOutput = (ReaderAndOutput)this.beamSourceReaders.remove(splitIndex);
        if (readerAndOutput == null) {
            throw new IllegalStateException("SourceReader for split " + splitIndex + " should never be null!");
        }
        LOG.info("Finished reading from split {}", (Object)readerAndOutput.splitId);
        readerAndOutput.reader.close();
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean checkIdleTimeoutAndMaybeStartCountdown() {
        if (this.idleTimeoutMs <= 0L) {
            this.idleTimeoutFuture.complete(null);
        } else if (!this.idleTimeoutCountingDown) {
            this.scheduleTask(() -> this.idleTimeoutFuture.complete(null), this.idleTimeoutMs);
            this.idleTimeoutCountingDown = true;
        }
        return this.idleTimeoutFuture.isDone();
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean noMoreSplits() {
        return this.noMoreSplits;
    }

    protected void scheduleTask(@UnknownKeyFor @NonNull @Initialized Runnable runnable, @UnknownKeyFor @NonNull @Initialized long delayMs) {
        FlinkSourceReaderBase.ignoreReturnValue(this.executor.schedule(new ErrorRecordingRunnable(runnable), delayMs, TimeUnit.MILLISECONDS));
    }

    protected void scheduleTaskAtFixedRate(@UnknownKeyFor @NonNull @Initialized Runnable runnable, @UnknownKeyFor @NonNull @Initialized long delayMs, @UnknownKeyFor @NonNull @Initialized long periodMs) {
        FlinkSourceReaderBase.ignoreReturnValue(this.executor.scheduleAtFixedRate(new ErrorRecordingRunnable(runnable), delayMs, periodMs, TimeUnit.MILLISECONDS));
    }

    protected void execute(@UnknownKeyFor @NonNull @Initialized Runnable runnable) {
        this.executor.execute(new ErrorRecordingRunnable(runnable));
    }

    protected void recordException(@UnknownKeyFor @NonNull @Initialized Throwable e) {
        if (!this.exception.compareAndSet(NO_EXCEPTION, e)) {
            this.exception.get().addSuppressed(e);
        }
    }

    protected void checkExceptionAndMaybeThrow() {
        if (this.exception.get() != NO_EXCEPTION) {
            throw new RuntimeException("The source reader received exception.", this.exception.get());
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean hasException() {
        return this.exception.get() != NO_EXCEPTION;
    }

    protected @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T>> sourceSplits() {
        return Collections.unmodifiableCollection(this.sourceSplits);
    }

    protected @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized FlinkSourceReaderBase. @UnknownKeyFor @NonNull @Initialized ReaderAndOutput> allReaders() {
        return Collections.unmodifiableMap(this.beamSourceReaders);
    }

    protected static void ignoreReturnValue(@UnknownKeyFor @NonNull @Initialized Object o) {
    }

    private <CheckpointMarkT extends UnboundedSource.CheckpointMark> @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getAndEncodeCheckpointMark(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<OutputT> reader) {
        byte[] byArray;
        UnboundedSource source = reader.getCurrentSource();
        UnboundedSource.CheckpointMark checkpointMark = reader.getCheckpointMark();
        Coder coder = source.getCheckpointMarkCoder();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            coder.encode((Object)checkpointMark, (OutputStream)baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    FlinkSourceReaderBase.$closeResource(throwable, baos);
                    throw throwable3;
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to encode checkpoint mark.", ioe);
            }
        }
        FlinkSourceReaderBase.$closeResource(throwable, baos);
        return byArray;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Source.Reader<T> createReader(@Nonnull @UnknownKeyFor @NonNull @Initialized FlinkSourceSplit<T> sourceSplit) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Source<T> beamSource = sourceSplit.getBeamSplitSource();
        if (beamSource instanceof BoundedSource) {
            return ((BoundedSource)beamSource).createReader(this.pipelineOptions);
        }
        if (beamSource instanceof UnboundedSource) {
            return this.createUnboundedSourceReader(beamSource, sourceSplit.getSplitState());
        }
        throw new IllegalStateException("Unknown source type " + beamSource.getClass());
    }

    private <CheckpointMarkT extends UnboundedSource.CheckpointMark> // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Source.Reader<T> createUnboundedSourceReader(@UnknownKeyFor @NonNull @Initialized Source<T> beamSource, @javax.annotation.Nullable @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @Nullable @Initialized [] splitState) throws @UnknownKeyFor @NonNull @Initialized IOException {
        UnboundedSource unboundedSource = (UnboundedSource)beamSource;
        Coder coder = unboundedSource.getCheckpointMarkCoder();
        if (splitState == null) {
            return unboundedSource.createReader(this.pipelineOptions, null);
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(splitState);){
            UnboundedSource.UnboundedReader unboundedReader = unboundedSource.createReader(this.pipelineOptions, (UnboundedSource.CheckpointMark)coder.decode((InputStream)bais));
            return unboundedReader;
        }
    }

    private final class ErrorRecordingRunnable
    implements Runnable {
        private final @UnknownKeyFor @NonNull @Initialized Runnable runnable;

        ErrorRecordingRunnable(Runnable r) {
            this.runnable = r;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                FlinkSourceReaderBase.this.recordException(t);
            }
        }
    }

    protected final class ReaderAndOutput {
        public final @UnknownKeyFor @NonNull @Initialized String splitId;
        public final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Source.Reader<T> reader;
        private @UnknownKeyFor @NonNull @Initialized boolean started;
        @javax.annotation.Nullable
        private @UnknownKeyFor @Nullable @Initialized SourceOutput<OutputT> outputForSplit;

        public ReaderAndOutput(@UnknownKeyFor @NonNull @Initialized String splitId, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Source.Reader<T> reader, boolean started) {
            this.splitId = splitId;
            this.reader = reader;
            this.started = started;
            this.outputForSplit = null;
        }

        public @UnknownKeyFor @NonNull @Initialized SourceOutput<OutputT> getAndMaybeCreateSplitOutput(@UnknownKeyFor @NonNull @Initialized ReaderOutput<OutputT> output) {
            if (this.outputForSplit == null) {
                this.outputForSplit = output.createOutputForSplit(this.splitId);
            }
            return this.outputForSplit;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean startOrAdvance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.started) {
                return this.reader.advance();
            }
            this.started = true;
            return this.reader.start();
        }

        @javax.annotation.Nullable
        public @UnknownKeyFor @Nullable @Initialized SourceOutput<OutputT> sourceOutput() {
            return this.outputForSplit;
        }
    }
}

