/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import java.util.Random;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.util.MovingFunction;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class AdaptiveThrottler {
    private final @UnknownKeyFor @NonNull @Initialized MovingFunction successfulRequests;
    private final @UnknownKeyFor @NonNull @Initialized MovingFunction allRequests;
    private final @UnknownKeyFor @NonNull @Initialized double overloadRatio;
    private static final @UnknownKeyFor @NonNull @Initialized double MIN_REQUESTS = 1.0;
    private final @UnknownKeyFor @NonNull @Initialized Random random;

    public AdaptiveThrottler(@UnknownKeyFor @NonNull @Initialized long samplePeriodMs, @UnknownKeyFor @NonNull @Initialized long sampleUpdateMs, @UnknownKeyFor @NonNull @Initialized double overloadRatio) {
        this(samplePeriodMs, sampleUpdateMs, overloadRatio, new Random());
    }

    @VisibleForTesting
    AdaptiveThrottler(@UnknownKeyFor @NonNull @Initialized long samplePeriodMs, @UnknownKeyFor @NonNull @Initialized long sampleUpdateMs, @UnknownKeyFor @NonNull @Initialized double overloadRatio, @UnknownKeyFor @NonNull @Initialized Random random) {
        this.allRequests = new MovingFunction(samplePeriodMs, sampleUpdateMs, 1, 1, Sum.ofLongs());
        this.successfulRequests = new MovingFunction(samplePeriodMs, sampleUpdateMs, 1, 1, Sum.ofLongs());
        this.overloadRatio = overloadRatio;
        this.random = random;
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized double throttlingProbability(@UnknownKeyFor @NonNull @Initialized long nowMsSinceEpoch) {
        if (!this.allRequests.isSignificant()) {
            return 0.0;
        }
        long allRequestsNow = this.allRequests.get(nowMsSinceEpoch);
        long successfulRequestsNow = this.successfulRequests.get(nowMsSinceEpoch);
        return Math.max(0.0, ((double)allRequestsNow - this.overloadRatio * (double)successfulRequestsNow) / ((double)allRequestsNow + 1.0));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean throttleRequest(@UnknownKeyFor @NonNull @Initialized long nowMsSinceEpoch) {
        double delayProbability = this.throttlingProbability(nowMsSinceEpoch);
        this.allRequests.add(nowMsSinceEpoch, 1L);
        return this.random.nextDouble() < delayProbability;
    }

    public void successfulRequest(@UnknownKeyFor @NonNull @Initialized long nowMsSinceEpoch) {
        this.successfulRequests.add(nowMsSinceEpoch, 1L);
    }
}

