/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.util.Assert;

final class DynamicWaitTimes {
    DynamicWaitTimes() {
    }

    static SingleStreamStatus build(List<IRowSet> rowSets, Supplier<Integer> supplier, Integer waitTime) {
        if (rowSets.size() == 1) {
            return new SingleStreamStatus(waitTime);
        }
        return new MultiStreamStatus(new ArrayList<IRowSet>(rowSets), supplier, waitTime);
    }

    private static class MultiStreamStatus
    extends SingleStreamStatus {
        private final List<IRowSet> streamList;
        private final List<SingleStreamStatus> statusList;
        private final Supplier<Integer> supplier;

        MultiStreamStatus(List<IRowSet> rowSets, Supplier<Integer> supplier, Integer waitTime) {
            super(waitTime);
            this.streamList = rowSets;
            this.supplier = supplier;
            this.statusList = new ArrayList<SingleStreamStatus>(rowSets.size());
            for (int i = 0; i < rowSets.size(); ++i) {
                this.statusList.add(new SingleStreamStatus(waitTime));
            }
        }

        @Override
        public long get() {
            SingleStreamStatus stream = this.statusList.get(this.supplier.get());
            return stream.active ? stream.get() : 0L;
        }

        @Override
        public void reset() {
            this.statusList.get(this.supplier.get()).reset();
        }

        @Override
        public void adjust(boolean timeout, IRowSet nextIfExist) {
            int index = this.supplier.get();
            if (index == -1) {
                return;
            }
            SingleStreamStatus current = this.statusList.get(index);
            if (this.streamList.get(index).equals(nextIfExist)) {
                if (this.streamList.size() == 1 && !current.active) {
                    current.reset();
                }
            } else {
                int nextIndex = this.streamList.indexOf(nextIfExist);
                Assert.assertTrue(nextIndex == 0 || nextIndex == index + 1);
                current = this.statusList.get(nextIndex);
                if (this.activeIfNeed()) {
                    current.reset();
                    return;
                }
            }
            current.adjust(timeout, nextIfExist);
        }

        @Override
        public void remove(IRowSet rowSet) {
            int index = this.supplier.get();
            if (!this.streamList.get(index).equals(rowSet)) {
                index = this.streamList.indexOf(rowSet);
            }
            Assert.assertTrue(index > -1, "Removed input steam at {0}, before switch next stream", index);
            this.streamList.remove(index);
            this.statusList.remove(index);
            if (!this.streamList.isEmpty() && this.activeIfNeed()) {
                this.statusList.forEach(SingleStreamStatus::reset);
            }
        }

        @Override
        protected boolean allowAdjust() {
            return this.activeIfNeed();
        }

        private boolean activeIfNeed() {
            return this.statusList.stream().noneMatch(SingleStreamStatus::allowAdjust);
        }

        @Override
        protected void doReset(int index) {
            this.statusList.get(index).reset();
        }
    }

    static class SingleStreamStatus {
        protected boolean active = true;
        private long interval = 1L;
        private long waitTime;

        SingleStreamStatus(Integer waitTime) {
            this.waitTime = waitTime.intValue();
        }

        public long get() {
            return this.interval;
        }

        public void reset() {
            this.interval = 1L;
            this.active = true;
        }

        public void adjust(boolean timeout, IRowSet nextIfExist) {
            if (this.allowAdjust() && timeout) {
                if (this.interval == this.waitTime) {
                    this.active = false;
                }
                this.interval *= 2L;
                if (this.interval > this.waitTime) {
                    this.interval = this.waitTime;
                }
            }
        }

        public void remove(IRowSet rowSet) {
        }

        protected boolean allowAdjust() {
            return this.active;
        }

        protected void doReset(int index) {
        }
    }
}

