/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.internal.ClickHouseStatementImpl;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractPreparedStatement
extends ClickHouseStatementImpl
implements PreparedStatement {
    protected AbstractPreparedStatement(ClickHouseConnectionImpl connection, ClickHouseRequest<?> request, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, request, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected abstract long[] executeAny(boolean var1) throws SQLException;

    protected abstract int getMaxParameterIndex();

    protected int toArrayIndex(int parameterIndex) throws SQLException {
        int max = this.getMaxParameterIndex();
        if (max < 1) {
            String name = this.getConnection().getJdbcConfig().useNamedParameter() ? "named parameter" : "JDBC style '?' placeholder";
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format("Can't set parameter at index %d due to no %s found in the query", parameterIndex, name));
        }
        if (parameterIndex < 1 || parameterIndex > max) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format("Parameter index must between 1 and %d but we got %d", max, parameterIndex));
        }
        return parameterIndex - 1;
    }

    @Override
    public final void addBatch(String sql) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("addBatch(String) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("execute(String) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("execute(String, int) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("execute(String, int[]) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("execute(String, String[]) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return this.executeAny(true);
    }

    @Override
    public final long executeLargeUpdate(String sql) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("executeLargeUpdate(String) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public final long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("executeLargeUpdate(String, int) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public final long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("executeLargeUpdate(String, int[]) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public final long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("executeLargeUpdate(String, String[]) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("executeQuery(String) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public final int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("executeUpate(String) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("executeUpdate(String, int) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("executeUpdate(String, int[]) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("executeUpdate(String, String[]) cannot be called in PreparedStatement or CallableStatement!");
    }
}

