/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.ShardedKeyCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.AutoValue_WriteFiles;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.ShardingFunction;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.MoreFutures;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
@AutoValue
public abstract class WriteFiles<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT, @UnknownKeyFor OutputT>
extends PTransform<PCollection<UserT>, WriteFilesResult<DestinationT>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WriteFiles.class);
    @Internal
    public static final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized WriteFiles> CONCRETE_CLASS = AutoValue_WriteFiles.class;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_NUM_WRITERS_PER_BUNDLE = 20;
    private static final @UnknownKeyFor @NonNull @Initialized int SPILLED_RECORD_SHARDING_FACTOR = 10;
    private static final @UnknownKeyFor @NonNull @Initialized int FILE_TRIGGERING_RECORD_COUNT = 100000;
    private static final @UnknownKeyFor @NonNull @Initialized int FILE_TRIGGERING_BYTE_COUNT = 0x4000000;
    private static final @UnknownKeyFor @NonNull @Initialized Duration FILE_TRIGGERING_RECORD_BUFFERING_DURATION = Duration.standardSeconds((long)5L);
    static final @UnknownKeyFor @NonNull @Initialized int UNKNOWN_SHARDNUM = -1;
    static final @UnknownKeyFor @NonNull @Initialized int DUMMY_SHARDNUM = 0;
    private @Nullable @UnknownKeyFor @Initialized FileBasedSink.WriteOperation<DestinationT, OutputT> writeOperation;

    public static <UserT, DestinationT, OutputT> @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> to(@UnknownKeyFor @NonNull @Initialized FileBasedSink<UserT, DestinationT, OutputT> sink) {
        Preconditions.checkArgument((sink != null ? 1 : 0) != 0, (Object)"sink can not be null");
        return new AutoValue_WriteFiles.Builder<UserT, DestinationT, OutputT>().setSink(sink).setComputeNumShards(null).setNumShardsProvider(null).setWindowedWrites(false).setMaxNumWritersPerBundle(20).setSideInputs(sink.getDynamicDestinations().getSideInputs()).setSkipIfEmpty(false).build();
    }

    public abstract @UnknownKeyFor @NonNull @Initialized FileBasedSink<UserT, DestinationT, OutputT> getSink();

    public abstract @Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<UserT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Integer>> getComputeNumShards();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> getNumShardsProvider();

    public abstract @UnknownKeyFor @NonNull @Initialized boolean getWindowedWrites();

    abstract @UnknownKeyFor @NonNull @Initialized int getMaxNumWritersPerBundle();

    abstract @UnknownKeyFor @NonNull @Initialized boolean getSkipIfEmpty();

    abstract /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs();

    public abstract @Nullable @UnknownKeyFor @Initialized ShardingFunction<UserT, DestinationT> getShardingFunction();

    abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> toBuilder();

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> getAdditionalInputs() {
        return PCollectionViews.toAdditionalInputs(this.getSideInputs());
    }

    public @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> withNumShards(@UnknownKeyFor @NonNull @Initialized int numShards) {
        if (numShards > 0) {
            return this.withNumShards(ValueProvider.StaticValueProvider.of(numShards));
        }
        return this.withRunnerDeterminedSharding();
    }

    public @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> withNumShards(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> numShardsProvider) {
        return this.toBuilder().setNumShardsProvider(numShardsProvider).build();
    }

    public @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> withMaxNumWritersPerBundle(@UnknownKeyFor @NonNull @Initialized int maxNumWritersPerBundle) {
        return this.toBuilder().setMaxNumWritersPerBundle(maxNumWritersPerBundle).build();
    }

    public @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> withSkipIfEmpty(@UnknownKeyFor @NonNull @Initialized boolean skipIfEmpty) {
        return this.toBuilder().setSkipIfEmpty(skipIfEmpty).build();
    }

    public @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> withSideInputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
        return this.toBuilder().setSideInputs(sideInputs).build();
    }

    public @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> withSharding(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<UserT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Integer>> sharding) {
        Preconditions.checkArgument((sharding != null ? 1 : 0) != 0, (Object)"sharding can not be null. Use withRunnerDeterminedSharding() instead.");
        return this.toBuilder().setComputeNumShards(sharding).build();
    }

    public @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> withRunnerDeterminedSharding() {
        return this.toBuilder().setComputeNumShards(null).setNumShardsProvider(null).build();
    }

    public @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> withShardingFunction(@UnknownKeyFor @NonNull @Initialized ShardingFunction<UserT, DestinationT> shardingFunction) {
        return this.toBuilder().setShardingFunction(shardingFunction).build();
    }

    public @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> withWindowedWrites() {
        return this.toBuilder().setWindowedWrites(true).build();
    }

    public @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> withNoSpilling() {
        return this.toBuilder().setMaxNumWritersPerBundle(-1).build();
    }

    public @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> withSkipIfEmpty() {
        return this.toBuilder().setSkipIfEmpty(true).build();
    }

    @Override
    public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.getSink().validate(options);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<UserT> input) {
        boolean fixedSharding;
        Coder<DestinationT> destinationCoder;
        if (input.isBounded() == PCollection.IsBounded.UNBOUNDED) {
            Preconditions.checkArgument((boolean)this.getWindowedWrites(), (String)"Must use windowed writes when applying %s to an unbounded PCollection", (Object)WriteFiles.class.getSimpleName());
            if (input.getWindowingStrategy().needsMerge()) {
                Preconditions.checkArgument((this.getComputeNumShards() != null || this.getNumShardsProvider() != null ? 1 : 0) != 0, (String)"When applying %s to an unbounded PCollection with merging windows, must specify number of output shards explicitly", (Object)WriteFiles.class.getSimpleName());
            }
        }
        this.writeOperation = this.getSink().createWriteOperation();
        if (this.getWindowedWrites()) {
            this.writeOperation.setWindowedWrites();
        } else {
            input = (PCollection)input.apply("RewindowIntoGlobal", Window.into(new GlobalWindows()).triggering(DefaultTrigger.of()).discardingFiredPanes());
        }
        try {
            destinationCoder = this.getDynamicDestinations().getDestinationCoderWithDefault(input.getPipeline().getCoderRegistry());
            destinationCoder.verifyDeterministic();
        }
        catch (CannotProvideCoderException | Coder.NonDeterministicException e) {
            throw new RuntimeException(e);
        }
        Coder<BoundedWindow> windowCoder = input.getWindowingStrategy().getWindowFn().windowCoder();
        FileBasedSink.FileResultCoder<DestinationT> fileResultCoder = FileBasedSink.FileResultCoder.of(windowCoder, destinationCoder);
        PCollectionView<Integer> numShardsView = this.getComputeNumShards() == null ? null : input.apply(this.getComputeNumShards());
        boolean bl = fixedSharding = this.getComputeNumShards() != null || this.getNumShardsProvider() != null;
        PCollection tempFileResults = fixedSharding ? (PCollection)((PCollection)input.apply("WriteShardedBundlesToTempFiles", new WriteShardedBundlesToTempFiles(destinationCoder, fileResultCoder, numShardsView))).apply("GatherTempFileResults", new GatherResults(fileResultCoder)) : (input.isBounded() == PCollection.IsBounded.BOUNDED ? (PCollection)((PCollection)input.apply("WriteUnshardedBundlesToTempFiles", new WriteUnshardedBundlesToTempFiles(destinationCoder, fileResultCoder))).apply("GatherTempFileResults", new GatherResults(fileResultCoder)) : (PCollection)input.apply("WriteAutoShardedBundlesToTempFiles", new WriteAutoShardedBundlesToTempFiles(destinationCoder, fileResultCoder)));
        return (WriteFilesResult)tempFileResults.apply("FinalizeTempFileBundles", new FinalizeTempFileBundles(numShardsView, destinationCoder));
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("sink", this.getSink().getClass()).withLabel("WriteFiles Sink")).include("sink", this.getSink());
        if (this.getComputeNumShards() != null) {
            builder.include("sharding", this.getComputeNumShards());
        } else {
            builder.addIfNotNull(DisplayData.item("numShards", this.getNumShardsProvider()).withLabel("Fixed Number of Shards"));
        }
    }

    private @UnknownKeyFor @NonNull @Initialized FileBasedSink.DynamicDestinations<UserT, DestinationT, OutputT> getDynamicDestinations() {
        return this.writeOperation.getSink().getDynamicDestinations();
    }

    private static <DestinationT, OutputT> void writeOrClose(@UnknownKeyFor @NonNull @Initialized FileBasedSink.Writer<DestinationT, OutputT> writer, OutputT t) throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            writer.write(t);
        }
        catch (Exception e) {
            try {
                writer.close();
                writer.cleanup();
            }
            catch (Exception closeException) {
                if (closeException instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                e.addSuppressed(closeException);
            }
            throw e;
        }
    }

    private static <DestinationT> @UnknownKeyFor @NonNull @Initialized int hashDestination(DestinationT destination, @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return Hashing.murmur3_32().hashBytes(CoderUtils.encodeToByteArray(destinationCoder, destination)).asInt();
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT>, @UnknownKeyFor @NonNull @Initialized ResourceId>> finalizeAllDestinations(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT>> fileResults, @Nullable @UnknownKeyFor @Initialized Integer fixedNumShards) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayListMultimap res = ArrayListMultimap.create();
        for (FileBasedSink.FileResult<DestinationT> result : fileResults) {
            res.put(KV.of(result.getDestination(), result.getWindow()), result);
        }
        ArrayList resultsToFinalFilenames = Lists.newArrayList();
        for (Map.Entry destEntry : res.asMap().entrySet()) {
            KV destWindow = (KV)destEntry.getKey();
            resultsToFinalFilenames.addAll(this.writeOperation.finalizeDestination(destWindow.getKey(), (BoundedWindow)destWindow.getValue(), fixedNumShards, (Collection)destEntry.getValue()));
        }
        return resultsToFinalFilenames;
    }

    private static class GatherBundlesPerWindowFn<@UnknownKeyFor T>
    extends DoFn<T, List<T>> {
        private transient @Nullable @UnknownKeyFor @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized BoundedWindow, T> bundles = null;

        private GatherBundlesPerWindowFn() {
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.bundles = ArrayListMultimap.create();
        }

        @DoFn.ProcessElement
        public void process(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow w) {
            this.bundles.put((Object)w, c.element());
        }

        @DoFn.FinishBundle
        public void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            for (BoundedWindow w : this.bundles.keySet()) {
                c.output(Lists.newArrayList((Iterable)this.bundles.get((Object)w)), w.maxTimestamp(), w);
            }
        }
    }

    private class FinalizeTempFileBundles
    extends PTransform<PCollection<List<FileBasedSink.FileResult<DestinationT>>>, WriteFilesResult<DestinationT>> {
        private final @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Integer> numShardsView;
        private final @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder;

        private FinalizeTempFileBundles(@UnknownKeyFor @NonNull @Initialized PCollectionView<Integer> numShardsView, Coder<DestinationT> destinationCoder) {
            this.numShardsView = numShardsView;
            this.destinationCoder = destinationCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized WriteFilesResult<DestinationT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT>>> input) {
            ArrayList finalizeSideInputs = Lists.newArrayList(WriteFiles.this.getSideInputs());
            if (this.numShardsView != null) {
                finalizeSideInputs.add(this.numShardsView);
            }
            PCollection outputFilenames = (PCollection)((PCollection)input.apply("Finalize", ParDo.of(new FinalizeFn()).withSideInputs(finalizeSideInputs))).setCoder(KvCoder.of(this.destinationCoder, StringUtf8Coder.of())).apply(Reshuffle.viaRandomKey());
            TupleTag perDestinationOutputFilenamesTag = new TupleTag("perDestinationOutputFilenames");
            return WriteFilesResult.in(input.getPipeline(), perDestinationOutputFilenamesTag, outputFilenames);
        }

        private class FinalizeFn
        extends DoFn<List<FileBasedSink.FileResult<DestinationT>>, KV<DestinationT, String>> {
            private FinalizeFn() {
            }

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                WriteFiles.this.getDynamicDestinations().setSideInputAccessorFromProcessContext(c);
                Integer fixedNumShards = FinalizeTempFileBundles.this.numShardsView != null ? (Integer)c.sideInput(FinalizeTempFileBundles.this.numShardsView) : (WriteFiles.this.getNumShardsProvider() != null ? WriteFiles.this.getNumShardsProvider().get() : null);
                ArrayList fileResults = Lists.newArrayList((Iterable)((Iterable)c.element()));
                LOG.info("Finalizing {} file results", (Object)fileResults.size());
                if (fileResults.isEmpty() && WriteFiles.this.getSkipIfEmpty()) {
                    return;
                }
                Object defaultDest = WriteFiles.this.getDynamicDestinations().getDefaultDestination();
                List resultsToFinalFilenames = fileResults.isEmpty() ? WriteFiles.this.writeOperation.finalizeDestination(defaultDest, GlobalWindow.INSTANCE, fixedNumShards, fileResults) : WriteFiles.this.finalizeAllDestinations(fileResults, fixedNumShards);
                WriteFiles.this.writeOperation.moveToOutputFiles(resultsToFinalFilenames);
                for (KV entry : resultsToFinalFilenames) {
                    FileBasedSink.FileResult res = entry.getKey();
                    c.output(KV.of(res.getDestination(), entry.getValue().toString()));
                }
            }
        }
    }

    private class WriteShardsIntoTempFilesFn
    extends DoFn<KV<org.apache.beam.sdk.values.ShardedKey<Integer>, Iterable<UserT>>, FileBasedSink.FileResult<DestinationT>> {
        private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CompletionStage<@UnknownKeyFor @Nullable @Initialized Void>> closeFutures = new ArrayList<CompletionStage<Void>>();
        private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT>>> deferredOutput = new ArrayList();

        private WriteShardsIntoTempFilesFn() {
        }

        private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
            in.defaultReadObject();
            this.closeFutures = new ArrayList<CompletionStage<Void>>();
            this.deferredOutput = new ArrayList();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized Exception {
            WriteFiles.this.getDynamicDestinations().setSideInputAccessorFromProcessContext(c);
            HashMap writers = Maps.newHashMap();
            for (Object input : (Iterable)((KV)c.element()).getValue()) {
                Object destination = WriteFiles.this.getDynamicDestinations().getDestination(input);
                FileBasedSink.Writer writer = (FileBasedSink.Writer)writers.get(destination);
                if (writer == null) {
                    String uuid = UUID.randomUUID().toString();
                    LOG.info("Opening writer {} for window {} pane {} destination {}", new Object[]{uuid, window, c.pane(), destination});
                    writer = WriteFiles.this.writeOperation.createWriter();
                    writer.setDestination(destination);
                    writer.open(uuid);
                    writers.put(destination, writer);
                }
                WriteFiles.writeOrClose(writer, WriteFiles.this.getDynamicDestinations().formatRecord(input));
            }
            CompletionStage<List<Void>> pastCloseFutures = MoreFutures.allAsList(this.closeFutures);
            this.closeFutures.clear();
            for (Map.Entry entry : writers.entrySet()) {
                int shard = ((org.apache.beam.sdk.values.ShardedKey)((KV)c.element()).getKey()).getShardNumber();
                Preconditions.checkArgument((shard != -1 ? 1 : 0) != 0, (String)"Shard should have been set, but is unset for element %s", c.element());
                FileBasedSink.Writer writer = (FileBasedSink.Writer)entry.getValue();
                this.deferredOutput.add(KV.of(c.timestamp(), new FileBasedSink.FileResult(writer.getOutputFile(), shard, window, c.pane(), entry.getKey())));
                this.closeWriterInBackground(writer);
            }
            MoreFutures.get(pastCloseFutures);
        }

        private void closeWriterInBackground(@UnknownKeyFor @NonNull @Initialized FileBasedSink.Writer<DestinationT, OutputT> writer) {
            this.closeFutures.add(MoreFutures.runAsync(() -> {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    writer.cleanup();
                    throw e;
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @DoFn.FinishBundle
        public void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            try {
                MoreFutures.get(MoreFutures.allAsList(this.closeFutures));
                for (KV result : this.deferredOutput) {
                    c.output(result.getValue(), result.getKey(), result.getValue().getWindow());
                }
            }
            finally {
                this.deferredOutput.clear();
                this.closeFutures.clear();
            }
        }
    }

    private class ApplyShardingFunctionFn
    extends DoFn<UserT, KV<org.apache.beam.sdk.values.ShardedKey<Integer>, UserT>> {
        private final @UnknownKeyFor @NonNull @Initialized ShardingFunction<UserT, DestinationT> shardingFn;
        private final @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Integer> numShardsView;

        ApplyShardingFunctionFn(@Nullable @UnknownKeyFor @Initialized ShardingFunction<@UnknownKeyFor @NonNull @Initialized UserT, DestinationT> shardingFn, PCollectionView<Integer> numShardsView) {
            this.numShardsView = numShardsView;
            this.shardingFn = shardingFn;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
            int shardCount;
            WriteFiles.this.getDynamicDestinations().setSideInputAccessorFromProcessContext(context);
            if (this.numShardsView != null) {
                shardCount = context.sideInput(this.numShardsView);
            } else {
                Preconditions.checkNotNull(WriteFiles.this.getNumShardsProvider());
                shardCount = (Integer)Preconditions.checkNotNull((Object)WriteFiles.this.getNumShardsProvider().get(), (Object)"Must have non-null number of shards.");
            }
            Preconditions.checkArgument((shardCount > 0 ? 1 : 0) != 0, (String)"Must have a positive number of shards specified for non-runner-determined sharding. Got %s", (int)shardCount);
            Object destination = WriteFiles.this.getDynamicDestinations().getDestination(context.element());
            org.apache.beam.sdk.values.ShardedKey<Integer> shardKey = this.shardingFn.assignShardKey(destination, context.element(), shardCount);
            context.output(KV.of(shardKey, context.element()));
        }
    }

    private class RandomShardingFunction
    implements ShardingFunction<UserT, DestinationT> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder;
        private @UnknownKeyFor @NonNull @Initialized int shardNumber;

        RandomShardingFunction(Coder<DestinationT> destinationCoder) {
            this.destinationCoder = destinationCoder;
            this.shardNumber = -1;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.ShardedKey<@UnknownKeyFor @NonNull @Initialized Integer> assignShardKey(DestinationT destination, UserT element, @UnknownKeyFor @NonNull @Initialized int shardCount) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.shardNumber = this.shardNumber == -1 ? ThreadLocalRandom.current().nextInt(shardCount) : (this.shardNumber + 1) % shardCount;
            return org.apache.beam.sdk.values.ShardedKey.of(WriteFiles.hashDestination(destination, this.destinationCoder), this.shardNumber);
        }
    }

    private class WriteAutoShardedBundlesToTempFiles
    extends PTransform<PCollection<UserT>, PCollection<List<FileBasedSink.FileResult<DestinationT>>>> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT>> fileResultCoder;

        private WriteAutoShardedBundlesToTempFiles(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized DestinationT> destinationCoder, Coder<FileBasedSink.FileResult<DestinationT>> fileResultCoder) {
            this.destinationCoder = destinationCoder;
            this.fileResultCoder = fileResultCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<UserT> input) {
            PCollection shardedInput = ((PCollection)((PCollection)input.apply("KeyedByDestinationHash", ParDo.of(new DoFn<UserT, KV<Integer, UserT>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element UserT element, /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    WriteFiles.this.getDynamicDestinations().setSideInputAccessorFromProcessContext(context);
                    Object destination = WriteFiles.this.getDynamicDestinations().getDestination(context.element());
                    context.output(KV.of(WriteFiles.hashDestination(destination, WriteAutoShardedBundlesToTempFiles.this.destinationCoder), element));
                }
            }))).setCoder(KvCoder.of(VarIntCoder.of(), input.getCoder())).apply("ShardAndBatch", GroupIntoBatches.ofSize(100000L).withByteSize(0x4000000L).withMaxBufferingDuration(FILE_TRIGGERING_RECORD_BUFFERING_DURATION).withShardedKey())).setCoder(KvCoder.of(ShardedKey.Coder.of(VarIntCoder.of()), IterableCoder.of(input.getCoder())));
            PCollection tempFiles = ((PCollection)((PCollection)((PCollection)shardedInput.apply("AddDummyShard", MapElements.via(new SimpleFunction<KV<ShardedKey<Integer>, Iterable<UserT>>, KV<org.apache.beam.sdk.values.ShardedKey<Integer>, Iterable<UserT>>>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.ShardedKey<@UnknownKeyFor @NonNull @Initialized Integer>, @UnknownKeyFor @NonNull @Initialized Iterable<UserT>> apply(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<@UnknownKeyFor @NonNull @Initialized Integer>, @UnknownKeyFor @NonNull @Initialized Iterable<UserT>> input) {
                    return KV.of(org.apache.beam.sdk.values.ShardedKey.of(input.getKey().getKey(), 0), input.getValue());
                }
            }))).setCoder(KvCoder.of(ShardedKeyCoder.of(VarIntCoder.of()), IterableCoder.of(input.getCoder()))).apply("WriteShardsIntoTempFiles", ParDo.of(new WriteShardsIntoTempFilesFn()).withSideInputs(WriteFiles.this.getSideInputs()))).setCoder(this.fileResultCoder).apply("DropShardNum", ParDo.of(new DoFn<FileBasedSink.FileResult<DestinationT>, FileBasedSink.FileResult<DestinationT>>(){

                @DoFn.ProcessElement
                public void process(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    c.output(((FileBasedSink.FileResult)c.element()).withShard(-1));
                }
            }))).setCoder(this.fileResultCoder);
            return ((PCollection)((PCollection)((PCollection)tempFiles.apply("KeyedByDestination", WithKeys.of(new SimpleFunction<FileBasedSink.FileResult<DestinationT>, DestinationT>(){

                @Override
                public DestinationT apply(@UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT> input) {
                    return input.getDestination();
                }
            }))).setCoder(KvCoder.of(this.destinationCoder, this.fileResultCoder)).apply(GroupByKey.create())).apply("ExtractValuesToList", ParDo.of(new DoFn<KV<DestinationT, Iterable<FileBasedSink.FileResult<DestinationT>>>, List<FileBasedSink.FileResult<DestinationT>>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT>>> element, /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    ArrayList result = new ArrayList();
                    for (FileBasedSink.FileResult e : element.getValue()) {
                        result.add(e);
                    }
                    c.output(result);
                }
            }))).setCoder(ListCoder.of(this.fileResultCoder));
        }
    }

    private class WriteShardedBundlesToTempFiles
    extends PTransform<PCollection<UserT>, PCollection<FileBasedSink.FileResult<DestinationT>>> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT>> fileResultCoder;
        private final @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Integer> numShardsView;

        private WriteShardedBundlesToTempFiles(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized DestinationT> destinationCoder, @Nullable @UnknownKeyFor @Initialized Coder<@UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT>> fileResultCoder, PCollectionView<Integer> numShardsView) {
            this.destinationCoder = destinationCoder;
            this.fileResultCoder = fileResultCoder;
            this.numShardsView = numShardsView;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<UserT> input) {
            ArrayList shardingSideInputs = Lists.newArrayList(WriteFiles.this.getSideInputs());
            if (this.numShardsView != null) {
                shardingSideInputs.add(this.numShardsView);
            }
            ShardingFunction shardingFunction = WriteFiles.this.getShardingFunction() == null ? new RandomShardingFunction(this.destinationCoder) : WriteFiles.this.getShardingFunction();
            return ((PCollection)((PCollection)((PCollection)input.apply("ApplyShardingKey", ParDo.of(new ApplyShardingFunctionFn(shardingFunction, this.numShardsView)).withSideInputs(shardingSideInputs))).setCoder(KvCoder.of(ShardedKeyCoder.of(VarIntCoder.of()), input.getCoder())).apply("GroupIntoShards", GroupByKey.create())).apply("WriteShardsIntoTempFiles", ParDo.of(new WriteShardsIntoTempFilesFn()).withSideInputs(WriteFiles.this.getSideInputs()))).setCoder(this.fileResultCoder);
        }
    }

    private static class WriterKey<@UnknownKeyFor DestinationT> {
        private final @UnknownKeyFor @NonNull @Initialized BoundedWindow window;
        private final @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo;
        private final DestinationT destination;

        WriterKey(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, DestinationT destination) {
            this.window = window;
            this.paneInfo = paneInfo;
            this.destination = destination;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (!(o instanceof WriterKey)) {
                return false;
            }
            WriterKey other = (WriterKey)o;
            return Objects.equal((Object)this.window, (Object)other.window) && Objects.equal((Object)this.paneInfo, (Object)other.paneInfo) && Objects.equal(this.destination, other.destination);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.window, this.paneInfo, this.destination});
        }
    }

    private class WriteUnshardedTempFilesFn
    extends DoFn<UserT, FileBasedSink.FileResult<DestinationT>> {
        private final @Nullable @UnknownKeyFor @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.ShardedKey<@UnknownKeyFor @NonNull @Initialized Integer>, UserT>> unwrittenRecordsTag;
        private final @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder;
        private @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized WriterKey<DestinationT>, @UnknownKeyFor @NonNull @Initialized FileBasedSink.Writer<DestinationT, OutputT>> writers;
        private @UnknownKeyFor @NonNull @Initialized int spilledShardNum = -1;

        WriteUnshardedTempFilesFn(@UnknownKeyFor @NonNull @Initialized TupleTag<KV<org.apache.beam.sdk.values.ShardedKey<Integer>, UserT>> unwrittenRecordsTag, Coder<DestinationT> destinationCoder) {
            this.unwrittenRecordsTag = unwrittenRecordsTag;
            this.destinationCoder = destinationCoder;
        }

        @DoFn.StartBundle
        public void startBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext c) {
            this.writers = Maps.newHashMap();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized Exception {
            WriteFiles.this.getDynamicDestinations().setSideInputAccessorFromProcessContext(c);
            PaneInfo paneInfo = c.pane();
            Object destination = WriteFiles.this.getDynamicDestinations().getDestination(c.element());
            WriterKey key = new WriterKey(window, c.pane(), destination);
            FileBasedSink.Writer writer = this.writers.get(key);
            if (writer == null) {
                if (WriteFiles.this.getMaxNumWritersPerBundle() < 0 || this.writers.size() <= WriteFiles.this.getMaxNumWritersPerBundle()) {
                    String uuid = UUID.randomUUID().toString();
                    LOG.info("Opening writer {} for window {} pane {} destination {}", new Object[]{uuid, window, paneInfo, destination});
                    writer = WriteFiles.this.writeOperation.createWriter();
                    writer.setDestination(destination);
                    writer.open(uuid);
                    this.writers.put(key, writer);
                    LOG.debug("Done opening writer");
                } else {
                    this.spilledShardNum = this.spilledShardNum == -1 ? ThreadLocalRandom.current().nextInt(10) : (this.spilledShardNum + 1) % 10;
                    c.output(this.unwrittenRecordsTag, KV.of(org.apache.beam.sdk.values.ShardedKey.of(WriteFiles.hashDestination(destination, this.destinationCoder), this.spilledShardNum), c.element()));
                    return;
                }
            }
            WriteFiles.writeOrClose(writer, WriteFiles.this.getDynamicDestinations().formatRecord(c.element()));
        }

        @DoFn.FinishBundle
        public void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            for (Map.Entry entry : this.writers.entrySet()) {
                WriterKey key = entry.getKey();
                FileBasedSink.Writer writer = entry.getValue();
                try {
                    writer.close();
                }
                catch (Exception e) {
                    writer.cleanup();
                    throw e;
                }
                BoundedWindow window = key.window;
                c.output(new FileBasedSink.FileResult<Object>(writer.getOutputFile(), -1, window, key.paneInfo, key.destination), window.maxTimestamp(), window);
            }
        }
    }

    private class WriteUnshardedBundlesToTempFiles
    extends PTransform<PCollection<UserT>, PCollection<FileBasedSink.FileResult<DestinationT>>> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT>> fileResultCoder;

        private WriteUnshardedBundlesToTempFiles(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized DestinationT> destinationCoder, Coder<FileBasedSink.FileResult<DestinationT>> fileResultCoder) {
            this.destinationCoder = destinationCoder;
            this.fileResultCoder = fileResultCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized FileBasedSink.FileResult<DestinationT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<UserT> input) {
            if (WriteFiles.this.getMaxNumWritersPerBundle() < 0) {
                return ((PCollection)input.apply("WritedUnshardedBundles", ParDo.of(new WriteUnshardedTempFilesFn(null, this.destinationCoder)).withSideInputs(WriteFiles.this.getSideInputs()))).setCoder(this.fileResultCoder);
            }
            TupleTag writtenRecordsTag = new TupleTag("writtenRecords");
            TupleTag unwrittenRecordsTag = new TupleTag("unwrittenRecords");
            PCollectionTuple writeTuple = (PCollectionTuple)input.apply("WriteUnshardedBundles", ParDo.of(new WriteUnshardedTempFilesFn(unwrittenRecordsTag, this.destinationCoder)).withSideInputs(WriteFiles.this.getSideInputs()).withOutputTags(writtenRecordsTag, TupleTagList.of(unwrittenRecordsTag)));
            PCollection writtenBundleFiles = writeTuple.get(writtenRecordsTag).setCoder(this.fileResultCoder);
            PCollection writtenSpilledFiles = ((PCollection)((PCollection)((PCollection)writeTuple.get(unwrittenRecordsTag).setCoder(KvCoder.of(ShardedKeyCoder.of(VarIntCoder.of()), input.getCoder())).apply("GroupUnwritten", GroupByKey.create())).apply("WriteUnwritten", ParDo.of(new WriteShardsIntoTempFilesFn()).withSideInputs(WriteFiles.this.getSideInputs()))).setCoder(this.fileResultCoder).apply("DropShardNum", ParDo.of(new DoFn<FileBasedSink.FileResult<DestinationT>, FileBasedSink.FileResult<DestinationT>>(){

                @DoFn.ProcessElement
                public void process(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    c.output(((FileBasedSink.FileResult)c.element()).withShard(-1));
                }
            }))).setCoder(this.fileResultCoder);
            return ((PCollection)PCollectionList.of(writtenBundleFiles).and(writtenSpilledFiles).apply(Flatten.pCollections())).setCoder(this.fileResultCoder);
        }
    }

    private class GatherResults<@UnknownKeyFor ResultT>
    extends PTransform<PCollection<ResultT>, PCollection<List<ResultT>>> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<ResultT> resultCoder;

        private GatherResults(Coder<ResultT> resultCoder) {
            this.resultCoder = resultCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized List<ResultT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<ResultT> input) {
            if (WriteFiles.this.getWindowedWrites()) {
                return (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)input.apply("Add void key", WithKeys.of((Void)null))).apply("Reshuffle", Reshuffle.of())).apply("Drop key", Values.create())).apply("Gather bundles", ParDo.of(new GatherBundlesPerWindowFn()))).setCoder(ListCoder.of(this.resultCoder)).apply(Reshuffle.viaRandomKey());
            }
            return input.getPipeline().apply(Reify.viewInGlobalWindow((PCollectionView)input.apply(View.asList()), ListCoder.of(this.resultCoder)));
        }
    }

    @AutoValue.Builder
    static abstract class Builder<@UnknownKeyFor UserT, @UnknownKeyFor DestinationT, @UnknownKeyFor OutputT> {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setSink(@UnknownKeyFor @NonNull @Initialized FileBasedSink<UserT, DestinationT, OutputT> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setComputeNumShards(@Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<UserT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Integer>> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setNumShardsProvider(@Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setWindowedWrites(@UnknownKeyFor @NonNull @Initialized boolean var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setMaxNumWritersPerBundle(@UnknownKeyFor @NonNull @Initialized int var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setSkipIfEmpty(@UnknownKeyFor @NonNull @Initialized boolean var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setSideInputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<UserT, DestinationT, OutputT> setShardingFunction(@Nullable @UnknownKeyFor @Initialized ShardingFunction<UserT, DestinationT> var1);

        abstract @UnknownKeyFor @NonNull @Initialized WriteFiles<UserT, DestinationT, OutputT> build();
    }
}

