/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.OffsetBasedSource;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public abstract class BlockBasedSource<@UnknownKeyFor T>
extends FileBasedSource<T> {
    public BlockBasedSource(@UnknownKeyFor @NonNull @Initialized String fileOrPatternSpec, @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment, @UnknownKeyFor @NonNull @Initialized long minBundleSize) {
        this(ValueProvider.StaticValueProvider.of(fileOrPatternSpec), emptyMatchTreatment, minBundleSize);
    }

    public BlockBasedSource(@UnknownKeyFor @NonNull @Initialized String fileOrPatternSpec, @UnknownKeyFor @NonNull @Initialized long minBundleSize) {
        this(ValueProvider.StaticValueProvider.of(fileOrPatternSpec), minBundleSize);
    }

    public BlockBasedSource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fileOrPatternSpec, @UnknownKeyFor @NonNull @Initialized long minBundleSize) {
        this(fileOrPatternSpec, EmptyMatchTreatment.DISALLOW, minBundleSize);
    }

    public BlockBasedSource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fileOrPatternSpec, @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment, @UnknownKeyFor @NonNull @Initialized long minBundleSize) {
        super(fileOrPatternSpec, emptyMatchTreatment, minBundleSize);
    }

    public BlockBasedSource( @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long minBundleSize, @UnknownKeyFor @NonNull @Initialized long startOffset, @UnknownKeyFor @NonNull @Initialized long endOffset) {
        super(metadata, minBundleSize, startOffset, endOffset);
    }

    @Override
    protected abstract @UnknownKeyFor @NonNull @Initialized BlockBasedSource<T> createForSubrangeOfFile( @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata var1, @UnknownKeyFor @NonNull @Initialized long var2, @UnknownKeyFor @NonNull @Initialized long var4);

    @Override
    protected abstract @UnknownKeyFor @NonNull @Initialized BlockBasedReader<T> createSingleFileReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions var1);

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    public static abstract class BlockBasedReader<@UnknownKeyFor T>
    extends FileBasedSource.FileBasedReader<T> {
        private @UnknownKeyFor @NonNull @Initialized boolean atSplitPoint;

        protected BlockBasedReader(@UnknownKeyFor @NonNull @Initialized BlockBasedSource<T> source) {
            super(source);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized boolean readNextBlock() throws @UnknownKeyFor @NonNull @Initialized IOException;

        public abstract @Nullable @UnknownKeyFor @Initialized Block<T> getCurrentBlock();

        public abstract @UnknownKeyFor @NonNull @Initialized long getCurrentBlockSize();

        public abstract @UnknownKeyFor @NonNull @Initialized long getCurrentBlockOffset();

        @Override
        public final T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            Block<T> currentBlock = this.getCurrentBlock();
            if (currentBlock == null) {
                throw new NoSuchElementException("No block has been successfully read from " + this.getCurrentSource());
            }
            return currentBlock.getCurrentRecord();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isAtSplitPoint() {
            return this.atSplitPoint;
        }

        @Override
        protected final @UnknownKeyFor @NonNull @Initialized boolean readNextRecord() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.atSplitPoint = false;
            while (this.getCurrentBlock() == null || !this.getCurrentBlock().readNextRecord()) {
                if (!this.readNextBlock()) {
                    return false;
                }
                this.atSplitPoint = true;
            }
            return true;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Double getFractionConsumed() {
            if (!this.isStarted()) {
                return 0.0;
            }
            if (this.isDone()) {
                return 1.0;
            }
            OffsetBasedSource source = this.getCurrentSource();
            if (source.getEndOffset() == Long.MAX_VALUE) {
                return null;
            }
            long currentBlockOffset = this.getCurrentBlockOffset();
            long startOffset = source.getStartOffset();
            long endOffset = source.getEndOffset();
            double fractionAtBlockStart = (double)(currentBlockOffset - startOffset) / (double)(endOffset - startOffset);
            double fractionAtBlockEnd = (double)(currentBlockOffset + this.getCurrentBlockSize() - startOffset) / (double)(endOffset - startOffset);
            double blockFraction = this.getCurrentBlock().getFractionOfBlockConsumed();
            return Math.min(1.0, fractionAtBlockStart + blockFraction * (fractionAtBlockEnd - fractionAtBlockStart));
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized long getCurrentOffset() {
            return this.getCurrentBlockOffset();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    protected static abstract class Block<@UnknownKeyFor T> {
        protected Block() {
        }

        public abstract T getCurrentRecord();

        public abstract @UnknownKeyFor @NonNull @Initialized boolean readNextRecord() throws @UnknownKeyFor @NonNull @Initialized IOException;

        public abstract @UnknownKeyFor @NonNull @Initialized double getFractionOfBlockConsumed();
    }
}

