/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.accessoutput;

import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TableBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.accessoutput.AccessOutputData;
import org.apache.hop.pipeline.transforms.accessoutput.AccessOutputMeta;

public class AccessOutput
extends BaseTransform<AccessOutputMeta, AccessOutputData> {
    private static final Class<?> PKG = AccessOutput.class;

    public AccessOutput(TransformMeta transformMeta, AccessOutputMeta meta, AccessOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first && ((AccessOutputMeta)this.meta).isWaitFirstRowToCreateFile()) {
            try {
                if (!this.openFile()) {
                    return false;
                }
            }
            catch (Exception e) {
                this.logError("An error occurred intialising this transformation: " + e.getMessage());
                this.stopAll();
                this.setErrors(1L);
            }
        }
        try {
            this.writeToTable(row);
            this.putRow(((AccessOutputData)this.data).outputRowMeta, row);
            if (this.checkFeedback(this.getLinesOutput()) && this.log.isBasic()) {
                this.logBasic("linenr " + this.getLinesOutput());
            }
        }
        catch (HopException e) {
            this.logError("Because of an error, this transformation can't continue: " + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean writeToTable(Object[] row) throws HopValueException {
        block10: {
            if (row == null) {
                if (!this.log.isDetailed()) return false;
                this.logDetailed("Last line inserted: stop");
                return false;
            }
            if (this.first) {
                this.first = false;
                ((AccessOutputData)this.data).outputRowMeta = this.getInputRowMeta();
                try {
                    String tableName = this.resolve(((AccessOutputMeta)this.meta).getTableName());
                    ((AccessOutputData)this.data).table = ((AccessOutputData)this.data).db.getTable(tableName);
                    if (((AccessOutputData)this.data).table == null) {
                        if (!((AccessOutputMeta)this.meta).isCreateTable()) {
                            this.logError(BaseMessages.getString(PKG, (String)"AccessOutput.Error.TableDoesNotExist", (String[])new String[]{tableName}));
                            this.setErrors(1L);
                            this.stopAll();
                            return false;
                        }
                        List<ColumnBuilder> columns = this.prepareTableColumns(((AccessOutputData)this.data).outputRowMeta);
                        ((AccessOutputData)this.data).table = new TableBuilder(tableName).addColumns(columns).toTable(((AccessOutputData)this.data).db);
                        break block10;
                    }
                    if (((AccessOutputMeta)this.meta).isTruncateTable()) {
                        this.truncateTable();
                    }
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"AccessOutput.Exception.UnexpectedErrorCreatingTable", (String[])new String[]{e.toString()}));
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
        }
        Object[] values = this.createRowValues(((AccessOutputData)this.data).outputRowMeta, row);
        try {
            ((AccessOutputData)this.data).rows.add(values);
            if (((AccessOutputMeta)this.meta).getCommitSize() > 0) {
                if (((AccessOutputData)this.data).rows.size() < ((AccessOutputMeta)this.meta).getCommitSize()) return true;
                ((AccessOutputData)this.data).table.addRows(((AccessOutputData)this.data).rows);
                ((AccessOutputData)this.data).rows.clear();
                return true;
            }
            ((AccessOutputData)this.data).table.addRow(values);
            return true;
        }
        catch (IOException e) {
            this.logError(BaseMessages.getString(PKG, (String)"AccessOutput.Exception.UnexpectedErrorWritingRow", (String[])new String[]{((AccessOutputData)this.data).outputRowMeta.getString(row)}));
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
    }

    public boolean init() {
        if (super.init()) {
            if (!((AccessOutputMeta)this.meta).isWaitFirstRowToCreateFile()) {
                try {
                    return this.openFile();
                }
                catch (Exception e) {
                    this.logError("An error occurred intialising this transformation: " + e.getMessage());
                    this.stopAll();
                    this.setErrors(1L);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean openFile() throws Exception {
        FileObject fileObject;
        File file;
        ((AccessOutputData)this.data).oneFileOpened = true;
        String fileName = this.resolve(((AccessOutputMeta)this.meta).getFileName());
        if (this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"AccessOutput.log.WritingToFile", (String[])new String[]{fileName}));
        }
        if (!(file = FileUtils.toFile((URL)(fileObject = HopVfs.getFileObject((String)fileName)).getURL())).exists()) {
            if (!((AccessOutputMeta)this.meta).isCreateFile()) {
                this.logError(BaseMessages.getString(PKG, (String)"AccessOutput.InitError.FileDoesNotExist", (String[])new String[]{fileName}));
                return false;
            }
            ((AccessOutputData)this.data).db = DatabaseBuilder.create((Database.FileFormat)Database.FileFormat.V2000, (File)file);
        } else {
            ((AccessOutputData)this.data).db = DatabaseBuilder.open((File)file);
        }
        if (((AccessOutputMeta)this.meta).isAddToResultFile()) {
            ResultFile resultFile = new ResultFile(0, fileObject, this.getPipelineMeta().getName(), this.toString());
            resultFile.setComment("This file was created with an Microsoft Access output transformation");
            this.addResultFile(resultFile);
        }
        return true;
    }

    protected void truncateTable() throws IOException {
        if (((AccessOutputData)this.data).table == null) {
            return;
        }
        Cursor tableRows = CursorBuilder.createCursor((Table)((AccessOutputData)this.data).table);
        while (tableRows.moveToNextRow()) {
            tableRows.deleteCurrentRow();
        }
    }

    public Object[] createRowValues(IRowMeta rowMeta, Object[] rowData) throws HopValueException {
        Object[] values = new Object[rowMeta.size()];
        block9: for (int i = 0; i < rowMeta.size(); ++i) {
            IValueMeta valueMeta = rowMeta.getValueMeta(i);
            Object valueData = rowData[i];
            if (valueData == null || valueMeta == null) {
                values[i] = null;
                continue;
            }
            int length = valueMeta.getLength();
            switch (valueMeta.getType()) {
                case 5: {
                    if (length < 3) {
                        values[i] = valueMeta.getInteger(valueData).byteValue();
                        continue block9;
                    }
                    if (length < 5) {
                        values[i] = valueMeta.getInteger(valueData).shortValue();
                        continue block9;
                    }
                    values[i] = valueMeta.getInteger(valueData);
                    continue block9;
                }
                case 1: {
                    values[i] = valueMeta.getNumber(valueData);
                    continue block9;
                }
                case 3: 
                case 9: {
                    values[i] = valueMeta.getDate(valueData);
                    continue block9;
                }
                case 2: {
                    values[i] = valueMeta.getString(valueData);
                    continue block9;
                }
                case 8: {
                    values[i] = valueMeta.getBinary(valueData);
                    continue block9;
                }
                case 4: {
                    values[i] = valueMeta.getBoolean(valueData);
                    continue block9;
                }
                case 6: {
                    values[i] = valueMeta.getNumber(valueData);
                    continue block9;
                }
            }
        }
        return values;
    }

    public List<ColumnBuilder> prepareTableColumns(IRowMeta row) {
        ArrayList<ColumnBuilder> list = new ArrayList<ColumnBuilder>();
        for (int i = 0; i < row.size(); ++i) {
            IValueMeta valueMeta = row.getValueMeta(i);
            ColumnBuilder column = new ColumnBuilder(valueMeta.getName());
            int length = valueMeta.getLength();
            switch (valueMeta.getType()) {
                case 5: {
                    if (length < 3) {
                        column.setType(DataType.BYTE);
                        column.setLength(DataType.BYTE.getFixedSize());
                        break;
                    }
                    if (length < 5) {
                        column.setType(DataType.INT);
                        column.setLength(DataType.INT.getFixedSize());
                        break;
                    }
                    column.setType(DataType.LONG);
                    column.setLength(DataType.LONG.getFixedSize());
                    break;
                }
                case 1: {
                    column.setType(DataType.DOUBLE);
                    column.setLength(DataType.DOUBLE.getFixedSize());
                    break;
                }
                case 3: 
                case 9: {
                    column.setType(DataType.SHORT_DATE_TIME);
                    column.setLength(DataType.SHORT_DATE_TIME.getFixedSize());
                    break;
                }
                case 2: {
                    if (length < 255) {
                        column.setType(DataType.TEXT);
                        column.setLength(DataType.TEXT.getUnitSize());
                        break;
                    }
                    column.setType(DataType.MEMO);
                    column.setLength(DataType.MEMO.getUnitSize());
                    break;
                }
                case 8: {
                    column.setType(DataType.BINARY);
                    break;
                }
                case 4: {
                    column.setType(DataType.BOOLEAN);
                    column.setLength(DataType.BOOLEAN.getFixedSize());
                    break;
                }
                case 6: {
                    column.setType(DataType.NUMERIC);
                    column.setLength(DataType.NUMERIC.getFixedSize());
                    break;
                }
            }
            if (valueMeta.getPrecision() >= 1 && valueMeta.getPrecision() <= 28) {
                column.setPrecision((int)((byte)valueMeta.getPrecision()));
            }
            list.add(column);
        }
        return list;
    }

    public void dispose() {
        if (((AccessOutputData)this.data).oneFileOpened) {
            try {
                if (((AccessOutputData)this.data).table != null) {
                    ((AccessOutputData)this.data).table.addRows(((AccessOutputData)this.data).rows);
                }
                ((AccessOutputData)this.data).rows.clear();
                if (((AccessOutputData)this.data).db != null) {
                    ((AccessOutputData)this.data).db.close();
                    ((AccessOutputData)this.data).db = null;
                }
            }
            catch (IOException e) {
                this.logError("Error closing the database: " + e.toString());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        super.dispose();
    }
}

