/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.metrics;

import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.AccumulatorV2;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAccumulator
extends AccumulatorV2<MetricsContainerStepMap, MetricsContainerStepMap> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MetricsAccumulator.class);
    private static final @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap EMPTY = new SparkMetricsContainerStepMap();
    private static final @UnknownKeyFor @NonNull @Initialized String ACCUMULATOR_NAME = "Beam.Metrics";
    private static volatile @Nullable @UnknownKeyFor @Initialized MetricsAccumulator instance = null;
    private @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap value;

    public MetricsAccumulator() {
        this.value = new SparkMetricsContainerStepMap();
    }

    private MetricsAccumulator(@UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap value) {
        this.value = value;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isZero() {
        return this.value.equals((Object)EMPTY);
    }

    public @UnknownKeyFor @NonNull @Initialized MetricsAccumulator copy() {
        SparkMetricsContainerStepMap newContainer = new SparkMetricsContainerStepMap();
        newContainer.updateAll(this.value);
        return new MetricsAccumulator(newContainer);
    }

    public void reset() {
        this.value = new SparkMetricsContainerStepMap();
    }

    public void add(@UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap other) {
        this.value.updateAll(other);
    }

    public void merge(@UnknownKeyFor @NonNull @Initialized AccumulatorV2<@UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap, @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap> other) {
        this.value.updateAll((MetricsContainerStepMap)other.value());
    }

    public @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap value() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @UnknownKeyFor @NonNull @Initialized MetricsAccumulator getInstance(@UnknownKeyFor @NonNull @Initialized SparkSession session) {
        MetricsAccumulator current = instance;
        if (current != null) {
            return current;
        }
        Class<MetricsAccumulator> clazz = MetricsAccumulator.class;
        synchronized (MetricsAccumulator.class) {
            MetricsAccumulator accumulator = instance;
            if (accumulator == null) {
                accumulator = new MetricsAccumulator();
                session.sparkContext().register((AccumulatorV2)accumulator, ACCUMULATOR_NAME);
                instance = accumulator;
                LOG.info("Instantiated metrics accumulator: {}", (Object)instance.value());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return accumulator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clear() {
        Class<MetricsAccumulator> clazz = MetricsAccumulator.class;
        synchronized (MetricsAccumulator.class) {
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class SparkMetricsContainerStepMap
    extends MetricsContainerStepMap {
        private SparkMetricsContainerStepMap() {
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return SparkMetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)this).toString();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            return super.equals(o);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return super.hashCode();
        }
    }
}

