/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.ftp;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.actions.util.FtpClientUtil;
import org.apache.hop.workflow.actions.util.IFtpConnection;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

@Action(id="FTP", name="i18n::ActionFTP.Name", description="i18n::ActionFTP.Description", image="FTP.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileTransfer", keywords={"i18n::ActionFtp.keyword"}, documentationUrl="/workflow/actions/ftp.html")
public class ActionFtp
extends ActionBase
implements Cloneable,
IAction,
IFtpConnection {
    private static final Class<?> PKG = ActionFtp.class;
    private String serverName = null;
    private String userName;
    private String password;
    private String remoteDirectory;
    private String targetDirectory;
    private String wildcard;
    private boolean binaryMode;
    private int timeout;
    private boolean remove;
    private boolean onlyGettingNewFiles;
    private boolean activeConnection;
    private String controlEncoding;
    private static String LEGACY_CONTROL_ENCODING = "US-ASCII";
    private static String DEFAULT_CONTROL_ENCODING = "ISO-8859-1";
    private boolean moveFiles = false;
    private String moveToDirectory = null;
    private boolean addDate = false;
    private boolean addTime = false;
    private boolean specifyFormat = false;
    private String dateTimeFormat;
    private boolean addDateBeforeExtension = false;
    private boolean isAddResult = true;
    private boolean createMoveFolder = false;
    private String serverPort = "21";
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String socksProxyHost;
    private String socksProxyPort = "1080";
    private String socksProxyUsername;
    private String socksProxyPassword;
    public int ifFileExistsSkip = 0;
    public static final String STRING_IF_FILE_EXISTS_SKIP = "ifFileExistsSkip";
    public int ifFileExistsCreateUniq = 1;
    public static final String STRING_IF_FILE_EXISTS_CREATE_UNIQ = "ifFileExistsCreateUniq";
    public int ifFileExistsFail = 2;
    public static final String STRING_IF_FILE_EXISTS_FAIL = "ifFileExistsFail";
    public int ifFileExists;
    public String stringIfFileExists = "ifFileExistsSkip";
    public String SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private String nrLimit = "10";
    private String successCondition = this.SUCCESS_IF_NO_ERRORS;
    long nrErrors = 0L;
    long nrFilesRetrieved = 0L;
    boolean successConditionBroken = false;
    int limitFiles = 0;
    String targetFilename = null;
    static String FILE_SEPARATOR = "/";

    public ActionFtp(String n) {
        super(n, "");
        this.ifFileExists = this.ifFileExistsSkip;
        this.setControlEncoding(DEFAULT_CONTROL_ENCODING);
    }

    public ActionFtp() {
        this("");
    }

    public Object clone() {
        ActionFtp je = (ActionFtp)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(650);
        xml.append(super.getXml());
        xml.append("      ").append(XmlHandler.addTagValue((String)"port", (String)this.serverPort));
        xml.append("      ").append(XmlHandler.addTagValue((String)"servername", (String)this.serverName));
        xml.append("      ").append(XmlHandler.addTagValue((String)"username", (String)this.userName));
        xml.append("      ").append(XmlHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        xml.append("      ").append(XmlHandler.addTagValue((String)"ftpdirectory", (String)this.remoteDirectory));
        xml.append("      ").append(XmlHandler.addTagValue((String)"targetdirectory", (String)this.targetDirectory));
        xml.append("      ").append(XmlHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        xml.append("      ").append(XmlHandler.addTagValue((String)"binary", (boolean)this.binaryMode));
        xml.append("      ").append(XmlHandler.addTagValue((String)"timeout", (int)this.timeout));
        xml.append("      ").append(XmlHandler.addTagValue((String)"remove", (boolean)this.remove));
        xml.append("      ").append(XmlHandler.addTagValue((String)"only_new", (boolean)this.onlyGettingNewFiles));
        xml.append("      ").append(XmlHandler.addTagValue((String)"active", (boolean)this.activeConnection));
        xml.append("      ").append(XmlHandler.addTagValue((String)"control_encoding", (String)this.controlEncoding));
        xml.append("      ").append(XmlHandler.addTagValue((String)"movefiles", (boolean)this.moveFiles));
        xml.append("      ").append(XmlHandler.addTagValue((String)"movetodirectory", (String)this.moveToDirectory));
        xml.append("      ").append(XmlHandler.addTagValue((String)"adddate", (boolean)this.addDate));
        xml.append("      ").append(XmlHandler.addTagValue((String)"addtime", (boolean)this.addTime));
        xml.append("      ").append(XmlHandler.addTagValue((String)"SpecifyFormat", (boolean)this.specifyFormat));
        xml.append("      ").append(XmlHandler.addTagValue((String)"date_time_format", (String)this.dateTimeFormat));
        xml.append("      ").append(XmlHandler.addTagValue((String)"AddDateBeforeExtension", (boolean)this.addDateBeforeExtension));
        xml.append("      ").append(XmlHandler.addTagValue((String)"isaddresult", (boolean)this.isAddResult));
        xml.append("      ").append(XmlHandler.addTagValue((String)"createmovefolder", (boolean)this.createMoveFolder));
        xml.append("      ").append(XmlHandler.addTagValue((String)"proxy_host", (String)this.proxyHost));
        xml.append("      ").append(XmlHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        xml.append("      ").append(XmlHandler.addTagValue((String)"proxy_username", (String)this.proxyUsername));
        xml.append("      ").append(XmlHandler.addTagValue((String)"proxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        xml.append("      ").append(XmlHandler.addTagValue((String)"socksproxy_host", (String)this.socksProxyHost));
        xml.append("      ").append(XmlHandler.addTagValue((String)"socksproxy_port", (String)this.socksProxyPort));
        xml.append("      ").append(XmlHandler.addTagValue((String)"socksproxy_username", (String)this.socksProxyUsername));
        xml.append("      ").append(XmlHandler.addTagValue((String)"socksproxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.socksProxyPassword)));
        xml.append("      ").append(XmlHandler.addTagValue((String)"ifFileExists", (String)this.stringIfFileExists));
        xml.append("      ").append(XmlHandler.addTagValue((String)"nr_limit", (String)this.nrLimit));
        xml.append("      ").append(XmlHandler.addTagValue((String)"success_condition", (String)this.successCondition));
        return xml.toString();
    }

    public void loadXml(Node entryNode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entryNode);
            this.serverPort = XmlHandler.getTagValue((Node)entryNode, (String)"port");
            this.serverName = XmlHandler.getTagValue((Node)entryNode, (String)"servername");
            this.userName = XmlHandler.getTagValue((Node)entryNode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entryNode, (String)"password"));
            this.remoteDirectory = XmlHandler.getTagValue((Node)entryNode, (String)"ftpdirectory");
            this.targetDirectory = XmlHandler.getTagValue((Node)entryNode, (String)"targetdirectory");
            this.wildcard = XmlHandler.getTagValue((Node)entryNode, (String)"wildcard");
            this.binaryMode = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entryNode, (String)"binary"));
            this.timeout = Const.toInt((String)XmlHandler.getTagValue((Node)entryNode, (String)"timeout"), (int)10000);
            this.remove = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entryNode, (String)"remove"));
            this.onlyGettingNewFiles = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entryNode, (String)"only_new"));
            this.activeConnection = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entryNode, (String)"active"));
            this.controlEncoding = XmlHandler.getTagValue((Node)entryNode, (String)"control_encoding");
            if (this.controlEncoding == null) {
                this.controlEncoding = LEGACY_CONTROL_ENCODING;
            }
            this.moveFiles = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entryNode, (String)"movefiles"));
            this.moveToDirectory = XmlHandler.getTagValue((Node)entryNode, (String)"movetodirectory");
            this.addDate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entryNode, (String)"adddate"));
            this.addTime = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entryNode, (String)"addtime"));
            this.specifyFormat = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entryNode, (String)"SpecifyFormat"));
            this.dateTimeFormat = XmlHandler.getTagValue((Node)entryNode, (String)"date_time_format");
            this.addDateBeforeExtension = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entryNode, (String)"AddDateBeforeExtension"));
            String addresult = XmlHandler.getTagValue((Node)entryNode, (String)"isaddresult");
            this.isAddResult = Utils.isEmpty((CharSequence)addresult) ? true : "Y".equalsIgnoreCase(addresult);
            this.createMoveFolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entryNode, (String)"createmovefolder"));
            this.proxyHost = XmlHandler.getTagValue((Node)entryNode, (String)"proxy_host");
            this.proxyPort = XmlHandler.getTagValue((Node)entryNode, (String)"proxy_port");
            this.proxyUsername = XmlHandler.getTagValue((Node)entryNode, (String)"proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entryNode, (String)"proxy_password"));
            this.socksProxyHost = XmlHandler.getTagValue((Node)entryNode, (String)"socksproxy_host");
            this.socksProxyPort = XmlHandler.getTagValue((Node)entryNode, (String)"socksproxy_port");
            this.socksProxyUsername = XmlHandler.getTagValue((Node)entryNode, (String)"socksproxy_username");
            this.socksProxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entryNode, (String)"socksproxy_password"));
            this.stringIfFileExists = XmlHandler.getTagValue((Node)entryNode, (String)"ifFileExists");
            this.ifFileExists = Utils.isEmpty((CharSequence)this.stringIfFileExists) ? this.ifFileExistsSkip : (this.stringIfFileExists.equals(STRING_IF_FILE_EXISTS_CREATE_UNIQ) ? this.ifFileExistsCreateUniq : (this.stringIfFileExists.equals(STRING_IF_FILE_EXISTS_FAIL) ? this.ifFileExistsFail : this.ifFileExistsSkip));
            this.nrLimit = XmlHandler.getTagValue((Node)entryNode, (String)"nr_limit");
            this.successCondition = Const.NVL((String)XmlHandler.getTagValue((Node)entryNode, (String)"success_condition"), (String)this.SUCCESS_IF_NO_ERRORS);
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'ftp' from XML node", (Throwable)xe);
        }
    }

    protected InetAddress getInetAddress(String realServername) throws UnknownHostException {
        return InetAddress.getByName(realServername);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result execute(Result previousResult, int nr) {
        boolean exitaction;
        Result result;
        block43: {
            FTPClient ftpClient;
            block41: {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"ActionFTP.Started", (String[])new String[]{this.serverName}));
                result = previousResult;
                result.setNrErrors(1L);
                result.setResult(false);
                this.nrErrors = 0L;
                this.nrFilesRetrieved = 0L;
                this.successConditionBroken = false;
                exitaction = false;
                this.limitFiles = Const.toInt((String)this.resolve(this.getNrLimit()), (int)10);
                if (this.moveFiles && Utils.isEmpty((CharSequence)this.moveToDirectory)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionFTP.MoveToFolderEmpty", (String[])new String[0]));
                    return result;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.Start", (String[])new String[0]));
                }
                ftpClient = null;
                String realMoveToFolder = null;
                ftpClient = FtpClientUtil.connectAndLogin(this.log, (IVariables)this, this, this.getName());
                if (!Utils.isEmpty((CharSequence)this.remoteDirectory)) {
                    String realFtpDirectory = this.resolve(this.remoteDirectory);
                    realFtpDirectory = this.normalizePath(realFtpDirectory);
                    ftpClient.changeWorkingDirectory(realFtpDirectory);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.ChangedDir", (String[])new String[]{realFtpDirectory}));
                    }
                }
                if (this.moveFiles && !Utils.isEmpty((CharSequence)this.moveToDirectory)) {
                    realMoveToFolder = this.resolve(this.moveToDirectory);
                    realMoveToFolder = this.normalizePath(realMoveToFolder);
                    boolean folderExist = true;
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.CheckMoveToFolder", (String[])new String[]{realMoveToFolder}));
                    }
                    String originalLocation = ftpClient.printWorkingDirectory();
                    try {
                        ftpClient.changeWorkingDirectory(realMoveToFolder);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.CheckMoveToFolderSwitchBack", (String[])new String[]{originalLocation}));
                        }
                        ftpClient.changeWorkingDirectory(originalLocation);
                    }
                    catch (Exception e) {
                        folderExist = false;
                    }
                    if (!folderExist) {
                        if (this.createMoveFolder) {
                            ftpClient.makeDirectory(realMoveToFolder);
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.MoveToFolderCreated", (String[])new String[]{realMoveToFolder}));
                            }
                        } else {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionFTP.MoveToFolderNotExist", (String[])new String[0]));
                            exitaction = true;
                            ++this.nrErrors;
                        }
                    }
                }
                if (!exitaction) {
                    String translatedWildcard;
                    FTPFile[] ftpFiles = ftpClient.listFiles();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.FoundNFiles", (String[])new String[]{String.valueOf(ftpFiles.length)}));
                    }
                    if (ftpFiles.length == 1 && !Utils.isEmpty((CharSequence)(translatedWildcard = this.resolve(this.wildcard))) && ftpFiles[0].getName().startsWith(translatedWildcard)) {
                        throw new HopException(ftpFiles[0].getName());
                    }
                    Pattern pattern = null;
                    if (!Utils.isEmpty((CharSequence)this.wildcard)) {
                        String realWildcard = this.resolve(this.wildcard);
                        pattern = Pattern.compile(realWildcard);
                    }
                    if (!this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS)) {
                        this.limitFiles = Const.toInt((String)this.resolve(this.getNrLimit()), (int)10);
                    }
                    for (FTPFile ftpFile : ftpFiles) {
                        if (this.parentWorkflow.isStopped()) {
                            exitaction = true;
                            throw new Exception(BaseMessages.getString(PKG, (String)"ActionFTP.WorkflowStopped", (String[])new String[0]));
                        }
                        if (this.successConditionBroken) {
                            throw new Exception(BaseMessages.getString(PKG, (String)"ActionFTP.SuccesConditionBroken", (String[])new String[]{"" + this.nrErrors}));
                        }
                        boolean getIt = true;
                        String filename = ftpFile.getName();
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionFTP.AnalysingFile", (String[])new String[]{filename}));
                        }
                        if (ftpFile.isDirectory()) {
                            getIt = false;
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"ActionFTP.SkippingNotAFile", (String[])new String[]{filename}));
                            }
                        }
                        if (!getIt) continue;
                        try {
                            if (pattern != null) {
                                Matcher matcher = pattern.matcher(filename);
                                getIt = matcher.matches();
                            }
                            if (!getIt) continue;
                            this.downloadFile(ftpClient, filename, realMoveToFolder, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result);
                        }
                        catch (Exception e) {
                            this.updateErrors();
                            this.logError(BaseMessages.getString(PKG, (String)"ActionFtp.UnexpectedError", (String[])new String[]{e.toString()}));
                        }
                    }
                }
                if (ftpClient == null) break block41;
                try {
                    ftpClient.quit();
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionFTP.ErrorQuitting", (String[])new String[]{e.getMessage()}));
                }
            }
            FtpClientUtil.clearSocksJvmSettings();
            break block43;
            catch (Exception e) {
                block42: {
                    try {
                        if (!this.successConditionBroken && !exitaction) {
                            this.updateErrors();
                        }
                        this.logError(BaseMessages.getString(PKG, (String)"ActionFTP.ErrorGetting", (String[])new String[]{e.getMessage()}));
                        if (ftpClient == null) break block42;
                    }
                    catch (Throwable throwable) {
                        if (ftpClient != null) {
                            try {
                                ftpClient.quit();
                            }
                            catch (Exception e2) {
                                this.logError(BaseMessages.getString(PKG, (String)"ActionFTP.ErrorQuitting", (String[])new String[]{e2.getMessage()}));
                            }
                        }
                        FtpClientUtil.clearSocksJvmSettings();
                        throw throwable;
                    }
                    try {
                        ftpClient.quit();
                    }
                    catch (Exception e3) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionFTP.ErrorQuitting", (String[])new String[]{e3.getMessage()}));
                    }
                }
                FtpClientUtil.clearSocksJvmSettings();
            }
        }
        result.setNrErrors(this.nrErrors);
        result.setNrFilesRetrieved(this.nrFilesRetrieved);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        if (exitaction) {
            result.setResult(false);
        }
        this.displayResults();
        return result;
    }

    private void downloadFile(FTPClient ftpclient, String filename, String realMoveToFolder, IWorkflowEngine<WorkflowMeta> parentWorkflow, Result result) throws Exception {
        String localFilename = filename;
        this.targetFilename = HopVfs.getFilename((FileObject)HopVfs.getFileObject((String)this.returnTargetFilename(localFilename)));
        if (!this.onlyGettingNewFiles || this.onlyGettingNewFiles && this.needsDownload(this.targetFilename)) {
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.GettingFile", (String[])new String[]{filename, this.resolve(this.targetDirectory)}));
            }
            try (OutputStream outputStream = HopVfs.getOutputStream((String)this.targetFilename, (boolean)false);){
                ftpclient.retrieveFile(filename, outputStream);
            }
            this.updateRetrievedFiles();
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.GotFile", (String[])new String[]{filename}));
            }
            this.addFilenameToResultFilenames(result, parentWorkflow, this.targetFilename);
            if (this.remove) {
                ftpclient.deleteFile(filename);
                if (this.isDetailed() && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.DeletedFile", (String[])new String[]{filename}));
                }
            } else if (this.moveFiles) {
                ftpclient.rename(filename, realMoveToFolder + FILE_SEPARATOR + filename);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.MovedFile", (String[])new String[]{filename, realMoveToFolder}));
                }
            }
        }
    }

    public String normalizePath(String path) throws Exception {
        String normalizedPath = path.replaceAll("\\\\", FILE_SEPARATOR);
        while (normalizedPath.endsWith("\\") || normalizedPath.endsWith(FILE_SEPARATOR)) {
            normalizedPath = normalizedPath.substring(0, normalizedPath.length() - 1);
        }
        return normalizedPath;
    }

    private void addFilenameToResultFilenames(Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow, String filename) throws HopException {
        if (this.isAddResult) {
            FileObject targetFile = null;
            try {
                targetFile = HopVfs.getFileObject((String)filename);
                ResultFile resultFile = new ResultFile(0, targetFile, parentWorkflow.getWorkflowName(), this.toString());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"ActionFTP.Downloaded", (String[])new String[]{this.serverName}));
                result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.FileAddedToResult", (String[])new String[]{filename}));
                }
            }
            catch (Exception e) {
                throw new HopException((Throwable)e);
            }
            finally {
                try {
                    targetFile.close();
                    targetFile = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    private void displayResults() {
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.Log.Info.FilesInError", (String[])new String[]{"" + this.nrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFTP.Log.Info.FilesRetrieved", (String[])new String[]{"" + this.nrFilesRetrieved}));
            this.logDetailed("=======================================");
        }
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.nrErrors == 0L && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.nrFilesRetrieved >= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED) || this.nrErrors <= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateErrors() {
        ++this.nrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.nrErrors > 0L && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.nrErrors >= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateRetrievedFiles() {
        ++this.nrFilesRetrieved;
    }

    @VisibleForTesting
    String returnTargetFilename(String filename) {
        Object retval = null;
        if (filename == null) {
            return null;
        }
        retval = filename;
        int lenstring = ((String)retval).length();
        int lastindexOfDot = ((String)retval).lastIndexOf(".");
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        String fileExtension = ((String)retval).substring(lastindexOfDot, lenstring);
        if (this.isAddDateBeforeExtension()) {
            retval = ((String)retval).substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.specifyFormat && !Utils.isEmpty((CharSequence)this.dateTimeFormat)) {
            daf.applyPattern(this.dateTimeFormat);
            String dt = daf.format(now);
            retval = (String)retval + dt;
        } else {
            if (this.addDate) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = (String)retval + "_" + d;
            }
            if (this.addTime) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                retval = (String)retval + "_" + t;
            }
        }
        if (this.isAddDateBeforeExtension()) {
            retval = (String)retval + fileExtension;
        }
        retval = this.resolve(this.targetDirectory) + Const.FILE_SEPARATOR + (String)retval;
        return retval;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    protected boolean needsDownload(String filename) {
        boolean retval = false;
        File file = new File(filename);
        if (!file.exists()) {
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionFTP.LocalFileNotExists", (String[])new String[0]), new Object[]{filename});
            }
            return true;
        }
        if (this.ifFileExists == this.ifFileExistsCreateUniq) {
            if (this.isDebug()) {
                this.logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ActionFTP.LocalFileExists", (String[])new String[0]), filename});
            }
            int lenstring = this.targetFilename.length();
            int lastindexOfDot = this.targetFilename.lastIndexOf(46);
            if (lastindexOfDot == -1) {
                lastindexOfDot = lenstring;
            }
            this.targetFilename = this.targetFilename.substring(0, lastindexOfDot) + StringUtil.getFormattedDateTimeNow((boolean)true) + this.targetFilename.substring(lastindexOfDot, lenstring);
            return true;
        }
        if (this.ifFileExists == this.ifFileExistsFail) {
            this.log.logError(BaseMessages.getString(PKG, (String)"ActionFTP.LocalFileExists", (String[])new String[0]), new Object[]{filename});
            this.updateErrors();
        } else if (this.isDebug()) {
            this.logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ActionFTP.LocalFileExists", (String[])new String[0]), filename});
        }
        return retval;
    }

    @Override
    public boolean isActiveConnection() {
        return this.activeConnection;
    }

    public void setActiveConnection(boolean activeConnection) {
        this.activeConnection = activeConnection;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "targetDirectory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "userName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "password", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.serverName)) {
            String realServername = this.resolve(this.serverName);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectory = remoteDirectory;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    @Override
    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean isOnlyGettingNewFiles() {
        return this.onlyGettingNewFiles;
    }

    public void setOnlyGettingNewFiles(boolean onlyGettingNewFiles) {
        this.onlyGettingNewFiles = onlyGettingNewFiles;
    }

    @Override
    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String controlEncoding) {
        this.controlEncoding = controlEncoding;
    }

    public boolean isMoveFiles() {
        return this.moveFiles;
    }

    public void setMoveFiles(boolean moveFiles) {
        this.moveFiles = moveFiles;
    }

    public String getMoveToDirectory() {
        return this.moveToDirectory;
    }

    public void setMoveToDirectory(String moveToDirectory) {
        this.moveToDirectory = moveToDirectory;
    }

    public boolean isAddDate() {
        return this.addDate;
    }

    public void setAddDate(boolean addDate) {
        this.addDate = addDate;
    }

    public boolean isAddTime() {
        return this.addTime;
    }

    public void setAddTime(boolean addTime) {
        this.addTime = addTime;
    }

    public boolean isSpecifyFormat() {
        return this.specifyFormat;
    }

    public void setSpecifyFormat(boolean specifyFormat) {
        this.specifyFormat = specifyFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public boolean isAddDateBeforeExtension() {
        return this.addDateBeforeExtension;
    }

    public void setAddDateBeforeExtension(boolean addDateBeforeExtension) {
        this.addDateBeforeExtension = addDateBeforeExtension;
    }

    public boolean isAddResult() {
        return this.isAddResult;
    }

    public void setAddResult(boolean addResult) {
        this.isAddResult = addResult;
    }

    public boolean isCreateMoveFolder() {
        return this.createMoveFolder;
    }

    public void setCreateMoveFolder(boolean createMoveFolder) {
        this.createMoveFolder = createMoveFolder;
    }

    @Override
    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Override
    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @Override
    public String getSocksProxyHost() {
        return this.socksProxyHost;
    }

    public void setSocksProxyHost(String socksProxyHost) {
        this.socksProxyHost = socksProxyHost;
    }

    @Override
    public String getSocksProxyPort() {
        return this.socksProxyPort;
    }

    public void setSocksProxyPort(String socksProxyPort) {
        this.socksProxyPort = socksProxyPort;
    }

    @Override
    public String getSocksProxyUsername() {
        return this.socksProxyUsername;
    }

    public void setSocksProxyUsername(String socksProxyUsername) {
        this.socksProxyUsername = socksProxyUsername;
    }

    @Override
    public String getSocksProxyPassword() {
        return this.socksProxyPassword;
    }

    public void setSocksProxyPassword(String socksProxyPassword) {
        this.socksProxyPassword = socksProxyPassword;
    }

    public int getIfFileExistsSkip() {
        return this.ifFileExistsSkip;
    }

    public void setIfFileExistsSkip(int ifFileExistsSkip) {
        this.ifFileExistsSkip = ifFileExistsSkip;
    }

    public int getIfFileExistsCreateUniq() {
        return this.ifFileExistsCreateUniq;
    }

    public void setIfFileExistsCreateUniq(int ifFileExistsCreateUniq) {
        this.ifFileExistsCreateUniq = ifFileExistsCreateUniq;
    }

    public int getIfFileExistsFail() {
        return this.ifFileExistsFail;
    }

    public void setIfFileExistsFail(int ifFileExistsFail) {
        this.ifFileExistsFail = ifFileExistsFail;
    }

    public int getIfFileExists() {
        return this.ifFileExists;
    }

    public void setIfFileExists(int ifFileExists) {
        this.ifFileExists = ifFileExists;
    }

    public String getStringIfFileExists() {
        return this.stringIfFileExists;
    }

    public void setStringIfFileExists(String stringIfFileExists) {
        this.stringIfFileExists = stringIfFileExists;
    }

    public String getNrLimit() {
        return this.nrLimit;
    }

    public void setNrLimit(String nrLimit) {
        this.nrLimit = nrLimit;
    }

    public String getSuccessCondition() {
        return this.successCondition;
    }

    public void setSuccessCondition(String successCondition) {
        this.successCondition = successCondition;
    }

    public long getNrErrors() {
        return this.nrErrors;
    }

    public void setNrErrors(long nrErrors) {
        this.nrErrors = nrErrors;
    }

    public long getNrFilesRetrieved() {
        return this.nrFilesRetrieved;
    }

    public void setNrFilesRetrieved(long nrFilesRetrieved) {
        this.nrFilesRetrieved = nrFilesRetrieved;
    }

    public boolean isSuccessConditionBroken() {
        return this.successConditionBroken;
    }

    public void setSuccessConditionBroken(boolean successConditionBroken) {
        this.successConditionBroken = successConditionBroken;
    }

    public int getLimitFiles() {
        return this.limitFiles;
    }

    public void setLimitFiles(int limitFiles) {
        this.limitFiles = limitFiles;
    }

    public String getTargetFilename() {
        return this.targetFilename;
    }

    public void setTargetFilename(String targetFilename) {
        this.targetFilename = targetFilename;
    }
}

