/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.i18n;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.util.Assert;
import org.apache.hop.ui.i18n.BundleFile;

public class BundlesStore {
    private List<String> bundleRootFolders = new ArrayList<String>();
    private Map<String, Map<String, BundleFile>> packageLanguageBundleMap = new HashMap<String, Map<String, BundleFile>>();
    private final Map<String, List<String>> collisionPackages = new HashMap<String, List<String>>();

    public BundlesStore() {
    }

    public BundlesStore(List<String> bundleRootFolders) {
        this();
        this.bundleRootFolders = bundleRootFolders;
    }

    public BundlesStore(String rootFolder) throws HopException {
        this();
        try {
            Files.walk(Paths.get(rootFolder, new String[0]), new FileVisitOption[0]).filter(path -> Files.isDirectory(path, new LinkOption[0]) && path.endsWith("src/main/resources") && !path.toString().contains("/impl/")).forEach(path -> this.bundleRootFolders.add(path.toAbsolutePath().toFile().getPath()));
        }
        catch (IOException e) {
            throw new HopException("Error reading root folder: " + rootFolder, (Throwable)e);
        }
    }

    public void findAllMessagesBundles() throws HopException {
        try {
            for (String bundleRootFolder : this.bundleRootFolders) {
                Files.walk(Paths.get(bundleRootFolder, new String[0]), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().startsWith("messages_") && path.getFileName().toString().endsWith(".properties")).forEach(path -> this.addMessagesFile(bundleRootFolder, (Path)path));
            }
            if (!this.collisionPackages.isEmpty()) {
                String collisionFiles = this.collisionPackages.values().stream().flatMap(Collection::stream).collect(Collectors.joining("\n\t"));
                this.collisionPackages.clear();
                throw new HopFileException("Bundle file collision! We're trying to add all files to the bundle store but some files already exists in the same package. You should rename part of collision files, otherwise the package bundle will be ignored.\nList of collision file:\n\t" + collisionFiles);
            }
        }
        catch (HopFileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HopException("Error searching for messages bundles", (Throwable)e);
        }
    }

    private void addMessagesFile(String bundleRootFolder, Path messagesFilePath) throws RuntimeException {
        String messagesFileFolder = messagesFilePath.toFile().getParent();
        if (messagesFileFolder.startsWith(bundleRootFolder)) {
            String packageName = messagesFileFolder.substring(bundleRootFolder.length()).replace(File.separator, "/").replaceAll("\\/messages$", "").replaceAll("^\\/", "").replaceAll("\\/", ".");
            String locale = messagesFilePath.getFileName().toString().replaceAll("^messages_", "").replaceAll("\\.properties$", "");
            String filename = messagesFilePath.toString();
            try {
                BundleFile bundleFile = new BundleFile(filename, packageName, locale);
                this.addBundleFile(packageName, locale, bundleFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to read messages bundle file : " + filename, e);
            }
        }
    }

    public void addBundleFile(String packageName, String language, BundleFile bundleFile) {
        BundleFile existingFile;
        Map<String, BundleFile> languageBundleMap = this.packageLanguageBundleMap.get(packageName);
        if (languageBundleMap == null) {
            languageBundleMap = new HashMap<String, BundleFile>();
            this.packageLanguageBundleMap.put(packageName, languageBundleMap);
        }
        if ((existingFile = languageBundleMap.get(language)) != null || this.collisionPackages.containsKey(packageName)) {
            List<String> collisionFiles = this.collisionPackages.get(packageName);
            if (collisionFiles == null) {
                Assert.assertNotNull((Object)((Object)existingFile));
                collisionFiles = new ArrayList<String>();
                collisionFiles.add(existingFile.getFilename());
                this.collisionPackages.put(packageName, collisionFiles);
                languageBundleMap.remove(language, (Object)existingFile);
            }
            this.packageLanguageBundleMap.remove(packageName);
            collisionFiles.add(bundleFile.getFilename());
            return;
        }
        languageBundleMap.put(language, bundleFile);
    }

    public Map<String, String> findTranslations(String packageName, String key) {
        HashMap<String, String> translations = new HashMap<String, String>();
        Map<String, BundleFile> languageBundleFileMap = this.packageLanguageBundleMap.get(packageName);
        if (languageBundleFileMap != null) {
            for (String language : languageBundleFileMap.keySet()) {
                String translation = languageBundleFileMap.get(language).get(key);
                if (translation == null) continue;
                translations.put(language, translation);
            }
        }
        return translations;
    }

    public String lookupTranslation(String packageName, String locale, String key) {
        BundleFile bundleFile;
        Map<String, BundleFile> languageBundleFileMap = this.packageLanguageBundleMap.get(packageName);
        if (languageBundleFileMap != null && (bundleFile = languageBundleFileMap.get(locale)) != null) {
            return bundleFile.get(key);
        }
        return null;
    }

    public void removeTranslation(String packageName, String locale, String key) {
        BundleFile bundleFile;
        Map<String, BundleFile> languageBundleFileMap = this.packageLanguageBundleMap.get(packageName);
        if (languageBundleFileMap != null && (bundleFile = languageBundleFileMap.get(locale)) != null) {
            bundleFile.remove(key);
        }
    }

    public void addTranslation(String sourceFolder, String packageName, String locale, String key, String value) {
        BundleFile bundleFile;
        Map<String, BundleFile> languageBundleFileMap = this.packageLanguageBundleMap.get(packageName);
        if (languageBundleFileMap == null) {
            languageBundleFileMap = new HashMap<String, BundleFile>();
            this.packageLanguageBundleMap.put(packageName, languageBundleFileMap);
        }
        if ((bundleFile = languageBundleFileMap.get(locale)) == null) {
            String bundleFileName = sourceFolder.replace("java", "resources" + File.separator).concat(packageName.replace(".", File.separator)).concat(File.separator + "messages" + File.separator + "messages_" + locale + ".properties");
            bundleFile = new BundleFile(bundleFileName, packageName, locale, new HashMap<String, String>());
            languageBundleFileMap.put(locale, bundleFile);
        }
        bundleFile.put(key, value);
    }

    public List<BundleFile> getChangedBundleFiles() {
        ArrayList<BundleFile> bundleFiles = new ArrayList<BundleFile>();
        for (String packageName : this.packageLanguageBundleMap.keySet()) {
            Map<String, BundleFile> languageBundleMap = this.packageLanguageBundleMap.get(packageName);
            for (String locale : languageBundleMap.keySet()) {
                BundleFile bundleFile = languageBundleMap.get(locale);
                if (!bundleFile.hasChanged()) continue;
                bundleFiles.add(bundleFile);
            }
        }
        return bundleFiles;
    }

    public List<BundleFile> getBundleFiles(String packageName, String locale) {
        ArrayList<BundleFile> bundleFiles = new ArrayList<BundleFile>();
        for (String pckName : this.packageLanguageBundleMap.keySet()) {
            BundleFile bundleFile;
            Map<String, BundleFile> languageBundleMap;
            if (packageName != null && !packageName.equals(pckName) || (languageBundleMap = this.packageLanguageBundleMap.get(pckName)) == null || (bundleFile = languageBundleMap.get(locale)) == null) continue;
            bundleFiles.add(bundleFile);
        }
        return bundleFiles;
    }

    public BundleFile findBundleFile(String packageName, String locale) {
        Map<String, BundleFile> languageBundleMap = this.packageLanguageBundleMap.get(packageName);
        if (languageBundleMap != null) {
            return languageBundleMap.get(locale);
        }
        return null;
    }

    public List<String> getBundleRootFolders() {
        return this.bundleRootFolders;
    }

    public void setBundleRootFolders(List<String> bundleRootFolders) {
        this.bundleRootFolders = bundleRootFolders;
    }

    public Map<String, Map<String, BundleFile>> getPackageLanguageBundleMap() {
        return this.packageLanguageBundleMap;
    }

    public void setPackageLanguageBundleMap(Map<String, Map<String, BundleFile>> packageLanguageBundleMap) {
        this.packageLanguageBundleMap = packageLanguageBundleMap;
    }
}

