/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.workflow.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.plugin.IGuiRefresher;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.action.GuiActionLambdaBuilder;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.ui.hopgui.context.BaseGuiContextHandler;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.workflow.WorkflowMeta;

public class HopGuiWorkflowContext
extends BaseGuiContextHandler
implements IGuiContextHandler {
    public static final String CONTEXT_ID = "HopGuiWorkflowContext";
    private WorkflowMeta workflowMeta;
    private HopGuiWorkflowGraph workflowGraph;
    private Point click;
    private GuiActionLambdaBuilder<HopGuiWorkflowContext> lambdaBuilder;

    public HopGuiWorkflowContext(WorkflowMeta workflowMeta, HopGuiWorkflowGraph workflowGraph, Point click) {
        this.workflowMeta = workflowMeta;
        this.workflowGraph = workflowGraph;
        this.click = click;
        this.lambdaBuilder = new GuiActionLambdaBuilder();
    }

    @Override
    public String getContextId() {
        return CONTEXT_ID;
    }

    @Override
    public List<GuiAction> getSupportedActions() {
        ArrayList<GuiAction> guiActions = new ArrayList<GuiAction>();
        List<GuiAction> pluginActions = this.getPluginActions(true);
        if (pluginActions != null) {
            for (GuiAction pluginAction : pluginActions) {
                guiActions.add(this.lambdaBuilder.createLambda(pluginAction, (Object)this, (IGuiRefresher)this.workflowGraph));
            }
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        List actionPlugins = registry.getPlugins(ActionPluginType.class);
        for (IPlugin actionPlugin : actionPlugins) {
            GuiAction createActionGuiAction = new GuiAction("workflow-graph-create-workflow-action-" + actionPlugin.getIds()[0], GuiActionType.Create, actionPlugin.getName(), actionPlugin.getDescription(), actionPlugin.getImageFile(), (shiftClicked, controlClicked, t) -> this.workflowGraph.workflowActionDelegate.newAction(this.workflowMeta, actionPlugin.getIds()[0], actionPlugin.getName(), controlClicked, this.click));
            createActionGuiAction.getKeywords().addAll(Arrays.asList(actionPlugin.getKeywords()));
            createActionGuiAction.setCategory(actionPlugin.getCategory());
            createActionGuiAction.setCategoryOrder("9999_" + actionPlugin.getCategory());
            try {
                createActionGuiAction.setClassLoader(registry.getClassLoader(actionPlugin));
            }
            catch (HopPluginException e) {
                LogChannel.UI.logError("Unable to get classloader for action plugin " + actionPlugin.getIds()[0], (Throwable)e);
            }
            createActionGuiAction.getKeywords().add(actionPlugin.getCategory());
            guiActions.add(createActionGuiAction);
        }
        return guiActions;
    }

    public WorkflowMeta getWorkflowMeta() {
        return this.workflowMeta;
    }

    public void setWorkflowMeta(WorkflowMeta workflowMeta) {
        this.workflowMeta = workflowMeta;
    }

    public HopGuiWorkflowGraph getWorkflowGraph() {
        return this.workflowGraph;
    }

    public void setWorkflowGraph(HopGuiWorkflowGraph workflowGraph) {
        this.workflowGraph = workflowGraph;
    }

    public Point getClick() {
        return this.click;
    }

    public void setClick(Point click) {
        this.click = click;
    }

    public GuiActionLambdaBuilder<HopGuiWorkflowContext> getLambdaBuilder() {
        return this.lambdaBuilder;
    }

    public void setLambdaBuilder(GuiActionLambdaBuilder<HopGuiWorkflowContext> lambdaBuilder) {
        this.lambdaBuilder = lambdaBuilder;
    }
}

