/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NLSExchangeAttrReply;
import com.ibm.as400.access.NLSExchangeAttrRequest;
import com.ibm.as400.access.NLSGetDoubleByteTableRequest;
import com.ibm.as400.access.NLSGetMixedByteTableRequest;
import com.ibm.as400.access.NLSGetTableReply;
import com.ibm.as400.access.NLSGetTableRequest;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.UnknownHostException;

public class NLSTableDownload {
    private static final String copyright = "Copyright (C) 1997-2016 International Business Machines Corporation and others.";
    private AS400Server server_;
    private AS400ImplRemote sys_;
    boolean checkRetry = false;
    public static final int SINGLE_BYTE_FROM_CCSID = 1;
    public static final int DOUBLE_BYTE_FROM_CCSID = 2;
    public static final int MIXED_BYTE_FROM_CCSID = 3;

    public NLSTableDownload(AS400ImplRemote aS400ImplRemote) {
        this.setSystem(aS400ImplRemote);
        String string = System.getProperty("retry");
        if (string != null) {
            this.checkRetry = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws ServerStartupException, UnknownHostException, AS400SecurityException, ConnectionDroppedException, InterruptedException, IOException {
        if (this.server_ == null) {
            AS400Server aS400Server = this.server_ = this.sys_.getConnection(6, false, false);
            synchronized (aS400Server) {
                DataStream dataStream = this.server_.getExchangeAttrReply();
                if (dataStream == null) {
                    ClientAccessDataStream clientAccessDataStream;
                    try {
                        try {
                            clientAccessDataStream = new NLSExchangeAttrRequest(true);
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            clientAccessDataStream = new NLSExchangeAttrRequest();
                        }
                        dataStream = this.server_.sendExchangeAttrRequest(clientAccessDataStream);
                    }
                    catch (IOException iOException) {
                        Trace.log(2, "IOException After Exchange Attribute Request");
                        this.disconnect();
                        throw iOException;
                    }
                    if (dataStream instanceof NLSExchangeAttrReply) {
                        clientAccessDataStream = (NLSExchangeAttrReply)dataStream;
                        if (((NLSExchangeAttrReply)clientAccessDataStream).primaryRC_ != 0) {
                            Trace.log(4, "Exchange attribute failed, primary return code =", ((NLSExchangeAttrReply)clientAccessDataStream).primaryRC_);
                            Trace.log(2, "Exchange attribute failed, secondary return code =", ((NLSExchangeAttrReply)clientAccessDataStream).getSecondaryRC_());
                            this.disconnect();
                            throw new IOException();
                        }
                    } else {
                        Trace.log(2, "Unknown instance returned from Exchange Attribute Reply");
                        throw new InternalErrorException(2);
                    }
                }
            }
        }
    }

    public void disconnect() {
        if (this.server_ != null) {
            try {
                this.getSystem().disconnectServer(this.server_);
                this.server_ = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public char[] download(int n, int n2, boolean bl) throws ConnectionDroppedException, IOException, InterruptedException {
        if (bl) {
            return this.download(n, n2, 2);
        }
        return this.download(n, n2, 1);
    }

    public char[] download(int n, int n2, int n3) throws ConnectionDroppedException, IOException, InterruptedException {
        NLSGetTableReply nLSGetTableReply = null;
        NLSGetTableRequest nLSGetTableRequest = null;
        BufferedReader bufferedReader = null;
        boolean bl = true;
        while (bl) {
            bl = false;
            if (n3 == 2) {
                nLSGetTableRequest = new NLSGetDoubleByteTableRequest(n);
            } else if (n3 == 1) {
                nLSGetTableRequest = new NLSGetTableRequest();
            } else if (n3 == 3) {
                nLSGetTableRequest = new NLSGetMixedByteTableRequest(n, n2);
            } else {
                throw new IOException("Invalid fromType=" + n3);
            }
            nLSGetTableRequest.setCCSIDs(n, n2);
            DataStream dataStream = this.server_.sendAndReceive(nLSGetTableRequest);
            if (dataStream instanceof NLSGetTableReply) {
                nLSGetTableReply = (NLSGetTableReply)dataStream;
                if (nLSGetTableReply.primaryRC_ == 0) continue;
                System.out.println("fromCCSID=" + n + " toCCSID=" + n2 + " fromType=" + n3);
                System.out.println("ERROR:  Exchange attribute failed, primary return code =" + nLSGetTableReply.primaryRC_);
                System.out.println("ERROR:    Exchange attribute failed, secondary return code =" + nLSGetTableReply.secondaryRC_);
                Trace.log(4, "Exchange attribute failed, primary return code =", nLSGetTableReply.primaryRC_);
                Trace.log(2, "Exchange attribute failed, secondary return code =", nLSGetTableReply.secondaryRC_);
                if (this.checkRetry) {
                    String string;
                    System.out.println("Enter Y to retry");
                    if (bufferedReader == null) {
                        bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    }
                    if ((string = bufferedReader.readLine()) != null && string.length() > 0 && string.charAt(0) == 'Y') {
                        bl = true;
                        System.out.println("Retrying");
                    }
                }
                if (bl) continue;
                throw new IOException();
            }
            this.disconnect();
            Trace.log(2, "Unknown instance returned from Exchange Attribute Reply");
            throw new InternalErrorException(2);
        }
        this.disconnect();
        if (nLSGetTableReply != null) {
            return nLSGetTableReply.table_;
        }
        return null;
    }

    AS400ImplRemote getSystem() {
        return this.sys_;
    }

    void setSystem(AS400ImplRemote aS400ImplRemote) {
        if (aS400ImplRemote == null) {
            throw new NullPointerException();
        }
        this.sys_ = aS400ImplRemote;
    }

    static {
        AS400Server.addReplyStream((DataStream)new NLSExchangeAttrReply(), "as-central");
        AS400Server.addReplyStream((DataStream)new NLSGetTableReply(), "as-central");
    }
}

