/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.cloud.spanner.spi.v1.SpannerRpcViews;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.opencensus.stats.MeasureMap;
import io.opencensus.stats.Stats;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HeaderInterceptor
implements ClientInterceptor {
    private static final Metadata.Key<String> SERVER_TIMING_HEADER_KEY = Metadata.Key.of((String)"server-timing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Pattern SERVER_TIMING_HEADER_PATTERN = Pattern.compile(".*dur=(?<dur>\\d+)");
    private static final Metadata.Key<String> GOOGLE_CLOUD_RESOURCE_PREFIX_KEY = Metadata.Key.of((String)"google-cloud-resource-prefix", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Pattern GOOGLE_CLOUD_RESOURCE_PREFIX_PATTERN = Pattern.compile(".*projects/(?<project>\\p{ASCII}[^/]*)(/instances/(?<instance>\\p{ASCII}[^/]*))?(/databases/(?<database>\\p{ASCII}[^/]*))?");
    private static final Tagger TAGGER = Tags.getTagger();
    private static final StatsRecorder STATS_RECORDER = Stats.getStatsRecorder();
    private static final Logger LOGGER = Logger.getLogger(HeaderInterceptor.class.getName());
    private static final Level LEVEL = Level.INFO;

    HeaderInterceptor() {
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                final TagContext tagContext = HeaderInterceptor.this.getTagContext(headers, method.getFullMethodName());
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onHeaders(Metadata metadata) {
                        HeaderInterceptor.this.processHeader(metadata, tagContext);
                        super.onHeaders(metadata);
                    }
                }, headers);
            }
        };
    }

    private void processHeader(Metadata metadata, TagContext tagContext) {
        MeasureMap measureMap = STATS_RECORDER.newMeasureMap();
        if (metadata.get(SERVER_TIMING_HEADER_KEY) != null) {
            String serverTiming = (String)metadata.get(SERVER_TIMING_HEADER_KEY);
            Matcher matcher = SERVER_TIMING_HEADER_PATTERN.matcher(serverTiming);
            if (matcher.find()) {
                try {
                    long latency = Long.parseLong(matcher.group("dur"));
                    measureMap.put(SpannerRpcViews.SPANNER_GFE_LATENCY, latency);
                    measureMap.put(SpannerRpcViews.SPANNER_GFE_HEADER_MISSING_COUNT, 0L);
                    measureMap.record(tagContext);
                }
                catch (NumberFormatException e) {
                    LOGGER.log(LEVEL, "Invalid server-timing object in header", matcher.group("dur"));
                }
            }
        } else {
            measureMap.put(SpannerRpcViews.SPANNER_GFE_HEADER_MISSING_COUNT, 1L).record(tagContext);
        }
    }

    private TagContext getTagContext(String method, String projectId, String instanceId, String databaseId) {
        return TAGGER.currentBuilder().putLocal(SpannerRpcViews.PROJECT_ID, TagValue.create((String)projectId)).putLocal(SpannerRpcViews.INSTANCE_ID, TagValue.create((String)instanceId)).putLocal(SpannerRpcViews.DATABASE_ID, TagValue.create((String)databaseId)).putLocal(SpannerRpcViews.METHOD, TagValue.create((String)method)).build();
    }

    private TagContext getTagContext(Metadata headers, String method) {
        String projectId = "undefined-project";
        String instanceId = "undefined-database";
        String databaseId = "undefined-database";
        if (headers.get(GOOGLE_CLOUD_RESOURCE_PREFIX_KEY) != null) {
            String googleResourcePrefix = (String)headers.get(GOOGLE_CLOUD_RESOURCE_PREFIX_KEY);
            Matcher matcher = GOOGLE_CLOUD_RESOURCE_PREFIX_PATTERN.matcher(googleResourcePrefix);
            if (matcher.find()) {
                projectId = matcher.group("project");
                if (matcher.group("instance") != null) {
                    instanceId = matcher.group("instance");
                }
                if (matcher.group("database") != null) {
                    databaseId = matcher.group("database");
                }
            } else {
                LOGGER.log(LEVEL, "Error parsing google cloud resource header: " + googleResourcePrefix);
            }
        }
        return this.getTagContext(method, projectId, instanceId, databaseId);
    }
}

