/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientSettings;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.CloudRegion;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.CursorClient;
import com.google.cloud.pubsublite.internal.CursorClientSettings;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.CommitterSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.RoutingMetadata;
import com.google.cloud.pubsublite.internal.wire.ServiceClients;
import com.google.cloud.pubsublite.internal.wire.SubscriberBuilder;
import com.google.cloud.pubsublite.internal.wire.SubscriberFactory;
import com.google.cloud.pubsublite.proto.Cursor;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.cloud.pubsublite.proto.Subscription;
import com.google.cloud.pubsublite.v1.CursorServiceClient;
import com.google.cloud.pubsublite.v1.CursorServiceSettings;
import com.google.cloud.pubsublite.v1.SubscriberServiceClient;
import com.google.cloud.pubsublite.v1.SubscriberServiceSettings;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitterImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.InitialOffsetReaderImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReaderSettings;

class SubscriberAssembler {
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");
    private static final ConcurrentHashMap<SubscriptionPath, TopicPath> KNOWN_PATHS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SubscriptionPath, SubscriberServiceClient> SUB_CLIENTS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SubscriptionPath, CursorServiceClient> CURSOR_CLIENTS = new ConcurrentHashMap();
    private final SubscriberOptions options;
    private final Partition partition;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TopicPath lookupTopicPath(SubscriptionPath subscriptionPath) {
        try (AdminClient adminClient = AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setRegion(subscriptionPath.location().extractRegion()).build());){
            TopicPath topicPath = TopicPath.parse((String)((Subscription)adminClient.getSubscription(subscriptionPath).get(1L, TimeUnit.MINUTES)).getTopic());
            return topicPath;
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private TopicPath getTopicPath() {
        return KNOWN_PATHS.computeIfAbsent(this.options.subscriptionPath(), SubscriberAssembler::lookupTopicPath);
    }

    private SubscriberServiceClient newSubscriberServiceClient() throws ApiException {
        try {
            SubscriberServiceSettings.Builder settingsBuilder = SubscriberServiceSettings.newBuilder();
            return SubscriberServiceClient.create((SubscriberServiceSettings)((SubscriberServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)this.options.subscriptionPath().location().extractRegion(), (ClientSettings.Builder)settingsBuilder)));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private SubscriberServiceClient getSubscriberServiceClient() {
        return SUB_CLIENTS.computeIfAbsent(this.options.subscriptionPath(), path -> this.newSubscriberServiceClient());
    }

    private CursorServiceClient newCursorClient() throws ApiException {
        try {
            CursorServiceSettings.Builder settingsBuilder = CursorServiceSettings.newBuilder();
            return CursorServiceClient.create((CursorServiceSettings)((CursorServiceSettings)ServiceClients.addDefaultSettings((CloudRegion)this.options.subscriptionPath().location().extractRegion(), (ClientSettings.Builder)settingsBuilder)));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private CursorServiceClient getCursorClient() {
        return CURSOR_CLIENTS.computeIfAbsent(this.options.subscriptionPath(), path -> this.newCursorClient());
    }

    SubscriberAssembler(SubscriberOptions options, Partition partition) {
        this.options = options;
        this.partition = partition;
    }

    SubscriberFactory getSubscriberFactory(Offset initialOffset) {
        SubscriberServiceClient client = this.getSubscriberServiceClient();
        return (SubscriberFactory & Serializable)consumer -> SubscriberBuilder.newBuilder().setMessageConsumer(consumer).setSubscriptionPath(this.options.subscriptionPath()).setPartition(this.partition).setRetryStreamRaces(false).setStreamFactory(responseStream -> {
            ApiCallContext context = ServiceClients.getCallContext((PubsubContext)PubsubContext.of((PubsubContext.Framework)FRAMEWORK), (RoutingMetadata)RoutingMetadata.of((SubscriptionPath)this.options.subscriptionPath(), (Partition)this.partition));
            return client.subscribeCallable().splitCall(responseStream, context);
        }).setInitialLocation(SeekRequest.newBuilder().setCursor(Cursor.newBuilder().setOffset(initialOffset.value())).build()).build();
    }

    BlockingCommitter newCommitter() {
        CursorServiceClient client = this.getCursorClient();
        Committer committer = CommitterSettings.newBuilder().setPartition(this.partition).setSubscriptionPath(this.options.subscriptionPath()).setStreamFactory(responseStream -> {
            ApiCallContext context = ServiceClients.getCallContext((PubsubContext)PubsubContext.of((PubsubContext.Framework)FRAMEWORK), (RoutingMetadata)RoutingMetadata.of((SubscriptionPath)this.options.subscriptionPath(), (Partition)this.partition));
            return client.streamingCommitCursorCallable().splitCall(responseStream, context);
        }).build().instantiate();
        committer.startAsync().awaitRunning();
        return new BlockingCommitterImpl(committer);
    }

    TopicBacklogReader getBacklogReader() {
        return TopicBacklogReaderSettings.newBuilder().setTopicPath(this.getTopicPath()).setPartition(this.partition).build().instantiate();
    }

    InitialOffsetReader getInitialOffsetReader() {
        return new InitialOffsetReaderImpl(CursorClient.create((CursorClientSettings)CursorClientSettings.newBuilder().setServiceClient(this.getCursorClient()).setRegion(this.options.subscriptionPath().location().extractRegion()).build()), this.options.subscriptionPath(), this.partition);
    }
}

