/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.value.AutoValue;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubMessage_Impl;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PubsubMessage {
    private Impl impl;

    public PubsubMessage(byte[] payload, @Nullable Map<String, String> attributes) {
        this(payload, attributes, null, null);
    }

    public PubsubMessage(byte[] payload, @Nullable Map<String, String> attributes, @Nullable String messageId) {
        this.impl = Impl.create(payload, attributes, messageId, null);
    }

    public PubsubMessage(byte[] payload, @Nullable Map<String, String> attributes, @Nullable String messageId, @Nullable String orderingKey) {
        this.impl = Impl.create(payload, attributes, messageId, orderingKey);
    }

    public byte[] getPayload() {
        return this.impl.getPayload();
    }

    public @Nullable String getAttribute(String attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"attribute");
        return this.impl.getAttributeMap().get(attribute);
    }

    public @Nullable Map<String, String> getAttributeMap() {
        return this.impl.getAttributeMap();
    }

    public @Nullable String getMessageId() {
        return this.impl.getMessageId();
    }

    public @Nullable String getOrderingKey() {
        return this.impl.getOrderingKey();
    }

    public String toString() {
        return this.impl.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PubsubMessage)) {
            return false;
        }
        return this.impl.equals(((PubsubMessage)other).impl);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    @AutoValue
    static abstract class Impl {
        Impl() {
        }

        abstract byte[] getPayload();

        abstract @Nullable Map<String, String> getAttributeMap();

        abstract @Nullable String getMessageId();

        abstract @Nullable String getOrderingKey();

        static Impl create(byte[] payload, @Nullable Map<String, String> attributes, @Nullable String messageId, @Nullable String orderingKey) {
            return new AutoValue_PubsubMessage_Impl(payload, attributes, messageId, orderingKey);
        }
    }
}

