/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Supplier;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.Materialization;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSortedMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Ints;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Longs;
import org.checkerframework.checker.nullness.qual.Nullable;

@Internal
public class PCollectionViews {
    public static <T, W extends BoundedWindow> PCollectionView<T> singletonView(PCollection<T> pCollection, TypeDescriptorSupplier<T> typeDescriptorSupplier, WindowingStrategy<?, W> windowingStrategy, boolean hasDefault, @Nullable T defaultValue, Coder<T> defaultValueCoder) {
        return new SimplePCollectionView(pCollection, new SingletonViewFn2(hasDefault, defaultValue, defaultValueCoder, typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    @Deprecated
    public static <T, W extends BoundedWindow> PCollectionView<T> singletonViewUsingVoidKey(TupleTag<Materializations.MultimapView<Void, T>> tag, PCollection<KV<Void, T>> pCollection, TypeDescriptorSupplier<T> typeDescriptorSupplier, WindowingStrategy<?, W> windowingStrategy, boolean hasDefault, @Nullable T defaultValue, Coder<T> defaultValueCoder) {
        return new SimplePCollectionView(pCollection, tag, new SingletonViewFn(hasDefault, defaultValue, defaultValueCoder, typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <T, W extends BoundedWindow> PCollectionView<Iterable<T>> iterableView(PCollection<T> pCollection, TypeDescriptorSupplier<T> typeDescriptorSupplier, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new IterableViewFn2<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    @Deprecated
    public static <T, W extends BoundedWindow> PCollectionView<Iterable<T>> iterableViewUsingVoidKey(TupleTag<Materializations.MultimapView<Void, T>> tag, PCollection<KV<Void, T>> pCollection, TypeDescriptorSupplier<T> typeDescriptorSupplier, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new IterableViewFn<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <T, W extends BoundedWindow> PCollectionView<List<T>> listView(PCollection<KV<Long, ValueOrMetadata<T, OffsetRange>>> pCollection, TypeDescriptorSupplier<T> typeDescriptorSupplier, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new ListViewFn2<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <T, W extends BoundedWindow> PCollectionView<List<T>> listView(PCollection<KV<Long, ValueOrMetadata<T, OffsetRange>>> pCollection, TupleTag<Materializations.MultimapView<Long, ValueOrMetadata<T, OffsetRange>>> tag, TypeDescriptorSupplier<T> typeDescriptorSupplier, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new ListViewFn2<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    @Deprecated
    public static <T, W extends BoundedWindow> PCollectionView<List<T>> listViewUsingVoidKey(TupleTag<Materializations.MultimapView<Void, T>> tag, PCollection<KV<Void, T>> pCollection, TypeDescriptorSupplier<T> typeDescriptorSupplier, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new ListViewFn<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    @Deprecated
    public static <T, W extends BoundedWindow> PCollectionView<List<T>> listViewUsingVoidKey(PCollection<KV<Void, T>> pCollection, TupleTag<Materializations.MultimapView<Void, T>> tag, TypeDescriptorSupplier<T> typeDescriptorSupplier, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new ListViewFn<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <K, V, W extends BoundedWindow> PCollectionView<Map<K, V>> mapView(PCollection<KV<K, V>> pCollection, TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, TypeDescriptorSupplier<V> valueTypeDescriptorSupplier, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new MapViewFn2<K, V>(keyTypeDescriptorSupplier, valueTypeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    @Deprecated
    public static <K, V, W extends BoundedWindow> PCollectionView<Map<K, V>> mapViewUsingVoidKey(TupleTag<Materializations.MultimapView<Void, KV<K, V>>> tag, PCollection<KV<Void, KV<K, V>>> pCollection, TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, TypeDescriptorSupplier<V> valueTypeDescriptorSupplier, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new MapViewFn<K, V>(keyTypeDescriptorSupplier, valueTypeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <K, V, W extends BoundedWindow> PCollectionView<Map<K, Iterable<V>>> multimapView(PCollection<KV<K, V>> pCollection, TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, TypeDescriptorSupplier<V> valueTypeDescriptorSupplier, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new MultimapViewFn2<K, V>(keyTypeDescriptorSupplier, valueTypeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    @Deprecated
    public static <K, V, W extends BoundedWindow> PCollectionView<Map<K, Iterable<V>>> multimapViewUsingVoidKey(TupleTag<Materializations.MultimapView<Void, KV<K, V>>> tag, PCollection<KV<Void, KV<K, V>>> pCollection, TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, TypeDescriptorSupplier<V> valueTypeDescriptorSupplier, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new MultimapViewFn<K, V>(keyTypeDescriptorSupplier, valueTypeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static Map<TupleTag<?>, PValue> toAdditionalInputs(Iterable<PCollectionView<?>> views) {
        ImmutableMap.Builder additionalInputs = ImmutableMap.builder();
        for (PCollectionView<?> view : views) {
            additionalInputs.put(view.getTagInternal(), view.getPCollection());
        }
        return additionalInputs.build();
    }

    @VisibleForTesting
    static SortedMap<OffsetRange, Integer> computeOverlappingRanges(Iterable<OffsetRange> ranges) {
        OffsetRange current;
        ImmutableSortedMap.Builder rval = ImmutableSortedMap.orderedBy((Comparator)OffsetRangeComparator.INSTANCE);
        ArrayList sortedRanges = Lists.newArrayList(ranges);
        if (sortedRanges.isEmpty()) {
            return rval.build();
        }
        Collections.sort(sortedRanges, OffsetRangeComparator.INSTANCE);
        PriorityQueue<OffsetRange> rangesWithSameFrom = new PriorityQueue<OffsetRange>(OffsetRangeComparator.INSTANCE);
        Iterator iterator = sortedRanges.iterator();
        ArrayList<OffsetRange> rangesToProcess = new ArrayList<OffsetRange>();
        while (iterator.hasNext()) {
            current = (OffsetRange)iterator.next();
            if (current.getFrom() == current.getTo()) continue;
            while (!rangesWithSameFrom.isEmpty() && rangesWithSameFrom.peek().getFrom() != current.getFrom()) {
                int i;
                rangesToProcess.addAll(rangesWithSameFrom);
                Collections.sort(rangesToProcess, OffsetRangeComparator.INSTANCE);
                rangesWithSameFrom.clear();
                long lastTo = ((OffsetRange)rangesToProcess.get(i)).getFrom();
                for (i = 0; i < rangesToProcess.size() && ((OffsetRange)rangesToProcess.get(i)).getTo() <= current.getFrom(); ++i) {
                    if (i != 0 && ((OffsetRange)rangesToProcess.get(i - 1)).getTo() == ((OffsetRange)rangesToProcess.get(i)).getTo()) continue;
                    rval.put((Object)new OffsetRange(lastTo, ((OffsetRange)rangesToProcess.get(i)).getTo()), (Object)(rangesToProcess.size() - i));
                    lastTo = ((OffsetRange)rangesToProcess.get(i)).getTo();
                }
                if (lastTo < current.getFrom() && i != rangesToProcess.size()) {
                    rval.put((Object)new OffsetRange(lastTo, current.getFrom()), (Object)(rangesToProcess.size() - i));
                }
                while (i < rangesToProcess.size()) {
                    rangesWithSameFrom.add(new OffsetRange(current.getFrom(), ((OffsetRange)rangesToProcess.get(i)).getTo()));
                    ++i;
                }
                rangesToProcess.clear();
            }
            rangesWithSameFrom.add(current);
        }
        while (!rangesWithSameFrom.isEmpty()) {
            current = (OffsetRange)rangesWithSameFrom.remove();
            rangesToProcess.addAll(rangesWithSameFrom);
            Collections.sort(rangesToProcess, OffsetRangeComparator.INSTANCE);
            rangesWithSameFrom.clear();
            rval.put((Object)current, (Object)(rangesToProcess.size() + 1));
            for (OffsetRange rangeWithDifferentFrom : rangesToProcess) {
                if (rangeWithDifferentFrom.getTo() <= current.getTo()) continue;
                rangesWithSameFrom.add(new OffsetRange(current.getTo(), rangeWithDifferentFrom.getTo()));
            }
            rangesToProcess.clear();
        }
        return rval.build();
    }

    @VisibleForTesting
    static int computeTotalNumElements(Map<OffsetRange, Integer> nonOverlappingRangesToNumElementsPerPosition) {
        long sum = 0L;
        for (Map.Entry<OffsetRange, Integer> range : nonOverlappingRangesToNumElementsPerPosition.entrySet()) {
            sum += Math.multiplyExact(Math.subtractExact(range.getKey().getTo(), range.getKey().getFrom()), (long)range.getValue().intValue());
        }
        return Ints.checkedCast((long)sum);
    }

    @VisibleForTesting
    static KV<Long, Integer> computePositionForIndex(Map<OffsetRange, Integer> nonOverlappingRangesToNumElementsPerPosition, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.format("Position %s was out of bounds for ranges %s.", index, nonOverlappingRangesToNumElementsPerPosition));
        }
        for (Map.Entry<OffsetRange, Integer> range : nonOverlappingRangesToNumElementsPerPosition.entrySet()) {
            int numElementsInRange = Ints.checkedCast((long)Math.multiplyExact(Math.subtractExact(range.getKey().getTo(), range.getKey().getFrom()), (long)range.getValue().intValue()));
            if (numElementsInRange <= index) {
                index -= numElementsInRange;
                continue;
            }
            long position = range.getKey().getFrom() + (long)(index / range.getValue());
            int subPosition = index % range.getValue();
            return KV.of(position, subPosition);
        }
        throw new IndexOutOfBoundsException(String.format("Position %s was out of bounds for ranges %s.", index, nonOverlappingRangesToNumElementsPerPosition));
    }

    private static class MultimapViewToMultimapAdapter<K, V>
    extends AbstractMap<K, Iterable<V>> {
        private final Materializations.MultimapView<K, V> primitiveViewT;
        private final Supplier<Integer> size;

        private MultimapViewToMultimapAdapter(Materializations.MultimapView<K, V> primitiveViewT) {
            this.primitiveViewT = primitiveViewT;
            this.size = Suppliers.memoize(() -> Iterables.size(primitiveViewT.get()));
        }

        @Override
        public boolean containsKey(Object key) {
            return this.primitiveViewT.get(key).iterator().hasNext();
        }

        @Override
        public Iterable<V> get(Object key) {
            Iterable<V> values = this.primitiveViewT.get(key);
            if (values.iterator().hasNext()) {
                return values;
            }
            return null;
        }

        @Override
        public int size() {
            return this.size.get();
        }

        @Override
        public Set<Map.Entry<K, Iterable<V>>> entrySet() {
            return new AbstractSet<Map.Entry<K, Iterable<V>>>(){

                @Override
                public Iterator<Map.Entry<K, Iterable<V>>> iterator() {
                    return FluentIterable.from(primitiveViewT.get()).transform(key -> new AbstractMap.SimpleEntry(key, primitiveViewT.get(key))).iterator();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    if (!(entry.getValue() instanceof Iterable)) {
                        return false;
                    }
                    Iterable value = primitiveViewT.get(entry.getKey());
                    if (value.iterator().hasNext()) {
                        return false;
                    }
                    return Iterables.elementsEqual((Iterable)((Iterable)entry.getValue()), value);
                }

                @Override
                public int size() {
                    return (Integer)size.get();
                }
            };
        }
    }

    private static class MultimapViewToMapAdapter<K, V>
    extends AbstractMap<K, V> {
        private final Materializations.MultimapView<K, V> primitiveViewT;
        private final Supplier<Integer> size;

        private MultimapViewToMapAdapter(Materializations.MultimapView<K, V> primitiveViewT) {
            this.primitiveViewT = primitiveViewT;
            this.size = Suppliers.memoize(() -> Iterables.size(primitiveViewT.get()));
        }

        @Override
        public boolean containsKey(Object key) {
            return this.primitiveViewT.get(key).iterator().hasNext();
        }

        @Override
        public V get(Object key) {
            Iterator<V> iterator = this.primitiveViewT.get(key).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            V value = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalArgumentException("Duplicate values for " + key);
            }
            return value;
        }

        @Override
        public int size() {
            return this.size.get();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return FluentIterable.from(primitiveViewT.get()).transform(key -> new AbstractMap.SimpleEntry(key, this.get(key))).iterator();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Iterable value = primitiveViewT.get(entry.getKey());
                    if (value.iterator().hasNext()) {
                        return false;
                    }
                    return Objects.equals(entry.getValue(), value);
                }

                @Override
                public int size() {
                    return (Integer)size.get();
                }
            };
        }
    }

    public static class SimplePCollectionView<ElemT, PrimitiveViewT, ViewT, W extends BoundedWindow>
    extends PValueBase
    implements PCollectionView<ViewT> {
        private transient PCollection<ElemT> pCollection;
        private TupleTag<PrimitiveViewT> tag;
        private WindowMappingFn<W> windowMappingFn;
        private WindowingStrategy<?, W> windowingStrategy;
        private @Nullable Coder<ElemT> coder;
        private ViewFn<PrimitiveViewT, ViewT> viewFn;

        private SimplePCollectionView(PCollection<ElemT> pCollection, TupleTag<PrimitiveViewT> tag, ViewFn<PrimitiveViewT, ViewT> viewFn, WindowMappingFn<W> windowMappingFn, WindowingStrategy<?, W> windowingStrategy) {
            super(pCollection.getPipeline());
            this.pCollection = pCollection;
            this.windowMappingFn = windowMappingFn;
            this.tag = tag;
            this.windowingStrategy = windowingStrategy;
            this.viewFn = viewFn;
            this.coder = pCollection.getCoder();
        }

        private SimplePCollectionView(PCollection<ElemT> pCollection, ViewFn<PrimitiveViewT, ViewT> viewFn, WindowMappingFn<W> windowMappingFn, WindowingStrategy<?, W> windowingStrategy) {
            this(pCollection, new TupleTag(), viewFn, windowMappingFn, windowingStrategy);
        }

        @Override
        public ViewFn<PrimitiveViewT, ViewT> getViewFn() {
            return this.viewFn;
        }

        @Override
        public WindowMappingFn<?> getWindowMappingFn() {
            return this.windowMappingFn;
        }

        @Override
        public PCollection<?> getPCollection() {
            return this.pCollection;
        }

        @Override
        public TupleTag<?> getTagInternal() {
            return this.tag;
        }

        @Override
        public WindowingStrategy<?, ?> getWindowingStrategyInternal() {
            return this.windowingStrategy;
        }

        @Override
        public Coder<?> getCoderInternal() {
            return this.coder;
        }

        public int hashCode() {
            return Objects.hash(this.tag);
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof PCollectionView)) {
                return false;
            }
            PCollectionView otherView = (PCollectionView)other;
            return this.tag.equals(otherView.getTagInternal());
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tag", this.tag).add("viewFn", this.viewFn).add("coder", this.coder).add("windowMappingFn", this.windowMappingFn).add("pCollection", this.pCollection).toString();
        }

        @Override
        public Map<TupleTag<?>, PValue> expand() {
            return Collections.singletonMap(this.tag, this.pCollection);
        }
    }

    @Deprecated
    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static class MapViewFn<K, V>
    extends ViewFn<Materializations.MultimapView<Void, KV<K, V>>, Map<K, V>> {
        private TypeDescriptorSupplier<K> keyTypeDescriptorSupplier;
        private TypeDescriptorSupplier<V> valueTypeDescriptorSupplier;

        public MapViewFn(TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, TypeDescriptorSupplier<V> valueTypeDescriptorSupplier) {
            this.keyTypeDescriptorSupplier = keyTypeDescriptorSupplier;
            this.valueTypeDescriptorSupplier = valueTypeDescriptorSupplier;
        }

        @Override
        public Materialization<Materializations.MultimapView<Void, KV<K, V>>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public Map<K, V> apply(Materializations.MultimapView<Void, KV<K, V>> primitiveViewT) {
            HashMap<K, V> map = new HashMap<K, V>();
            for (KV<K, V> elem : primitiveViewT.get(null)) {
                if (map.containsKey(elem.getKey())) {
                    throw new IllegalArgumentException("Duplicate values for " + elem.getKey());
                }
                map.put(elem.getKey(), elem.getValue());
            }
            return Collections.unmodifiableMap(map);
        }

        @Override
        public TypeDescriptor<Map<K, V>> getTypeDescriptor() {
            return TypeDescriptors.maps((TypeDescriptor)this.keyTypeDescriptorSupplier.get(), (TypeDescriptor)this.valueTypeDescriptorSupplier.get());
        }
    }

    @Internal
    public static class MapViewFn2<K, V>
    extends ViewFn<Materializations.MultimapView<K, V>, Map<K, V>> {
        private TypeDescriptorSupplier<K> keyTypeDescriptorSupplier;
        private TypeDescriptorSupplier<V> valueTypeDescriptorSupplier;

        public MapViewFn2(TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, TypeDescriptorSupplier<V> valueTypeDescriptorSupplier) {
            this.keyTypeDescriptorSupplier = keyTypeDescriptorSupplier;
            this.valueTypeDescriptorSupplier = valueTypeDescriptorSupplier;
        }

        @Override
        public Materialization<Materializations.MultimapView<K, V>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public Map<K, V> apply(Materializations.MultimapView<K, V> primitiveViewT) {
            return Collections.unmodifiableMap(new MultimapViewToMapAdapter(primitiveViewT));
        }

        @Override
        public TypeDescriptor<Map<K, V>> getTypeDescriptor() {
            return TypeDescriptors.maps((TypeDescriptor)this.keyTypeDescriptorSupplier.get(), (TypeDescriptor)this.valueTypeDescriptorSupplier.get());
        }
    }

    @Deprecated
    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static class MultimapViewFn<K, V>
    extends ViewFn<Materializations.MultimapView<Void, KV<K, V>>, Map<K, Iterable<V>>> {
        private TypeDescriptorSupplier<K> keyTypeDescriptorSupplier;
        private TypeDescriptorSupplier<V> valueTypeDescriptorSupplier;

        public MultimapViewFn(TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, TypeDescriptorSupplier<V> valueTypeDescriptorSupplier) {
            this.keyTypeDescriptorSupplier = keyTypeDescriptorSupplier;
            this.valueTypeDescriptorSupplier = valueTypeDescriptorSupplier;
        }

        @Override
        public Materialization<Materializations.MultimapView<Void, KV<K, V>>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public Map<K, Iterable<V>> apply(Materializations.MultimapView<Void, KV<K, V>> primitiveViewT) {
            ArrayListMultimap multimap = ArrayListMultimap.create();
            for (KV<K, V> elem : primitiveViewT.get(null)) {
                multimap.put(elem.getKey(), elem.getValue());
            }
            Map resultMap = multimap.asMap();
            return Collections.unmodifiableMap(resultMap);
        }

        @Override
        public TypeDescriptor<Map<K, Iterable<V>>> getTypeDescriptor() {
            return TypeDescriptors.maps((TypeDescriptor)this.keyTypeDescriptorSupplier.get(), TypeDescriptors.iterables((TypeDescriptor)this.valueTypeDescriptorSupplier.get()));
        }
    }

    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    @Internal
    public static class MultimapViewFn2<K, V>
    extends ViewFn<Materializations.MultimapView<K, V>, Map<K, Iterable<V>>> {
        private TypeDescriptorSupplier<K> keyTypeDescriptorSupplier;
        private TypeDescriptorSupplier<V> valueTypeDescriptorSupplier;

        public MultimapViewFn2(TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, TypeDescriptorSupplier<V> valueTypeDescriptorSupplier) {
            this.keyTypeDescriptorSupplier = keyTypeDescriptorSupplier;
            this.valueTypeDescriptorSupplier = valueTypeDescriptorSupplier;
        }

        @Override
        public Materialization<Materializations.MultimapView<K, V>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public Map<K, Iterable<V>> apply(Materializations.MultimapView<K, V> primitiveViewT) {
            return Collections.unmodifiableMap(new MultimapViewToMultimapAdapter(primitiveViewT));
        }

        @Override
        public TypeDescriptor<Map<K, Iterable<V>>> getTypeDescriptor() {
            return TypeDescriptors.maps((TypeDescriptor)this.keyTypeDescriptorSupplier.get(), TypeDescriptors.iterables((TypeDescriptor)this.valueTypeDescriptorSupplier.get()));
        }
    }

    @Deprecated
    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static class ListViewFn<T>
    extends ViewFn<Materializations.MultimapView<Void, T>, List<T>> {
        private TypeDescriptorSupplier<T> typeDescriptorSupplier;

        public ListViewFn(TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.typeDescriptorSupplier = typeDescriptorSupplier;
        }

        @Override
        public Materialization<Materializations.MultimapView<Void, T>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public List<T> apply(Materializations.MultimapView<Void, T> primitiveViewT) {
            ArrayList<T> list = new ArrayList<T>();
            for (T t : primitiveViewT.get(null)) {
                list.add(t);
            }
            return Collections.unmodifiableList(list);
        }

        @Override
        public TypeDescriptor<List<T>> getTypeDescriptor() {
            return TypeDescriptors.lists((TypeDescriptor)this.typeDescriptorSupplier.get());
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ListViewFn;
        }

        public int hashCode() {
            return ListViewFn.class.hashCode();
        }
    }

    public static class ValueOrMetadataCoder<T, MetaT>
    extends StructuredCoder<ValueOrMetadata<T, MetaT>> {
        private final Coder<T> valueCoder;
        private final Coder<MetaT> metadataCoder;

        public static <T, MetaT> ValueOrMetadataCoder<T, MetaT> create(Coder<T> valueCoder, Coder<MetaT> metadataCoder) {
            return new ValueOrMetadataCoder<T, MetaT>(valueCoder, metadataCoder);
        }

        private ValueOrMetadataCoder(Coder<T> valueCoder, Coder<MetaT> metadataCoder) {
            this.valueCoder = valueCoder;
            this.metadataCoder = metadataCoder;
        }

        @Override
        public void encode(ValueOrMetadata<T, MetaT> value, OutputStream outStream) throws CoderException, IOException {
            BooleanCoder.of().encode(value.isMetadata(), outStream);
            if (value.isMetadata()) {
                this.metadataCoder.encode(value.getMetadata(), outStream);
            } else {
                this.valueCoder.encode(value.get(), outStream);
            }
        }

        @Override
        public ValueOrMetadata<T, MetaT> decode(InputStream inStream) throws CoderException, IOException {
            boolean isMetadata = BooleanCoder.of().decode(inStream);
            if (isMetadata) {
                return ValueOrMetadata.createMetadata(this.metadataCoder.decode(inStream));
            }
            return ValueOrMetadata.create(this.valueCoder.decode(inStream));
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.valueCoder, this.metadataCoder);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            ValueOrMetadataCoder.verifyDeterministic(this.valueCoder, "value coder", new Coder[0]);
            ValueOrMetadataCoder.verifyDeterministic(this.metadataCoder, "metadata coder", new Coder[0]);
        }
    }

    public static class ValueOrMetadata<T, MetaT> {
        private final T value;
        private final boolean isMetadata;
        private final MetaT metadata;

        public static <T, MetaT> ValueOrMetadata<T, MetaT> create(T value) {
            return new ValueOrMetadata<T, Object>(false, value, null);
        }

        public static <T, MetaT> ValueOrMetadata<T, MetaT> createMetadata(MetaT metadata) {
            return new ValueOrMetadata<Object, MetaT>(true, null, metadata);
        }

        public ValueOrMetadata(boolean isMetadata, T value, MetaT metadata) {
            this.isMetadata = isMetadata;
            this.value = value;
            this.metadata = metadata;
        }

        public T get() {
            Preconditions.checkState((!this.isMetadata ? 1 : 0) != 0);
            return this.value;
        }

        public boolean isMetadata() {
            return this.isMetadata;
        }

        public MetaT getMetadata() {
            Preconditions.checkState((boolean)this.isMetadata);
            return this.metadata;
        }
    }

    @VisibleForTesting
    static class OffsetRangeComparator
    implements Comparator<OffsetRange> {
        private static final OffsetRangeComparator INSTANCE = new OffsetRangeComparator();

        OffsetRangeComparator() {
        }

        @Override
        public int compare(OffsetRange o1, OffsetRange o2) {
            int fromComparison = Longs.compare((long)o1.getFrom(), (long)o2.getFrom());
            if (fromComparison != 0) {
                return fromComparison;
            }
            return Longs.compare((long)o1.getTo(), (long)o2.getTo());
        }
    }

    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    @VisibleForTesting
    public static class ListViewFn2<T>
    extends ViewFn<Materializations.MultimapView<Long, ValueOrMetadata<T, OffsetRange>>, List<T>> {
        private TypeDescriptorSupplier<T> typeDescriptorSupplier;

        public ListViewFn2(TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.typeDescriptorSupplier = typeDescriptorSupplier;
        }

        @Override
        public Materialization<Materializations.MultimapView<Long, ValueOrMetadata<T, OffsetRange>>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public List<T> apply(Materializations.MultimapView<Long, ValueOrMetadata<T, OffsetRange>> primitiveViewT) {
            return Collections.unmodifiableList(new ListOverMultimapView(primitiveViewT));
        }

        @Override
        public TypeDescriptor<List<T>> getTypeDescriptor() {
            return TypeDescriptors.lists((TypeDescriptor)this.typeDescriptorSupplier.get());
        }

        private static class ListOverMultimapView<T>
        extends AbstractList<T>
        implements RandomAccess {
            private final Materializations.MultimapView<Long, ValueOrMetadata<T, OffsetRange>> primitiveView;
            private final Supplier<SortedMap<OffsetRange, Integer>> nonOverlappingRangesToNumElementsPerPosition;
            private final Supplier<Integer> size;

            private ListOverMultimapView(Materializations.MultimapView<Long, ValueOrMetadata<T, OffsetRange>> primitiveView) {
                this.primitiveView = primitiveView;
                this.nonOverlappingRangesToNumElementsPerPosition = Suppliers.memoize(() -> PCollectionViews.computeOverlappingRanges(Iterables.transform(primitiveView.get(Long.MIN_VALUE), value -> (OffsetRange)value.getMetadata())));
                this.size = Suppliers.memoize(() -> PCollectionViews.computeTotalNumElements((Map<OffsetRange, Integer>)this.nonOverlappingRangesToNumElementsPerPosition.get()));
            }

            @Override
            public T get(int index) {
                if (index < 0 || index >= this.size.get()) {
                    throw new IndexOutOfBoundsException();
                }
                KV<Long, Integer> position = PCollectionViews.computePositionForIndex((Map<OffsetRange, Integer>)this.nonOverlappingRangesToNumElementsPerPosition.get(), index);
                return ((ValueOrMetadata)Iterables.get(this.primitiveView.get(position.getKey()), (int)position.getValue())).get();
            }

            @Override
            public int size() {
                return this.size.get();
            }

            @Override
            public Iterator<T> iterator() {
                return this.listIterator();
            }

            @Override
            public ListIterator<T> listIterator() {
                return super.listIterator();
            }
        }
    }

    @Deprecated
    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static class IterableViewFn<T>
    extends ViewFn<Materializations.MultimapView<Void, T>, Iterable<T>> {
        private TypeDescriptorSupplier<T> typeDescriptorSupplier;

        public IterableViewFn(TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.typeDescriptorSupplier = typeDescriptorSupplier;
        }

        @Override
        public Materialization<Materializations.MultimapView<Void, T>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public Iterable<T> apply(Materializations.MultimapView<Void, T> primitiveViewT) {
            return Iterables.unmodifiableIterable(primitiveViewT.get(null));
        }

        @Override
        public TypeDescriptor<Iterable<T>> getTypeDescriptor() {
            return TypeDescriptors.iterables((TypeDescriptor)this.typeDescriptorSupplier.get());
        }
    }

    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    @Internal
    public static class IterableViewFn2<T>
    extends ViewFn<Materializations.IterableView<T>, Iterable<T>> {
        private TypeDescriptorSupplier<T> typeDescriptorSupplier;

        public IterableViewFn2(TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.typeDescriptorSupplier = typeDescriptorSupplier;
        }

        @Override
        public Materialization<Materializations.IterableView<T>> getMaterialization() {
            return Materializations.iterable();
        }

        @Override
        public Iterable<T> apply(Materializations.IterableView<T> primitiveViewT) {
            return Iterables.unmodifiableIterable(primitiveViewT.get());
        }

        @Override
        public TypeDescriptor<Iterable<T>> getTypeDescriptor() {
            return TypeDescriptors.iterables((TypeDescriptor)this.typeDescriptorSupplier.get());
        }
    }

    @Deprecated
    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static class SingletonViewFn<T>
    extends ViewFn<Materializations.MultimapView<Void, T>, T>
    implements HasDefaultValue<T> {
        private byte @Nullable [] encodedDefaultValue;
        private transient @Nullable T defaultValue;
        private @Nullable Coder<T> valueCoder;
        private boolean hasDefault;
        private TypeDescriptorSupplier<T> typeDescriptorSupplier;

        private SingletonViewFn(boolean hasDefault, T defaultValue, Coder<T> valueCoder, TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.hasDefault = hasDefault;
            this.defaultValue = defaultValue;
            this.valueCoder = valueCoder;
            this.typeDescriptorSupplier = typeDescriptorSupplier;
            if (hasDefault) {
                try {
                    this.encodedDefaultValue = CoderUtils.encodeToByteArray(valueCoder, defaultValue);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException: ", e);
                }
            }
        }

        @Internal
        public boolean hasDefault() {
            return this.hasDefault;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getDefaultValue() {
            if (!this.hasDefault) {
                throw new NoSuchElementException("Empty PCollection accessed as a singleton view.");
            }
            SingletonViewFn singletonViewFn = this;
            synchronized (singletonViewFn) {
                if (this.encodedDefaultValue != null) {
                    try {
                        this.defaultValue = CoderUtils.decodeFromByteArray(this.valueCoder, this.encodedDefaultValue);
                        this.encodedDefaultValue = null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unexpected IOException: ", e);
                    }
                }
                return this.defaultValue;
            }
        }

        @Override
        public Materialization<Materializations.MultimapView<Void, T>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public T apply(Materializations.MultimapView<Void, T> primitiveViewT) {
            try {
                return (T)Iterables.getOnlyElement(primitiveViewT.get(null));
            }
            catch (NoSuchElementException exc) {
                return this.getDefaultValue();
            }
            catch (IllegalArgumentException exc) {
                throw new IllegalArgumentException("PCollection with more than one element accessed as a singleton view.");
            }
        }

        @Override
        public TypeDescriptor<T> getTypeDescriptor() {
            return (TypeDescriptor)this.typeDescriptorSupplier.get();
        }
    }

    @Internal
    public static interface HasDefaultValue<T> {
        public T getDefaultValue();
    }

    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    @Internal
    public static class SingletonViewFn2<T>
    extends ViewFn<Materializations.IterableView<T>, T>
    implements HasDefaultValue<T> {
        private byte @Nullable [] encodedDefaultValue;
        private transient @Nullable T defaultValue;
        private @Nullable Coder<T> valueCoder;
        private boolean hasDefault;
        private TypeDescriptorSupplier<T> typeDescriptorSupplier;

        private SingletonViewFn2(boolean hasDefault, T defaultValue, Coder<T> valueCoder, TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.hasDefault = hasDefault;
            this.defaultValue = defaultValue;
            this.valueCoder = valueCoder;
            this.typeDescriptorSupplier = typeDescriptorSupplier;
            if (hasDefault) {
                try {
                    this.encodedDefaultValue = CoderUtils.encodeToByteArray(valueCoder, defaultValue);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException: ", e);
                }
            }
        }

        @Internal
        public boolean hasDefault() {
            return this.hasDefault;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getDefaultValue() {
            if (!this.hasDefault) {
                throw new NoSuchElementException("Empty PCollection accessed as a singleton view.");
            }
            SingletonViewFn2 singletonViewFn2 = this;
            synchronized (singletonViewFn2) {
                if (this.encodedDefaultValue != null) {
                    try {
                        this.defaultValue = CoderUtils.decodeFromByteArray(this.valueCoder, this.encodedDefaultValue);
                        this.encodedDefaultValue = null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unexpected IOException: ", e);
                    }
                }
                return this.defaultValue;
            }
        }

        @Override
        public Materialization<Materializations.IterableView<T>> getMaterialization() {
            return Materializations.iterable();
        }

        @Override
        public T apply(Materializations.IterableView<T> primitiveViewT) {
            try {
                return (T)Iterables.getOnlyElement(primitiveViewT.get());
            }
            catch (NoSuchElementException exc) {
                return this.getDefaultValue();
            }
            catch (IllegalArgumentException exc) {
                throw new IllegalArgumentException("PCollection with more than one element accessed as a singleton view.");
            }
        }

        @Override
        public TypeDescriptor<T> getTypeDescriptor() {
            return (TypeDescriptor)this.typeDescriptorSupplier.get();
        }
    }

    public static interface TypeDescriptorSupplier<T>
    extends Supplier<TypeDescriptor<T>>,
    Serializable {
    }
}

