/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ReadTranslation;
import org.apache.beam.runners.direct.AutoValue_BoundedReadEvaluatorFactory_BoundedSourceShard;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.RootInputProvider;
import org.apache.beam.runners.direct.SourceShard;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.SettableFuture;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

final class BoundedReadEvaluatorFactory
implements TransformEvaluatorFactory {
    private static final long REQUIRED_DYNAMIC_SPLIT_ORIGINAL_SIZE = 0L;
    private final EvaluationContext evaluationContext;
    private final PipelineOptions options;
    @VisibleForTesting
    final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setThreadFactory(MoreExecutors.platformThreadFactory()).setDaemon(true).setNameFormat("direct-dynamic-split-requester").build());
    private final long minimumDynamicSplitSize;

    BoundedReadEvaluatorFactory(EvaluationContext evaluationContext, PipelineOptions options) {
        this(evaluationContext, options, 0L);
    }

    @VisibleForTesting
    BoundedReadEvaluatorFactory(EvaluationContext evaluationContext, PipelineOptions options, long minimumDynamicSplitSize) {
        this.evaluationContext = evaluationContext;
        this.options = options;
        this.minimumDynamicSplitSize = minimumDynamicSplitSize;
    }

    @Override
    public <InputT> @Nullable TransformEvaluator<InputT> forApplication(AppliedPTransform<?, ?, ?> application, CommittedBundle<?> inputBundle) throws IOException {
        return this.createEvaluator(application);
    }

    private <OutputT> TransformEvaluator<?> createEvaluator(AppliedPTransform<?, PCollection<OutputT>, ?> transform) {
        return new BoundedReadEvaluator<OutputT>(transform, this.evaluationContext, this.options, this.minimumDynamicSplitSize, this.executor);
    }

    @Override
    public void cleanup() {
        this.executor.shutdown();
    }

    private static class GenerateSplitAtHalfwayPoint<T>
    implements Callable<BoundedSource<T>> {
        private final BoundedSource.BoundedReader<T> reader;

        private GenerateSplitAtHalfwayPoint(BoundedSource.BoundedReader<T> reader) {
            this.reader = reader;
        }

        @Override
        public BoundedSource<T> call() throws Exception {
            Double currentlyConsumed = this.reader.getFractionConsumed();
            if (currentlyConsumed == null || currentlyConsumed == 1.0) {
                return null;
            }
            double halfwayBetweenCurrentAndCompletion = 0.5 + currentlyConsumed / 2.0;
            return this.reader.splitAtFraction(halfwayBetweenCurrentAndCompletion);
        }
    }

    static class InputProvider<T>
    implements RootInputProvider<T, BoundedSourceShard<T>, PBegin> {
        private final EvaluationContext evaluationContext;
        private final PipelineOptions options;

        InputProvider(EvaluationContext evaluationContext, PipelineOptions options) {
            this.evaluationContext = evaluationContext;
            this.options = options;
        }

        @Override
        public Collection<CommittedBundle<BoundedSourceShard<T>>> getInitialInputs(AppliedPTransform<PBegin, PCollection<T>, PTransform<PBegin, PCollection<T>>> transform, int targetParallelism) throws Exception {
            BoundedSource<T> source = ReadTranslation.boundedSourceFromTransform(transform);
            long estimatedBytes = source.getEstimatedSizeBytes(this.options);
            long bytesPerBundle = estimatedBytes / (long)targetParallelism;
            List bundles = source.split(bytesPerBundle, this.options);
            ImmutableList.Builder shards = ImmutableList.builder();
            for (BoundedSource bundle : bundles) {
                CommittedBundle inputShard = this.evaluationContext.createRootBundle().add(WindowedValue.valueInGlobalWindow(BoundedSourceShard.of(bundle))).commit(BoundedWindow.TIMESTAMP_MAX_VALUE);
                shards.add(inputShard);
            }
            return shards.build();
        }
    }

    @AutoValue
    static abstract class BoundedSourceShard<T>
    implements SourceShard<T> {
        BoundedSourceShard() {
        }

        static <T> BoundedSourceShard<T> of(BoundedSource<T> source) {
            return new AutoValue_BoundedReadEvaluatorFactory_BoundedSourceShard<T>(source);
        }

        @Override
        public abstract BoundedSource<T> getSource();
    }

    private static class BoundedReadEvaluator<OutputT>
    implements TransformEvaluator<BoundedSourceShard<OutputT>> {
        private final PCollection<OutputT> outputPCollection;
        private final EvaluationContext evaluationContext;
        private final PipelineOptions options;
        private StepTransformResult.Builder resultBuilder;
        private final long minimumDynamicSplitSize;
        private final ExecutorService produceSplitExecutor;

        public BoundedReadEvaluator(AppliedPTransform<?, PCollection<OutputT>, ?> transform, EvaluationContext evaluationContext, PipelineOptions options, long minimumDynamicSplitSize, ExecutorService executor) {
            this.evaluationContext = evaluationContext;
            this.outputPCollection = (PCollection)Iterables.getOnlyElement(transform.getOutputs().values());
            this.resultBuilder = StepTransformResult.withoutHold(transform);
            this.options = options;
            this.minimumDynamicSplitSize = minimumDynamicSplitSize;
            this.produceSplitExecutor = executor;
        }

        @Override
        public void processElement(WindowedValue<BoundedSourceShard<OutputT>> element) throws Exception {
            BoundedSource source = ((BoundedSourceShard)element.getValue()).getSource();
            try (BoundedSource.BoundedReader reader = source.createReader(this.options);){
                boolean contentsRemaining = reader.start();
                Future residualFuture = this.startDynamicSplitThread(source, reader);
                UncommittedBundle<OutputT> output = this.evaluationContext.createBundle(this.outputPCollection);
                while (contentsRemaining) {
                    output.add(WindowedValue.timestampedValueInGlobalWindow((Object)reader.getCurrent(), (Instant)reader.getCurrentTimestamp()));
                    contentsRemaining = reader.advance();
                }
                this.resultBuilder.addOutput(output, new UncommittedBundle[0]);
                try {
                    BoundedSource residual = residualFuture.get();
                    if (residual != null) {
                        this.resultBuilder.addUnprocessedElements(element.withValue(BoundedSourceShard.of(residual)));
                    }
                }
                catch (ExecutionException exex) {
                    throw UserCodeException.wrap((Throwable)exex.getCause());
                }
            }
        }

        private Future<BoundedSource<OutputT>> startDynamicSplitThread(BoundedSource<OutputT> source, BoundedSource.BoundedReader<OutputT> reader) throws Exception {
            if (source.getEstimatedSizeBytes(this.options) > this.minimumDynamicSplitSize) {
                return this.produceSplitExecutor.submit(new GenerateSplitAtHalfwayPoint(reader));
            }
            SettableFuture emptyFuture = SettableFuture.create();
            emptyFuture.set(null);
            return emptyFuture;
        }

        @Override
        public TransformResult<BoundedSourceShard<OutputT>> finishBundle() {
            return this.resultBuilder.build();
        }
    }
}

