/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin.httpserver;

import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.httpserver.InternalServerException;
import com.amazon.redshift.plugin.httpserver.RequestHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import javax.net.ServerSocketFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.DefaultBHttpServerConnectionFactory;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;

public class Server {
    private final DefaultBHttpServerConnectionFactory m_connectionFactory;
    private final HttpService m_httpService;
    private final InetAddress m_ipAddress;
    private final int m_port;
    private int local_port;
    private final RequestHandler m_handler;
    private final ServerSocketFactory m_socketFactory;
    private final SocketConfig m_defaultSocketConfig;
    private ListenerThread m_listener;
    private RedshiftLogger m_log;
    private CountDownLatch m_startSignal = null;

    public Server(int port, RequestHandler handler, Duration waitTime, RedshiftLogger log) {
        this.m_log = log;
        this.m_port = port;
        this.m_handler = handler;
        this.m_ipAddress = InetAddress.getLoopbackAddress();
        this.m_socketFactory = ServerSocketFactory.getDefault();
        this.m_defaultSocketConfig = SocketConfig.custom().setBacklogSize(1).setSoKeepAlive(false).setSoTimeout((int)waitTime.toMillis()).build();
        this.m_httpService = new HttpService(HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseContent()).add((HttpResponseInterceptor)new ResponseConnControl()).build(), (HttpRequestHandlerMapper)this.prepareRequestMapper(handler));
        this.m_connectionFactory = DefaultBHttpServerConnectionFactory.INSTANCE;
    }

    public int getLocalPort() {
        return this.local_port;
    }

    public void listen() throws IOException {
        ServerSocket serverSocket = null;
        try {
            serverSocket = this.m_socketFactory.createServerSocket(this.m_port, this.m_defaultSocketConfig.getBacklogSize(), this.m_ipAddress);
            serverSocket.setSoTimeout(this.m_defaultSocketConfig.getSoTimeout());
            this.local_port = serverSocket.getLocalPort();
            this.m_listener = new ListenerThread(serverSocket);
            this.m_startSignal = new CountDownLatch(1);
            this.m_listener.start();
            try {
                this.m_startSignal.await();
                this.m_startSignal = null;
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logError(ex.getMessage(), new Object[0]);
            }
            if (serverSocket != null) {
                serverSocket.close();
            }
            throw ex;
        }
    }

    public void waitForResult() {
        block2: {
            try {
                this.m_listener.join();
            }
            catch (InterruptedException e) {
                if (!RedshiftLogger.isEnable()) break block2;
                this.m_log.logError(e);
            }
        }
    }

    public void stop() {
        this.m_listener.interrupt();
    }

    private UriHttpRequestHandlerMapper prepareRequestMapper(HttpRequestHandler handler) {
        UriHttpRequestHandlerMapper mapper = new UriHttpRequestHandlerMapper();
        mapper.register("*", handler);
        return mapper;
    }

    public class ListenerThread
    extends Thread {
        private final ServerSocket serverSocket;

        ListenerThread(ServerSocket serverSocket) {
            super("http-listener");
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            DefaultBHttpServerConnection conn = null;
            try {
                Server.this.m_startSignal.countDown();
                Socket socket = this.serverSocket.accept();
                socket.setKeepAlive(Server.this.m_defaultSocketConfig.isSoKeepAlive());
                socket.setTcpNoDelay(Server.this.m_defaultSocketConfig.isTcpNoDelay());
                if (Server.this.m_defaultSocketConfig.getRcvBufSize() > 0) {
                    socket.setReceiveBufferSize(Server.this.m_defaultSocketConfig.getRcvBufSize());
                }
                if (Server.this.m_defaultSocketConfig.getSndBufSize() > 0) {
                    socket.setSendBufferSize(Server.this.m_defaultSocketConfig.getSndBufSize());
                }
                if (Server.this.m_defaultSocketConfig.getSoLinger() >= 0) {
                    socket.setSoLinger(true, Server.this.m_defaultSocketConfig.getSoLinger());
                }
                conn = Server.this.m_connectionFactory.createConnection(socket);
                BasicHttpContext localContext = new BasicHttpContext();
                HttpCoreContext context = HttpCoreContext.adapt((HttpContext)localContext);
                Server.this.m_httpService.handleRequest((HttpServerConnection)conn, (HttpContext)context);
                localContext.clear();
                conn.close();
                conn = null;
            }
            catch (SocketTimeoutException ex) {
                if (RedshiftLogger.isEnable()) {
                    Server.this.m_log.logError(ex);
                }
            }
            catch (IOException | HttpException e) {
                if (RedshiftLogger.isEnable()) {
                    Server.this.m_log.logError((Exception)e);
                }
                throw InternalServerException.wrap((Exception)e);
            }
            finally {
                block28: {
                    block27: {
                        try {
                            if (conn != null) {
                                conn.shutdown();
                            }
                        }
                        catch (IOException e) {
                            if (!RedshiftLogger.isEnable()) break block27;
                            Server.this.m_log.logError(e);
                        }
                    }
                    try {
                        if (!this.serverSocket.isClosed()) {
                            this.serverSocket.close();
                        }
                    }
                    catch (IOException e) {
                        if (!RedshiftLogger.isEnable()) break block28;
                        Server.this.m_log.logError(e);
                    }
                }
            }
        }
    }
}

