/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.util;

import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.SwtUniversalImage;
import org.apache.hop.core.SwtUniversalImageBitmap;
import org.apache.hop.core.SwtUniversalImageSvg;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.svg.SvgCache;
import org.apache.hop.core.svg.SvgCacheEntry;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.svg.SvgImage;
import org.apache.hop.core.svg.SvgSupport;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;

public class SwtSvgImageUtil {
    private static ILogChannel log = new LogChannel((Object)"SwtSvgImageUtil");
    private static final String NO_IMAGE = "ui/images/no_image.svg";
    private static FileObject base;
    private static double zoomFactor;

    public static SwtUniversalImage getMissingImage(Display display) {
        Image img = new Image((Device)display, 32, 32);
        if (!EnvironmentUtils.getInstance().isWeb()) {
            GC gc = new GC((Drawable)img);
            gc.setForeground(new Color((Device)display, PropsUi.getInstance().contrastColor(0, 0, 0)));
            gc.drawRectangle(4, 4, 24, 24);
            gc.setForeground(new Color((Device)display, PropsUi.getInstance().contrastColor(255, 0, 0)));
            gc.drawLine(4, 4, 28, 28);
            gc.drawLine(28, 4, 4, 28);
            gc.dispose();
        }
        return new SwtUniversalImageBitmap(img, zoomFactor);
    }

    private static SwtUniversalImage getImageAsResourceInternal(Display display, String location) {
        SwtUniversalImage result = null;
        result = SwtSvgImageUtil.loadFromCurrentClasspath(location);
        if (result == null) {
            result = SwtSvgImageUtil.loadFromBasedVFS(display, location);
        }
        if (result == null) {
            result = SwtSvgImageUtil.loadFromSimpleVFS(display, location);
        }
        return result;
    }

    public static SwtUniversalImage getImageAsResource(Display display, String location) {
        if (location == null) {
            throw new RuntimeException("No location given to load image resource");
        }
        SwtUniversalImage result = null;
        if (result == null && SvgSupport.isSvgEnabled()) {
            result = SwtSvgImageUtil.getImageAsResourceInternal(display, SvgSupport.toSvgName((String)location));
        }
        if (result == null) {
            result = SwtSvgImageUtil.getImageAsResourceInternal(display, SvgSupport.toPngName((String)location));
        }
        if (result == null && !location.equals(NO_IMAGE)) {
            log.logError("Unable to load image [" + location + "]", (Throwable)new Exception());
            result = SwtSvgImageUtil.getImageAsResource(display, NO_IMAGE);
        }
        if (result == null) {
            log.logError("Unable to load image [" + location + "]", (Throwable)new Exception());
            result = SwtSvgImageUtil.getMissingImage(display);
        }
        return result;
    }

    public static Image getImage(Display display, ClassLoader classLoader, String filename, int width, int height) {
        SwtUniversalImage u = SwtSvgImageUtil.getUniversalImage(display, classLoader, filename);
        return u.getAsBitmapForSize((Device)display, width, height);
    }

    private static SwtUniversalImage getUniversalImageInternal(Display display, ClassLoader classLoader, String filename) {
        SwtUniversalImage result = SwtSvgImageUtil.loadFromClassLoader(classLoader, filename);
        if (result == null && (result = SwtSvgImageUtil.loadFromClassLoader(classLoader, "/" + filename)) == null && (result = SwtSvgImageUtil.loadFromClassLoader(classLoader, "ui/images/" + filename)) == null) {
            result = SwtSvgImageUtil.getImageAsResourceInternal(display, filename);
        }
        return result;
    }

    public static SwtUniversalImage getUniversalImage(Display display, ClassLoader classLoader, String filename) {
        if (StringUtils.isBlank((String)filename)) {
            return SwtSvgImageUtil.getImageAsResource(display, NO_IMAGE);
        }
        SwtUniversalImage result = null;
        if (SvgSupport.isSvgEnabled()) {
            result = SwtSvgImageUtil.getUniversalImageInternal(display, classLoader, SvgSupport.toSvgName((String)filename));
        }
        if (result == null) {
            result = SwtSvgImageUtil.getUniversalImageInternal(display, classLoader, SvgSupport.toPngName((String)filename));
        }
        if (result == null) {
            log.logError("Unable to load image [" + filename + "]", (Throwable)new Exception());
            result = SwtSvgImageUtil.getImageAsResource(display, NO_IMAGE);
        }
        return result;
    }

    public static SwtUniversalImage getImage(Display display, String location) {
        return SwtSvgImageUtil.getImageAsResource(display, location);
    }

    private static SwtUniversalImage loadFromClassLoader(ClassLoader classLoader, String location) {
        try {
            SvgCacheEntry cacheEntry = SvgCache.loadSvg((SvgFile)new SvgFile(location, classLoader));
            SvgImage svgImage = new SvgImage((Document)cacheEntry.getSvgDocument());
            return new SwtUniversalImageSvg(svgImage);
        }
        catch (Throwable e) {
            log.logError("Error loading image from location '" + location + "'", e);
            return null;
        }
    }

    private static SwtUniversalImage loadFromCurrentClasspath(String location) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = SwtSvgImageUtil.class.getClassLoader();
        }
        URL res = null;
        try {
            res = cl.getResource(location);
        }
        catch (Throwable t) {
            log.logDebug("Unable to load image from classloader [" + location + "]", new Object[]{t});
        }
        if (res == null) {
            return null;
        }
        return SwtSvgImageUtil.loadFromClassLoader(cl, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwtUniversalImage loadFromBasedVFS(Display display, String location) {
        SwtUniversalImage swtUniversalImage;
        FileObject imageFileObject = HopVfs.getFileSystemManager().resolveFile(base, location);
        InputStream s = HopVfs.getInputStream((FileObject)imageFileObject);
        if (s == null) {
            return null;
        }
        try {
            swtUniversalImage = SwtSvgImageUtil.loadImage(display, s, location);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)s);
                throw throwable;
            }
            catch (FileSystemException ex) {
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)s);
        return swtUniversalImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwtUniversalImage loadFromSimpleVFS(Display display, String location) {
        SwtUniversalImage swtUniversalImage;
        InputStream s = HopVfs.getInputStream((String)location);
        if (s == null) {
            return null;
        }
        try {
            swtUniversalImage = SwtSvgImageUtil.loadImage(display, s, location);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)s);
                throw throwable;
            }
            catch (HopFileException hopFileException) {
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)s);
        return swtUniversalImage;
    }

    private static SwtUniversalImage loadImage(Display display, InputStream in, String filename) {
        if (!SvgSupport.isSvgName((String)filename)) {
            return new SwtUniversalImageBitmap(new Image((Device)display, in), zoomFactor);
        }
        try {
            return new SwtUniversalImageSvg(SvgSupport.loadSvgImage((InputStream)in));
        }
        catch (Exception ex) {
            throw new RuntimeException("Error loading file " + filename, ex);
        }
    }

    static {
        zoomFactor = PropsUi.getInstance().getZoomFactor();
        try {
            base = HopVfs.getFileSystemManager().resolveFile(System.getProperty("user.dir"));
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            base = null;
        }
    }
}

