/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.importer;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.neo4j.transforms.gencsv.StreamConsumer;
import org.apache.hop.neo4j.transforms.importer.ImporterData;
import org.apache.hop.neo4j.transforms.importer.ImporterMeta;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

public class Importer
extends BaseTransform<ImporterMeta, ImporterData> {
    public Importer(TransformMeta transformMeta, ImporterMeta meta, ImporterData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            if (((ImporterData)this.data).nodesFiles != null && !((ImporterData)this.data).nodesFiles.isEmpty() || ((ImporterData)this.data).relsFiles != null && !((ImporterData)this.data).relsFiles.isEmpty()) {
                this.runImport();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((ImporterData)this.data).nodesFiles = new ArrayList<String>();
            ((ImporterData)this.data).relsFiles = new ArrayList<String>();
            ((ImporterData)this.data).filenameFieldIndex = this.getInputRowMeta().indexOfValue(((ImporterMeta)this.meta).getFilenameField());
            if (((ImporterData)this.data).filenameFieldIndex < 0) {
                throw new HopException("Unable to find filename field " + ((ImporterMeta)this.meta).getFilenameField() + "' in the transform input");
            }
            ((ImporterData)this.data).fileTypeFieldIndex = this.getInputRowMeta().indexOfValue(((ImporterMeta)this.meta).getFileTypeField());
            if (((ImporterData)this.data).fileTypeFieldIndex < 0) {
                throw new HopException("Unable to find file type field " + ((ImporterMeta)this.meta).getFileTypeField() + "' in the transform input");
            }
            ((ImporterData)this.data).adminCommand = StringUtils.isEmpty((String)((ImporterMeta)this.meta).getAdminCommand()) ? "neo4j-admin" : this.resolve(((ImporterMeta)this.meta).getAdminCommand());
            ((ImporterData)this.data).databaseFilename = this.resolve(((ImporterMeta)this.meta).getDatabaseName());
            ((ImporterData)this.data).reportFile = this.resolve(((ImporterMeta)this.meta).getReportFile());
            ((ImporterData)this.data).baseFolder = this.resolve(((ImporterMeta)this.meta).getBaseFolder());
            if (!((ImporterData)this.data).baseFolder.endsWith(File.separator)) {
                ((ImporterData)this.data).baseFolder = ((ImporterData)this.data).baseFolder + File.separator;
            }
            ((ImporterData)this.data).importFolder = ((ImporterData)this.data).baseFolder + "import/";
            ((ImporterData)this.data).badTolerance = this.resolve(((ImporterMeta)this.meta).getBadTolerance());
            ((ImporterData)this.data).readBufferSize = this.resolve(((ImporterMeta)this.meta).getReadBufferSize());
            ((ImporterData)this.data).maxMemory = this.resolve(((ImporterMeta)this.meta).getMaxMemory());
            ((ImporterData)this.data).processors = this.resolve(((ImporterMeta)this.meta).getProcessors());
        }
        String filename = this.getInputRowMeta().getString(row, ((ImporterData)this.data).filenameFieldIndex);
        String fileType = this.getInputRowMeta().getString(row, ((ImporterData)this.data).fileTypeFieldIndex);
        if (StringUtils.isNotEmpty((String)filename) && StringUtils.isNotEmpty((String)fileType)) {
            if ("Node".equalsIgnoreCase(fileType) || "Nodes".equalsIgnoreCase(fileType) || "N".equalsIgnoreCase(fileType)) {
                ((ImporterData)this.data).nodesFiles.add(filename);
            }
            if ("Relationship".equalsIgnoreCase(fileType) || "Relationships".equalsIgnoreCase(fileType) || "Rel".equalsIgnoreCase(fileType) || "Rels".equalsIgnoreCase(fileType) || "R".equalsIgnoreCase(fileType) || "Edge".equalsIgnoreCase(fileType) || "Edges".equalsIgnoreCase(fileType) || "E".equalsIgnoreCase(fileType)) {
                ((ImporterData)this.data).relsFiles.add(filename);
            }
        }
        this.putRow(this.getInputRowMeta(), row);
        return true;
    }

    private void runImport() throws HopException {
        String targetDbFolder = ((ImporterData)this.data).baseFolder + "data/databases/" + ((ImporterData)this.data).databaseFilename;
        try {
            if (new File(targetDbFolder).exists()) {
                this.log.logBasic("Removing exsting folder: " + targetDbFolder);
                FileUtils.deleteDirectory((File)new File(targetDbFolder));
            }
        }
        catch (Exception e) {
            throw new HopException("Unable to remove old database files from '" + targetDbFolder + "'", (Throwable)e);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(((ImporterData)this.data).adminCommand);
        arguments.add("import");
        arguments.add("--database=" + ((ImporterData)this.data).databaseFilename);
        arguments.add("--id-type=STRING");
        arguments.add("--report-file=" + ((ImporterData)this.data).reportFile);
        arguments.add("--high-io=" + (((ImporterMeta)this.meta).isHighIo() ? "true" : "false"));
        arguments.add("--cache-on-heap=" + (((ImporterMeta)this.meta).isHighIo() ? "true" : "false"));
        arguments.add("--ignore-empty-strings=" + (((ImporterMeta)this.meta).isIgnoringEmptyStrings() ? "true" : "false"));
        arguments.add("--ignore-extra-columns=" + (((ImporterMeta)this.meta).isIgnoringExtraColumns() ? "true" : "false"));
        arguments.add("--legacy-style-quoting=" + (((ImporterMeta)this.meta).isQuotingLegacyStyle() ? "true" : "false"));
        arguments.add("--multiline-fields=" + (((ImporterMeta)this.meta).isMultiLine() ? "true" : "false"));
        arguments.add("--normalize-types=" + (((ImporterMeta)this.meta).isNormalizingTypes() ? "true" : "false"));
        arguments.add("--skip-duplicate-nodes=" + (((ImporterMeta)this.meta).isSkippingDuplicateNodes() ? "true" : "false"));
        arguments.add("--skip-bad-relationships=" + (((ImporterMeta)this.meta).isSkippingBadRelationships() ? "true" : "false"));
        arguments.add("--trim-strings=" + (((ImporterMeta)this.meta).isTrimmingStrings() ? "true" : "false"));
        if (StringUtils.isNotEmpty((String)((ImporterData)this.data).badTolerance)) {
            arguments.add("--bad-tolerance=" + ((ImporterData)this.data).badTolerance);
        }
        if (StringUtils.isNotEmpty((String)((ImporterData)this.data).readBufferSize)) {
            arguments.add("--read-buffer-size=" + ((ImporterData)this.data).readBufferSize);
        }
        if (StringUtils.isNotEmpty((String)((ImporterData)this.data).maxMemory)) {
            arguments.add("--max-memory=" + ((ImporterData)this.data).maxMemory);
        }
        for (String string : ((ImporterData)this.data).nodesFiles) {
            arguments.add("--nodes=" + string);
        }
        for (String string : ((ImporterData)this.data).relsFiles) {
            arguments.add("--relationships=" + string);
        }
        StringBuffer command = new StringBuffer();
        for (String argument : arguments) {
            command.append(argument).append(" ");
        }
        this.log.logBasic("Running command : " + String.valueOf(command));
        this.log.logBasic("Running from base folder: " + ((ImporterData)this.data).baseFolder);
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        processBuilder.directory(new File(((ImporterData)this.data).baseFolder));
        try {
            Process process = processBuilder.start();
            StreamConsumer errorConsumer = new StreamConsumer(this.getLogChannel(), process.getErrorStream(), LogLevel.ERROR);
            errorConsumer.start();
            StreamConsumer outputConsumer = new StreamConsumer(this.getLogChannel(), process.getInputStream(), LogLevel.BASIC);
            outputConsumer.start();
            boolean exited = process.waitFor(10L, TimeUnit.MILLISECONDS);
            while (!exited && !this.isStopped()) {
                exited = process.waitFor(10L, TimeUnit.MILLISECONDS);
            }
            if (!exited && this.isStopped()) {
                process.destroyForcibly();
            }
        }
        catch (Exception e) {
            throw new HopException("Error running command: " + String.valueOf(arguments), (Throwable)e);
        }
    }
}

