/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats;

import com.clickhouse.client.api.data_formats.ClickHouseBinaryFormatWriter;
import com.clickhouse.client.api.data_formats.RowBinaryFormatSerializer;
import com.clickhouse.client.api.data_formats.internal.SerializerUtils;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;

public class RowBinaryFormatWriter
implements ClickHouseBinaryFormatWriter {
    private final OutputStream out;
    private final TableSchema tableSchema;
    private final Object[] row;
    private final boolean defaultSupport;
    private int rowCount = 0;
    private boolean rowStarted = false;

    public RowBinaryFormatWriter(OutputStream out, TableSchema tableSchema, ClickHouseFormat format) {
        if (format != ClickHouseFormat.RowBinary && format != ClickHouseFormat.RowBinaryWithDefaults) {
            throw new IllegalArgumentException("Only RowBinary and RowBinaryWithDefaults are supported");
        }
        this.out = out;
        this.tableSchema = tableSchema;
        this.row = new Object[tableSchema.getColumns().size()];
        this.defaultSupport = format == ClickHouseFormat.RowBinaryWithDefaults;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public ClickHouseFormat getFormat() {
        return this.defaultSupport ? ClickHouseFormat.RowBinaryWithDefaults : ClickHouseFormat.RowBinary;
    }

    @Override
    public void clearRow() {
        Arrays.fill(this.row, null);
        this.rowStarted = false;
    }

    @Override
    public void setValue(String column, Object value) {
        this.setValue(this.tableSchema.nameToColumnIndex(column), value);
    }

    @Override
    public void setValue(int colIndex, Object value) {
        this.row[colIndex - 1] = value;
        if (!this.rowStarted) {
            this.rowStarted = true;
        }
    }

    @Override
    public void commitRow() throws IOException {
        if (this.rowStarted) {
            List<ClickHouseColumn> columnList = this.tableSchema.getColumns();
            for (int i = 0; i < this.row.length; ++i) {
                ClickHouseColumn column = columnList.get(i);
                if (column.hasDefault() && column.getDefaultValue() != ClickHouseColumn.DefaultValue.DEFAULT || !RowBinaryFormatSerializer.writeValuePreamble(this.out, this.defaultSupport, column, this.row[i])) continue;
                SerializerUtils.serializeData(this.out, this.row[i], column);
            }
            this.clearRow();
            ++this.rowCount;
        }
    }

    @Override
    public void setByte(String column, byte value) {
        this.setValue(column, (Object)value);
    }

    @Override
    public void setByte(int colIndex, byte value) {
        this.setValue(colIndex, (Object)value);
    }

    @Override
    public void setShort(String column, short value) {
        this.setValue(column, (Object)value);
    }

    @Override
    public void setShort(int colIndex, short value) {
        this.setValue(colIndex, (Object)value);
    }

    @Override
    public void setInteger(String column, int value) {
        this.setValue(column, (Object)value);
    }

    @Override
    public void setInteger(int colIndex, int value) {
        this.setValue(colIndex, (Object)value);
    }

    @Override
    public void setLong(String column, long value) {
        this.setValue(column, (Object)value);
    }

    @Override
    public void setLong(int colIndex, long value) {
        this.setValue(colIndex, (Object)value);
    }

    @Override
    public void setBigInteger(int colIndex, BigInteger value) {
        this.setValue(colIndex, (Object)value);
    }

    @Override
    public void setBigInteger(String column, BigInteger value) {
        this.setValue(column, (Object)value);
    }

    @Override
    public void setFloat(int colIndex, float value) {
        this.setValue(colIndex, (Object)Float.valueOf(value));
    }

    @Override
    public void setFloat(String column, float value) {
        this.setValue(column, (Object)Float.valueOf(value));
    }

    @Override
    public void setDouble(int colIndex, double value) {
        this.setValue(colIndex, (Object)value);
    }

    @Override
    public void setDouble(String column, double value) {
        this.setValue(column, (Object)value);
    }

    @Override
    public void setBigDecimal(int colIndex, BigDecimal value) {
        this.setValue(colIndex, (Object)value);
    }

    @Override
    public void setBigDecimal(String column, BigDecimal value) {
        this.setValue(column, (Object)value);
    }

    @Override
    public void setBoolean(int colIndex, boolean value) {
        this.setValue(colIndex, (Object)value);
    }

    @Override
    public void setBoolean(String column, boolean value) {
        this.setValue(column, (Object)value);
    }

    @Override
    public void setString(String column, String value) {
        this.setValue(column, (Object)value);
    }

    @Override
    public void setString(int colIndex, String value) {
        this.setValue(colIndex, (Object)value);
    }

    @Override
    public void setDate(String column, LocalDate value) {
        this.setValue(column, (Object)value);
    }

    @Override
    public void setDate(int colIndex, LocalDate value) {
        this.setValue(colIndex, (Object)value);
    }

    @Override
    public void setDateTime(String column, LocalDateTime value) {
        this.setValue(column, (Object)value);
    }

    @Override
    public void setDateTime(int colIndex, LocalDateTime value) {
        this.setValue(colIndex, (Object)value);
    }

    @Override
    public void setDateTime(String column, ZonedDateTime value) {
        this.setValue(column, (Object)value);
    }

    @Override
    public void setDateTime(int colIndex, ZonedDateTime value) {
        this.setValue(colIndex, (Object)value);
    }

    @Override
    public void setList(String column, List<?> value) {
        this.setValue(column, value);
    }

    @Override
    public void setList(int colIndex, List<?> value) {
        this.setValue(colIndex, value);
    }

    @Override
    public void setInputStream(int colIndex, InputStream in, long len) {
        this.setValue(colIndex, (Object)new InputStreamHolder(in, len));
    }

    @Override
    public void setInputStream(String column, InputStream in, long len) {
        this.setValue(column, (Object)new InputStreamHolder(in, len));
    }

    @Override
    public void setReader(int colIndex, Reader reader, long len) {
        this.setValue(colIndex, (Object)new ReaderHolder(reader, len));
    }

    @Override
    public void setReader(String column, Reader reader, long len) {
        this.setValue(column, (Object)new ReaderHolder(reader, len));
    }

    private static class InputStreamHolder {
        final InputStream stream;
        final long length;

        InputStreamHolder(InputStream stream, long length) {
            this.stream = stream;
            this.length = length;
        }
    }

    private static class ReaderHolder {
        final Reader read;
        final long length;

        ReaderHolder(Reader reader, long length) {
            this.read = reader;
            this.length = length;
        }
    }
}

