/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.runners.core.metrics.ExecutionStateTracker;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTimeUtils;

public class ExecutionStateSampler {
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized ExecutionStateTracker> activeTrackers = ConcurrentHashMap.newKeySet();
    private static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DateTimeUtils.MillisProvider SYSTEM_MILLIS_PROVIDER = System::currentTimeMillis;
    private static final @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler INSTANCE = new ExecutionStateSampler(SYSTEM_MILLIS_PROVIDER);
    protected final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DateTimeUtils.MillisProvider clock;
    @VisibleForTesting
    protected volatile @UnknownKeyFor @NonNull @Initialized long lastSampleTimeMillis;
    private static @UnknownKeyFor @NonNull @Initialized long periodMs = 200L;
    private @Nullable @UnknownKeyFor @Initialized Future<@UnknownKeyFor @Nullable @Initialized Void> executionSamplerFuture = null;

    protected ExecutionStateSampler(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DateTimeUtils.MillisProvider clock) {
        this.clock = clock;
    }

    public static @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler newForTest() {
        return new ExecutionStateSampler(SYSTEM_MILLIS_PROVIDER);
    }

    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized ExecutionStateSampler newForTest(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DateTimeUtils.MillisProvider clock) {
        return new ExecutionStateSampler((DateTimeUtils.MillisProvider)Preconditions.checkNotNull((Object)clock));
    }

    public static void setSamplingPeriod(@UnknownKeyFor @NonNull @Initialized long samplingPeriodMillis) {
        periodMs = samplingPeriodMillis;
    }

    public void reset() {
        this.lastSampleTimeMillis = 0L;
    }

    public void start() {
        this.start(Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("state-sampler-%d").build()));
    }

    @VisibleForTesting
    synchronized void start(@UnknownKeyFor @NonNull @Initialized ExecutorService executor) {
        if (this.executionSamplerFuture != null) {
            return;
        }
        this.executionSamplerFuture = executor.submit(() -> {
            this.lastSampleTimeMillis = this.clock.getMillis();
            long targetTimeMillis = this.lastSampleTimeMillis + periodMs;
            while (!Thread.interrupted()) {
                long currentTimeMillis = this.clock.getMillis();
                long difference = targetTimeMillis - currentTimeMillis;
                if (difference > 0L) {
                    try {
                        Thread.sleep(difference);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                this.doSampling(currentTimeMillis - this.lastSampleTimeMillis);
                this.lastSampleTimeMillis = currentTimeMillis;
                targetTimeMillis = this.lastSampleTimeMillis + periodMs;
            }
            return null;
        });
    }

    public synchronized void stop() {
        Future<Void> executionSamplerFuture = this.executionSamplerFuture;
        if (executionSamplerFuture == null) {
            return;
        }
        executionSamplerFuture.cancel(true);
        try {
            executionSamplerFuture.get(5L * periodMs, TimeUnit.MILLISECONDS);
        }
        catch (CancellationException cancellationException) {
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Failed to stop state sampling after waiting 5 sampling periods.", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Exception in state sampler", e);
        }
        finally {
            this.executionSamplerFuture = null;
        }
    }

    protected void addTracker(@UnknownKeyFor @NonNull @Initialized ExecutionStateTracker tracker) {
        this.activeTrackers.add(tracker);
    }

    protected void removeTracker(@UnknownKeyFor @NonNull @Initialized ExecutionStateTracker tracker) {
        this.activeTrackers.remove(tracker);
        long millisSinceLastSample = this.clock.getMillis() - this.lastSampleTimeMillis;
        if (millisSinceLastSample > 0L) {
            tracker.takeSample(millisSinceLastSample);
        }
    }

    @VisibleForTesting
    public void doSampling(@UnknownKeyFor @NonNull @Initialized long millisSinceLastSample) {
        for (ExecutionStateTracker tracker : this.activeTrackers) {
            tracker.takeSample(millisSinceLastSample);
        }
    }
}

