/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.vaccess.ActionCompletedEventSupport;
import com.ibm.as400.vaccess.DBCellRenderer;
import com.ibm.as400.vaccess.DBDateCellRenderer;
import com.ibm.as400.vaccess.ErrorEvent;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.SQLResultSetData;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.SQLWarning;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class SQLResultSetFormPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private transient JLabel recordLabel_;
    private transient JLabel recordNumber_;
    transient JButton firstButton_;
    transient JButton lastButton_;
    transient JButton nextButton_;
    transient JButton previousButton_;
    transient JButton refreshButton_;
    private transient JLabel[] labels_ = new JLabel[0];
    private transient JTextField[] values_ = new JTextField[0];
    private transient DBCellRenderer[] formatter_ = new DBCellRenderer[0];
    private JLabel status_;
    private JPanel dataArea_;
    private DBCellRenderer leftCell_ = new DBCellRenderer(2);
    private DBDateCellRenderer dateCell_ = new DBDateCellRenderer(3);
    private DBDateCellRenderer timeCell_ = new DBDateCellRenderer(1);
    private DBDateCellRenderer timestampCell_ = new DBDateCellRenderer(2);
    private static final int TYPE_CHAR = 1;
    private static final int TYPE_TIME = 2;
    private static final int TYPE_TIMESTAMP = 3;
    private static final int TYPE_DATE = 4;
    private static final int TYPE_BIT = 5;
    private transient ActionCompletedEventSupport actionListeners_ = new ActionCompletedEventSupport(this);
    transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    transient int current_ = -1;
    private SQLResultSetData tableData_ = new SQLResultSetData();
    transient boolean error_;
    private transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);

    public SQLResultSetFormPane() {
        this.addFocusListener(new SerializationListener(this));
        this.tableData_.addErrorListener(new ErrorListener_());
        this.tableData_.addWorkingListener(this.worker_);
        this.init();
    }

    public SQLResultSetFormPane(SQLConnection connection, String query) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        if (query == null) {
            throw new NullPointerException("query");
        }
        this.addFocusListener(new SerializationListener(this));
        this.tableData_.setConnection(connection);
        this.tableData_.setQuery(query);
        this.tableData_.addErrorListener(new ErrorListener_());
        this.tableData_.addWorkingListener(this.worker_);
        this.init();
    }

    public void addActionCompletedListener(ActionCompletedListener listener) {
        this.actionListeners_.addActionCompletedListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners_.addErrorListener(listener);
    }

    public void clearWarnings() {
        this.tableData_.clearWarnings();
    }

    public void close() {
        this.tableData_.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFirst() {
        SQLResultSetFormPane sQLResultSetFormPane = this;
        synchronized (sQLResultSetFormPane) {
            this.current_ = 0;
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayLast() {
        SQLResultSetFormPane sQLResultSetFormPane = this;
        synchronized (sQLResultSetFormPane) {
            this.error_ = false;
            this.current_ = this.tableData_.getNumberOfRows() - 1;
            if (this.error_) {
                this.current_ = this.tableData_.getLastRecordProcessed();
            }
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayNext() {
        SQLResultSetFormPane sQLResultSetFormPane = this;
        synchronized (sQLResultSetFormPane) {
            this.current_ = this.tableData_.getAllRecordsProcessed() ? (this.current_ + 1 == this.tableData_.getNumberOfRows() ? 0 : ++this.current_) : ++this.current_;
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayPrevious() {
        SQLResultSetFormPane sQLResultSetFormPane = this;
        synchronized (sQLResultSetFormPane) {
            if (this.current_ < 1) {
                this.error_ = false;
                this.current_ = this.tableData_.getNumberOfRows() - 1;
                if (this.error_) {
                    this.current_ = this.tableData_.getLastRecordProcessed();
                }
            } else {
                --this.current_;
            }
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    public SQLConnection getConnection() {
        return this.tableData_.getConnection();
    }

    public synchronized int getCurrentRecord() {
        return this.current_;
    }

    public synchronized String getLabelText(int index) {
        return this.labels_[index].getText();
    }

    public String getQuery() {
        String result = this.tableData_.getQuery();
        if (result == null) {
            return "";
        }
        return result;
    }

    public synchronized String getStringValueAt(int index) {
        return this.values_[index].getText();
    }

    public synchronized Object getValueAt(int index) {
        return this.tableData_.getValueAt(this.current_, index);
    }

    public SQLWarning getWarnings() {
        return this.tableData_.getWarnings();
    }

    private void init() {
        this.recordLabel_ = new JLabel(ResourceLoader.getText("DBFORM_LABEL_RECORD_NUMBER"));
        this.recordNumber_ = new JLabel();
        String text = ResourceLoader.getText("DBFORM_TOOLTIP_FIRST");
        this.firstButton_ = new JButton(ResourceLoader.getIcon("FirstIcon.gif", text));
        this.firstButton_.setToolTipText(text);
        text = ResourceLoader.getText("DBFORM_TOOLTIP_LAST");
        this.lastButton_ = new JButton(ResourceLoader.getIcon("LastIcon.gif", text));
        this.lastButton_.setToolTipText(text);
        text = ResourceLoader.getText("DBFORM_TOOLTIP_NEXT");
        this.nextButton_ = new JButton(ResourceLoader.getIcon("NextIcon.gif", text));
        this.nextButton_.setToolTipText(text);
        text = ResourceLoader.getText("DBFORM_TOOLTIP_PREVIOUS");
        this.previousButton_ = new JButton(ResourceLoader.getIcon("PreviousIcon.gif", text));
        this.previousButton_.setToolTipText(text);
        text = ResourceLoader.getText("DBFORM_TOOLTIP_REFRESH");
        this.refreshButton_ = new JButton(ResourceLoader.getIcon("RefreshIcon.gif", null));
        this.refreshButton_.setToolTipText(text);
        ButtonListener_ l = new ButtonListener_();
        this.firstButton_.addActionListener(l);
        this.lastButton_.addActionListener(l);
        this.nextButton_.addActionListener(l);
        this.previousButton_.addActionListener(l);
        this.refreshButton_.addActionListener(l);
        this.dataArea_ = new JPanel();
        this.dataArea_.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.status_ = new JLabel(ResourceLoader.getText("DBFORM_MSG_NO_DATA"));
        this.setLayout(new BorderLayout());
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(1));
        panel1.add(this.firstButton_);
        panel1.add(this.previousButton_);
        panel1.add(this.nextButton_);
        panel1.add(this.lastButton_);
        panel1.add(this.refreshButton_);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(1));
        panel2.add(this.status_);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", panel1);
        panel.add("South", panel2);
        this.add("South", panel);
        panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.recordLabel_);
        panel.add(this.recordNumber_);
        this.add("North", panel);
        this.add("Center", this.dataArea_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        SQLResultSetFormPane sQLResultSetFormPane = this;
        synchronized (sQLResultSetFormPane) {
            this.dataArea_.removeAll();
            IllegalStateException exception = null;
            this.error_ = false;
            if (this.tableData_.getConnection() == null) {
                exception = new IllegalStateException("connection");
                this.error_ = true;
            } else if (this.tableData_.getQuery() == null) {
                exception = new IllegalStateException("query");
                this.error_ = true;
            } else {
                this.tableData_.load();
            }
            if (this.error_) {
                this.values_ = new JTextField[0];
                this.labels_ = new JLabel[0];
                this.current_ = -1;
                this.refreshScreen();
                if (exception != null) {
                    throw exception;
                }
                return;
            }
            int num = this.tableData_.getNumberOfColumns();
            this.labels_ = new JLabel[num];
            this.values_ = new JTextField[num];
            this.formatter_ = new DBCellRenderer[num];
            this.dataArea_.setLayout(new GridLayout(num, 1));
            for (int i = 0; i < num; ++i) {
                JLabel label;
                this.labels_[i] = label = new JLabel(this.tableData_.getColumnLabel(i));
                int type = this.tableData_.getColumnType(i);
                int sqltype = this.tableData_.getColumnType(i);
                switch (sqltype) {
                    case 91: {
                        type = 4;
                        break;
                    }
                    case 92: {
                        type = 2;
                        break;
                    }
                    case 93: {
                        type = 3;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        type = 5;
                        break;
                    }
                    default: {
                        type = 1;
                    }
                }
                int size = this.tableData_.getColumnDisplaySize(i);
                if (type == 5) {
                    size *= 2;
                }
                JTextField value = new JTextField(size);
                value.setEditable(false);
                this.values_[i] = value;
                this.formatter_[i] = type == 4 ? this.dateCell_ : (type == 2 ? this.timeCell_ : (type == 3 ? this.timestampCell_ : this.leftCell_));
                JPanel panel = new JPanel();
                panel.setLayout(new FlowLayout(0));
                panel.add(this.labels_[i]);
                panel.add(this.values_[i]);
                this.dataArea_.add(panel);
            }
            this.current_ = 0;
            this.refreshScreen();
        }
        this.actionListeners_.fireActionCompleted();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.actionListeners_ = new ActionCompletedEventSupport(this);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.worker_ = new WorkingCursorAdapter(this);
        this.labels_ = new JLabel[0];
        this.values_ = new JTextField[0];
        this.formatter_ = new DBCellRenderer[0];
        this.current_ = -1;
        this.tableData_.addErrorListener(new ErrorListener_());
        this.tableData_.addWorkingListener(this.worker_);
        this.init();
    }

    private void refreshScreen() {
        if (this.tableData_.getAllRecordsProcessed() && this.tableData_.getNumberOfRows() == 0) {
            this.current_ = -1;
        }
        if (this.current_ == -1) {
            this.status_.setText(ResourceLoader.getText("DBFORM_MSG_NO_DATA"));
            int num = this.values_.length;
            for (int i = 0; i < num; ++i) {
                this.values_[i].setText("");
            }
            this.recordNumber_.setText("");
        } else {
            int num = this.values_.length;
            for (int i = 0; i < num; ++i) {
                Object data = this.tableData_.getValueAt(this.current_, i);
                this.values_[i].setText(this.formatter_[i].getText(data));
            }
            this.recordNumber_.setText(String.valueOf(this.current_ + 1));
            this.recordNumber_.setSize(this.recordNumber_.getPreferredSize());
            this.status_.setText("");
        }
        this.validate();
    }

    public void removeActionCompletedListener(ActionCompletedListener listener) {
        this.actionListeners_.removeActionCompletedListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorListeners_.removeErrorListener(listener);
    }

    public void setConnection(SQLConnection connection) throws PropertyVetoException {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        SQLConnection old = this.getConnection();
        this.fireVetoableChange("connection", old, connection);
        this.tableData_.setConnection(connection);
        this.firePropertyChange("connection", old, connection);
    }

    public synchronized void setLabelText(int index, String text) {
        this.labels_[index].setText(text);
    }

    public void setQuery(String query) throws PropertyVetoException {
        if (query == null) {
            throw new NullPointerException("query");
        }
        String old = this.getQuery();
        this.fireVetoableChange("query", old, query);
        this.tableData_.setQuery(query);
        this.firePropertyChange("query", old, query);
    }

    private class ErrorListener_
    implements ErrorListener {
        private ErrorListener_() {
        }

        @Override
        public void errorOccurred(ErrorEvent event) {
            SQLResultSetFormPane.this.error_ = true;
            SQLResultSetFormPane.this.errorListeners_.fireError(event.getException());
        }
    }

    private class ButtonListener_
    implements ActionListener {
        private ButtonListener_() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            if (source == SQLResultSetFormPane.this.firstButton_) {
                SQLResultSetFormPane.this.displayFirst();
            } else if (source == SQLResultSetFormPane.this.lastButton_) {
                SQLResultSetFormPane.this.displayLast();
            } else if (source == SQLResultSetFormPane.this.nextButton_) {
                SQLResultSetFormPane.this.displayNext();
            } else if (source == SQLResultSetFormPane.this.previousButton_) {
                SQLResultSetFormPane.this.displayPrevious();
            } else if (source == SQLResultSetFormPane.this.refreshButton_) {
                SQLResultSetFormPane.this.load();
            }
        }
    }
}

