/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ConfirmedAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;
import java.io.IOException;

class IFSDeleteAction
extends ConfirmedAction {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String confirmTitleText_ = ResourceLoader.getText("DLG_CONFIRM_DELETION_TITLE");
    private static final String confirmMessageText_ = ResourceLoader.getText("DLG_CONFIRM_DELETION");
    private static final String text_ = ResourceLoader.getText("ACTION_DELETE");
    private IFSFile file_ = null;

    public IFSDeleteAction(VObject object, IFSFile file) {
        super(object, confirmTitleText_, confirmMessageText_);
        this.file_ = file;
    }

    @Override
    public String getText() {
        return text_;
    }

    @Override
    public void perform2(VActionContext context) {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Deleting file or directory [" + this.file_.getPath() + "].");
        }
        this.fireStartWorking();
        boolean objectDeleted = false;
        try {
            if (!this.file_.exists()) {
                this.fireError(new IOException(ResourceLoader.getText("EXC_FILE_NOT_FOUND")));
                objectDeleted = true;
            } else if (this.file_.delete()) {
                objectDeleted = true;
            } else {
                this.fireError(new IOException(ResourceLoader.getText("EXC_FILE_NOT_DELETED")));
            }
        }
        catch (IOException e) {
            this.fireError(e);
        }
        this.fireStopWorking();
        if (objectDeleted) {
            this.fireObjectDeleted();
        }
    }
}

