/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.ValidationListAttribute;
import com.ibm.as400.access.ValidationListAttributeData;

public class ValidationListAttributeInfo {
    private ValidationListAttribute[] attributes_ = null;

    public ValidationListAttributeInfo() {
    }

    public ValidationListAttributeInfo(ValidationListAttribute[] attributes) {
        this.setAttributes(attributes);
    }

    public ValidationListAttribute[] getAttributes() {
        if (this.attributes_ == null) {
            this.attributes_ = new ValidationListAttribute[0];
        }
        return this.attributes_;
    }

    public int getByteLength() {
        int total = 4;
        for (int i = 0; i < this.getAttributes().length; ++i) {
            total += this.getAttributes()[i].getByteLength();
        }
        return total;
    }

    public int getByteLengthForNativeCall() {
        int total = 4;
        total += 12;
        for (int i = 0; i < this.getAttributes().length; ++i) {
            total += this.getAttributes()[i].getByteLength();
        }
        return total;
    }

    public void setAttributes(ValidationListAttribute[] attributes) {
        this.attributes_ = attributes;
    }

    public void setAttributesData(byte[] buffer, int offset) {
        ValidationListAttribute[] attribs = this.getAttributes();
        int dataStructOffset = 12;
        int position = offset;
        for (int i = 0; i < attribs.length; ++i) {
            int entrySize = new AS400Bin4().toInt(buffer, position);
            attribs[i].setData(new ValidationListAttributeData(buffer, position + dataStructOffset));
            position += entrySize;
        }
    }

    public byte[] toBytes() {
        byte[] buffer = new byte[this.getByteLength()];
        this.toBytes(buffer, 0);
        return buffer;
    }

    public int toBytes(byte[] buffer, int offset) {
        new AS400Bin4().toBytes(this.getAttributes().length, buffer, offset);
        int position = offset + 4;
        for (int i = 0; i < this.getAttributes().length; ++i) {
            position += this.getAttributes()[i].toBytes(buffer, position);
        }
        return position;
    }
}

