/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy.impl;

import com.microsoft.azure.proton.transport.proxy.ProxyConfiguration;
import com.microsoft.azure.proton.transport.proxy.impl.StringUtils;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import java.util.Objects;

class ProxyAuthenticator {
    private static final String PROMPT = "Event Hubs client web socket proxy support";
    private final ProxyConfiguration configuration;

    ProxyAuthenticator() {
        this(ProxyConfiguration.SYSTEM_DEFAULTS);
    }

    ProxyAuthenticator(ProxyConfiguration configuration) {
        Objects.requireNonNull(configuration);
        this.configuration = configuration;
    }

    PasswordAuthentication getPasswordAuthentication(String scheme, String host) {
        if (this.configuration.hasUserDefinedCredentials()) {
            return this.configuration.credentials();
        }
        if (this.configuration.isProxyAddressConfigured()) {
            InetSocketAddress address = (InetSocketAddress)this.configuration.proxyAddress().address();
            return Authenticator.requestPasswordAuthentication(address.getHostName(), address.getAddress(), 0, null, PROMPT, scheme, null, Authenticator.RequestorType.PROXY);
        }
        ProxySelector proxySelector = ProxySelector.getDefault();
        List<Proxy> proxies = null;
        if (!StringUtils.isNullOrEmpty(host)) {
            URI uri = URI.create(host);
            proxies = proxySelector.select(uri);
        }
        InetAddress proxyAddr = null;
        Enum proxyType = null;
        if (ProxyAuthenticator.isProxyAddressLegal(proxies)) {
            proxyAddr = ((InetSocketAddress)proxies.get(0).address()).getAddress();
            proxyType = proxies.get(0).type();
        }
        return Authenticator.requestPasswordAuthentication("", proxyAddr, 0, proxyType == null ? "" : proxyType.name(), PROMPT, scheme, null, Authenticator.RequestorType.PROXY);
    }

    static boolean isPasswordAuthenticationHasValues(PasswordAuthentication passwordAuthentication) {
        if (passwordAuthentication == null) {
            return false;
        }
        String username = passwordAuthentication.getUserName();
        char[] password = passwordAuthentication.getPassword();
        return !StringUtils.isNullOrEmpty(username) && password != null && password.length > 0;
    }

    private static boolean isProxyAddressLegal(List<Proxy> proxies) {
        return proxies != null && !proxies.isEmpty() && proxies.get(0).address() != null && proxies.get(0).address() instanceof InetSocketAddress;
    }
}

