/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createParentFolder(Class<?> PKG, String filename, boolean createParentFolder, ILogChannel log) {
        FileObject parentfolder = null;
        boolean resultat = true;
        try {
            parentfolder = HopVfs.getFileObject((String)filename).getParent();
            if (!parentfolder.exists()) {
                if (createParentFolder) {
                    if (log.isDebug()) {
                        log.logDebug(BaseMessages.getString(PKG, (String)"ActionPipeline.Log.ParentLogFolderNotExist", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                    parentfolder.createFolder();
                    if (log.isDebug()) {
                        log.logDebug(BaseMessages.getString(PKG, (String)"ActionPipeline.Log.ParentLogFolderCreated", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                } else {
                    log.logError(BaseMessages.getString(PKG, (String)"ActionPipeline.Log.ParentLogFolderNotExist", (String[])new String[]{parentfolder.getName().toString()}));
                    resultat = false;
                }
            } else if (log.isDebug()) {
                log.logDebug(BaseMessages.getString(PKG, (String)"ActionPipeline.Log.ParentLogFolderExists", (String[])new String[]{parentfolder.getName().toString()}));
            }
        }
        catch (Exception e) {
            resultat = false;
            log.logError(BaseMessages.getString(PKG, (String)"ActionPipeline.Error.ChekingParentLogFolderTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionPipeline.Error.ChekingParentLogFolder", (String[])new String[]{parentfolder.getName().toString()}), e});
        }
        finally {
            if (parentfolder != null) {
                try {
                    parentfolder.close();
                    parentfolder = null;
                }
                catch (Exception exception) {}
            }
        }
        return resultat;
    }

    public static boolean isFullyQualified(String pathname) {
        return new File(pathname).isAbsolute() || pathname.startsWith("/") || pathname.startsWith("\\");
    }
}

