/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.models.ListFileSystemsOptions;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import com.azure.storage.file.datalake.models.PathItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.vfs.azure.AzureFileName;
import org.apache.hop.vfs.azure.AzureFileSystem;
import org.apache.hop.vfs.azure.BlobInputStream;

public class AzureFileObject
extends AbstractFileObject<AzureFileSystem> {
    private final DataLakeServiceClient service;
    private boolean attached = false;
    private long size;
    private long lastModified;
    private FileType type;
    private List<String> children = null;
    private DataLakeFileClient dataLakeFileClient;
    private String currentFilePath;
    private PathItem pathItem;
    private PathItem dirPathItem;
    private final String markerFileName = ".cvfs.temp";
    private OutputStream blobOutputStream;
    private String containerName;

    public AzureFileObject(AbstractFileName fileName, AzureFileSystem fileSystem, DataLakeServiceClient service) throws FileSystemException {
        super(fileName, (AbstractFileSystem)fileSystem);
        this.service = service;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doAttach() throws HopException {
        if (this.attached) {
            return;
        }
        this.containerName = ((AzureFileName)this.getName()).getContainer();
        String fullPath = ((AzureFileName)this.getName()).getPath();
        DataLakeFileSystemClient fileSystemClient = this.service.getFileSystemClient(this.containerName);
        ListPathsOptions lpo = new ListPathsOptions();
        this.children = new ArrayList<String>();
        if (AzureFileObject.isFileSystemRoot(fullPath)) {
            this.service.listFileSystems().iterator().forEachRemaining(item -> this.children.add(StringUtils.substringAfterLast((String)item.getName(), (String)"/")));
            this.size = this.children.size();
            this.lastModified = 0L;
            this.type = FileType.FOLDER;
            this.dataLakeFileClient = null;
            this.currentFilePath = "";
            return;
        }
        if (this.isContainer(fullPath)) {
            if (this.containerExists()) {
                this.type = FileType.FOLDER;
                fileSystemClient.listPaths().forEach(pi -> this.children.add(pi.getName()));
                return;
            }
            this.type = FileType.IMAGINARY;
            throw new HopException("Container does not exist: " + fullPath);
        }
        this.currentFilePath = ((AzureFileName)this.getName()).getPathAfterContainer();
        if (StringUtils.isEmpty((CharSequence)this.currentFilePath)) {
            this.type = FileType.FOLDER;
            fileSystemClient.listPaths().forEach(pi -> this.children.add(pi.getName()));
            return;
        }
        lpo.setPath(this.currentFilePath);
        DataLakeDirectoryClient directoryClient = fileSystemClient.getDirectoryClient(this.currentFilePath);
        Boolean exists = directoryClient.exists();
        Boolean isDirectory = exists != false && fileSystemClient.getDirectoryClient(this.currentFilePath).getProperties().isDirectory() != false;
        Boolean isFile = isDirectory == false;
        if (exists.booleanValue() && isDirectory.booleanValue()) {
            this.children = new ArrayList<String>();
            PagedIterable pathItems = fileSystemClient.listPaths(lpo, null);
            pathItems.forEach(item -> this.children.add(StringUtils.removeStart((String)item.getName().replace(StringUtils.removeStart((String)this.currentFilePath, (String)"/"), ""), (String)"/")));
            this.size = this.children.size();
            this.type = FileType.FOLDER;
            this.lastModified = directoryClient.getProperties().getLastModified().toEpochSecond();
            return;
        }
        if (exists.booleanValue() && isFile.booleanValue()) {
            this.dataLakeFileClient = fileSystemClient.getFileClient(this.currentFilePath);
            this.size = this.dataLakeFileClient.getProperties().getFileSize();
            this.type = FileType.FILE;
            this.lastModified = this.dataLakeFileClient.getProperties().getLastModified().toEpochSecond();
            return;
        }
        this.lastModified = 0L;
        this.type = FileType.IMAGINARY;
        this.size = 0L;
        this.pathItem = null;
        this.dirPathItem = null;
    }

    private boolean containerExists() {
        String containerName = ((AzureFileName)this.getName()).getContainer();
        ListFileSystemsOptions fileSystemsOptions = new ListFileSystemsOptions();
        fileSystemsOptions.setPrefix(containerName);
        DataLakeFileSystemClient fileSystemClient = this.service.getFileSystemClient(containerName);
        try {
            return (Boolean)fileSystemClient.existsWithResponse(Duration.ofSeconds(5L), Context.NONE).getValue();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private boolean isContainer(String fullPath) {
        String fullPathWithoutTralilingSlash;
        String container = ((AzureFileName)this.getName()).getContainer();
        return StringUtils.equals((CharSequence)container, (CharSequence)(fullPathWithoutTralilingSlash = StringUtils.removeStart((String)fullPath, (String)"/"))) && !StringUtils.isEmpty((CharSequence)fullPathWithoutTralilingSlash);
    }

    private static boolean isFileSystemRoot(String fullPath) {
        return "/".equals(fullPath);
    }

    private String getFilePath(String filename) {
        return filename.substring(filename.indexOf(47), filename.length());
    }

    protected void doDetach() {
        if (this.attached) {
            this.attached = false;
            this.children = null;
            this.size = 0L;
            this.type = null;
            this.dataLakeFileClient = null;
            this.currentFilePath = null;
            this.pathItem = null;
            this.dirPathItem = null;
        }
    }

    protected void onChange() throws IOException {
        this.refresh();
    }

    protected boolean doIsHidden() throws Exception {
        return this.getName().getBaseName().equals(".cvfs.temp");
    }

    public boolean canRenameTo(FileObject newfile) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        DataLakeFileSystemClient fileSystemClient = this.service.getFileSystemClient(this.containerName);
        DataLakeFileClient fileClient = fileSystemClient.getFileClient(this.currentFilePath.substring(1));
        if (fileClient == null) {
            throw new UnsupportedOperationException();
        }
        FileObject parent = this.getParent();
        boolean lastFile = ((AzureFileObject)parent).doListChildren().length == 1;
        try {
            if (this.currentFilePath.equals("")) {
                fileClient.delete();
            } else {
                if (StringUtils.isNotEmpty((CharSequence)this.currentFilePath) && fileClient.exists().booleanValue()) {
                    fileClient.delete();
                } else if (this.dirPathItem != null) {
                    ListPathsOptions lpo = new ListPathsOptions();
                    lpo.setPath(((AzureFileName)this.getName()).getPathAfterContainer());
                    fileSystemClient.listPaths(lpo, null).forEach(pi -> {
                        if (!pi.isDirectory() && this.getFilePath(pi.getName()).startsWith(this.getName().getPath())) {
                            DataLakeFileClient dataLakeFileClient = fileSystemClient.getFileClient(this.pathItem.getName());
                            dataLakeFileClient.delete();
                        }
                    });
                } else {
                    throw new UnsupportedOperationException();
                }
                if (lastFile) {
                    FileObject marker = parent.resolveFile(".cvfs.temp");
                    marker.createFile();
                }
            }
        }
        finally {
            this.type = FileType.IMAGINARY;
            this.children = null;
            this.size = 0L;
            this.lastModified = 0L;
        }
    }

    protected boolean doIsSameFile(FileObject destFile) throws FileSystemException {
        return true;
    }

    protected void doRename(FileObject newfile) throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.currentFilePath)) {
            throw new FileSystemException("Renaming of directories not supported on this file.");
        }
        DataLakeFileSystemClient fileSystemClient = this.service.getFileSystemClient(this.containerName);
        DataLakeFileClient fileClient = fileSystemClient.getFileClient(this.currentFilePath.substring(1));
        fileClient.rename(this.containerName, ((AzureFileName)newfile.getName()).getPathAfterContainer().substring(1));
    }

    protected void doCreateFolder() {
        this.service.getFileSystemClient(this.containerName).createDirectory(this.currentFilePath.substring(1));
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.lastModified;
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.currentFilePath)) {
            throw new UnsupportedOperationException();
        }
        DataLakeFileSystemClient fileSystemClient = this.service.getFileSystemClient(this.containerName);
        DataLakeFileClient dataLakeFileClient = fileSystemClient.getFileClient(this.currentFilePath);
        if (dataLakeFileClient != null) {
            if (bAppend) {
                throw new UnsupportedOperationException();
            }
            this.type = FileType.FILE;
            return new BlockBlobOutputStream(dataLakeFileClient.getOutputStream());
        }
        throw new UnsupportedOperationException();
    }

    protected InputStream doGetInputStream() throws Exception {
        if (!this.currentFilePath.equals("") && this.type == FileType.FILE) {
            DataLakeFileSystemClient fileSystemClient = this.service.getFileSystemClient(this.containerName);
            DataLakeFileClient fileClient = fileSystemClient.getFileClient(this.currentFilePath);
            if (!fileSystemClient.exists() || !fileClient.exists().booleanValue()) {
                throw new FileSystemException("File not found: " + this.currentFilePath);
            }
            return new BlobInputStream(fileClient.openInputStream(), this.size);
        }
        throw new UnsupportedOperationException();
    }

    protected FileType doGetType() throws Exception {
        return this.type;
    }

    protected String[] doListChildren() throws Exception {
        return this.children == null ? ArrayUtils.toStringArray((Object[])this.getChildren()) : this.children.toArray(new String[0]);
    }

    public FileObject[] getChildren() throws FileSystemException {
        return super.getChildren();
    }

    protected long doGetContentSize() throws Exception {
        return this.size;
    }

    public boolean delete() throws FileSystemException {
        if (this.dataLakeFileClient.exists().booleanValue()) {
            try {
                this.doDelete();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private static String removeTrailingSlash(String itemPath) {
        while (itemPath.endsWith("/")) {
            itemPath = itemPath.substring(0, itemPath.length() - 1);
        }
        return itemPath;
    }

    private static String removeLeadingSlash(String relpath) {
        while (relpath.startsWith("/")) {
            relpath = relpath.substring(1);
        }
        return relpath;
    }

    public class BlockBlobOutputStream
    extends OutputStream {
        private final OutputStream outputStream;
        long written = 0L;

        public BlockBlobOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void write(int b) throws IOException {
            this.outputStream.write(b);
            this.written(1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        protected void written(int len) {
            this.written += (long)len;
            AzureFileObject.this.lastModified = System.currentTimeMillis();
            AzureFileObject.this.size = this.written;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
            this.written(len);
        }

        @Override
        public void flush() throws IOException {
            super.flush();
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }
    }
}

