/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.filemerging.SegmentFileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStreamFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMergingCheckpointStateOutputStream
extends FsCheckpointStreamFactory.FsCheckpointStateOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(FileMergingCheckpointStateOutputStream.class);
    private final FileMergingSnapshotManagerProxy fileMergingSnapshotManagerProxy;
    private volatile boolean closed;
    private Path filePath;
    @Nullable
    private FSDataOutputStream outputStream;
    private long startPos;
    private long curPosRelative = 0L;
    private final byte[] writeBuffer;
    private int bufferPos;

    public FileMergingCheckpointStateOutputStream(int bufferSize, FileMergingSnapshotManagerProxy fileMergingSnapshotManagerProxy) {
        super(null, null, bufferSize, -1);
        this.fileMergingSnapshotManagerProxy = fileMergingSnapshotManagerProxy;
        this.writeBuffer = new byte[bufferSize];
    }

    private void initializeOutputStream() throws IOException {
        Tuple2<FSDataOutputStream, Path> streamAndPath = this.fileMergingSnapshotManagerProxy.providePhysicalFile();
        this.outputStream = (FSDataOutputStream)streamAndPath.f0;
        this.startPos = this.outputStream.getPos();
        this.filePath = (Path)streamAndPath.f1;
    }

    @Override
    public long getPos() throws IOException {
        return (long)this.bufferPos + this.curPosRelative;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.bufferPos >= this.writeBuffer.length) {
            this.flushToFile();
        }
        this.writeBuffer[this.bufferPos++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < this.writeBuffer.length) {
            int remaining = this.writeBuffer.length - this.bufferPos;
            if (len > remaining) {
                System.arraycopy(b, off, this.writeBuffer, this.bufferPos, remaining);
                off += remaining;
                len -= remaining;
                this.bufferPos += remaining;
                this.flushToFile();
            }
            System.arraycopy(b, off, this.writeBuffer, this.bufferPos, len);
            this.bufferPos += len;
        } else {
            this.flushToFile();
            this.outputStream.write(b, off, len);
            this.curPosRelative += (long)len;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.flushToFile();
        }
    }

    @Override
    public void sync() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.sync();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public SegmentFileStateHandle closeAndGetHandle() throws IOException {
        if (this.outputStream == null && this.bufferPos == 0) {
            return null;
        }
        FileMergingCheckpointStateOutputStream fileMergingCheckpointStateOutputStream = this;
        synchronized (fileMergingCheckpointStateOutputStream) {
            if (this.closed) {
                throw new IOException("Stream has already been closed and discarded.");
            }
            try {
                this.flushToFile();
                this.bufferPos = this.writeBuffer.length;
                SegmentFileStateHandle segmentFileStateHandle = this.fileMergingSnapshotManagerProxy.closeStreamAndCreateStateHandle(this.filePath, this.startPos, this.curPosRelative);
                return segmentFileStateHandle;
            }
            catch (Exception exception) {
                this.fileMergingSnapshotManagerProxy.closeStreamExceptionally();
                throw new IOException("Could not flush to file and close the file system output stream to " + this.filePath + " in order to obtain the stream state handle", exception);
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.bufferPos = this.writeBuffer.length;
            try {
                this.fileMergingSnapshotManagerProxy.closeStreamExceptionally();
            }
            catch (Throwable throwable) {
                LOG.warn("Could not close the state stream for {}.", (Object)this.filePath, (Object)throwable);
            }
        }
    }

    @Override
    public void flushToFile() throws IOException {
        if (!this.closed) {
            if (this.outputStream == null) {
                this.initializeOutputStream();
            }
            if (this.bufferPos > 0) {
                this.outputStream.write(this.writeBuffer, 0, this.bufferPos);
                this.curPosRelative += (long)this.bufferPos;
                this.bufferPos = 0;
            }
        } else {
            throw new IOException("Cannot call flushToFile() to a closed stream.");
        }
    }

    @Nullable
    @VisibleForTesting
    public Path getFilePath() {
        return this.filePath;
    }

    public static interface FileMergingSnapshotManagerProxy {
        public Tuple2<FSDataOutputStream, Path> providePhysicalFile() throws IOException;

        public SegmentFileStateHandle closeStreamAndCreateStateHandle(Path var1, long var2, long var4) throws IOException;

        public void closeStreamExceptionally() throws IOException;
    }
}

