/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.data.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RecurringAudienceListName
implements ResourceName {
    private static final PathTemplate PROPERTY_RECURRING_AUDIENCE_LIST = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/recurringAudienceLists/{recurring_audience_list}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String recurringAudienceList;

    @Deprecated
    protected RecurringAudienceListName() {
        this.property = null;
        this.recurringAudienceList = null;
    }

    private RecurringAudienceListName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.recurringAudienceList = (String)Preconditions.checkNotNull((Object)builder.getRecurringAudienceList());
    }

    public String getProperty() {
        return this.property;
    }

    public String getRecurringAudienceList() {
        return this.recurringAudienceList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RecurringAudienceListName of(String property, String recurringAudienceList) {
        return RecurringAudienceListName.newBuilder().setProperty(property).setRecurringAudienceList(recurringAudienceList).build();
    }

    public static String format(String property, String recurringAudienceList) {
        return RecurringAudienceListName.newBuilder().setProperty(property).setRecurringAudienceList(recurringAudienceList).build().toString();
    }

    public static RecurringAudienceListName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_RECURRING_AUDIENCE_LIST.validatedMatch(formattedString, "RecurringAudienceListName.parse: formattedString not in valid format");
        return RecurringAudienceListName.of((String)matchMap.get("property"), (String)matchMap.get("recurring_audience_list"));
    }

    public static List<RecurringAudienceListName> parseList(List<String> formattedStrings) {
        ArrayList<RecurringAudienceListName> list = new ArrayList<RecurringAudienceListName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RecurringAudienceListName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RecurringAudienceListName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RecurringAudienceListName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_RECURRING_AUDIENCE_LIST.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RecurringAudienceListName recurringAudienceListName = this;
            synchronized (recurringAudienceListName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.recurringAudienceList != null) {
                        fieldMapBuilder.put((Object)"recurring_audience_list", (Object)this.recurringAudienceList);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_RECURRING_AUDIENCE_LIST.instantiate(new String[]{"property", this.property, "recurring_audience_list", this.recurringAudienceList});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RecurringAudienceListName that = (RecurringAudienceListName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.recurringAudienceList, that.recurringAudienceList);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.recurringAudienceList);
    }

    public static class Builder {
        private String property;
        private String recurringAudienceList;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getRecurringAudienceList() {
            return this.recurringAudienceList;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setRecurringAudienceList(String recurringAudienceList) {
            this.recurringAudienceList = recurringAudienceList;
            return this;
        }

        private Builder(RecurringAudienceListName recurringAudienceListName) {
            this.property = recurringAudienceListName.property;
            this.recurringAudienceList = recurringAudienceListName.recurringAudienceList;
        }

        public RecurringAudienceListName build() {
            return new RecurringAudienceListName(this);
        }
    }
}

