/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.Result;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.attributes.AttributesUtil;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopMissingPluginsException;
import org.apache.hop.core.exception.HopRowException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.parameters.NamedParameters;
import org.apache.hop.core.reflection.StringSearchResult;
import org.apache.hop.core.reflection.StringSearcher;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.IXml;
import org.apache.hop.core.xml.XmlFormatter;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.partition.PartitionSchema;
import org.apache.hop.pipeline.CheckTransformsExtension;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMetaInfo;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.ITransformMetaChangeListener;
import org.apache.hop.pipeline.transform.TransformErrorMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.missing.Missing;
import org.apache.hop.resource.IResourceExport;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceReference;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PipelineMeta
extends AbstractMeta
implements IXml,
Comparator<PipelineMeta>,
Comparable<PipelineMeta>,
Cloneable,
IResourceExport,
IHasFilename {
    public static final String PIPELINE_EXTENSION = ".hpl";
    private static final String CONST_DESCRIPTION = "description";
    private static final String CONST_ERROR_OPENING_OR_VALIDATING = "PipelineMeta.Exception.ErrorOpeningOrValidatingTheXMLFile";
    private static final String CONST_PARAMETER = "parameter";
    private static final String CONST_EMPTY = "        ";
    private static final Class<?> PKG = Pipeline.class;
    public static final String XML_TAG = "pipeline";
    public static final int BORDER_INDENT = 20;
    @HopMetadataProperty(key="info")
    protected PipelineMetaInfo info;
    @HopMetadataProperty(key="transform")
    protected List<TransformMeta> transforms;
    @HopMetadataProperty(groupKey="order", key="hop")
    protected List<PipelineHopMeta> hops;
    protected int pipelineStatus;
    protected boolean changedTransforms;
    protected boolean changedHops;
    protected Result previousResult;
    protected Map<String, IRowMeta> transformFieldsCache;
    protected Map<String, Boolean> loopCache;
    protected Map<String, List<TransformMeta>> previousTransformCache;
    protected List<ITransformMetaChangeListener> transformChangeListeners;
    private ArrayList<Missing> missingPipeline;
    public static final String[] descTypeUndo = new String[]{"", BaseMessages.getString(PKG, (String)"PipelineMeta.UndoTypeDesc.UndoChange", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineMeta.UndoTypeDesc.UndoNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineMeta.UndoTypeDesc.UndoDelete", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineMeta.UndoTypeDesc.UndoPosition", (String[])new String[0])};
    protected static final String XML_TAG_INFO = "info";
    public static final String XML_TAG_ORDER = "order";
    public static final String XML_TAG_NOTEPADS = "notepads";
    public static final String XML_TAG_PARAMETERS = "parameters";
    public static final String XML_TAG_TRANSFORM_ERROR_HANDLING = "transform_error_handling";
    private long prevCount;

    public PipelineMeta() {
        this.clear();
    }

    @Override
    public int compare(PipelineMeta t1, PipelineMeta t2) {
        return super.compare(t1, t2);
    }

    @Override
    public int compareTo(PipelineMeta o) {
        return this.compare(this, o);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PipelineMeta)) {
            return false;
        }
        return this.compare(this, (PipelineMeta)obj) == 0;
    }

    public Object clone() {
        return this.realClone(true);
    }

    public Object realClone(boolean doClear) {
        try {
            PipelineMeta pipelineMeta = (PipelineMeta)super.clone();
            if (doClear) {
                pipelineMeta.clear();
            } else {
                pipelineMeta.transforms = new ArrayList<TransformMeta>();
                pipelineMeta.hops = new ArrayList<PipelineHopMeta>();
                pipelineMeta.notes = new ArrayList();
                pipelineMeta.namedParams = new NamedParameters();
                pipelineMeta.transformChangeListeners = new ArrayList<ITransformMetaChangeListener>();
            }
            for (TransformMeta transform : this.transforms) {
                pipelineMeta.addTransform((TransformMeta)transform.clone());
            }
            for (TransformMeta transform : pipelineMeta.getTransforms()) {
                ITransformIOMeta iTransformIOMeta;
                ITransformMeta transformMeta = transform.getTransform();
                if (transformMeta == null || (iTransformIOMeta = transformMeta.getTransformIOMeta()) == null) continue;
                for (IStream stream : iTransformIOMeta.getInfoStreams()) {
                    String streamTransformName = stream.getTransformName();
                    if (streamTransformName == null) continue;
                    TransformMeta streamTransformMeta = pipelineMeta.findTransform(streamTransformName);
                    stream.setTransformMeta(streamTransformMeta);
                }
            }
            for (PipelineHopMeta hop : this.hops) {
                pipelineMeta.addPipelineHop(hop.clone());
            }
            for (NotePadMeta note : this.notes) {
                pipelineMeta.addNote(note.clone());
            }
            for (Iterator<Cloneable> iterator : this.listParameters()) {
                pipelineMeta.addParameterDefinition((String)((Object)iterator), this.getParameterDefault((String)((Object)iterator)), this.getParameterDescription((String)((Object)iterator)));
            }
            return pipelineMeta;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected String getExtension() {
        return PIPELINE_EXTENSION;
    }

    @Override
    public void clear() {
        this.transforms = new ArrayList<TransformMeta>();
        this.hops = new ArrayList<PipelineHopMeta>();
        this.namedParams = new NamedParameters();
        this.transformChangeListeners = new ArrayList<ITransformMetaChangeListener>();
        this.pipelineStatus = -1;
        this.info = new PipelineMetaInfo();
        this.undo = new ArrayList();
        this.maxUndo = 100;
        this.undoPosition = -1;
        super.clear();
        this.transformFieldsCache = new HashMap<String, IRowMeta>();
        this.loopCache = new HashMap<String, Boolean>();
        this.previousTransformCache = new HashMap<String, List<TransformMeta>>();
    }

    public void addTransform(TransformMeta transformMeta) {
        this.transforms.add(transformMeta);
        transformMeta.setParentPipelineMeta(this);
        ITransformMeta iface = transformMeta.getTransform();
        if (iface instanceof ITransformMetaChangeListener) {
            ITransformMetaChangeListener iTransformMetaChangeListener = (ITransformMetaChangeListener)((Object)iface);
            this.addTransformChangeListener(iTransformMetaChangeListener);
        }
        this.changedTransforms = true;
        this.clearCaches();
    }

    public void addOrReplaceTransform(TransformMeta transformMeta) {
        int index = this.transforms.indexOf(transformMeta);
        if (index < 0) {
            index = this.transforms.add(transformMeta) ? 0 : index;
        } else {
            TransformMeta previous = this.getTransform(index);
            previous.replaceMeta(transformMeta);
        }
        transformMeta.setParentPipelineMeta(this);
        ITransformMeta iface = transformMeta.getTransform();
        if (index != -1 && iface instanceof ITransformMetaChangeListener) {
            ITransformMetaChangeListener iTransformMetaChangeListener = (ITransformMetaChangeListener)((Object)iface);
            this.addTransformChangeListener(index, iTransformMetaChangeListener);
        }
        this.changedTransforms = true;
        this.clearCaches();
    }

    public void addPipelineHop(PipelineHopMeta hi) {
        this.hops.add(hi);
        this.changedHops = true;
        this.clearCaches();
    }

    public void addTransform(int p, TransformMeta transformMeta) {
        this.transforms.add(p, transformMeta);
        transformMeta.setParentPipelineMeta(this);
        this.changedTransforms = true;
        ITransformMeta iface = transformMeta.getTransform();
        if (iface instanceof ITransformMetaChangeListener) {
            this.addTransformChangeListener(p, (ITransformMetaChangeListener)((Object)transformMeta.getTransform()));
        }
        this.clearCaches();
    }

    public void addPipelineHop(int p, PipelineHopMeta hi) {
        try {
            this.hops.add(p, hi);
        }
        catch (IndexOutOfBoundsException e) {
            this.hops.add(hi);
        }
        this.changedHops = true;
        this.clearCaches();
    }

    public List<TransformMeta> getTransforms() {
        return this.transforms;
    }

    public TransformMeta getTransform(int i) {
        return this.transforms.get(i);
    }

    public List<PipelineHopMeta> getPipelineHops() {
        return Collections.unmodifiableList(this.hops);
    }

    public PipelineHopMeta getPipelineHop(int i) {
        return this.hops.get(i);
    }

    public void removeTransform(int i) {
        if (i < 0 || i >= this.transforms.size()) {
            return;
        }
        TransformMeta removeTransform = this.transforms.get(i);
        ITransformMeta iface = removeTransform.getTransform();
        if (iface instanceof ITransformMetaChangeListener) {
            ITransformMetaChangeListener iTransformMetaChangeListener = (ITransformMetaChangeListener)((Object)iface);
            this.removeTransformChangeListener(iTransformMetaChangeListener);
        }
        this.transforms.remove(i);
        ITransformMeta iTransformMeta = removeTransform.getTransform();
        if (iTransformMeta instanceof Missing) {
            Missing missingTransform = (Missing)iTransformMeta;
            this.removeMissingPipeline(missingTransform);
        }
        this.changedTransforms = true;
        this.clearCaches();
    }

    public void removePipelineHop(int i) {
        if (i < 0 || i >= this.hops.size()) {
            return;
        }
        this.hops.remove(i);
        this.changedHops = true;
        this.clearCaches();
    }

    public void removePipelineHop(PipelineHopMeta hop) {
        this.hops.remove(hop);
        this.changedHops = true;
        this.clearCaches();
    }

    public int nrTransforms() {
        return this.transforms.size();
    }

    public int nrPipelineHops() {
        return this.hops.size();
    }

    public int nrTransformChangeListeners() {
        return this.transformChangeListeners.size();
    }

    public void setTransform(int i, TransformMeta transformMeta) {
        ITransformMeta iface = transformMeta.getTransform();
        if (iface instanceof ITransformMetaChangeListener) {
            this.addTransformChangeListener(i, (ITransformMetaChangeListener)((Object)transformMeta.getTransform()));
        }
        this.transforms.set(i, transformMeta);
        transformMeta.setParentPipelineMeta(this);
        this.clearCaches();
    }

    public void setPipelineHop(int i, PipelineHopMeta hi) {
        this.hops.set(i, hi);
        this.clearCaches();
    }

    public List<TransformMeta> getUsedTransforms() {
        List<TransformMeta> list = new ArrayList<TransformMeta>();
        for (TransformMeta transformMeta : this.transforms) {
            if (!this.isTransformUsedInPipelineHops(transformMeta)) continue;
            list.add(transformMeta);
        }
        if (list.isEmpty() && this.getTransforms().size() == 1) {
            list = this.getTransforms();
        }
        return list;
    }

    public TransformMeta findTransform(String name) {
        return this.findTransform(name, null);
    }

    public TransformMeta findTransform(String name, TransformMeta exclude) {
        if (name == null) {
            return null;
        }
        int excl = -1;
        if (exclude != null) {
            excl = this.indexOfTransform(exclude);
        }
        for (int i = 0; i < this.nrTransforms(); ++i) {
            TransformMeta transformMeta = this.getTransform(i);
            if (i == excl || !transformMeta.getName().equalsIgnoreCase(name)) continue;
            return transformMeta;
        }
        return null;
    }

    public PipelineHopMeta findPipelineHop(String name) {
        for (int i = 0; i < this.nrPipelineHops(); ++i) {
            PipelineHopMeta hi = this.getPipelineHop(i);
            if (!hi.toString().equalsIgnoreCase(name)) continue;
            return hi;
        }
        return null;
    }

    public PipelineHopMeta findPipelineHopFrom(TransformMeta fromTransform) {
        for (int i = 0; i < this.nrPipelineHops(); ++i) {
            PipelineHopMeta hi = this.getPipelineHop(i);
            if (hi.getFromTransform() == null || !hi.getFromTransform().equals(fromTransform)) continue;
            return hi;
        }
        return null;
    }

    public List<PipelineHopMeta> findAllPipelineHopFrom(TransformMeta fromTransform) {
        return this.hops.stream().filter(hop -> hop.getFromTransform() != null && hop.getFromTransform().equals(fromTransform)).collect(Collectors.toList());
    }

    public PipelineHopMeta findPipelineHop(PipelineHopMeta hi) {
        return this.findPipelineHop(hi.getFromTransform(), hi.getToTransform());
    }

    public PipelineHopMeta findPipelineHop(TransformMeta from, TransformMeta to) {
        return this.findPipelineHop(from, to, false);
    }

    public PipelineHopMeta findPipelineHop(TransformMeta from, TransformMeta to, boolean disabledToo) {
        for (int i = 0; i < this.nrPipelineHops(); ++i) {
            PipelineHopMeta hi = this.getPipelineHop(i);
            if (!hi.isEnabled() && !disabledToo || hi.getFromTransform() == null || hi.getToTransform() == null || !hi.getFromTransform().equals(from) || !hi.getToTransform().equals(to)) continue;
            return hi;
        }
        return null;
    }

    public PipelineHopMeta findPipelineHopTo(TransformMeta toTransform) {
        for (int i = 0; i < this.nrPipelineHops(); ++i) {
            PipelineHopMeta hi = this.getPipelineHop(i);
            if (hi.getToTransform() == null || !hi.getToTransform().equals(toTransform)) continue;
            return hi;
        }
        return null;
    }

    public boolean isTransformInformative(TransformMeta thisTransform, TransformMeta prevTransform) {
        String[] infoTransforms = thisTransform.getTransform().getTransformIOMeta().getInfoTransformNames();
        if (infoTransforms == null) {
            return false;
        }
        for (int i = 0; i < infoTransforms.length; ++i) {
            if (!prevTransform.getName().equalsIgnoreCase(infoTransforms[i])) continue;
            return true;
        }
        return false;
    }

    public List<TransformMeta> findPreviousTransforms(TransformMeta transformMeta) {
        return this.findPreviousTransforms(transformMeta, true);
    }

    public List<TransformMeta> findPreviousTransforms(TransformMeta transformMeta, boolean info) {
        if (transformMeta == null) {
            return new ArrayList<TransformMeta>();
        }
        String cacheKey = PipelineMeta.getTransformMetaCacheKey(transformMeta, info);
        List<TransformMeta> previousTransforms = this.previousTransformCache.get(cacheKey);
        if (previousTransforms == null) {
            previousTransforms = new ArrayList<TransformMeta>();
            for (PipelineHopMeta hi : this.hops) {
                if (hi.getToTransform() == null || !hi.isEnabled() || !hi.getToTransform().equals(transformMeta) || !info && this.isTransformInformative(transformMeta, hi.getFromTransform())) continue;
                previousTransforms.add(hi.getFromTransform());
            }
            this.previousTransformCache.put(cacheKey, previousTransforms);
        }
        return previousTransforms;
    }

    public TransformMeta[] getInfoTransform(TransformMeta transformMeta) {
        String[] infoTransformName = transformMeta.getTransform().getTransformIOMeta().getInfoTransformNames();
        if (infoTransformName == null) {
            return null;
        }
        TransformMeta[] infoTransform = new TransformMeta[infoTransformName.length];
        for (int i = 0; i < infoTransform.length; ++i) {
            infoTransform[i] = this.findTransform(infoTransformName[i]);
        }
        return infoTransform;
    }

    public int findNrInfoTransforms(TransformMeta transformMeta) {
        if (transformMeta == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.nrPipelineHops(); ++i) {
            PipelineHopMeta hi = this.getPipelineHop(i);
            if (hi == null || hi.getToTransform() == null) {
                LogChannel.GENERAL.logError(BaseMessages.getString(PKG, (String)"PipelineMeta.Log.DestinationOfHopCannotBeNull", (String[])new String[0]));
            }
            if (hi == null || hi.getToTransform() == null || !hi.isEnabled() || !hi.getToTransform().equals(transformMeta) || !this.isTransformInformative(transformMeta, hi.getFromTransform())) continue;
            ++count;
        }
        return count;
    }

    public IRowMeta getPrevInfoFields(IVariables variables, String transformName) throws HopTransformException {
        return this.getPrevInfoFields(variables, this.findTransform(transformName));
    }

    public IRowMeta getPrevInfoFields(IVariables variables, TransformMeta transformMeta) throws HopTransformException {
        for (int i = 0; i < this.nrPipelineHops(); ++i) {
            TransformMeta infoTransform;
            PipelineHopMeta hi = this.getPipelineHop(i);
            if (!hi.isEnabled() || !hi.getToTransform().equals(transformMeta) || !this.isTransformInformative(transformMeta, infoTransform = hi.getFromTransform())) continue;
            IRowMeta row = this.getPrevTransformFields(variables, infoTransform);
            return this.getThisTransformFields(variables, infoTransform, transformMeta, row);
        }
        return new RowMeta();
    }

    public TransformMeta[] getPrevTransforms(TransformMeta transformMeta) {
        List<TransformMeta> prevTransforms = this.previousTransformCache.get(PipelineMeta.getTransformMetaCacheKey(transformMeta, true));
        if (prevTransforms == null) {
            prevTransforms = new ArrayList<TransformMeta>();
            for (int i = 0; i < this.nrPipelineHops(); ++i) {
                PipelineHopMeta hopMeta = this.getPipelineHop(i);
                if (!hopMeta.isEnabled() || !hopMeta.getToTransform().equals(transformMeta)) continue;
                prevTransforms.add(hopMeta.getFromTransform());
            }
        }
        return prevTransforms.toArray(new TransformMeta[prevTransforms.size()]);
    }

    public String[] getPrevTransformNames(String transformName) {
        return this.getPrevTransformNames(this.findTransform(transformName));
    }

    public String[] getPrevTransformNames(TransformMeta transformMeta) {
        TransformMeta[] prevTransformMetas = this.getPrevTransforms(transformMeta);
        String[] retval = new String[prevTransformMetas.length];
        for (int x = 0; x < prevTransformMetas.length; ++x) {
            retval[x] = prevTransformMetas[x].getName();
        }
        return retval;
    }

    public List<TransformMeta> findNextTransforms(TransformMeta transformMeta) {
        return this.findNextTransforms(transformMeta, false);
    }

    public List<TransformMeta> findNextTransforms(TransformMeta transformMeta, boolean includeDisabled) {
        ArrayList<TransformMeta> nextTransforms = new ArrayList<TransformMeta>();
        for (int i = 0; i < this.nrPipelineHops(); ++i) {
            PipelineHopMeta hop = this.getPipelineHop(i);
            if (!hop.isEnabled() && !includeDisabled || !hop.getFromTransform().equals(transformMeta)) continue;
            nextTransforms.add(hop.getToTransform());
        }
        return nextTransforms;
    }

    public String[] getNextTransformNames(TransformMeta transformMeta) {
        List<TransformMeta> nextTransformMeta = this.findNextTransforms(transformMeta);
        String[] retval = new String[nextTransformMeta.size()];
        for (int x = 0; x < nextTransformMeta.size(); ++x) {
            retval[x] = nextTransformMeta.get(x).getName();
        }
        return retval;
    }

    public TransformMeta getTransform(int x, int y, int iconsize) {
        int s = this.transforms.size();
        for (int i = s - 1; i >= 0; --i) {
            TransformMeta transformMeta = this.transforms.get(i);
            Point p = transformMeta.getLocation();
            if (p == null || x < p.x || x > p.x + iconsize || y < p.y || y > p.y + iconsize + 20) continue;
            return transformMeta;
        }
        return null;
    }

    public boolean partOfPipelineHop(TransformMeta transformMeta) {
        for (int i = 0; i < this.nrPipelineHops(); ++i) {
            PipelineHopMeta hi = this.getPipelineHop(i);
            if (hi.getFromTransform() == null || hi.getToTransform() == null) {
                return false;
            }
            if (!hi.getFromTransform().equals(transformMeta) && !hi.getToTransform().equals(transformMeta)) continue;
            return true;
        }
        return false;
    }

    public IRowMeta getTransformFields(IVariables variables, String transformName) throws HopTransformException {
        TransformMeta transformMeta = this.findTransform(transformName);
        if (transformMeta != null) {
            return this.getTransformFields(variables, transformMeta);
        }
        return null;
    }

    public IRowMeta getTransformFields(IVariables variables, TransformMeta transformMeta) throws HopTransformException {
        return this.getTransformFields(variables, transformMeta, null);
    }

    public IRowMeta getTransformFields(IVariables variables, TransformMeta[] transformMeta) throws HopTransformException {
        RowMeta fields = new RowMeta();
        for (int i = 0; i < transformMeta.length; ++i) {
            IRowMeta flds = this.getTransformFields(variables, transformMeta[i]);
            if (flds == null) continue;
            fields.mergeRowMeta(flds, transformMeta[i].getName());
        }
        return fields;
    }

    public IRowMeta getTransformFields(IVariables variables, TransformMeta transformMeta, IProgressMonitor monitor) throws HopTransformException {
        return this.getTransformFields(variables, transformMeta, null, monitor);
    }

    public IRowMeta getTransformFields(IVariables variables, TransformMeta transformMeta, TransformMeta targetTransform, IProgressMonitor monitor) throws HopTransformException {
        RowMeta row = new RowMeta();
        if (transformMeta == null) {
            return row;
        }
        String fromToCacheEntry = transformMeta.getName() + (String)(targetTransform != null ? "-" + targetTransform.getName() : "");
        IRowMeta rowMeta = this.transformFieldsCache.get(fromToCacheEntry);
        if (rowMeta != null) {
            return rowMeta;
        }
        if (targetTransform != null && transformMeta.isSendingErrorRowsToTransform(targetTransform)) {
            row = this.getPrevTransformFields(variables, transformMeta);
            if (row.isEmpty()) {
                row = this.getThisTransformFields(variables, transformMeta, targetTransform, (IRowMeta)row, monitor);
            }
            TransformErrorMeta transformErrorMeta = transformMeta.getTransformErrorMeta();
            row.addRowMeta(transformErrorMeta.getErrorRowMeta(variables));
            this.transformFieldsCache.put(fromToCacheEntry, (IRowMeta)row);
            return row;
        }
        List<TransformMeta> prevTransforms = this.findPreviousTransforms(transformMeta, false);
        int nrPrevious = prevTransforms.size();
        if (LogChannel.GENERAL.isDebug()) {
            LogChannel.GENERAL.logDebug(BaseMessages.getString(PKG, (String)"PipelineMeta.Log.FromTransformALookingAtPreviousTransform", (String[])new String[]{transformMeta.getName(), String.valueOf(nrPrevious)}));
        }
        for (int i = 0; i < prevTransforms.size(); ++i) {
            IRowMeta add;
            TransformMeta prevTransformMeta = prevTransforms.get(i);
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"PipelineMeta.Monitor.CheckingTransformTask.Title", (String[])new String[]{prevTransformMeta.getName()}));
            }
            if ((add = this.getTransformFields(variables, prevTransformMeta, transformMeta, monitor)) == null) {
                add = new RowMeta();
            }
            if (LogChannel.GENERAL.isDebug()) {
                LogChannel.GENERAL.logDebug(BaseMessages.getString(PKG, (String)"PipelineMeta.Log.FoundFieldsToAdd", (String[])new String[0]) + add);
            }
            if (i == 0) {
                row.addRowMeta(add);
                continue;
            }
            for (int x = 0; x < add.size(); ++x) {
                IValueMeta v = add.getValueMeta(x);
                IValueMeta s = row.searchValueMeta(v.getName());
                if (s != null) continue;
                row.addValueMeta(v);
            }
        }
        rowMeta = this.getThisTransformFields(variables, transformMeta, targetTransform, (IRowMeta)row, monitor);
        this.transformFieldsCache.put(fromToCacheEntry, rowMeta);
        return rowMeta;
    }

    public IRowMeta getPrevTransformFields(IVariables variables, String transformName) throws HopTransformException {
        return this.getPrevTransformFields(variables, this.findTransform(transformName));
    }

    public IRowMeta getPrevTransformFields(IVariables variables, TransformMeta transformMeta) throws HopTransformException {
        return this.getPrevTransformFields(variables, transformMeta, null);
    }

    public IRowMeta getPrevTransformFields(IVariables variables, TransformMeta transformMeta, IProgressMonitor monitor) throws HopTransformException {
        return this.getPrevTransformFields(variables, transformMeta, null, monitor);
    }

    public IRowMeta getPrevTransformFields(IVariables variables, TransformMeta transformMeta, String transformName, IProgressMonitor monitor) throws HopTransformException {
        this.clearTransformFieldsCache();
        RowMeta row = new RowMeta();
        if (transformMeta == null) {
            return null;
        }
        List<TransformMeta> prevTransforms = this.findPreviousTransforms(transformMeta);
        int nrPrevTransforms = prevTransforms.size();
        if (LogChannel.GENERAL.isDebug()) {
            LogChannel.GENERAL.logDebug(BaseMessages.getString(PKG, (String)"PipelineMeta.Log.FromTransformALookingAtPreviousTransform", (String[])new String[]{transformMeta.getName(), String.valueOf(nrPrevTransforms)}));
        }
        for (int i = 0; i < nrPrevTransforms; ++i) {
            TransformMeta prevTransformMeta = prevTransforms.get(i);
            if (transformName != null && !transformName.equalsIgnoreCase(prevTransformMeta.getName())) continue;
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"PipelineMeta.Monitor.CheckingTransformTask.Title", (String[])new String[]{prevTransformMeta.getName()}));
            }
            IRowMeta add = this.getTransformFields(variables, prevTransformMeta, transformMeta, monitor);
            if (LogChannel.GENERAL.isDebug()) {
                LogChannel.GENERAL.logDebug(BaseMessages.getString(PKG, (String)"PipelineMeta.Log.FoundFieldsToAdd2", (String[])new String[0]) + add.toString());
            }
            if (i == 0) {
                row.addRowMeta(add);
                continue;
            }
            for (int x = 0; x < add.size(); ++x) {
                IValueMeta v = add.getValueMeta(x);
                IValueMeta s = row.searchValueMeta(v.getName());
                if (s != null) continue;
                row.addValueMeta(v);
            }
        }
        return row;
    }

    public IRowMeta getThisTransformFields(IVariables variables, String transformName, IRowMeta row) throws HopTransformException {
        return this.getThisTransformFields(variables, this.findTransform(transformName), null, row);
    }

    public IRowMeta getThisTransformFields(IVariables variables, TransformMeta transformMeta, TransformMeta nextTransform, IRowMeta row) throws HopTransformException {
        return this.getThisTransformFields(variables, transformMeta, nextTransform, row, null);
    }

    public IRowMeta getThisTransformFields(IVariables variables, TransformMeta transformMeta, TransformMeta nextTransform, IRowMeta row, IProgressMonitor monitor) throws HopTransformException {
        IRowMeta[] infoRowMeta;
        if (LogChannel.GENERAL.isDebug()) {
            LogChannel.GENERAL.logDebug(BaseMessages.getString(PKG, (String)"PipelineMeta.Log.GettingFieldsFromTransform", (String[])new String[]{transformMeta.getName(), transformMeta.getTransformPluginId()}));
        }
        String name = transformMeta.getName();
        if (monitor != null) {
            monitor.subTask(BaseMessages.getString(PKG, (String)"PipelineMeta.Monitor.GettingFieldsFromTransformTask.Title", (String[])new String[]{name}));
        }
        ITransformMeta iTransformMeta = transformMeta.getTransform();
        Object[] lu = this.getInfoTransform(transformMeta);
        if (Utils.isEmpty((Object[])lu)) {
            infoRowMeta = new IRowMeta[]{iTransformMeta.getTableFields(variables)};
        } else {
            infoRowMeta = new IRowMeta[lu.length];
            for (int i = 0; i < lu.length; ++i) {
                infoRowMeta[i] = this.getTransformFields(variables, (TransformMeta)lu[i]);
            }
        }
        IRowMeta before = row.clone();
        IRowMeta[] clonedInfo = PipelineMeta.cloneRowMetaInterfaces(infoRowMeta);
        if (!this.isSomethingDifferentInRow(before, row)) {
            iTransformMeta.getFields(this, before, name, clonedInfo, nextTransform, variables, this.metadataProvider);
            row = before;
        }
        return row;
    }

    private boolean isSomethingDifferentInRow(IRowMeta before, IRowMeta after) {
        if (before.size() != after.size()) {
            return true;
        }
        for (int i = 0; i < before.size(); ++i) {
            IValueMeta beforeValueMeta = before.getValueMeta(i);
            IValueMeta afterValueMeta = after.getValueMeta(i);
            if (this.stringsDifferent(beforeValueMeta.getName(), afterValueMeta.getName())) {
                return true;
            }
            if (beforeValueMeta.getType() != afterValueMeta.getType()) {
                return true;
            }
            if (beforeValueMeta.getLength() != afterValueMeta.getLength()) {
                return true;
            }
            if (beforeValueMeta.getPrecision() != afterValueMeta.getPrecision()) {
                return true;
            }
            if (this.stringsDifferent(beforeValueMeta.getOrigin(), afterValueMeta.getOrigin())) {
                return true;
            }
            if (this.stringsDifferent(beforeValueMeta.getComments(), afterValueMeta.getComments())) {
                return true;
            }
            if (this.stringsDifferent(beforeValueMeta.getConversionMask(), afterValueMeta.getConversionMask())) {
                return true;
            }
            if (this.stringsDifferent(beforeValueMeta.getStringEncoding(), afterValueMeta.getStringEncoding())) {
                return true;
            }
            if (this.stringsDifferent(beforeValueMeta.getDecimalSymbol(), afterValueMeta.getDecimalSymbol())) {
                return true;
            }
            if (!this.stringsDifferent(beforeValueMeta.getGroupingSymbol(), afterValueMeta.getGroupingSymbol())) continue;
            return true;
        }
        return false;
    }

    private boolean stringsDifferent(String one, String two) {
        if (one == null && two == null) {
            return false;
        }
        if (one == null && two != null) {
            return true;
        }
        if (one != null && two == null) {
            return true;
        }
        return !one.equals(two);
    }

    public boolean isUsingPartitionSchema(PartitionSchema partitionSchema) {
        for (int i = 0; i < this.nrTransforms(); ++i) {
            PartitionSchema check;
            TransformPartitioningMeta transformPartitioningMeta = this.getTransform(i).getTransformPartitioningMeta();
            if (transformPartitioningMeta == null || (check = transformPartitioningMeta.getPartitionSchema()) == null || !check.equals(partitionSchema)) continue;
            return true;
        }
        return false;
    }

    public int indexOfPipelineHop(PipelineHopMeta hi) {
        return this.hops.indexOf(hi);
    }

    public int indexOfTransform(TransformMeta transformMeta) {
        return this.transforms.indexOf(transformMeta);
    }

    @Override
    public String getXml(IVariables variables) throws HopException {
        TransformMeta transformMeta;
        int i;
        StringBuilder xml = new StringBuilder(800);
        xml.append(XmlHandler.getLicenseHeader((IVariables)variables));
        xml.append(XmlHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("  ").append(XmlHandler.openTag((String)XML_TAG_INFO)).append(Const.CR);
        xml.append("    ").append(XmlHandler.addTagValue((String)"name", (String)this.getName()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"name_sync_with_filename", (boolean)this.isNameSynchronizedWithFilename()));
        xml.append("    ").append(XmlHandler.addTagValue((String)CONST_DESCRIPTION, (String)this.getDescription()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"extended_description", (String)this.getExtendedDescription()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"pipeline_version", (String)this.getPipelineVersion()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"pipeline_type", (String)this.getPipelineType().getCode()));
        if (this.pipelineStatus >= 0) {
            xml.append("    ").append(XmlHandler.addTagValue((String)"pipeline_status", (int)this.pipelineStatus));
        }
        xml.append("    ").append(XmlHandler.openTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        String[] parameters = this.listParameters();
        for (int idx = 0; idx < parameters.length; ++idx) {
            xml.append("      ").append(XmlHandler.openTag((String)CONST_PARAMETER)).append(Const.CR);
            xml.append(CONST_EMPTY).append(XmlHandler.addTagValue((String)"name", (String)parameters[idx]));
            xml.append(CONST_EMPTY).append(XmlHandler.addTagValue((String)"default_value", (String)this.getParameterDefault(parameters[idx])));
            xml.append(CONST_EMPTY).append(XmlHandler.addTagValue((String)CONST_DESCRIPTION, (String)this.getParameterDescription(parameters[idx])));
            xml.append("      ").append(XmlHandler.closeTag((String)CONST_PARAMETER)).append(Const.CR);
        }
        xml.append("    ").append(XmlHandler.closeTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        xml.append("    ").append(XmlHandler.addTagValue((String)"capture_transform_performance", (boolean)this.isCapturingTransformPerformanceSnapShots()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"transform_performance_capturing_delay", (long)this.getTransformPerformanceCapturingDelay()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"transform_performance_capturing_size_limit", (String)this.getTransformPerformanceCapturingSizeLimit()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"created_user", (String)this.getCreatedUser()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"created_date", (String)XmlHandler.date2string((Date)this.getCreatedDate())));
        xml.append("    ").append(XmlHandler.addTagValue((String)"modified_user", (String)this.getModifiedUser()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"modified_date", (String)XmlHandler.date2string((Date)this.getModifiedDate())));
        xml.append("  ").append(XmlHandler.closeTag((String)XML_TAG_INFO)).append(Const.CR);
        xml.append("  ").append(XmlHandler.openTag((String)XML_TAG_NOTEPADS)).append(Const.CR);
        if (this.notes != null) {
            for (i = 0; i < this.nrNotes(); ++i) {
                NotePadMeta ni = this.getNote(i);
                xml.append(ni.getXml());
            }
        }
        xml.append("  ").append(XmlHandler.closeTag((String)XML_TAG_NOTEPADS)).append(Const.CR);
        xml.append("  ").append(XmlHandler.openTag((String)XML_TAG_ORDER)).append(Const.CR);
        for (i = 0; i < this.nrPipelineHops(); ++i) {
            PipelineHopMeta pipelineHopMeta = this.getPipelineHop(i);
            xml.append(pipelineHopMeta.getXml());
        }
        xml.append("  ").append(XmlHandler.closeTag((String)XML_TAG_ORDER)).append(Const.CR);
        for (i = 0; i < this.nrTransforms(); ++i) {
            transformMeta = this.getTransform(i);
            xml.append(transformMeta.getXml());
        }
        xml.append("  ").append(XmlHandler.openTag((String)XML_TAG_TRANSFORM_ERROR_HANDLING)).append(Const.CR);
        for (i = 0; i < this.nrTransforms(); ++i) {
            transformMeta = this.getTransform(i);
            if (transformMeta.getTransformErrorMeta() == null) continue;
            xml.append(transformMeta.getTransformErrorMeta().getXml());
        }
        xml.append("  ").append(XmlHandler.closeTag((String)XML_TAG_TRANSFORM_ERROR_HANDLING)).append(Const.CR);
        xml.append(AttributesUtil.getAttributesXml(this.attributesMap));
        xml.append(XmlHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return XmlFormatter.format((String)xml.toString());
    }

    public PipelineMeta(String fname, IHopMetadataProvider metadataProvider, IVariables parentVariableSpace) throws HopXmlException, HopMissingPluginsException {
        if (StringUtils.isBlank((String)fname)) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"PipelineMeta.Exception.MissingXMLFilePath", (String[])new String[0]));
        }
        if (metadataProvider == null) {
            throw new HopXmlException("API error: metadata provider can't be null. When loading a pipeline Hop needs to be able to reference external metadata objects");
        }
        this.metadataProvider = metadataProvider;
        this.loadXml(fname, metadataProvider, parentVariableSpace);
    }

    public void loadXml(String fname, IHopMetadataProvider metadataProvider, IVariables parentVariableSpace) throws HopXmlException, HopMissingPluginsException {
        Node pipelineNode;
        Document doc = null;
        try {
            FileObject pipelineFile = HopVfs.getFileObject((String)fname);
            if (!pipelineFile.exists()) {
                throw new HopXmlException(BaseMessages.getString(PKG, (String)"PipelineMeta.Exception.InvalidXMLPath", (String[])new String[]{fname}));
            }
            doc = XmlHandler.loadXmlFile((FileObject)pipelineFile);
        }
        catch (HopXmlException ke) {
            throw ke;
        }
        catch (FileSystemException | HopException e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)CONST_ERROR_OPENING_OR_VALIDATING, (String[])new String[]{fname}), e);
        }
        if (doc != null) {
            pipelineNode = XmlHandler.getSubNode((Node)doc, (String)XML_TAG);
            if (pipelineNode == null) {
                throw new HopXmlException(BaseMessages.getString(PKG, (String)"PipelineMeta.Exception.NotValidPipelineXML", (String[])new String[]{fname}));
            }
        } else {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)CONST_ERROR_OPENING_OR_VALIDATING, (String[])new String[]{fname}));
        }
        this.loadXml(pipelineNode, fname, metadataProvider, parentVariableSpace);
    }

    public PipelineMeta(InputStream xmlStream, IHopMetadataProvider metadataProvider, IVariables parentVariableSpace) throws HopXmlException, HopMissingPluginsException {
        Document doc = XmlHandler.loadXmlFile((InputStream)xmlStream, null, (boolean)false, (boolean)false);
        Node pipelineNode = XmlHandler.getSubNode((Node)doc, (String)XML_TAG);
        this.loadXml(pipelineNode, null, metadataProvider, parentVariableSpace);
    }

    public PipelineMeta(Node pipelineNode, IHopMetadataProvider metadataProvider) throws HopXmlException, HopMissingPluginsException {
        this.loadXml(pipelineNode, null, metadataProvider, null);
    }

    public void loadXml(Node pipelineNode, String filename, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException, HopMissingPluginsException {
        HopMissingPluginsException missingPluginsException = new HopMissingPluginsException(BaseMessages.getString(PKG, (String)"PipelineMeta.MissingPluginsFoundWhileLoadingPipeline.Exception", (String[])new String[0]));
        this.metadataProvider = metadataProvider;
        try {
            try {
                int i;
                this.clear();
                this.setFilename(filename);
                Node notepadsNode = XmlHandler.getSubNode((Node)pipelineNode, (String)XML_TAG_NOTEPADS);
                List notepadNodes = XmlHandler.getNodes((Node)notepadsNode, (String)"notepad");
                for (Object notepadNode : notepadNodes) {
                    NotePadMeta ni = new NotePadMeta((Node)notepadNode);
                    this.notes.add(ni);
                }
                List transformNodes = XmlHandler.getNodes((Node)pipelineNode, (String)"transform");
                if (LogChannel.GENERAL.isDebug()) {
                    LogChannel.GENERAL.logDebug(BaseMessages.getString(PKG, (String)"PipelineMeta.Log.ReadingTransforms", (String[])new String[0]) + transformNodes.size() + " transforms...");
                }
                for (Node transformNode : transformNodes) {
                    TransformMeta transformMeta = new TransformMeta(transformNode, metadataProvider);
                    transformMeta.setParentPipelineMeta(this);
                    if (transformMeta.isMissing()) {
                        this.addMissingPipeline((Missing)transformMeta.getTransform());
                    }
                    this.addOrReplaceTransform(transformMeta);
                }
                Node errorHandlingNode = XmlHandler.getSubNode((Node)pipelineNode, (String)XML_TAG_TRANSFORM_ERROR_HANDLING);
                int nrErrorHandlers = XmlHandler.countNodes((Node)errorHandlingNode, (String)"error");
                for (i = 0; i < nrErrorHandlers; ++i) {
                    Node transformErrorMetaNode = XmlHandler.getSubNodeByNr((Node)errorHandlingNode, (String)"error", (int)i);
                    TransformErrorMeta transformErrorMeta = new TransformErrorMeta(transformErrorMetaNode, this.transforms);
                    if (transformErrorMeta.getSourceTransform() == null) continue;
                    transformErrorMeta.getSourceTransform().setTransformErrorMeta(transformErrorMeta);
                }
                for (i = 0; i < this.nrTransforms(); ++i) {
                    TransformMeta transformMeta = this.getTransform(i);
                    ITransformMeta sii = transformMeta.getTransform();
                    if (sii == null) continue;
                    sii.searchInfoAndTargetTransforms(this.transforms);
                }
                Node orderNode = XmlHandler.getSubNode((Node)pipelineNode, (String)XML_TAG_ORDER);
                List hopNodes = XmlHandler.getNodes((Node)orderNode, (String)"hop");
                if (LogChannel.GENERAL.isDebug()) {
                    LogChannel.GENERAL.logDebug(BaseMessages.getString(PKG, (String)"PipelineMeta.Log.WeHaveHops", (String[])new String[0]) + hopNodes.size() + " hops...");
                }
                for (Node hopNode : hopNodes) {
                    PipelineHopMeta hopinf = new PipelineHopMeta(hopNode, this.transforms);
                    hopinf.setErrorHop(this.isErrorNode(errorHandlingNode, hopNode));
                    this.addPipelineHop(hopinf);
                }
                Node infoNode = XmlHandler.getSubNode((Node)pipelineNode, (String)XML_TAG_INFO);
                this.info.setName(XmlHandler.getTagValue((Node)infoNode, (String)"name"));
                this.info.setNameSynchronizedWithFilename("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)infoNode, (String)"name_sync_with_filename")));
                this.info.setDescription(XmlHandler.getTagValue((Node)infoNode, (String)CONST_DESCRIPTION));
                this.info.setExtendedDescription(XmlHandler.getTagValue((Node)infoNode, (String)"extended_description"));
                this.info.setPipelineVersion(XmlHandler.getTagValue((Node)infoNode, (String)"pipeline_version"));
                this.pipelineStatus = Const.toInt((String)XmlHandler.getTagValue((Node)infoNode, (String)"pipeline_status"), (int)-1);
                String pipelineTypeCode = XmlHandler.getTagValue((Node)infoNode, (String)"pipeline_type");
                this.info.setPipelineType(PipelineType.getPipelineTypeByCode(pipelineTypeCode));
                Node paramsNode = XmlHandler.getSubNode((Node)infoNode, (String)XML_TAG_PARAMETERS);
                int nrParams = XmlHandler.countNodes((Node)paramsNode, (String)CONST_PARAMETER);
                for (int i2 = 0; i2 < nrParams; ++i2) {
                    Node paramNode = XmlHandler.getSubNodeByNr((Node)paramsNode, (String)CONST_PARAMETER, (int)i2);
                    String paramName = XmlHandler.getTagValue((Node)paramNode, (String)"name");
                    String defaultValue = XmlHandler.getTagValue((Node)paramNode, (String)"default_value");
                    String descr = XmlHandler.getTagValue((Node)paramNode, (String)CONST_DESCRIPTION);
                    this.addParameterDefinition(paramName, defaultValue, descr);
                }
                this.info.setCapturingTransformPerformanceSnapShots("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)infoNode, (String)"capture_transform_performance")));
                this.info.setTransformPerformanceCapturingDelay(Const.toLong((String)XmlHandler.getTagValue((Node)infoNode, (String)"transform_performance_capturing_delay"), (long)1000L));
                this.info.setTransformPerformanceCapturingSizeLimit(XmlHandler.getTagValue((Node)infoNode, (String)"transform_performance_capturing_size_limit"));
                this.info.setCreatedUser(XmlHandler.getTagValue((Node)infoNode, (String)"created_user"));
                String createDate = XmlHandler.getTagValue((Node)infoNode, (String)"created_date");
                if (createDate != null) {
                    this.info.setCreatedDate(XmlHandler.stringToDate((String)createDate));
                }
                this.info.setModifiedUser(XmlHandler.getTagValue((Node)infoNode, (String)"modified_user"));
                String modDate = XmlHandler.getTagValue((Node)infoNode, (String)"modified_date");
                if (modDate != null) {
                    this.info.setModifiedDate(XmlHandler.stringToDate((String)modDate));
                }
                if (LogChannel.GENERAL.isDebug()) {
                    LogChannel.GENERAL.logDebug(BaseMessages.getString(PKG, (String)"PipelineMeta.Log.NumberOfTransformReaded", (String[])new String[0]) + this.nrTransforms());
                    LogChannel.GENERAL.logDebug(BaseMessages.getString(PKG, (String)"PipelineMeta.Log.NumberOfHopsReaded", (String[])new String[0]) + this.nrPipelineHops());
                }
                this.sortTransforms();
                this.attributesMap = AttributesUtil.loadAttributes(XmlHandler.getSubNode((Node)pipelineNode, (String)"attributes"));
            }
            catch (HopXmlException xe) {
                throw new HopXmlException(BaseMessages.getString(PKG, (String)"PipelineMeta.Exception.ErrorReadingPipeline", (String[])new String[0]), (Throwable)xe);
            }
            catch (Exception e) {
                throw new HopXmlException((Throwable)e);
            }
            finally {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)variables, (String)HopExtensionPoint.PipelineMetaLoaded.id, (Object)this);
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"PipelineMeta.Exception.ErrorReadingPipeline", (String[])new String[0]), (Throwable)e);
        }
        finally {
            if (!missingPluginsException.getMissingPluginDetailsList().isEmpty()) {
                throw missingPluginsException;
            }
        }
        this.clearChanged();
    }

    public List<TransformMeta> getPipelineHopTransforms(boolean all) {
        int x;
        ArrayList<TransformMeta> st = new ArrayList<TransformMeta>();
        for (x = 0; x < this.nrPipelineHops(); ++x) {
            PipelineHopMeta hi = this.getPipelineHop(x);
            if (!hi.isEnabled() && !all) continue;
            int idx = st.indexOf(hi.getFromTransform());
            if (idx < 0) {
                st.add(hi.getFromTransform());
            }
            if ((idx = st.indexOf(hi.getToTransform())) >= 0) continue;
            st.add(hi.getToTransform());
        }
        for (x = 0; x < this.nrTransforms(); ++x) {
            TransformMeta transformMeta = this.getTransform(x);
            if (this.isTransformUsedInPipelineHops(transformMeta)) continue;
            st.add(transformMeta);
        }
        return st;
    }

    public boolean isTransformUsedInPipelineHops(TransformMeta transformMeta) {
        PipelineHopMeta fr = this.findPipelineHopFrom(transformMeta);
        PipelineHopMeta to = this.findPipelineHopTo(transformMeta);
        return fr != null || to != null;
    }

    public boolean isAnySelectedTransformUsedInPipelineHops() {
        List<TransformMeta> selectedTransforms = this.getSelectedTransforms();
        for (int i = 0; i < selectedTransforms.size(); ++i) {
            TransformMeta transformMeta = selectedTransforms.get(i);
            if (!this.isTransformUsedInPipelineHops(transformMeta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearChanged() {
        int i;
        this.changedTransforms = false;
        this.changedHops = false;
        for (i = 0; i < this.nrTransforms(); ++i) {
            this.getTransform(i).setChanged(false);
            if (this.getTransform(i).getTransformPartitioningMeta() == null) continue;
            this.getTransform(i).getTransformPartitioningMeta().hasChanged(false);
        }
        for (i = 0; i < this.nrPipelineHops(); ++i) {
            this.getPipelineHop(i).setChanged(false);
        }
        super.clearChanged();
    }

    public boolean haveTransformsChanged() {
        if (this.changedTransforms) {
            return true;
        }
        for (int i = 0; i < this.nrTransforms(); ++i) {
            TransformMeta transformMeta = this.getTransform(i);
            if (transformMeta.hasChanged()) {
                return true;
            }
            if (transformMeta.getTransformPartitioningMeta() == null || !transformMeta.getTransformPartitioningMeta().hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveHopsChanged() {
        if (this.changedHops) {
            return true;
        }
        for (int i = 0; i < this.nrPipelineHops(); ++i) {
            PipelineHopMeta hi = this.getPipelineHop(i);
            if (!hi.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChanged() {
        return super.hasChanged() || this.haveTransformsChanged() || this.haveHopsChanged();
    }

    private boolean isErrorNode(Node errorHandingNode, Node checkNode) {
        if (errorHandingNode != null) {
            NodeList errors = errorHandingNode.getChildNodes();
            Node nodeHopFrom = XmlHandler.getSubNode((Node)checkNode, (String)"from");
            Node nodeHopTo = XmlHandler.getSubNode((Node)checkNode, (String)"to");
            int i = 0;
            while (i < errors.getLength()) {
                Node errorNode = errors.item(i);
                if (!"error".equals(errorNode.getNodeName())) {
                    ++i;
                    continue;
                }
                Node errorSourceNode = XmlHandler.getSubNode((Node)errorNode, (String)"source_transform");
                Node errorTagetNode = XmlHandler.getSubNode((Node)errorNode, (String)"target_transform");
                String sourceContent = errorSourceNode.getTextContent().trim();
                String tagetContent = errorTagetNode.getTextContent().trim();
                if (sourceContent.equals(nodeHopFrom.getTextContent().trim()) && tagetContent.equals(nodeHopTo.getTextContent().trim())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasLoop(TransformMeta transformMeta) {
        this.clearLoopCache();
        return this.hasLoop(transformMeta, null);
    }

    public boolean hasLoop(TransformMeta transformMeta, TransformMeta lookup) {
        return this.hasLoop(transformMeta, lookup, new HashSet<TransformMeta>());
    }

    private boolean hasLoop(TransformMeta transformMeta, TransformMeta lookup, HashSet<TransformMeta> checkedEntries) {
        String cacheKey = transformMeta.getName() + " - " + (lookup != null ? lookup.getName() : "");
        Boolean hasLoop = this.loopCache.get(cacheKey);
        if (hasLoop != null) {
            return hasLoop;
        }
        hasLoop = false;
        checkedEntries.add(transformMeta);
        List<TransformMeta> prevTransforms = this.findPreviousTransforms(transformMeta, true);
        int nr = prevTransforms.size();
        for (int i = 0; i < nr; ++i) {
            TransformMeta prevTransformMeta = prevTransforms.get(i);
            if (prevTransformMeta == null || !prevTransformMeta.equals(lookup) && (checkedEntries.contains(prevTransformMeta) || !this.hasLoop(prevTransformMeta, lookup == null ? transformMeta : lookup, checkedEntries))) continue;
            hasLoop = true;
            break;
        }
        this.loopCache.put(cacheKey, hasLoop);
        return hasLoop;
    }

    public void selectAll() {
        int i;
        for (i = 0; i < this.nrTransforms(); ++i) {
            TransformMeta transformMeta = this.getTransform(i);
            transformMeta.setSelected(true);
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            ni.setSelected(true);
        }
        this.setChanged();
        this.notifyObservers("refreshGraph");
    }

    public void unselectAll() {
        int i;
        for (i = 0; i < this.nrTransforms(); ++i) {
            TransformMeta transformMeta = this.getTransform(i);
            transformMeta.setSelected(false);
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            ni.setSelected(false);
        }
    }

    public Point[] getSelectedTransformLocations() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (TransformMeta transformMeta : this.getSelectedTransforms()) {
            Point p = transformMeta.getLocation();
            points.add(new Point(p.x, p.y));
        }
        return points.toArray(new Point[points.size()]);
    }

    public Point[] getSelectedNoteLocations() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (NotePadMeta ni : this.getSelectedNotes()) {
            Point p = ni.getLocation();
            points.add(new Point(p.x, p.y));
        }
        return points.toArray(new Point[points.size()]);
    }

    public List<TransformMeta> getSelectedTransforms() {
        ArrayList<TransformMeta> selection = new ArrayList<TransformMeta>();
        for (TransformMeta transformMeta : this.transforms) {
            if (!transformMeta.isSelected()) continue;
            selection.add(transformMeta);
        }
        return selection;
    }

    public String[] getSelectedTransformNames() {
        List<TransformMeta> selection = this.getSelectedTransforms();
        String[] retval = new String[selection.size()];
        for (int i = 0; i < retval.length; ++i) {
            TransformMeta transformMeta = selection.get(i);
            retval[i] = transformMeta.getName();
        }
        return retval;
    }

    public int[] getTransformIndexes(List<TransformMeta> transforms) {
        int[] retval = new int[transforms.size()];
        for (int i = 0; i < transforms.size(); ++i) {
            retval[i] = this.indexOfTransform(transforms.get(i));
        }
        return retval;
    }

    public Point getMaximum() {
        Point loc;
        int maxx = 0;
        int maxy = 0;
        for (TransformMeta transformMeta : this.getTransforms()) {
            loc = transformMeta.getLocation();
            if (loc.x > maxx) {
                maxx = loc.x;
            }
            if (loc.y <= maxy) continue;
            maxy = loc.y;
        }
        for (NotePadMeta notePadMeta : this.getNotes()) {
            loc = notePadMeta.getLocation();
            if (loc.x + notePadMeta.width > maxx) {
                maxx = loc.x + notePadMeta.width;
            }
            if (loc.y + notePadMeta.height <= maxy) continue;
            maxy = loc.y + notePadMeta.height;
        }
        return new Point(maxx + 100, maxy + 100);
    }

    public Point getMinimum() {
        Point loc;
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        for (TransformMeta transformMeta : this.getTransforms()) {
            loc = transformMeta.getLocation();
            if (loc.x < minx) {
                minx = loc.x;
            }
            if (loc.y >= miny) continue;
            miny = loc.y;
        }
        for (NotePadMeta notePadMeta : this.getNotes()) {
            loc = notePadMeta.getLocation();
            if (loc.x < minx) {
                minx = loc.x;
            }
            if (loc.y >= miny) continue;
            miny = loc.y;
        }
        minx = minx > 20 && minx != Integer.MAX_VALUE ? (minx -= 20) : 0;
        miny = miny > 20 && miny != Integer.MAX_VALUE ? (miny -= 20) : 0;
        return new Point(minx, miny);
    }

    public String[] getTransformNames() {
        String[] retval = new String[this.nrTransforms()];
        for (int i = 0; i < this.nrTransforms(); ++i) {
            retval[i] = this.getTransform(i).getName();
        }
        return retval;
    }

    public TransformMeta[] getTransformsArray() {
        TransformMeta[] retval = new TransformMeta[this.nrTransforms()];
        for (int i = 0; i < this.nrTransforms(); ++i) {
            retval[i] = this.getTransform(i);
        }
        return retval;
    }

    public boolean findPrevious(TransformMeta startTransform, TransformMeta transformToFind) {
        String key = startTransform.getName() + " - " + transformToFind.getName();
        Boolean result = this.loopCache.get(key);
        if (result != null) {
            return result;
        }
        List<TransformMeta> previousTransforms = this.findPreviousTransforms(startTransform, false);
        for (int i = 0; i < previousTransforms.size(); ++i) {
            TransformMeta transformMeta = previousTransforms.get(i);
            if (transformMeta.equals(transformToFind)) {
                this.loopCache.put(key, true);
                return true;
            }
            boolean found = this.findPrevious(transformMeta, transformToFind);
            if (!found) continue;
            this.loopCache.put(key, true);
            return true;
        }
        List<TransformMeta> infoTransforms = this.findPreviousTransforms(startTransform, true);
        for (int i = 0; i < infoTransforms.size(); ++i) {
            TransformMeta transformMeta = infoTransforms.get(i);
            if (transformMeta.equals(transformToFind)) {
                this.loopCache.put(key, true);
                return true;
            }
            boolean found = this.findPrevious(transformMeta, transformToFind);
            if (!found) continue;
            this.loopCache.put(key, true);
            return true;
        }
        this.loopCache.put(key, false);
        return false;
    }

    public void sortTransforms() {
        try {
            Collections.sort(this.transforms);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError(BaseMessages.getString(PKG, (String)"PipelineMeta.Exception.ErrorOfSortingTransforms", (String[])new String[0]) + e);
            LogChannel.GENERAL.logError(Const.getStackTracker((Throwable)e));
        }
    }

    public void sortHops() {
        Collections.sort(this.hops);
    }

    public Map<TransformMeta, Map<TransformMeta, Boolean>> sortTransformsNatural() {
        long startTime = System.currentTimeMillis();
        this.prevCount = 0L;
        HashMap<TransformMeta, Map<TransformMeta, Boolean>> transformMap = new HashMap<TransformMeta, Map<TransformMeta, Boolean>>();
        HashMap<TransformMeta, List<TransformMeta>> previousCache = new HashMap<TransformMeta, List<TransformMeta>>();
        HashMap<TransformMeta, Map<TransformMeta, Boolean>> beforeCache = new HashMap<TransformMeta, Map<TransformMeta, Boolean>>();
        for (TransformMeta transformMeta : this.transforms) {
            List<TransformMeta> prevTransforms = (List<TransformMeta>)previousCache.get(transformMeta);
            if (prevTransforms == null) {
                prevTransforms = this.findPreviousTransforms(transformMeta);
                ++this.prevCount;
                previousCache.put(transformMeta, prevTransforms);
            }
            for (TransformMeta prev : prevTransforms) {
                Map<TransformMeta, Boolean> beforePrevMap = this.updateFillTransformMap(previousCache, beforeCache, transformMeta, prev);
                transformMap.put(transformMeta, beforePrevMap);
                beforeCache.put(prev, beforePrevMap);
            }
        }
        Collections.sort(this.transforms, (o1, o2) -> {
            Map beforeMap = (Map)transformMap.get(o1);
            if (beforeMap != null) {
                if (beforeMap.get(o2) == null) {
                    return -1;
                }
                return 1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        });
        long endTime = System.currentTimeMillis();
        LogChannel.GENERAL.logBasic(BaseMessages.getString(PKG, (String)"PipelineMeta.Log.TimeExecutionTransformSort", (Object[])new Object[]{endTime - startTime, this.prevCount}));
        return transformMap;
    }

    private Map<TransformMeta, Boolean> updateFillTransformMap(Map<TransformMeta, List<TransformMeta>> previousCache, Map<TransformMeta, Map<TransformMeta, Boolean>> beforeCache, TransformMeta originTransformMeta, TransformMeta previousTransformMeta) {
        Map<TransformMeta, Boolean> beforeMap = beforeCache.get(previousTransformMeta);
        if (beforeMap != null) {
            return beforeMap;
        }
        beforeMap = new HashMap<TransformMeta, Boolean>();
        beforeMap.put(previousTransformMeta, Boolean.TRUE);
        List<TransformMeta> prevTransforms = previousCache.get(previousTransformMeta);
        if (prevTransforms == null) {
            prevTransforms = this.findPreviousTransforms(previousTransformMeta);
            ++this.prevCount;
            previousCache.put(previousTransformMeta, prevTransforms);
        }
        for (TransformMeta prev : prevTransforms) {
            Map<TransformMeta, Boolean> beforePrevMap = this.updateFillTransformMap(previousCache, beforeCache, originTransformMeta, prev);
            beforeCache.put(prev, beforePrevMap);
            beforeMap.putAll(beforePrevMap);
        }
        return beforeMap;
    }

    public void sortHopsNatural() {
        for (int j = 0; j < this.nrPipelineHops(); ++j) {
            for (int i = 0; i < this.nrPipelineHops() - 1; ++i) {
                TransformMeta b;
                PipelineHopMeta one = this.getPipelineHop(i);
                PipelineHopMeta two = this.getPipelineHop(i + 1);
                TransformMeta a = two.getFromTransform();
                if (this.findPrevious(a, b = one.getToTransform()) || a.equals(b)) continue;
                this.setPipelineHop(i + 1, one);
                this.setPipelineHop(i, two);
            }
        }
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, IProgressMonitor monitor) throws HopTransformException {
        if (monitor != null) {
            monitor.beginTask(BaseMessages.getString(PKG, (String)"PipelineMeta.Monitor.DeterminingImpactTask.Title", (String[])new String[0]), this.nrTransforms());
        }
        boolean stop = false;
        for (int i = 0; i < this.nrTransforms() && !stop; ++i) {
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"PipelineMeta.Monitor.LookingAtTransformTask.Title", (String[])new String[0]) + (i + 1) + "/" + this.nrTransforms());
            }
            TransformMeta transformMeta = this.getTransform(i);
            IRowMeta prev = this.getPrevTransformFields(variables, transformMeta);
            ITransformMeta iTransformMeta = transformMeta.getTransform();
            TransformMeta[] lu = this.getInfoTransform(transformMeta);
            IRowMeta infoRowMeta = lu != null ? this.getTransformFields(variables, lu) : iTransformMeta.getTableFields(variables);
            iTransformMeta.analyseImpact(variables, impact, this, transformMeta, prev, null, null, infoRowMeta, this.metadataProvider);
            if (monitor == null) continue;
            monitor.worked(1);
            stop = monitor.isCanceled();
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public String getAlternativeTransformName(String transformName) {
        Object newname = transformName;
        TransformMeta transformMeta = this.findTransform((String)newname);
        int nr = 1;
        while (transformMeta != null) {
            newname = transformName + " " + ++nr;
            transformMeta = this.findTransform((String)newname);
        }
        return newname;
    }

    public List<SqlStatement> getSqlStatements(IVariables variables) throws HopTransformException {
        return this.getSqlStatements(variables, null);
    }

    public List<SqlStatement> getSqlStatements(IVariables variables, IProgressMonitor monitor) throws HopTransformException {
        if (monitor != null) {
            monitor.beginTask(BaseMessages.getString(PKG, (String)"PipelineMeta.Monitor.GettingTheSQLForPipelineTask.Title", (String[])new String[0]), this.nrTransforms() + 1);
        }
        ArrayList<SqlStatement> stats = new ArrayList<SqlStatement>();
        for (int i = 0; i < this.nrTransforms(); ++i) {
            TransformMeta transformMeta = this.getTransform(i);
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"PipelineMeta.Monitor.GettingTheSQLForTransformTask.Title", (String[])new String[]{"" + transformMeta}));
            }
            IRowMeta prev = this.getPrevTransformFields(variables, transformMeta);
            SqlStatement sql = transformMeta.getTransform().getSqlStatements(variables, this, transformMeta, prev, this.metadataProvider);
            if (sql.getSql() != null || sql.hasError()) {
                stats.add(sql);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return stats;
    }

    public String getSqlStatementsString(IVariables variables) throws HopTransformException {
        Object sql = "";
        List<SqlStatement> stats = this.getSqlStatements(variables);
        for (int i = 0; i < stats.size(); ++i) {
            SqlStatement stat = stats.get(i);
            if (stat.hasError() || !stat.hasSql()) continue;
            sql = (String)sql + stat.getSql();
        }
        return sql;
    }

    public void checkTransforms(List<ICheckResult> remarks, boolean onlySelected, IProgressMonitor monitor, IVariables variables, IHopMetadataProvider metadataProvider) {
        try {
            TransformMeta[] transforms;
            String[] transformnames;
            remarks.clear();
            Hashtable<IValueMeta, String> values = new Hashtable<IValueMeta, String>();
            List<TransformMeta> selectedTransforms = this.getSelectedTransforms();
            if (!onlySelected || selectedTransforms.isEmpty()) {
                transformnames = this.getTransformNames();
                transforms = this.getTransformsArray();
            } else {
                transformnames = this.getSelectedTransformNames();
                transforms = selectedTransforms.toArray(new TransformMeta[selectedTransforms.size()]);
            }
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)variables, (String)HopExtensionPoint.BeforeCheckTransforms.id, (Object)new CheckTransformsExtension(remarks, variables, this, transforms, metadataProvider));
            boolean stopChecking = false;
            if (monitor != null) {
                monitor.beginTask(BaseMessages.getString(PKG, (String)"PipelineMeta.Monitor.VerifyingThisPipelineTask.Title", (String[])new String[0]), transforms.length + 2);
            }
            for (int i = 0; i < transforms.length && !stopChecking; ++i) {
                CheckResult cr;
                CheckResult cr2;
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"PipelineMeta.Monitor.VerifyingTransformTask.Title", (String[])new String[]{transformnames[i]}));
                }
                TransformMeta transformMeta = transforms[i];
                int nrinfo = this.findNrInfoTransforms(transformMeta);
                TransformMeta[] infoTransform = null;
                if (nrinfo > 0) {
                    infoTransform = this.getInfoTransform(transformMeta);
                }
                IRowMeta info = null;
                if (infoTransform != null) {
                    try {
                        info = this.getTransformFields(variables, infoTransform);
                    }
                    catch (HopTransformException kse) {
                        info = null;
                        cr2 = new CheckResult(4, BaseMessages.getString(PKG, (String)"PipelineMeta.CheckResult.TypeResultError.ErrorOccurredGettingTransformMetaFields.Description", (String[])new String[]{"" + transformMeta, Const.CR + kse.getMessage()}), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr2);
                    }
                }
                IRowMeta prev = null;
                try {
                    prev = this.getPrevTransformFields(variables, transformMeta);
                }
                catch (HopTransformException kse) {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PipelineMeta.CheckResult.TypeResultError.ErrorOccurredGettingInputFields.Description", (String[])new String[]{"" + transformMeta, Const.CR + kse.getMessage()}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    stopChecking = true;
                }
                if (this.isTransformUsedInPipelineHops(transformMeta) || this.getTransforms().size() == 1) {
                    String[] input = this.getPrevTransformNames(transformMeta);
                    String[] output = this.getNextTransformNames(transformMeta);
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)variables, (String)HopExtensionPoint.BeforeCheckTransform.id, (Object)new CheckTransformsExtension(remarks, variables, this, new TransformMeta[]{transformMeta}, metadataProvider));
                    transformMeta.check(remarks, this, prev, input, output, info, variables, metadataProvider);
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)variables, (String)HopExtensionPoint.AfterCheckTransform.id, (Object)new CheckTransformsExtension(remarks, variables, this, new TransformMeta[]{transformMeta}, metadataProvider));
                    if (prev != null) {
                        for (int x = 0; x < prev.size(); ++x) {
                            IValueMeta v = prev.getValueMeta(x);
                            String name = v.getName();
                            if (name == null) {
                                values.put(v, BaseMessages.getString(PKG, (String)"PipelineMeta.Value.CheckingFieldName.FieldNameIsEmpty.Description", (String[])new String[0]));
                                continue;
                            }
                            if (name.indexOf(32) >= 0) {
                                values.put(v, BaseMessages.getString(PKG, (String)"PipelineMeta.Value.CheckingFieldName.FieldNameContainsSpaces.Description", (String[])new String[0]));
                                continue;
                            }
                            char[] list = new char[]{'.', ',', '-', '/', '+', '*', '\'', '\t', '\"', '|', '@', '(', ')', '{', '}', '!', '^'};
                            for (int c = 0; c < list.length; ++c) {
                                if (name.indexOf(list[c]) < 0) continue;
                                values.put(v, BaseMessages.getString(PKG, (String)"PipelineMeta.Value.CheckingFieldName.FieldNameContainsUnfriendlyCodes.Description", (String[])new String[]{String.valueOf(list[c])}));
                            }
                        }
                        if (prev.size() > 1) {
                            String[] fieldNames = prev.getFieldNames();
                            String[] sortedNames = Const.sortStrings((String[])fieldNames);
                            String prevName = sortedNames[0];
                            for (int x = 1; x < sortedNames.length; ++x) {
                                if (prevName.equalsIgnoreCase(sortedNames[x])) {
                                    CheckResult cr3 = new CheckResult(4, BaseMessages.getString(PKG, (String)"PipelineMeta.CheckResult.TypeResultWarning.HaveTheSameNameField.Description", (String[])new String[]{prevName}), (ICheckResultSource)transformMeta);
                                    remarks.add((ICheckResult)cr3);
                                    continue;
                                }
                                prevName = sortedNames[x];
                            }
                        }
                    } else {
                        CheckResult cr4 = new CheckResult(4, BaseMessages.getString(PKG, (String)"PipelineMeta.CheckResult.TypeResultError.CannotFindPreviousFields.Description", (String[])new String[0]) + transformMeta.getName(), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr4);
                    }
                } else {
                    cr2 = new CheckResult(3, BaseMessages.getString(PKG, (String)"PipelineMeta.CheckResult.TypeResultWarning.TransformIsNotUsed.Description", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr2);
                }
                try {
                    this.checkRowMixingStatically(variables, transformMeta, null);
                }
                catch (HopRowException e) {
                    cr = new CheckResult(4, e.getMessage(), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                if (monitor == null) continue;
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                stopChecking = true;
            }
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"PipelineMeta.Monitor.CheckingForDatabaseUnfriendlyCharactersInFieldNamesTask.Title", (String[])new String[0]));
            }
            if (values.size() > 0) {
                for (IValueMeta v : values.keySet()) {
                    String message = (String)values.get(v);
                    CheckResult cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"PipelineMeta.CheckResult.TypeResultWarning.Description", (String[])new String[]{v.getName(), message, v.getOrigin()}), (ICheckResultSource)this.findTransform(v.getOrigin()));
                    remarks.add((ICheckResult)cr);
                }
            } else {
                CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PipelineMeta.CheckResult.TypeResultOK.Description", (String[])new String[0]), null);
                remarks.add((ICheckResult)cr);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)variables, (String)HopExtensionPoint.AfterCheckTransforms.id, (Object)new CheckTransformsExtension(remarks, variables, this, transforms, metadataProvider));
        }
        catch (Exception e) {
            throw new RuntimeException("Error checking transforms", e);
        }
    }

    public String getPipelineVersion() {
        return this.info.getPipelineVersion();
    }

    public void setPipelineVersion(String pipelineVersion) {
        this.info.setPipelineVersion(pipelineVersion);
    }

    public void setPipelineStatus(int pipelineStatus) {
        this.pipelineStatus = pipelineStatus;
    }

    public int getPipelineStatus() {
        return this.pipelineStatus;
    }

    public String toString() {
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            if (Utils.isEmpty((CharSequence)this.getName())) {
                return this.filename;
            }
            return this.filename + " : " + this.getName();
        }
        if (this.getName() != null) {
            return this.getName();
        }
        return PipelineMeta.class.getName();
    }

    public void cancelQueries() throws HopDatabaseException {
        for (int i = 0; i < this.nrTransforms(); ++i) {
            this.getTransform(i).getTransform().cancelQueries();
        }
    }

    public List<StringSearchResult> getStringList(boolean searchTransforms, boolean searchDatabases, boolean searchNotes, boolean includePasswords) {
        int i;
        ArrayList<StringSearchResult> stringList = new ArrayList<StringSearchResult>();
        if (searchTransforms) {
            for (i = 0; i < this.nrTransforms(); ++i) {
                TransformMeta transformMeta = this.getTransform(i);
                stringList.add(new StringSearchResult(transformMeta.getName(), transformMeta, this, BaseMessages.getString(PKG, (String)"PipelineMeta.SearchMetadata.TransformName", (String[])new String[0])));
                if (transformMeta.getDescription() != null) {
                    stringList.add(new StringSearchResult(transformMeta.getDescription(), transformMeta, this, BaseMessages.getString(PKG, (String)"PipelineMeta.SearchMetadata.TransformDescription", (String[])new String[0])));
                }
                ITransformMeta metaInterface = transformMeta.getTransform();
                StringSearcher.findMetaData(metaInterface, 1, stringList, transformMeta, this);
            }
        }
        if (searchDatabases) {
            for (DatabaseMeta databaseMeta : this.getDatabases()) {
                stringList.add(new StringSearchResult(databaseMeta.getName(), databaseMeta, this, BaseMessages.getString(PKG, (String)"PipelineMeta.SearchMetadata.DatabaseConnectionName", (String[])new String[0])));
                if (databaseMeta.getHostname() != null) {
                    stringList.add(new StringSearchResult(databaseMeta.getHostname(), databaseMeta, this, BaseMessages.getString(PKG, (String)"PipelineMeta.SearchMetadata.DatabaseHostName", (String[])new String[0])));
                }
                if (databaseMeta.getDatabaseName() != null) {
                    stringList.add(new StringSearchResult(databaseMeta.getDatabaseName(), databaseMeta, this, BaseMessages.getString(PKG, (String)"PipelineMeta.SearchMetadata.DatabaseName", (String[])new String[0])));
                }
                if (databaseMeta.getUsername() != null) {
                    stringList.add(new StringSearchResult(databaseMeta.getUsername(), databaseMeta, this, BaseMessages.getString(PKG, (String)"PipelineMeta.SearchMetadata.DatabaseUsername", (String[])new String[0])));
                }
                if (databaseMeta.getPluginId() != null) {
                    stringList.add(new StringSearchResult(databaseMeta.getPluginId(), databaseMeta, this, BaseMessages.getString(PKG, (String)"PipelineMeta.SearchMetadata.DatabaseTypeDescription", (String[])new String[0])));
                }
                if (databaseMeta.getPort() != null) {
                    stringList.add(new StringSearchResult(databaseMeta.getPort(), databaseMeta, this, BaseMessages.getString(PKG, (String)"PipelineMeta.SearchMetadata.DatabasePort", (String[])new String[0])));
                }
                if (databaseMeta.getServername() != null) {
                    stringList.add(new StringSearchResult(databaseMeta.getServername(), databaseMeta, this, BaseMessages.getString(PKG, (String)"PipelineMeta.SearchMetadata.DatabaseServer", (String[])new String[0])));
                }
                if (!includePasswords || databaseMeta.getPassword() == null) continue;
                stringList.add(new StringSearchResult(databaseMeta.getPassword(), databaseMeta, this, BaseMessages.getString(PKG, (String)"PipelineMeta.SearchMetadata.DatabasePassword", (String[])new String[0])));
            }
        }
        if (searchNotes) {
            for (i = 0; i < this.nrNotes(); ++i) {
                NotePadMeta notePadMeta = this.getNote(i);
                if (notePadMeta.getNote() == null) continue;
                stringList.add(new StringSearchResult(notePadMeta.getNote(), notePadMeta, this, BaseMessages.getString(PKG, (String)"PipelineMeta.SearchMetadata.NotepadText", (String[])new String[0])));
            }
        }
        return stringList;
    }

    public List<StringSearchResult> getStringList(boolean searchTransforms, boolean searchDatabases, boolean searchNotes) {
        return this.getStringList(searchTransforms, searchDatabases, searchNotes, false);
    }

    public List<String> getUsedVariables() {
        List<StringSearchResult> stringList = this.getStringList(true, true, false, true);
        ArrayList<String> varList = new ArrayList<String>();
        for (int i = 0; i < stringList.size(); ++i) {
            StringSearchResult result = stringList.get(i);
            StringUtil.getUsedVariables((String)result.getString(), varList, (boolean)false);
        }
        return varList;
    }

    public void checkRowMixingStatically(IVariables variables, TransformMeta transformMeta, IProgressMonitor monitor) throws HopRowException {
        List<TransformMeta> prevTransforms = this.findPreviousTransforms(transformMeta);
        int nrPrevious = prevTransforms.size();
        if (nrPrevious > 1) {
            IRowMeta referenceRow = null;
            for (int i = 0; i < nrPrevious; ++i) {
                TransformMeta previousTransform = prevTransforms.get(i);
                try {
                    IRowMeta row = this.getTransformFields(variables, previousTransform, monitor);
                    if (referenceRow == null) {
                        referenceRow = row;
                        continue;
                    }
                    if (transformMeta.getTransform().excludeFromRowLayoutVerification()) continue;
                    BaseTransform.safeModeChecking(referenceRow, row);
                    continue;
                }
                catch (HopTransformException hopTransformException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setInternalHopVariables(IVariables variables) {
        this.setInternalFilenameHopVariables(variables);
        this.setInternalNameHopVariable(variables);
        this.setInternalEntryCurrentDirectory(variables);
    }

    @Override
    protected void setInternalNameHopVariable(IVariables variables) {
        variables.setVariable("Internal.Pipeline.Name", Const.NVL((String)this.getName(), (String)""));
    }

    @Override
    protected void setInternalFilenameHopVariables(IVariables variables) {
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            try {
                FileObject fileObject = HopVfs.getFileObject((String)this.filename);
                FileName fileName = fileObject.getName();
                variables.setVariable("Internal.Pipeline.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                variables.setVariable("Internal.Pipeline.Filename.Directory", fileDir.getURI());
            }
            catch (HopFileException e) {
                LogChannel.GENERAL.logError("Unexpected error setting internal filename variables!", (Throwable)e);
                variables.setVariable("Internal.Pipeline.Filename.Directory", "");
                variables.setVariable("Internal.Pipeline.Filename.Name", "");
            }
        } else {
            variables.setVariable("Internal.Pipeline.Filename.Directory", "");
            variables.setVariable("Internal.Pipeline.Filename.Name", "");
        }
        this.setInternalEntryCurrentDirectory(variables);
    }

    protected void setInternalEntryCurrentDirectory(IVariables variables) {
        variables.setVariable("Internal.Entry.Current.Folder", variables.getVariable(StringUtils.isNotEmpty((String)this.filename) ? "Internal.Pipeline.Filename.Directory" : "Internal.Entry.Current.Folder"));
    }

    public TransformMeta findMappingInputTransform(String transformName) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)transformName)) {
            TransformMeta transformMeta = this.findTransform(transformName);
            if (transformMeta == null) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"PipelineMeta.Exception.TransformNameNotFound", (String[])new String[]{transformName}));
            }
            return transformMeta;
        }
        TransformMeta transformMeta = null;
        for (TransformMeta mappingTransform : this.transforms) {
            if (!mappingTransform.getTransformPluginId().equals("MappingInput")) continue;
            if (transformMeta == null) {
                transformMeta = mappingTransform;
                continue;
            }
            if (transformMeta == null) continue;
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"PipelineMeta.Exception.OnlyOneMappingInputTransformAllowed", (String[])new String[]{"2"}));
        }
        if (transformMeta == null) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"PipelineMeta.Exception.OneMappingInputTransformRequired", (String[])new String[0]));
        }
        return transformMeta;
    }

    public TransformMeta findMappingOutputTransform(String transformName) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)transformName)) {
            TransformMeta transformMeta = this.findTransform(transformName);
            if (transformMeta == null) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"PipelineMeta.Exception.TransformNameNotFound", (String[])new String[]{transformName}));
            }
            return transformMeta;
        }
        TransformMeta transformMeta = null;
        for (TransformMeta mappingTransform : this.transforms) {
            if (!mappingTransform.getTransformPluginId().equals("MappingOutput")) continue;
            if (transformMeta == null) {
                transformMeta = mappingTransform;
                continue;
            }
            if (transformMeta == null) continue;
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"PipelineMeta.Exception.OnlyOneMappingOutputTransformAllowed", (String[])new String[]{"2"}));
        }
        if (transformMeta == null) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"PipelineMeta.Exception.OneMappingOutputTransformRequired", (String[])new String[0]));
        }
        return transformMeta;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables) {
        return this.transforms.stream().flatMap(transformMeta -> transformMeta.getResourceDependencies(variables).stream()).collect(Collectors.toList());
    }

    @Override
    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        String exportFileName = null;
        try {
            String extension = "hpl";
            if (StringUtils.isNotEmpty((String)this.getFilename())) {
                FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.getFilename()));
                String originalPath = fileObject.getParent().getURL().toString();
                String baseName = fileObject.getName().getBaseName();
                String fullname = fileObject.getURL().toString();
                exportFileName = iResourceNaming.nameResource(baseName, originalPath, extension, IResourceNaming.FileNamingType.PIPELINE);
                ResourceDefinition definition = definitions.get(exportFileName);
                if (definition == null) {
                    PipelineMeta pipelineMeta = (PipelineMeta)this.realClone(false);
                    pipelineMeta.setNameSynchronizedWithFilename(false);
                    pipelineMeta.setName(this.getName());
                    for (TransformMeta transformMeta : pipelineMeta.getTransforms()) {
                        transformMeta.exportResources(variables, definitions, iResourceNaming, metadataProvider);
                    }
                    pipelineMeta.setFilename(exportFileName);
                    String pipelineMetaContent = pipelineMeta.getXml(variables);
                    definition = new ResourceDefinition(exportFileName, pipelineMetaContent);
                    if (Utils.isEmpty((CharSequence)this.getFilename())) {
                        definition.setOrigin(fullname);
                    } else {
                        definition.setOrigin(this.getFilename());
                    }
                    definitions.put(fullname, definition);
                }
            }
            return exportFileName;
        }
        catch (FileSystemException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)CONST_ERROR_OPENING_OR_VALIDATING, (String[])new String[]{this.getFilename()}), (Throwable)e);
        }
        catch (HopFileException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)CONST_ERROR_OPENING_OR_VALIDATING, (String[])new String[]{this.getFilename()}), (Throwable)e);
        }
    }

    public boolean isCapturingTransformPerformanceSnapShots() {
        return this.info.isCapturingTransformPerformanceSnapShots();
    }

    public void setCapturingTransformPerformanceSnapShots(boolean capturingTransformPerformanceSnapShots) {
        this.info.setCapturingTransformPerformanceSnapShots(capturingTransformPerformanceSnapShots);
    }

    public long getTransformPerformanceCapturingDelay() {
        return this.info.getTransformPerformanceCapturingDelay();
    }

    public void setTransformPerformanceCapturingDelay(long transformPerformanceCapturingDelay) {
        this.info.setTransformPerformanceCapturingDelay(transformPerformanceCapturingDelay);
    }

    public String getTransformPerformanceCapturingSizeLimit() {
        return this.info.getTransformPerformanceCapturingSizeLimit();
    }

    public void setTransformPerformanceCapturingSizeLimit(String transformPerformanceCapturingSizeLimit) {
        this.info.setTransformPerformanceCapturingSizeLimit(transformPerformanceCapturingSizeLimit);
    }

    public void clearCaches() {
        this.clearTransformFieldsCache();
        this.clearLoopCache();
        this.clearPreviousTransformCache();
    }

    private void clearTransformFieldsCache() {
        this.transformFieldsCache.clear();
    }

    private void clearLoopCache() {
        this.loopCache.clear();
    }

    @VisibleForTesting
    void clearPreviousTransformCache() {
        this.previousTransformCache.clear();
    }

    public PipelineType getPipelineType() {
        return this.info.getPipelineType();
    }

    public void setPipelineType(PipelineType pipelineType) {
        this.info.setPipelineType(pipelineType);
    }

    public void addTransformChangeListener(ITransformMetaChangeListener listener) {
        this.transformChangeListeners.add(listener);
    }

    public void addTransformChangeListener(int p, ITransformMetaChangeListener list) {
        int indexListener = -1;
        int indexListenerRemove = -1;
        TransformMeta rewriteTransform = this.transforms.get(p);
        ITransformMeta iface = rewriteTransform.getTransform();
        if (iface instanceof ITransformMetaChangeListener) {
            for (ITransformMetaChangeListener listener : this.transformChangeListeners) {
                ++indexListener;
                if (!listener.equals(iface)) continue;
                indexListenerRemove = indexListener;
            }
            if (indexListenerRemove >= 0) {
                this.transformChangeListeners.add(indexListenerRemove, list);
            } else if (this.transformChangeListeners.isEmpty() && p == 0) {
                this.transformChangeListeners.add(list);
            }
        }
    }

    public void removeTransformChangeListener(ITransformMetaChangeListener list) {
        int indexListener = -1;
        int indexListenerRemove = -1;
        for (ITransformMetaChangeListener listener : this.transformChangeListeners) {
            ++indexListener;
            if (!listener.equals(list)) continue;
            indexListenerRemove = indexListener;
        }
        if (indexListenerRemove >= 0) {
            this.transformChangeListeners.remove(indexListenerRemove);
        }
    }

    public void notifyAllListeners(TransformMeta oldMeta, TransformMeta newMeta) {
        for (ITransformMetaChangeListener listener : this.transformChangeListeners) {
            listener.onTransformChange(this, oldMeta, newMeta);
        }
    }

    public boolean containsTransformMeta(TransformMeta transformMeta) {
        return this.transforms.contains(transformMeta);
    }

    public List<Missing> getMissingPipeline() {
        return this.missingPipeline;
    }

    public void addMissingPipeline(Missing pipeline) {
        if (this.missingPipeline == null) {
            this.missingPipeline = new ArrayList();
        }
        this.missingPipeline.add(pipeline);
    }

    public void removeMissingPipeline(Missing pipeline) {
        if (this.missingPipeline != null && pipeline != null) {
            this.missingPipeline.remove(pipeline);
        }
    }

    @Override
    public boolean hasMissingPlugins() {
        return this.missingPipeline != null && !this.missingPipeline.isEmpty();
    }

    private static String getTransformMetaCacheKey(TransformMeta transformMeta, boolean info) {
        return String.format("%1$b-%2$s-%3$s", info, transformMeta.getTransformPluginId(), transformMeta);
    }

    private static IRowMeta[] cloneRowMetaInterfaces(IRowMeta[] inform) {
        IRowMeta[] cloned = (IRowMeta[])inform.clone();
        for (int i = 0; i < cloned.length; ++i) {
            if (cloned[i] == null) continue;
            cloned[i] = cloned[i].clone();
        }
        return cloned;
    }

    public boolean isEmpty() {
        return this.nrTransforms() == 0 && this.nrNotes() == 0;
    }

    public void setTransforms(List<TransformMeta> transforms) {
        this.transforms = transforms;
    }

    public List<PipelineHopMeta> getHops() {
        return this.hops;
    }

    public void setHops(List<PipelineHopMeta> hops) {
        this.hops = hops;
    }

    public PipelineMetaInfo getInfo() {
        return this.info;
    }

    public void setInfo(PipelineMetaInfo info) {
        this.info = info;
    }

    @Override
    public String getName() {
        return PipelineMeta.extractNameFromFilename(this.isNameSynchronizedWithFilename(), this.info.getName(), this.filename, this.getExtension());
    }

    @Override
    public void setName(String newName) {
        this.fireNameChangedListeners(this.getName(), newName);
        this.info.setName(newName);
    }

    @Override
    public boolean isNameSynchronizedWithFilename() {
        return this.info.isNameSynchronizedWithFilename();
    }

    @Override
    public void setNameSynchronizedWithFilename(boolean nameSynchronizedWithFilename) {
        this.info.setNameSynchronizedWithFilename(nameSynchronizedWithFilename);
    }

    @Override
    public String getDescription() {
        return this.info.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.info.setDescription(description);
    }

    @Override
    public String getExtendedDescription() {
        return this.info.getExtendedDescription();
    }

    @Override
    public void setExtendedDescription(String extendedDescription) {
        this.info.setExtendedDescription(extendedDescription);
    }

    @Override
    public Date getCreatedDate() {
        return this.info.getCreatedDate();
    }

    @Override
    public void setCreatedDate(Date createdDate) {
        this.info.setCreatedDate(createdDate);
    }

    @Override
    public void setCreatedUser(String createdUser) {
        this.info.setCreatedUser(createdUser);
    }

    @Override
    public String getCreatedUser() {
        return this.info.getCreatedUser();
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        this.info.setModifiedDate(modifiedDate);
    }

    @Override
    public Date getModifiedDate() {
        return this.info.getModifiedDate();
    }

    @Override
    public void setModifiedUser(String modifiedUser) {
        this.info.setModifiedUser(modifiedUser);
    }

    @Override
    public String getModifiedUser() {
        return this.info.getModifiedUser();
    }

    public static enum PipelineType {
        Normal("Normal", BaseMessages.getString(PKG, (String)"PipelineMeta.PipelineType.Normal", (String[])new String[0])),
        SingleThreaded("SingleThreaded", BaseMessages.getString(PKG, (String)"PipelineMeta.PipelineType.SingleThreaded", (String[])new String[0]));

        private final String code;
        private final String description;

        private PipelineType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static PipelineType getPipelineTypeByCode(String pipelineTypeCode) {
            if (pipelineTypeCode != null) {
                for (PipelineType type : PipelineType.values()) {
                    if (!type.code.equalsIgnoreCase(pipelineTypeCode)) continue;
                    return type;
                }
            }
            return Normal;
        }

        public static String[] getPipelineTypesDescriptions() {
            String[] desc = new String[PipelineType.values().length];
            for (int i = 0; i < PipelineType.values().length; ++i) {
                desc[i] = PipelineType.values()[i].getDescription();
            }
            return desc;
        }
    }
}

