/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.concatfields;

import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.concatfields.ConcatField;
import org.apache.hop.pipeline.transforms.concatfields.ConcatFieldsData;
import org.apache.hop.pipeline.transforms.concatfields.ConcatFieldsMeta;

public class ConcatFields
extends BaseTransform<ConcatFieldsMeta, ConcatFieldsData> {
    private static final Class<?> PKG = ConcatFields.class;

    public ConcatFields(TransformMeta transformMeta, ConcatFieldsMeta meta, ConcatFieldsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public synchronized boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.first = false;
            ((ConcatFieldsData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((ConcatFieldsMeta)this.meta).getFields(((ConcatFieldsData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((ConcatFieldsData)this.data).posTargetField = ((ConcatFieldsData)this.data).outputRowMeta.indexOfValue(((ConcatFieldsMeta)this.meta).getExtraFields().getTargetFieldName());
            if (((ConcatFieldsData)this.data).posTargetField < 0) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"ConcatFields.Error.TargetFieldNotFoundOutputStream", (String[])new String[]{((ConcatFieldsMeta)this.meta).getExtraFields().getTargetFieldName()}));
            }
            ((ConcatFieldsData)this.data).outputFieldIndexes = new ArrayList<Integer>();
            for (i = 0; i < this.getInputRowMeta().size(); ++i) {
                ((ConcatFieldsData)this.data).outputFieldIndexes.add(i);
            }
            ((ConcatFieldsData)this.data).inputFieldIndexes = new ArrayList<Integer>();
            if (((ConcatFieldsMeta)this.meta).getOutputFields().isEmpty()) {
                for (i = 0; i < this.getInputRowMeta().size(); ++i) {
                    ((ConcatFieldsData)this.data).inputFieldIndexes.add(i);
                    if (!((ConcatFieldsMeta)this.meta).getExtraFields().isRemoveSelectedFields()) continue;
                    ((ConcatFieldsData)this.data).outputFieldIndexes.remove((Object)i);
                }
            } else {
                for (i = 0; i < ((ConcatFieldsMeta)this.meta).getOutputFields().size(); ++i) {
                    ConcatField field = ((ConcatFieldsMeta)this.meta).getOutputFields().get(i);
                    int fieldIndex = this.getInputRowMeta().indexOfValue(field.getName());
                    if (fieldIndex < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"ConcatFields.Error.FieldNotFoundInputStream", (String[])new String[]{field.getName()}));
                    }
                    ((ConcatFieldsData)this.data).inputFieldIndexes.add(fieldIndex);
                    if (!((ConcatFieldsMeta)this.meta).getExtraFields().isRemoveSelectedFields()) continue;
                    ((ConcatFieldsData)this.data).outputFieldIndexes.remove((Object)fieldIndex);
                }
            }
            ((ConcatFieldsData)this.data).targetFieldLength = ((ConcatFieldsMeta)this.meta).getExtraFields().getTargetFieldLength();
            if (((ConcatFieldsData)this.data).targetFieldLength <= 0) {
                ((ConcatFieldsData)this.data).targetFieldLength = ((ConcatFieldsMeta)this.meta).getOutputFields().isEmpty() ? 50 * this.getInputRowMeta().size() : 50 * ((ConcatFieldsMeta)this.meta).getOutputFields().size();
            }
        }
        Object[] outputRowData = this.concatFields(row);
        this.putRow(((ConcatFieldsData)this.data).outputRowMeta, outputRowData);
        if (this.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"ConcatFields.Log.WriteRow", (String[])new String[0]) + this.getLinesWritten() + " : " + ((ConcatFieldsData)this.data).outputRowMeta.getString(row));
        }
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ConcatFields.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    private Object[] concatFields(Object[] inputRowData) throws HopException {
        Object[] outputRowData = this.createOutputRow(inputRowData);
        StringBuilder targetString = new StringBuilder(((ConcatFieldsData)this.data).targetFieldLength);
        for (int i = 0; i < ((ConcatFieldsData)this.data).inputFieldIndexes.size(); ++i) {
            String nullString;
            if (i > 0) {
                targetString.append(((ConcatFieldsData)this.data).stringSeparator);
            }
            int inputRowIndex = ((ConcatFieldsData)this.data).inputFieldIndexes.get(i);
            IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(inputRowIndex);
            Object valueData = inputRowData[inputRowIndex];
            if (((ConcatFieldsMeta)this.meta).getOutputFields().isEmpty()) {
                nullString = "";
            } else {
                ConcatField field = ((ConcatFieldsMeta)this.meta).getOutputFields().get(i);
                nullString = Const.NVL((String)field.getNullString(), (String)"");
            }
            this.concatField(targetString, valueMeta, valueData, nullString);
        }
        outputRowData[((ConcatFieldsData)this.data).outputRowMeta.size() - 1] = targetString.toString();
        return outputRowData;
    }

    private void concatField(StringBuilder targetField, IValueMeta valueMeta, Object valueData, String nullString) throws HopValueException {
        if (valueMeta.isNull(valueData)) {
            targetField.append(nullString);
        } else {
            targetField.append(valueMeta.getString(valueData));
        }
    }

    private Object[] createOutputRow(Object[] inputRowData) {
        Object[] outputRowData;
        if (((ConcatFieldsMeta)this.meta).getExtraFields().isRemoveSelectedFields()) {
            outputRowData = RowDataUtil.allocateRowData((int)((ConcatFieldsData)this.data).outputRowMeta.size());
            int outputRowIndex = 0;
            for (int inputRowIndex : ((ConcatFieldsData)this.data).outputFieldIndexes) {
                outputRowData[outputRowIndex++] = inputRowData[inputRowIndex];
            }
        } else {
            outputRowData = RowDataUtil.createResizedCopy((Object[])inputRowData, (int)((ConcatFieldsData)this.data).outputRowMeta.size());
        }
        return outputRowData;
    }

    public boolean init() {
        this.initStringDataFields();
        return super.init();
    }

    private void initStringDataFields() {
        ((ConcatFieldsData)this.data).stringSeparator = "";
        ((ConcatFieldsData)this.data).stringEnclosure = "";
        if (!StringUtil.isEmpty((String)((ConcatFieldsMeta)this.meta).getSeparator())) {
            ((ConcatFieldsData)this.data).stringSeparator = this.resolve(((ConcatFieldsMeta)this.meta).getSeparator());
        }
        if (!StringUtil.isEmpty((String)((ConcatFieldsMeta)this.meta).getEnclosure())) {
            ((ConcatFieldsData)this.data).stringEnclosure = this.resolve(((ConcatFieldsMeta)this.meta).getEnclosure());
        }
        ((ConcatFieldsData)this.data).stringNullValue = new String[((ConcatFieldsMeta)this.meta).getOutputFields().size()];
        for (int i = 0; i < ((ConcatFieldsMeta)this.meta).getOutputFields().size(); ++i) {
            ((ConcatFieldsData)this.data).stringNullValue[i] = "";
            String nullString = ((ConcatFieldsMeta)this.meta).getOutputFields().get(i).getNullString();
            if (StringUtil.isEmpty((String)nullString)) continue;
            ((ConcatFieldsData)this.data).stringNullValue[i] = nullString;
        }
    }

    public void dispose() {
        super.dispose();
    }
}

