/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.thresholds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.exceptions.ReadSizeAbortException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.TombstoneAbortException;
import org.apache.cassandra.locator.InetAddressAndPort;

public class WarningsSnapshot {
    private static final WarningsSnapshot EMPTY = new WarningsSnapshot(Warnings.access$000(), Warnings.access$000(), Warnings.access$000());
    public final Warnings tombstones;
    public final Warnings localReadSize;
    public final Warnings rowIndexReadSize;

    private WarningsSnapshot(Warnings tombstones, Warnings localReadSize, Warnings rowIndexReadSize) {
        this.tombstones = tombstones;
        this.localReadSize = localReadSize;
        this.rowIndexReadSize = rowIndexReadSize;
    }

    public static WarningsSnapshot empty() {
        return EMPTY;
    }

    public static WarningsSnapshot create(Warnings tombstones, Warnings localReadSize, Warnings rowIndexTooLarge) {
        if (tombstones == localReadSize && tombstones == rowIndexTooLarge && tombstones == Warnings.EMPTY) {
            return EMPTY;
        }
        return new WarningsSnapshot(tombstones, localReadSize, rowIndexTooLarge);
    }

    public static WarningsSnapshot merge(WarningsSnapshot ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        WarningsSnapshot accum = EMPTY;
        for (WarningsSnapshot a : values) {
            accum = accum.merge(a);
        }
        return accum == EMPTY ? null : accum;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean isDefined() {
        return this != EMPTY;
    }

    @VisibleForTesting
    WarningsSnapshot merge(WarningsSnapshot other) {
        if (other == null || other == EMPTY) {
            return this;
        }
        return WarningsSnapshot.create(this.tombstones.merge(other.tombstones), this.localReadSize.merge(other.localReadSize), this.rowIndexReadSize.merge(other.rowIndexReadSize));
    }

    public void maybeAbort(ReadCommand command, ConsistencyLevel cl, int received, int blockFor, boolean isDataPresent, Map<InetAddressAndPort, RequestFailureReason> failureReasonByEndpoint) {
        if (!this.tombstones.aborts.instances.isEmpty()) {
            throw new TombstoneAbortException(this.tombstones.aborts.instances.size(), this.tombstones.aborts.maxValue, command.toCQLString(), isDataPresent, cl, received, blockFor, failureReasonByEndpoint);
        }
        if (!this.localReadSize.aborts.instances.isEmpty()) {
            throw new ReadSizeAbortException(WarningsSnapshot.localReadSizeAbortMessage(this.localReadSize.aborts.instances.size(), this.localReadSize.aborts.maxValue, command.toCQLString()), cl, received, blockFor, isDataPresent, failureReasonByEndpoint);
        }
        if (!this.rowIndexReadSize.aborts.instances.isEmpty()) {
            throw new ReadSizeAbortException(WarningsSnapshot.rowIndexReadSizeAbortMessage(this.rowIndexReadSize.aborts.instances.size(), this.rowIndexReadSize.aborts.maxValue, command.toCQLString()), cl, received, blockFor, isDataPresent, failureReasonByEndpoint);
        }
    }

    @VisibleForTesting
    public static String tombstoneAbortMessage(int nodes, long tombstones, String cql) {
        return String.format("%s nodes scanned over %s tombstones and aborted the query %s (see tombstone_failure_threshold)", nodes, tombstones, cql);
    }

    @VisibleForTesting
    public static String tombstoneWarnMessage(int nodes, long tombstones, String cql) {
        return String.format("%s nodes scanned up to %s tombstones and issued tombstone warnings for query %s  (see tombstone_warn_threshold)", nodes, tombstones, cql);
    }

    @VisibleForTesting
    public static String localReadSizeAbortMessage(long nodes, long bytes, String cql) {
        return String.format("%s nodes loaded over %s bytes and aborted the query %s (see local_read_size_fail_threshold)", nodes, bytes, cql);
    }

    @VisibleForTesting
    public static String localReadSizeWarnMessage(int nodes, long bytes, String cql) {
        return String.format("%s nodes loaded over %s bytes and issued local read size warnings for query %s  (see local_read_size_warn_threshold)", nodes, bytes, cql);
    }

    @VisibleForTesting
    public static String rowIndexReadSizeAbortMessage(long nodes, long bytes, String cql) {
        return String.format("%s nodes loaded over %s bytes in RowIndexEntry and aborted the query %s (see row_index_size_fail_threshold)", nodes, bytes, cql);
    }

    @VisibleForTesting
    public static String rowIndexSizeWarnMessage(int nodes, long bytes, String cql) {
        return String.format("%s nodes loaded over %s bytes in RowIndexEntry and issued warnings for query %s  (see row_index_size_warn_threshold)", nodes, bytes, cql);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarningsSnapshot that = (WarningsSnapshot)o;
        return Objects.equals(this.tombstones, that.tombstones) && Objects.equals(this.localReadSize, that.localReadSize) && Objects.equals(this.rowIndexReadSize, that.rowIndexReadSize);
    }

    public int hashCode() {
        return Objects.hash(this.tombstones, this.localReadSize, this.rowIndexReadSize);
    }

    public String toString() {
        return "(tombstones=" + this.tombstones + ", localReadSize=" + this.localReadSize + ", rowIndexTooLarge=" + this.rowIndexReadSize + ')';
    }

    @VisibleForTesting
    static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    public static final class Builder {
        private WarningsSnapshot snapshot = WarningsSnapshot.empty();

        public Builder tombstonesWarning(ImmutableSet<InetAddressAndPort> instances, long maxValue) {
            return this.tombstonesWarning(new Counter(Objects.requireNonNull(instances), maxValue));
        }

        public Builder tombstonesWarning(Counter counter) {
            Objects.requireNonNull(counter);
            this.snapshot = this.snapshot.merge(new WarningsSnapshot(new Warnings(counter, Counter.EMPTY), Warnings.EMPTY, Warnings.EMPTY));
            return this;
        }

        public Builder tombstonesAbort(ImmutableSet<InetAddressAndPort> instances, long maxValue) {
            return this.tombstonesAbort(new Counter(Objects.requireNonNull(instances), maxValue));
        }

        public Builder tombstonesAbort(Counter counter) {
            Objects.requireNonNull(counter);
            this.snapshot = this.snapshot.merge(new WarningsSnapshot(new Warnings(Counter.EMPTY, counter), Warnings.EMPTY, Warnings.EMPTY));
            return this;
        }

        public Builder localReadSizeWarning(ImmutableSet<InetAddressAndPort> instances, long maxValue) {
            return this.localReadSizeWarning(new Counter(Objects.requireNonNull(instances), maxValue));
        }

        public Builder localReadSizeWarning(Counter counter) {
            Objects.requireNonNull(counter);
            this.snapshot = this.snapshot.merge(new WarningsSnapshot(Warnings.EMPTY, new Warnings(counter, Counter.EMPTY), Warnings.EMPTY));
            return this;
        }

        public Builder localReadSizeAbort(ImmutableSet<InetAddressAndPort> instances, long maxValue) {
            return this.localReadSizeAbort(new Counter(Objects.requireNonNull(instances), maxValue));
        }

        public Builder localReadSizeAbort(Counter counter) {
            Objects.requireNonNull(counter);
            this.snapshot = this.snapshot.merge(new WarningsSnapshot(Warnings.EMPTY, new Warnings(Counter.EMPTY, counter), Warnings.EMPTY));
            return this;
        }

        public Builder rowIndexSizeWarning(Counter counter) {
            Objects.requireNonNull(counter);
            this.snapshot = this.snapshot.merge(new WarningsSnapshot(Warnings.EMPTY, Warnings.EMPTY, new Warnings(counter, Counter.EMPTY)));
            return this;
        }

        public Builder rowIndexSizeAbort(Counter counter) {
            Objects.requireNonNull(counter);
            this.snapshot = this.snapshot.merge(new WarningsSnapshot(Warnings.EMPTY, Warnings.EMPTY, new Warnings(Counter.EMPTY, counter)));
            return this;
        }

        public WarningsSnapshot build() {
            return this.snapshot;
        }
    }

    public static final class Counter {
        private static final Counter EMPTY = new Counter((ImmutableSet<InetAddressAndPort>)ImmutableSet.of(), 0L);
        public final ImmutableSet<InetAddressAndPort> instances;
        public final long maxValue;

        @VisibleForTesting
        Counter(ImmutableSet<InetAddressAndPort> instances, long maxValue) {
            this.instances = instances;
            this.maxValue = maxValue;
        }

        @VisibleForTesting
        static Counter empty() {
            return EMPTY;
        }

        public static Counter create(Set<InetAddressAndPort> instances, AtomicLong maxValue) {
            ImmutableSet copy = ImmutableSet.copyOf(instances);
            if (copy.isEmpty()) {
                return EMPTY;
            }
            return new Counter((ImmutableSet<InetAddressAndPort>)copy, maxValue.get());
        }

        public Counter merge(Counter other) {
            if (other == EMPTY) {
                return this;
            }
            ImmutableSet copy = ImmutableSet.builder().addAll(this.instances).addAll(other.instances).build();
            return new Counter((ImmutableSet<InetAddressAndPort>)copy, Math.max(this.maxValue, other.maxValue));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Counter counter = (Counter)o;
            return this.maxValue == counter.maxValue && Objects.equals(this.instances, counter.instances);
        }

        public int hashCode() {
            return Objects.hash(this.instances, this.maxValue);
        }

        public String toString() {
            return "(" + this.instances + ", " + this.maxValue + ')';
        }
    }

    public static final class Warnings {
        private static final Warnings EMPTY = new Warnings(Counter.access$100(), Counter.access$100());
        public final Counter warnings;
        public final Counter aborts;

        private Warnings(Counter warnings, Counter aborts) {
            this.warnings = warnings;
            this.aborts = aborts;
        }

        public static Warnings create(Counter warnings, Counter aborts) {
            if (warnings == Counter.EMPTY && aborts == Counter.EMPTY) {
                return EMPTY;
            }
            return new Warnings(warnings, aborts);
        }

        public Warnings merge(Warnings other) {
            if (other == EMPTY) {
                return this;
            }
            return Warnings.create(this.warnings.merge(other.warnings), this.aborts.merge(other.aborts));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Warnings warnings1 = (Warnings)o;
            return Objects.equals(this.warnings, warnings1.warnings) && Objects.equals(this.aborts, warnings1.aborts);
        }

        public int hashCode() {
            return Objects.hash(this.warnings, this.aborts);
        }

        public String toString() {
            return "(warnings=" + this.warnings + ", aborts=" + this.aborts + ')';
        }
    }
}

