/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.cql3.statements.schema.IndexAttributes;
import org.apache.cassandra.cql3.statements.schema.IndexTarget;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.sasi.SASIIndex;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;

public final class CreateIndexStatement
extends AlterSchemaStatement {
    private final String indexName;
    private final String tableName;
    private final List<IndexTarget.Raw> rawIndexTargets;
    private final IndexAttributes attrs;
    private final boolean ifNotExists;
    private ClientState state;

    public CreateIndexStatement(String keyspaceName, String tableName, String indexName, List<IndexTarget.Raw> rawIndexTargets, IndexAttributes attrs, boolean ifNotExists) {
        super(keyspaceName);
        this.tableName = tableName;
        this.indexName = indexName;
        this.rawIndexTargets = rawIndexTargets;
        this.attrs = attrs;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void validate(ClientState state) {
        super.validate(state);
        this.state = state;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        this.attrs.validate();
        Guardrails.createSecondaryIndexesEnabled.ensureEnabled("Creating secondary indexes", this.state);
        if (this.attrs.isCustom && this.attrs.customClass.equals(SASIIndex.class.getName()) && !DatabaseDescriptor.getSASIIndexesEnabled()) {
            throw new InvalidRequestException("SASI indexes are disabled. Enable in cassandra.yaml to use.");
        }
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        if (null == keyspace) {
            throw CreateIndexStatement.ire("Keyspace '%s' doesn't exist", this.keyspaceName);
        }
        TableMetadata table = keyspace.getTableOrViewNullable(this.tableName);
        if (null == table) {
            throw CreateIndexStatement.ire("Table '%s' doesn't exist", this.tableName);
        }
        if (null != this.indexName && keyspace.hasIndex(this.indexName)) {
            if (this.ifNotExists) {
                return schema;
            }
            throw CreateIndexStatement.ire("Index '%s' already exists", this.indexName);
        }
        if (table.isCounter()) {
            throw CreateIndexStatement.ire("Secondary indexes on counter tables aren't supported", new Object[0]);
        }
        if (table.isView()) {
            throw CreateIndexStatement.ire("Secondary indexes on materialized views aren't supported", new Object[0]);
        }
        if (Keyspace.open(table.keyspace).getReplicationStrategy().hasTransientReplicas()) {
            throw new InvalidRequestException("Secondary indexes are not supported on transiently replicated keyspaces");
        }
        Guardrails.secondaryIndexesPerTable.guard(table.indexes.size() + 1, Strings.isNullOrEmpty((String)this.indexName) ? String.format("on table %s", table.name) : String.format("%s on table %s", this.indexName, table.name), false, this.state);
        ArrayList indexTargets = Lists.newArrayList((Iterable)Iterables.transform(this.rawIndexTargets, t -> t.prepare(table)));
        if (indexTargets.isEmpty() && !this.attrs.isCustom) {
            throw CreateIndexStatement.ire("Only CUSTOM indexes can be created without specifying a target column", new Object[0]);
        }
        if (indexTargets.size() > 1) {
            if (!this.attrs.isCustom) {
                throw CreateIndexStatement.ire("Only CUSTOM indexes support multiple columns", new Object[0]);
            }
            HashSet<ColumnIdentifier> columns = new HashSet<ColumnIdentifier>();
            for (IndexTarget target : indexTargets) {
                if (columns.add(target.column)) continue;
                throw CreateIndexStatement.ire("Duplicate column '%s' in index target list", target.column);
            }
        }
        indexTargets.forEach(t -> this.validateIndexTarget(table, (IndexTarget)t));
        String name = null == this.indexName ? this.generateIndexName(keyspace, indexTargets) : this.indexName;
        IndexMetadata.Kind kind = this.attrs.isCustom ? IndexMetadata.Kind.CUSTOM : IndexMetadata.Kind.COMPOSITES;
        Map<String, String> options = this.attrs.isCustom ? this.attrs.getOptions() : Collections.emptyMap();
        IndexMetadata index = IndexMetadata.fromIndexTargets(indexTargets, name, kind, options);
        IndexMetadata equalIndex = (IndexMetadata)Iterables.tryFind((Iterable)table.indexes, i -> i.equalsWithoutName(index)).orNull();
        if (null != equalIndex) {
            if (this.ifNotExists) {
                return schema;
            }
            throw CreateIndexStatement.ire("Index %s is a duplicate of existing index %s", index.name, equalIndex.name);
        }
        TableMetadata newTable = table.withSwapped(table.indexes.with(index));
        newTable.validate();
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.tables.withSwapped(newTable)));
    }

    @Override
    Set<String> clientWarnings(Keyspaces.KeyspacesDiff diff) {
        if (this.attrs.isCustom && this.attrs.customClass.equals(SASIIndex.class.getName())) {
            return ImmutableSet.of((Object)"SASI indexes are experimental and are not recommended for production use.");
        }
        return ImmutableSet.of();
    }

    private void validateIndexTarget(TableMetadata table, IndexTarget target) {
        ColumnMetadata column = table.getColumn(target.column);
        if (null == column) {
            throw CreateIndexStatement.ire("Column '%s' doesn't exist", target.column);
        }
        if (column.type.referencesDuration()) {
            if (column.type.isCollection()) {
                throw CreateIndexStatement.ire("Secondary indexes are not supported on collections containing durations", new Object[0]);
            }
            if (column.type.isTuple()) {
                throw CreateIndexStatement.ire("Secondary indexes are not supported on tuples containing durations", new Object[0]);
            }
            if (column.type.isUDT()) {
                throw CreateIndexStatement.ire("Secondary indexes are not supported on UDTs containing durations", new Object[0]);
            }
            throw CreateIndexStatement.ire("Secondary indexes are not supported on duration columns", new Object[0]);
        }
        if (table.isCompactTable()) {
            TableMetadata.CompactTableMetadata compactTable = (TableMetadata.CompactTableMetadata)table;
            if (column.isPrimaryKeyColumn()) {
                throw new InvalidRequestException("Secondary indexes are not supported on PRIMARY KEY columns in COMPACT STORAGE tables");
            }
            if (compactTable.compactValueColumn.equals(column)) {
                throw new InvalidRequestException("Secondary indexes are not supported on compact value column of COMPACT STORAGE tables");
            }
        }
        if (column.isPartitionKey() && table.partitionKeyColumns().size() == 1) {
            throw CreateIndexStatement.ire("Cannot create secondary index on the only partition key column %s", column);
        }
        if (column.type.isFrozenCollection() && target.type != IndexTarget.Type.FULL) {
            throw CreateIndexStatement.ire("Cannot create %s() index on frozen column %s. Frozen collections are immutable and must be fully indexed by using the 'full(%s)' modifier", new Object[]{target.type, column, column});
        }
        if (!column.type.isFrozenCollection() && target.type == IndexTarget.Type.FULL) {
            throw CreateIndexStatement.ire("full() indexes can only be created on frozen collections", new Object[0]);
        }
        if (!column.type.isCollection() && target.type != IndexTarget.Type.SIMPLE) {
            throw CreateIndexStatement.ire("Cannot create %s() index on %s. Non-collection columns only support simple indexes", new Object[]{target.type, column});
        }
        if (!(column.type instanceof MapType && column.type.isMultiCell() || target.type != IndexTarget.Type.KEYS && target.type != IndexTarget.Type.KEYS_AND_VALUES)) {
            throw CreateIndexStatement.ire("Cannot create index on %s of column %s with non-map type", new Object[]{target.type, column});
        }
        if (column.type.isUDT() && column.type.isMultiCell()) {
            throw CreateIndexStatement.ire("Cannot create index on non-frozen UDT column %s", column);
        }
    }

    private String generateIndexName(KeyspaceMetadata keyspace, List<IndexTarget> targets) {
        String baseName = targets.size() == 1 ? IndexMetadata.generateDefaultIndexName(this.tableName, targets.get((int)0).column) : IndexMetadata.generateDefaultIndexName(this.tableName);
        return keyspace.findAvailableIndexName(baseName);
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspaceName, this.tableName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureTablePermission(this.keyspaceName, this.tableName, Permission.ALTER);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.CREATE_INDEX, this.keyspaceName, this.indexName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.indexName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName tableName;
        private final QualifiedName indexName;
        private final List<IndexTarget.Raw> rawIndexTargets;
        private final IndexAttributes attrs;
        private final boolean ifNotExists;

        public Raw(QualifiedName tableName, QualifiedName indexName, List<IndexTarget.Raw> rawIndexTargets, IndexAttributes attrs, boolean ifNotExists) {
            this.tableName = tableName;
            this.indexName = indexName;
            this.rawIndexTargets = rawIndexTargets;
            this.attrs = attrs;
            this.ifNotExists = ifNotExists;
        }

        @Override
        public CreateIndexStatement prepare(ClientState state) {
            String keyspaceName;
            String string = this.tableName.hasKeyspace() ? this.tableName.getKeyspace() : (keyspaceName = this.indexName.hasKeyspace() ? this.indexName.getKeyspace() : state.getKeyspace());
            if (this.tableName.hasKeyspace() && !keyspaceName.equals(this.tableName.getKeyspace())) {
                throw AlterSchemaStatement.ire("Keyspace name '%s' doesn't match table name '%s'", keyspaceName, this.tableName);
            }
            if (this.indexName.hasKeyspace() && !keyspaceName.equals(this.indexName.getKeyspace())) {
                throw AlterSchemaStatement.ire("Keyspace name '%s' doesn't match index name '%s'", keyspaceName, this.tableName);
            }
            return new CreateIndexStatement(keyspaceName, this.tableName.getName(), this.indexName.getName(), this.rawIndexTargets, this.attrs, this.ifNotExists);
        }
    }
}

