/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.terafast;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.AbstractTransform;
import org.apache.hop.core.util.ConfigurableStreamLogger;
import org.apache.hop.core.util.GenericTransformData;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.terafast.FastloadControlBuilder;
import org.apache.hop.pipeline.transforms.terafast.TeraFastMeta;

public class TeraFast
extends AbstractTransform<TeraFastMeta, GenericTransformData> {
    private static final Class<?> PKG = TeraFastMeta.class;
    private Process process;
    private OutputStream fastload;
    private OutputStream dataFile;
    private PrintStream dataFilePrintStream;
    private SimpleDateFormat simpleDateFormat;

    public TeraFast(TransformMeta transformMeta, TeraFastMeta meta, GenericTransformData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public String createCommandLine() throws HopException {
        FileObject fileObject;
        if (StringUtils.isBlank((String)((String)((TeraFastMeta)this.meta).getFastloadPath().getValue()))) {
            throw new HopException("Fastload path not set");
        }
        StringBuilder builder = new StringBuilder();
        try {
            fileObject = HopVfs.getFileObject((String)this.resolve((String)((TeraFastMeta)this.meta).getFastloadPath().getValue()), (IVariables)this.variables);
            String fastloadExec = HopVfs.getFilename((FileObject)fileObject);
            builder.append(fastloadExec);
        }
        catch (Exception e) {
            throw new HopException("Error retrieving fastload application string", (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)((String)((TeraFastMeta)this.meta).getLogFile().getValue()))) {
            try {
                fileObject = HopVfs.getFileObject((String)this.resolve((String)((TeraFastMeta)this.meta).getLogFile().getValue()), (IVariables)this.variables);
                builder.append(" -e ");
                builder.append("\"" + HopVfs.getFilename((FileObject)fileObject) + "\"");
            }
            catch (Exception e) {
                throw new HopException("Error retrieving logfile string", (Throwable)e);
            }
        }
        return builder.toString();
    }

    protected void verifyDatabaseConnection() throws HopException {
        if (((TeraFastMeta)this.meta).getDbMeta() == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TeraFastDialog.GetSQL.NoConnectionDefined", (String[])new String[0]));
        }
    }

    public boolean init() {
        this.simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        if (super.init()) {
            try {
                this.verifyDatabaseConnection();
            }
            catch (HopException ex) {
                this.logError(ex.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            if (this.dataFilePrintStream != null) {
                this.dataFilePrintStream.close();
                IOUtils.closeQuietly((OutputStream)this.dataFile);
                this.execute();
            }
            this.setOutputDone();
            try {
                this.logBasic(BaseMessages.getString(PKG, (String)"TeraFast.Log.WatingForFastload", (String[])new String[0]));
                if (this.process != null) {
                    int exitVal = this.process.waitFor();
                    if (exitVal != 0) {
                        this.setErrors(1L);
                    }
                    this.logBasic(BaseMessages.getString(PKG, (String)"TeraFast.Log.ExitValueFastloadPath", (String[])new String[]{"" + exitVal}));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"TeraFast.Log.ErrorInTransform", (String[])new String[0]), e);
                this.setDefaultError();
                this.stopAll();
            }
            return false;
        }
        if (this.first) {
            this.first = false;
            try {
                File tempDataFile = new File(this.resolveFileName((String)((TeraFastMeta)this.meta).getDataFile().getValue()));
                this.dataFile = FileUtils.openOutputStream((File)tempDataFile);
                this.dataFilePrintStream = new PrintStream(this.dataFile);
            }
            catch (IOException e) {
                throw new HopException("Cannot open data file [path=" + this.dataFile + "]", (Throwable)e);
            }
            IRowMeta tableRowMeta = ((TeraFastMeta)this.meta).getRequiredFields((IVariables)this);
            IRowMeta streamRowMeta = this.getPipelineMeta().getPrevTransformFields((IVariables)this, this.getTransformMeta());
            ArrayList<Integer> columnSortOrder = new ArrayList<Integer>(tableRowMeta.size());
            for (int i = 0; i < tableRowMeta.size(); ++i) {
                IValueMeta column = tableRowMeta.getValueMeta(i);
                int tableIndex = ((List)((TeraFastMeta)this.meta).getTableFieldList().getValue()).indexOf(column.getName());
                if (tableIndex < 0) continue;
                String streamField = (String)((List)((TeraFastMeta)this.meta).getStreamFieldList().getValue()).get(tableIndex);
                columnSortOrder.add(streamRowMeta.indexOfValue(streamField));
            }
        }
        this.writeToDataFile(this.getInputRowMeta(), row);
        return true;
    }

    public void writeToDataFile(IRowMeta iRowMeta, Object[] row) throws HopException {
        IValueMeta valueMeta = null;
        for (int i = 0; i < row.length && row[i] != null; ++i) {
            valueMeta = iRowMeta.getValueMeta(i);
            if (row[i] != null) {
                switch (valueMeta.getType()) {
                    case 2: {
                        String s = iRowMeta.getString(row, i);
                        this.dataFilePrintStream.print(this.pad(valueMeta, s));
                        break;
                    }
                    case 5: {
                        Long l = iRowMeta.getInteger(row, i);
                        this.dataFilePrintStream.print(this.pad(valueMeta, l.toString()));
                        break;
                    }
                    case 1: {
                        Double d = iRowMeta.getNumber(row, i);
                        this.dataFilePrintStream.print(this.pad(valueMeta, d.toString()));
                        break;
                    }
                    case 6: {
                        BigDecimal bd = iRowMeta.getBigNumber(row, i);
                        this.dataFilePrintStream.print(this.pad(valueMeta, bd.toString()));
                        break;
                    }
                    case 3: {
                        Date dt = iRowMeta.getDate(row, i);
                        this.dataFilePrintStream.print(this.simpleDateFormat.format(dt));
                        break;
                    }
                    case 4: {
                        Boolean b = iRowMeta.getBoolean(row, i);
                        if (b.booleanValue()) {
                            this.dataFilePrintStream.print("Y");
                            break;
                        }
                        this.dataFilePrintStream.print("N");
                        break;
                    }
                    case 8: {
                        byte[] byt = iRowMeta.getBinary(row, i);
                        this.dataFilePrintStream.print(byt);
                        break;
                    }
                    default: {
                        throw new HopException(BaseMessages.getString(PKG, (String)"TeraFast.Exception.TypeNotSupported", (Object[])new Object[]{valueMeta.getType()}));
                    }
                }
            }
            this.dataFilePrintStream.print("|");
        }
        this.dataFilePrintStream.print(Const.CR);
    }

    private String pad(IValueMeta iValueMeta, String data) {
        StringBuilder padding = new StringBuilder(data);
        int padLength = iValueMeta.getLength() - data.length();
        for (int currentPadLength = 0; currentPadLength < padLength; ++currentPadLength) {
            padding.append(" ");
        }
        return padding.toString();
    }

    public void execute() throws HopException {
        if (((Boolean)((TeraFastMeta)this.meta).getTruncateTable().getValue()).booleanValue()) {
            Database db = new Database((ILoggingObject)this, (IVariables)this, ((TeraFastMeta)this.meta).getDbMeta());
            db.connect();
            db.truncateTable((String)((TeraFastMeta)this.meta).getTargetTable().getValue());
            db.commit();
            db.disconnect();
        }
        this.startFastLoad();
        if (((Boolean)((TeraFastMeta)this.meta).getUseControlFile().getValue()).booleanValue()) {
            this.invokeLoadingControlFile();
        } else {
            this.invokeLoadingCommand();
        }
    }

    private void startFastLoad() throws HopException {
        String command = this.createCommandLine();
        this.logBasic("About to execute: " + command);
        try {
            this.process = Runtime.getRuntime().exec(command);
            new Thread((Runnable)new ConfigurableStreamLogger(this.getLogChannel(), this.process.getErrorStream(), LogLevel.ERROR, "ERROR")).start();
            new Thread((Runnable)new ConfigurableStreamLogger(this.getLogChannel(), this.process.getInputStream(), LogLevel.DETAILED, "OUTPUT")).start();
            this.fastload = this.process.getOutputStream();
        }
        catch (Exception e) {
            throw new HopException("Error while setup: " + command, (Throwable)e);
        }
    }

    private void invokeLoadingControlFile() throws HopException {
        String controlContent;
        FileInputStream control;
        File controlFile = null;
        try {
            controlFile = new File(this.resolveFileName((String)((TeraFastMeta)this.meta).getControlFile().getValue()));
            control = FileUtils.openInputStream((File)controlFile);
            controlContent = this.resolve(FileUtils.readFileToString((File)controlFile));
        }
        catch (IOException e) {
            throw new HopException("Cannot open control file [path=" + controlFile + "]", (Throwable)e);
        }
        try {
            IOUtils.write((String)controlContent, (OutputStream)this.fastload);
            this.fastload.flush();
        }
        catch (IOException e) {
            throw new HopException("Cannot pipe content of control file to fastload [path=" + controlFile + "]", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)control);
            IOUtils.closeQuietly((OutputStream)this.fastload);
        }
    }

    private void invokeLoadingCommand() throws HopException {
        FastloadControlBuilder builder = new FastloadControlBuilder();
        builder.setSessions((Integer)((TeraFastMeta)this.meta).getSessions().getValue());
        builder.setErrorLimit((Integer)((TeraFastMeta)this.meta).getErrorLimit().getValue());
        builder.logon(((TeraFastMeta)this.meta).getDbMeta().getHostname(), ((TeraFastMeta)this.meta).getDbMeta().getUsername(), ((TeraFastMeta)this.meta).getDbMeta().getPassword());
        builder.setRecordFormat("VARTEXT \"|\"");
        try {
            builder.define(((TeraFastMeta)this.meta).getRequiredFields((IVariables)this), ((TeraFastMeta)this.meta).getTableFieldList(), this.resolveFileName((String)((TeraFastMeta)this.meta).getDataFile().getValue()));
        }
        catch (Exception ex) {
            throw new HopException("Error defining data file!", (Throwable)ex);
        }
        builder.show();
        builder.beginLoading(((TeraFastMeta)this.meta).getDbMeta().getPreferredSchemaName(), (String)((TeraFastMeta)this.meta).getTargetTable().getValue());
        builder.insert(((TeraFastMeta)this.meta).getRequiredFields((IVariables)this), ((TeraFastMeta)this.meta).getTableFieldList(), (String)((TeraFastMeta)this.meta).getTargetTable().getValue());
        builder.endLoading();
        builder.logoff();
        String control = builder.toString();
        try {
            this.logDetailed("Control file: " + control);
            IOUtils.write((String)control, (OutputStream)this.fastload);
        }
        catch (IOException e) {
            throw new HopException("Error while execution control command [controlCommand=" + control + "]", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this.fastload);
        }
    }

    public void dispose() {
        try {
            if (this.fastload != null) {
                IOUtils.write((String)new FastloadControlBuilder().endLoading().toString(), (OutputStream)this.fastload);
            }
        }
        catch (IOException e) {
            this.logError("Unexpected error encountered while issuing END LOADING", e);
        }
        IOUtils.closeQuietly((OutputStream)this.dataFile);
        IOUtils.closeQuietly((OutputStream)this.fastload);
        try {
            if (this.process != null) {
                int exitValue = this.process.waitFor();
                this.logDetailed("Exit value for the fastload process was : " + exitValue);
                if (exitValue != 0) {
                    this.logError("Exit value for the fastload process was : " + exitValue);
                    this.setErrors(1L);
                }
            }
        }
        catch (InterruptedException e) {
            this.setErrors(1L);
            this.logError("Unexpected error encountered while finishing the fastload process", e);
        }
        super.dispose();
    }

    private String resolveFileName(String fileName) throws HopException {
        FileObject fileObject = HopVfs.getFileObject((String)this.resolve(fileName), (IVariables)this.variables);
        return HopVfs.getFilename((FileObject)fileObject);
    }
}

